/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.actions;

import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.SelectMarkerRulerAction;

public class AptanaSelectAnnotationRulerAction
extends SelectMarkerRulerAction {
    private ITextEditor fTextEditor;
    private Position fPosition;
    private Annotation fAnnotation;
    private boolean fHasCorrection;
    private ResourceBundle fBundle;

    public AptanaSelectAnnotationRulerAction(ResourceBundle bundle, String prefix, ITextEditor editor, IVerticalRulerInfo ruler) {
        super(bundle, prefix, editor, ruler);
        this.fTextEditor = editor;
        this.fBundle = bundle;
    }

    public void run() {
        this.runWithEvent(null);
    }

    public void runWithEvent(Event event) {
        if (this.fPosition != null) {
            this.fTextEditor.selectAndReveal(this.fPosition.getOffset(), this.fPosition.getLength());
            if (this.fHasCorrection) {
                ITextOperationTarget operation = (ITextOperationTarget)this.fTextEditor.getAdapter(ITextOperationTarget.class);
                if (operation != null && operation.canDoOperation(22)) {
                    operation.doOperation(22);
                }
                return;
            }
        }
        super.run();
    }

    public void update() {
        super.update();
        this.findAnnotation();
        this.setEnabled(true);
    }

    private void findAnnotation() {
        boolean isReadOnly;
        this.fPosition = null;
        this.fAnnotation = null;
        this.fHasCorrection = false;
        boolean bl = isReadOnly = this.fTextEditor instanceof ITextEditorExtension && ((ITextEditorExtension)this.fTextEditor).isEditorInputReadOnly();
        if (isReadOnly) {
            return;
        }
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        IAnnotationAccessExtension annotationAccess = this.getAnnotationAccessExtension();
        IDocument document = this.getDocument();
        if (model == null) {
            return;
        }
        Iterator iter = model.getAnnotationIterator();
        int layer = Integer.MIN_VALUE;
        while (iter.hasNext()) {
            Position position;
            Annotation annotation = (Annotation)iter.next();
            if (annotation.isMarkedDeleted()) continue;
            int annotationLayer = layer;
            if (annotationAccess != null && (annotationLayer = annotationAccess.getLayer(annotation)) < layer || !this.includesRulerLine(position = model.getPosition(annotation), document)) continue;
            this.fPosition = position;
            this.fAnnotation = annotation;
            if (annotation instanceof IQuickFixableAnnotation) {
                this.fHasCorrection = ((IQuickFixableAnnotation)annotation).isQuickFixableStateSet() && ((IQuickFixableAnnotation)annotation).isQuickFixable();
            }
            layer = annotationLayer;
            break;
        }
    }
}

