/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.editor.common.IPartitionScannerSwitchStrategy;
import com.aptana.editor.common.IPartitionerSwitchStrategy;
import com.aptana.editor.common.TextUtils;

public abstract class PartitionerSwitchStrategy
implements IPartitionerSwitchStrategy {
    private final char[][][] switchSequences;
    private final IPartitionScannerSwitchStrategy.ISequenceBypassHandler[] sequenceBypassHandlers;

    protected PartitionerSwitchStrategy(String[][] switchSequencePairs) {
        this(switchSequencePairs, null, null);
    }

    protected PartitionerSwitchStrategy(String[][] switchSequencePairs, IPartitionScannerSwitchStrategy.ISequenceBypassHandler startBypassHandler, IPartitionScannerSwitchStrategy.ISequenceBypassHandler endBypassHandler) {
        char[][] startSequences = new char[switchSequencePairs.length][];
        char[][] endSequences = new char[switchSequencePairs.length][];
        int i = 0;
        while (i < switchSequencePairs.length) {
            startSequences[i] = switchSequencePairs[i][0].toCharArray();
            endSequences[i] = switchSequencePairs[i][1].toCharArray();
            ++i;
        }
        this.switchSequences = new char[][][]{TextUtils.removeDuplicates(startSequences), TextUtils.removeDuplicates(endSequences)};
        this.sequenceBypassHandlers = new IPartitionScannerSwitchStrategy.ISequenceBypassHandler[]{startBypassHandler, endBypassHandler};
    }

    @Override
    public IPartitionScannerSwitchStrategy getDefaultSwitchStrategy() {
        return new IPartitionScannerSwitchStrategy(){

            @Override
            public char[][] getSwitchSequences() {
                return PartitionerSwitchStrategy.this.switchSequences[0];
            }

            @Override
            public IPartitionScannerSwitchStrategy.ISequenceBypassHandler getSequenceBypassHandler() {
                return PartitionerSwitchStrategy.this.sequenceBypassHandlers[0];
            }
        };
    }

    @Override
    public IPartitionScannerSwitchStrategy getPrimarySwitchStrategy() {
        return new IPartitionScannerSwitchStrategy(){

            @Override
            public char[][] getSwitchSequences() {
                return PartitionerSwitchStrategy.this.switchSequences[1];
            }

            @Override
            public IPartitionScannerSwitchStrategy.ISequenceBypassHandler getSequenceBypassHandler() {
                return PartitionerSwitchStrategy.this.sequenceBypassHandlers[1];
            }
        };
    }
}

