/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import java.lang.reflect.Method;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.WorkbenchPartReference;

public class OpenedFileSizeController {
    private static final int OPENED_FILES_MAX_SIZE = 0x500000;
    private static final int OPENED_FILE_MIN_SIZE = 0;
    private static final int ACTIVE_EDITOR_MIN_TIME = 180000;
    private static final int DELAY_TIME = 30000;
    private static Job job;

    public static void checkOpenedFileSize() {
        int state;
        if (job == null) {
            job = new Job("check opened file size job"){
                private Method method = null;

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (!Platform.isRunning() || monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                        long currentTime = System.currentTimeMillis();
                        IWorkbenchWindow[] iWorkbenchWindowArray = windows;
                        int n = windows.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IEditorReference[] editorReferences;
                            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                            IWorkbenchPage page = window.getActivePage();
                            if (page != null && (editorReferences = page.getEditorReferences()).length > 1) {
                                final TreeMap<Long, IEditorReference> toCloseEditor = new TreeMap<Long, IEditorReference>();
                                final TreeMap<Long, Integer> toCloseEditorFileSize = new TreeMap<Long, Integer>();
                                final long[] allSize = new long[1];
                                IEditorReference[] iEditorReferenceArray = editorReferences;
                                int n3 = editorReferences.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IEditorReference editorReference = iEditorReferenceArray[n4];
                                    IEditorPart part = editorReference.getEditor(false);
                                    if (part instanceof AbstractThemeableEditor) {
                                        AbstractThemeableEditor editor = (AbstractThemeableEditor)part;
                                        IDocument docuemnt = editor.getDocument();
                                        IEditorInput input = editor.getEditorInput();
                                        if (docuemnt != null && input != null && !"com.aptana.editor.text".equals(editorReference.getId())) {
                                            int size = docuemnt.getLength();
                                            allSize[0] = allSize[0] + (long)size;
                                            long lastTime = editor.lastActiveStamp;
                                            if (lastTime > 0L && currentTime - lastTime >= 180000L && input.exists() && !editorReference.isDirty() && size > 0) {
                                                toCloseEditor.put(lastTime, editorReference);
                                                toCloseEditorFileSize.put(lastTime, size);
                                            }
                                        }
                                    }
                                    ++n4;
                                }
                                if (allSize[0] >= 0x500000L && !toCloseEditor.isEmpty()) {
                                    if (this.method == null) {
                                        this.method = WorkbenchPartReference.class.getDeclaredMethod("disposePartPane", new Class[0]);
                                        this.method.setAccessible(true);
                                    }
                                    Display.getDefault().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            for (Long time : toCloseEditor.keySet()) {
                                                if (allSize[0] < 0x500000L) break;
                                                IEditorReference editorReference = (IEditorReference)toCloseEditor.get(time);
                                                int size = (Integer)toCloseEditorFileSize.get(time);
                                                if (!(editorReference instanceof EditorReference) || ((EditorReference)editorReference).getVisible()) continue;
                                                try {
                                                    Object result = method.invoke((Object)editorReference, new Object[0]);
                                                    if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
                                                    allSize[0] = allSize[0] - (long)size;
                                                }
                                                catch (Throwable e) {
                                                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                            ++n2;
                        }
                        job.schedule(30000L);
                    }
                    catch (NoSuchMethodException e) {
                        IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                        job.schedule(30000L);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
        }
        if ((state = job.getState()) == 4) {
            return;
        }
        if (state != 0) {
            job.cancel();
        }
        job.schedule();
    }
}

