/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonAnnotationModelFactory;
import com.aptana.editor.common.CommonDocumentProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class LazyProxyDocumentProvider
extends TextFileDocumentProvider {
    private CommonDocumentProvider fDocumentProvider;
    private boolean fConnected = false;

    public LazyProxyDocumentProvider(CommonDocumentProvider cdp) {
        cdp.setParentDocumentProvider((IDocumentProvider)this);
        this.fDocumentProvider = cdp;
    }

    public void connect(Object element) throws CoreException {
        if (!PlatformUI.getWorkbench().isStarting() && this.fDocumentProvider != null) {
            this.fDocumentProvider.connect(element);
            this.fConnected = true;
        }
        super.connect(element);
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        if (this.fDocumentProvider != null) {
            return this.fDocumentProvider.createAnnotationModel(file);
        }
        return new CommonAnnotationModelFactory().createAnnotationModel(file.getFullPath());
    }

    public void disconnect(Object element) {
        if (this.fDocumentProvider != null) {
            this.fDocumentProvider.setParentDocumentProvider((IDocumentProvider)new StorageDocumentProvider());
            this.fDocumentProvider.disconnect(element);
        }
        super.disconnect(element);
    }

    public CommonDocumentProvider getDocumentProvider() {
        return this.fDocumentProvider;
    }

    public boolean hasConnected() {
        return this.fConnected;
    }

    public void doConnect(AbstractThemeableEditor editor) {
        if (this.fDocumentProvider != null) {
            try {
                this.fDocumentProvider.doConnect(editor);
                this.fConnected = true;
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
            }
        }
    }
}

