/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.progress.UIJob;

class FilenameDifferentiator
extends UIJob
implements IPartListener2 {
    private static final String SEPARATOR = " | ";

    public FilenameDifferentiator() {
        super("Install filename differentiator");
        this.setSystem(true);
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        IWorkbenchWindow window;
        IWorkbench workbench = null;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (Exception exception) {}
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && window.getActivePage() != null) {
            window.getActivePage().addPartListener((IPartListener2)this);
        }
        return Status.OK_STATUS;
    }

    public void partActivated(IWorkbenchPartReference part) {
        this.disambiguate(part);
    }

    public void partBroughtToTop(IWorkbenchPartReference part) {
    }

    public void partClosed(IWorkbenchPartReference part) {
        if (!(part instanceof IEditorReference)) {
            return;
        }
        if (((EditorReference)part).getMemento() != null) {
            return;
        }
        IEditorReference[] editors = part.getPage().getEditorReferences();
        if (editors.length == 0) {
            return;
        }
        HashSet<IEditorReference> list = new HashSet<IEditorReference>();
        String title = this.getBaseName(part);
        IEditorReference[] iEditorReferenceArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editor = iEditorReferenceArray[n2];
            if (!editor.equals(part) && title.equals(this.getBaseName((IWorkbenchPartReference)editor))) {
                list.add(editor);
            }
            ++n2;
        }
        if (list.size() == 1) {
            this.setTitle((IEditorReference)list.iterator().next(), title);
        }
    }

    public void partDeactivated(IWorkbenchPartReference part) {
    }

    public void partOpened(IWorkbenchPartReference part) {
        this.disambiguate(part);
    }

    private void disambiguate(IWorkbenchPartReference part) {
        if (!(part instanceof IEditorReference)) {
            return;
        }
        IEditorReference[] editors = part.getPage().getEditorReferences();
        HashSet<IEditorReference> list = new HashSet<IEditorReference>();
        if (editors.length <= 1) {
            return;
        }
        list.add((IEditorReference)part);
        String title = this.getBaseName(part);
        IEditorReference[] iEditorReferenceArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editor = iEditorReferenceArray[n2];
            if (!editor.equals(part) && title.equals(this.getBaseName((IWorkbenchPartReference)editor))) {
                list.add(editor);
            }
            ++n2;
        }
        if (list.size() > 1) {
            Map<IEditorReference, String> newTitles = this.getUnambiguousTitles(list);
            for (Map.Entry<IEditorReference, String> entry : newTitles.entrySet()) {
                this.setTitle(entry.getKey(), entry.getValue());
            }
        }
    }

    private void setTitle(IEditorReference key, String value) {
        try {
            IWorkbenchPart part = key.getPart(false);
            if (part != null) {
                Method m = WorkbenchPart.class.getDeclaredMethod("setPartName", String.class);
                m.setAccessible(true);
                m.invoke((Object)part, value);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    protected String getBaseName(IWorkbenchPartReference part) {
        String title = part.getTitle();
        return title.split(Pattern.quote(SEPARATOR))[0];
    }

    private Map<IEditorReference, String> getUnambiguousTitles(Collection<IEditorReference> list) {
        IPath path;
        HashMap<IEditorReference, IPath> map = new HashMap<IEditorReference, IPath>();
        int min = Integer.MAX_VALUE;
        for (IEditorReference part : list) {
            path = this.getPath(part);
            if (path == null) continue;
            min = Math.min(path.segmentCount(), min);
            map.put(part, path);
        }
        HashMap<IEditorReference, String> returnMap = new HashMap<IEditorReference, String>();
        HashSet<String> curSegments = new HashSet<String>();
        int i = 2;
        while (i <= min) {
            returnMap.clear();
            curSegments.clear();
            for (Map.Entry entry : map.entrySet()) {
                path = (IPath)entry.getValue();
                String segment = path.segment(path.segmentCount() - i);
                if (curSegments.contains(segment)) break;
                curSegments.add(segment);
                String title = String.valueOf(path.lastSegment()) + SEPARATOR + segment;
                returnMap.put((IEditorReference)entry.getKey(), title);
            }
            if (curSegments.size() == map.size()) {
                return returnMap;
            }
            ++i;
        }
        return Collections.emptyMap();
    }

    private IPath getPath(IEditorReference otherEditor) {
        try {
            IEditorInput input = otherEditor.getEditorInput();
            if (input instanceof IPathEditorInput) {
                return ((IPathEditorInput)input).getPath();
            }
            URI uri = (URI)input.getAdapter(URI.class);
            if (uri != null) {
                return new Path(String.valueOf(uri.getHost()) + '/' + uri.getPath());
            }
            if (input instanceof IURIEditorInput) {
                return URIUtil.toPath((URI)((IURIEditorInput)input).getURI());
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void dispose() {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        IWorkbench workbench = null;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (Exception exception) {}
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            page.removePartListener((IPartListener2)this);
        }
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }
}

