/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.realtime.RealTimeInterface;
import com.aptana.editor.common.realtime.RealTimeReferenceFileChangeListener;
import com.aptana.editor.common.realtime.WebServerChangeListener;
import com.aptana.ui.util.StatusLineUtils;
import com.pandora.realtime.preview.IRealTimeInterface;
import com.pandora.realtime.preview.RealTimeHelper;
import java.io.File;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.progress.UIJob;

public class CommonStartup
implements IStartup {
    private String[] phpExts = new String[]{"php", "phtml", "inc", "ctp"};

    public void earlyStartup() {
        this.initTempFile();
        try {
            RealTimeHelper.init((IRealTimeInterface)new RealTimeInterface());
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        try {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new RealTimeReferenceFileChangeListener(), 1);
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        try {
            WebServerChangeListener.addWebServerChangeListener();
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        Job job = new Job("CommonContentAssistProcessor initSpecialListHandler"){

            protected IStatus run(IProgressMonitor monitor) {
                CommonContentAssistProcessor.initSpecialListHandler();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        UIJob synchronizationJob = new UIJob("Synchronization toggle status"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    State state;
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    Command command = null;
                    command = commandService.getCommand("com.pandora.ui.toggleShowIndentGuide");
                    if (command != null && (state = command.getState("org.eclipse.ui.commands.toggleState")) != null) {
                        state.setValue((Object)this.getPreferenceStore().getBoolean("com.aptana.editor.common.showIndentGuide"));
                    }
                    if ((command = commandService.getCommand("com.pandora.ui.lineNumberToggle")) != null) {
                        command.getState("org.eclipse.ui.commands.toggleState").setValue((Object)EditorsUI.getPreferenceStore().getBoolean("lineNumberRuler"));
                    }
                    if ((command = commandService.getCommand("com.aptana.view.toggleWordWrapCommand")) != null) {
                        command.getState("org.eclipse.ui.commands.toggleState").setValue((Object)this.getPreferenceStore().getBoolean("com.aptana.editor.common.enableWordWrap"));
                    }
                    if ((command = commandService.getCommand("com.aptana.editor.toggleWordWrapCommand")) != null) {
                        command.getState("org.eclipse.ui.commands.toggleState").setValue((Object)this.getPreferenceStore().getBoolean("com.aptana.editor.common.enableWordWrap"));
                    }
                    if ((command = commandService.getCommand("com.pandora.ui.toggleBlockSelectionMode")) != null) {
                        command.getState("org.eclipse.ui.commands.toggleState").setValue((Object)false);
                    }
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }

            private IPreferenceStore getPreferenceStore() {
                return CommonEditorPlugin.getDefault().getPreferenceStore();
            }
        };
        synchronizationJob.setSystem(true);
        synchronizationJob.schedule();
    }

    private void initTempFile() {
        try {
            if (CommonEditorPlugin.TEMP_FILES == null) {
                CommonEditorPlugin.initTempFile();
            }
            final IWorkbench workbench = PlatformUI.getWorkbench();
            final IWorkbenchWindow[] workbenchWindow = new IWorkbenchWindow[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    workbenchWindow[0] = workbench.getActiveWorkbenchWindow();
                }
            });
            IWorkbenchPage page = workbenchWindow[0].getActivePage();
            IEditorReference[] editorreferences = page.getEditorReferences();
            HashMap<String, IEditorReference> editorReferenceMap = new HashMap<String, IEditorReference>();
            IEditorReference[] iEditorReferenceArray = editorreferences;
            int n = editorreferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                String titleToolTip = editorReference.getTitleToolTip();
                File file = new File(titleToolTip);
                String name = file.getName();
                String tName = "";
                tName = name.startsWith("\u5f10&T") ? CommonEditorPlugin.getTempName(name) : CommonEditorPlugin.getTempName(titleToolTip);
                editorReferenceMap.put(tName, editorReference);
                ++n2;
            }
            Set<String> fileNames = CommonEditorPlugin.TEMP_FILES.keySet();
            for (String fileName : fileNames) {
                try {
                    final File file = CommonEditorPlugin.TEMP_FILES.get(fileName);
                    if (!editorReferenceMap.containsKey(fileName)) continue;
                    final IEditorReference editorReference = (IEditorReference)editorReferenceMap.get(fileName);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                IEditorPart part = editorReference.getEditor(false);
                                if (part != null && part instanceof AbstractThemeableEditor) {
                                    ISelection selection = ((AbstractThemeableEditor)part).getSelectionProvider().getSelection();
                                    String title = part.getTitle();
                                    if (title.startsWith("\u5f10&T") || title.startsWith("*\u65e0\u6807\u9898")) {
                                        CommonEditorPlugin.openTempFile((AbstractThemeableEditor)part, null);
                                    } else {
                                        CommonEditorPlugin.openTempFile((AbstractThemeableEditor)part, file);
                                        ((AbstractThemeableEditor)part).getSelectionProvider().setSelection(selection);
                                    }
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addWorkspaceReourceChangeListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    try {
                        delta.accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta delta) throws CoreException {
                                IResource resource = delta.getResource();
                                if (resource == null) {
                                    return false;
                                }
                                IProject project = resource.getProject();
                                if (project != null && !project.hasNature("com.pandora.projects.ui.MKeyNature")) {
                                    return false;
                                }
                                switch (delta.getKind()) {
                                    case 1: {
                                        if (!StringUtil.contains((String[])CommonStartup.this.phpExts, (String)resource.getFileExtension())) break;
                                        StatusLineUtils.showErrorMessage((String)"\u5728\u79fb\u52a8\u9879\u76ee\u4e0bphp\u6587\u4ef6\u65e0\u6cd5\u8fd0\u884c\uff0c\u5efa\u8bae\u5728web\u9879\u76ee\u4e0b\u8fdb\u884cphp\u5f00\u53d1\u3002", (long)3000L);
                                        break;
                                    }
                                }
                                return true;
                            }
                        });
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }
}

