/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonAnnotationModelFactory;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.internal.scripting.DocumentScopeManager;
import com.aptana.editor.common.scripting.IDocumentScopeManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;

public abstract class CommonDocumentProvider
extends TextFileDocumentProvider {
    public void connect(Object element) throws CoreException {
        super.connect(element);
        IDocument document = this.getDocument(element);
        if (document != null) {
            String fileName = null;
            if (element instanceof IFileEditorInput) {
                IFileEditorInput input = (IFileEditorInput)element;
                IFile file = input.getFile();
                fileName = file.getName();
            } else if (element instanceof IPathEditorInput) {
                IPathEditorInput input = (IPathEditorInput)element;
                fileName = input.getPath().lastSegment();
            } else if (element instanceof IURIEditorInput) {
                IURIEditorInput input = (IURIEditorInput)element;
                fileName = new Path(input.getURI().getPath()).lastSegment();
            }
            CommonEditorPlugin.getDefault().getDocumentScopeManager().setDocumentScope(document, this.getDefaultContentType(fileName), fileName);
        }
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new CommonAnnotationModelFactory().createAnnotationModel(file.getFullPath());
    }

    public void disconnect(Object element) {
        IDocument document;
        TextFileDocumentProvider.FileInfo fileInfo = this.getFileInfo(element);
        if (fileInfo != null && fileInfo.fCount == 1 && (document = this.getDocument(element)) != null) {
            IDocumentPartitioner partitioner = document.getDocumentPartitioner();
            if (partitioner != null) {
                partitioner.disconnect();
                document.setDocumentPartitioner(null);
            }
            try {
                IDocumentScopeManager documentScopeManager = CommonEditorPlugin.getDefault().getDocumentScopeManager();
                if (documentScopeManager instanceof DocumentScopeManager) {
                    ((DocumentScopeManager)documentScopeManager).removeDocumentScope(document);
                }
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            }
        }
        super.disconnect(element);
    }

    protected abstract String getDefaultContentType(String var1);

    public void doConnect(AbstractThemeableEditor editor) throws CoreException {
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        if (document != null && document.getDocumentPartitioner() == null) {
            this.connect(editor.getEditorInput());
        }
    }
}

