/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.build.util.AssistHelper;
import com.aptana.buildpath.core.BuildPathEntry;
import com.aptana.buildpath.core.BuildPathManager;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.common.contentassist.ICommonCompletionProposal;
import com.aptana.editor.common.contentassist.ICommonContentAssistProcessor;
import com.aptana.editor.common.contentassist.StringValueCompletionProposal;
import com.aptana.editor.common.contentassist.UserAgentFilterType;
import com.aptana.editor.common.contentassist.UserAgentManager;
import com.aptana.editor.common.extensions.ISpecialListHandler;
import com.aptana.editor.common.scripting.IDocumentScopeManager;
import com.aptana.editor.common.scripting.snippets.SnippetTemplateProposal;
import com.aptana.editor.common.scripting.snippets.SnippetType;
import com.aptana.editor.common.scripting.snippets.SnippetsCompletionProcessor;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.index.core.Index;
import com.aptana.index.core.QueryResult;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.CommandContext;
import com.aptana.scripting.model.CommandResult;
import com.aptana.scripting.model.ContentAssistElement;
import com.aptana.scripting.model.filters.IModelFilter;
import com.aptana.scripting.model.filters.ScopeFilter;
import com.aptana.ui.util.UIUtils;
import com.pandora.core.stats.Stats;
import com.pandora.core.utils.RegistryUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;

public class CommonContentAssistProcessor
implements IContentAssistProcessor,
ICommonContentAssistProcessor,
IEclipsePreferences.IPreferenceChangeListener {
    private static final String DEFAULT_IMAGE = "icons/proposal.png";
    private static final String INSERT = "insert";
    private static final String DISPLAY = "display";
    private static final String IMAGE = "image";
    private static final String TOOL_TIP = "tool_tip";
    private static final String LOCATION = "location";
    private static final String PERFORMANCE_EVENT_PREFIX = "com.aptana.editor.common/perf/content_assist";
    private static final String RUBLE_PERF = "com.aptana.editor.common/perf/content_assist/rubles";
    private static final String SNIPPET_PERF = "com.aptana.editor.common/perf/content_assist/snippets";
    public static final String[] NUMBER_STRING = new String[]{"LengthString", "NumberString", "TimeString", "AngleString", "FrequencyString"};
    protected static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];
    public static final Map<String, ISpecialListHandler> SPEC_MAPS = new HashMap<String, ISpecialListHandler>();
    protected static final String[] autoShowContentAssistChars = new String[]{".", "=", "=\"", ":", "/", ".html"};
    protected boolean isDisposed;
    private char[] _completionProposalChars = null;
    private char[] _contextInformationChars = null;
    private char[] _proposalTriggerChars = null;
    private URI _uri = null;
    private UserAgentFilterType _filterType = UserAgentFilterType.NO_FILTER;
    protected AbstractThemeableEditor editor;
    private URI _projectURI;
    private IProject _project;
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("CONTENT_ASSIST_USER_AGENT_FILTER_TYPE".equals(event.getProperty())) {
                CommonContentAssistProcessor.this._filterType = UserAgentFilterType.get(event.getNewValue().toString());
            }
        }
    };

    public CommonContentAssistProcessor(AbstractThemeableEditor editor) {
        this.editor = editor;
        try {
            this._uri = EditorUtil.getURI((IEditorPart)editor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._completionProposalChars = this.retrieveCAPreference("completionProposalActivationCharacters");
        this._contextInformationChars = this.retrieveCAPreference("contextInformationActivationCharacters");
        this._proposalTriggerChars = this.retrieveCAPreference("proposalTriggerCharacters");
        IPreferenceStore commonPreferences = CommonEditorPlugin.getDefault().getPreferenceStore();
        String filterTypeString = commonPreferences.getString("CONTENT_ASSIST_USER_AGENT_FILTER_TYPE");
        this._filterType = UserAgentFilterType.get(filterTypeString);
        commonPreferences.addPropertyChangeListener(this.propertyChangeListener);
        if (this.getPreferenceNodeQualifier() != null) {
            EclipseUtil.instanceScope().getNode(this.getPreferenceNodeQualifier()).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
    }

    public static void initSpecialListHandler() {
        try {
            if (!SPEC_MAPS.isEmpty()) {
                return;
            }
            List elements = RegistryUtils.getEp((String)"com.aptana.editor.common.specialList", (String)"special");
            if (elements != null) {
                for (IConfigurationElement cfg : elements) {
                    String type = cfg.getAttribute("type");
                    ISpecialListHandler handler = (ISpecialListHandler)cfg.createExecutableExtension("handler");
                    SPEC_MAPS.put(type, handler);
                }
                IdeLog.logInfo((Plugin)CommonEditorPlugin.getDefault(), (String)"\u7279\u6b8a\u5217\u8868\u6269\u5c55\u70b9\u52a0\u8f7d\u5b8c\u6210...");
            }
        }
        catch (Exception e) {
            try {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                Stats.addExceptionInfo((Throwable)e);
            }
            catch (Exception exception) {}
        }
    }

    protected void addCompletionProposalsForCategory(ITextViewer viewer, int offset, Index index, List<ICompletionProposal> completionProposals, String category) {
        List queryResults = index.query(new String[]{category}, "", 1);
        if (queryResults != null) {
            for (QueryResult queryResult : queryResults) {
                String text = queryResult.getWord();
                int length = text.length();
                String info = String.valueOf(category) + " : " + text;
                completionProposals.add((ICompletionProposal)new CompletionProposal(text, offset, 0, length, null, text, null, info));
            }
        }
    }

    protected Collection<? extends ICompletionProposal> addRubleCAProposals(ITextViewer viewer, int offset, Ruby ruby, ContentAssistElement ce) {
        boolean recordPerf = PerformanceStats.isEnabled((String)RUBLE_PERF);
        PerformanceStats stats = null;
        CommandContext context = ce.createCommandContext();
        context.setInputStream((InputStream)new ByteArrayInputStream(viewer.getDocument().get().getBytes()));
        if (recordPerf) {
            stats = PerformanceStats.getStats((String)RUBLE_PERF, (Object)ce.getDisplayName());
            stats.startRun();
        }
        CommandResult result = ce.execute(context);
        if (recordPerf) {
            stats.endRun();
        }
        if (result == null || !result.executedSuccessfully()) {
            return Collections.emptyList();
        }
        String output = result.getOutputString();
        if (StringUtil.isEmpty((String)output)) {
            return Collections.emptyList();
        }
        RubyArray object = (RubyArray)ruby.evalScriptlet(output);
        RubySymbol insertSymbol = RubySymbol.newSymbol((Ruby)ruby, (String)INSERT);
        RubySymbol displaySymbol = RubySymbol.newSymbol((Ruby)ruby, (String)DISPLAY);
        RubySymbol imageSymbol = RubySymbol.newSymbol((Ruby)ruby, (String)IMAGE);
        RubySymbol tooltipSymbol = RubySymbol.newSymbol((Ruby)ruby, (String)TOOL_TIP);
        RubySymbol locationSymbol = RubySymbol.newSymbol((Ruby)ruby, (String)LOCATION);
        ArrayList<CommonCompletionProposal> proposals = new ArrayList<CommonCompletionProposal>();
        IRubyObject[] iRubyObjectArray = object.toJavaArray();
        int n = iRubyObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            block17: {
                String displayName;
                int length;
                String name;
                Image image;
                int replaceLength;
                IContextInformation contextInfo;
                String location;
                String description;
                block18: {
                    IRubyObject element;
                    block16: {
                        element = iRubyObjectArray[n2];
                        description = null;
                        location = null;
                        contextInfo = null;
                        replaceLength = 0;
                        image = UIUtils.getImage((AbstractUIPlugin)CommonEditorPlugin.getDefault(), (String)DEFAULT_IMAGE);
                        if (!(element instanceof RubyHash)) break block16;
                        RubyHash hash = (RubyHash)element;
                        if (!hash.containsKey(insertSymbol)) break block17;
                        name = hash.get(insertSymbol).toString();
                        length = name.length();
                        displayName = hash.containsKey(displaySymbol) ? hash.get(displaySymbol).toString() : name;
                        if (hash.containsKey(locationSymbol)) {
                            location = hash.get(locationSymbol).toString();
                        }
                        if (hash.containsKey(imageSymbol)) {
                            String imagePath = hash.get(imageSymbol).toString();
                            ImageRegistry reg = CommonEditorPlugin.getDefault().getImageRegistry();
                            Image fromReg = reg.get(imagePath);
                            if (fromReg == null) {
                                URL imageURL = null;
                                try {
                                    imageURL = new URL(imagePath);
                                }
                                catch (MalformedURLException malformedURLException) {
                                    try {
                                        imageURL = new File(imagePath).toURI().toURL();
                                    }
                                    catch (MalformedURLException e1) {
                                        IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e1);
                                    }
                                }
                                if (imageURL != null) {
                                    ImageDescriptor desc = ImageDescriptor.createFromURL((URL)imageURL);
                                    reg.put(imagePath, desc);
                                    image = reg.get(imagePath);
                                }
                            } else {
                                image = fromReg;
                            }
                        }
                        if (hash.containsKey(tooltipSymbol)) {
                            description = hash.get(tooltipSymbol).toString();
                        }
                        break block18;
                    }
                    displayName = name = element.toString();
                    length = name.length();
                }
                CommonCompletionProposal proposal = new CommonCompletionProposal(name, offset, replaceLength, length, image, displayName, contextInfo, description);
                if (location != null) {
                    proposal.setFileLocation(location);
                }
                proposal.setCompletionProposalType(CompletionProposalType.CODEBLOCK);
                proposals.add(proposal);
            }
            ++n2;
        }
        return proposals;
    }

    protected List<ICompletionProposal> addRubleProposals(ITextViewer viewer, int offset) {
        AssistHelper.checkState();
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        try {
            String scope = this.getDocumentScopeManager().getScopeAtOffset(viewer, offset);
            List commands = this.getBundleManager().getContentAssists((IModelFilter)new ScopeFilter(scope));
            if (!CollectionsUtil.isEmpty((Collection)commands)) {
                Ruby ruby = Ruby.newInstance();
                for (ContentAssistElement ce : commands) {
                    proposals.addAll(this.addRubleCAProposals(viewer, offset, ruby, ce));
                }
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        proposals.trimToSize();
        return proposals;
    }

    protected Collection<ICompletionProposal> addSnippetProposals(ITextViewer viewer, int offset, boolean autoActivated) {
        AssistHelper.checkState();
        SnippetType snippetType = this.getSnippetType();
        if (snippetType == null || snippetType.getType() == SnippetType.Type.NO_TYPE) {
            return Collections.emptyList();
        }
        if (viewer != null && viewer.getSelectionProvider() != null) {
            PerformanceStats stats = null;
            if (PerformanceStats.isEnabled((String)SNIPPET_PERF)) {
                stats = PerformanceStats.getStats((String)SNIPPET_PERF, (Object)"SnippetsCompletionProcessor");
                stats.startRun();
            }
            SnippetsCompletionProcessor snippetsProcessor = new SnippetsCompletionProcessor(autoActivated, snippetType.getScope());
            snippetsProcessor.setContextTypeId(this.getSnippetContextTypeId());
            snippetsProcessor.setProject(this.getProject());
            ICompletionProposal[] snippets = snippetsProcessor.computeCompletionProposals(viewer, offset);
            if (stats != null) {
                stats.endRun();
            }
            if (snippets == null) {
                return Collections.emptyList();
            }
            boolean needShowWXSnippet = true;
            boolean needShowMuiSnippet = true;
            try {
                BuildPathManager buildPathManager = BuildPathManager.getInstance();
                Set buildPathEntrySet = buildPathManager.getBuildPaths(this.getProject());
                boolean isBuildWX = false;
                boolean isBuildMui = false;
                for (BuildPathEntry buildPathEntry : buildPathEntrySet) {
                    String displayName = buildPathEntry.getDisplayName();
                    if (!isBuildWX && StringUtil.isNotBlank((String)displayName) && displayName.startsWith("weixin ")) {
                        isBuildWX = true;
                    }
                    if (isBuildMui || !StringUtil.isNotBlank((String)displayName) || !displayName.startsWith("mui ")) continue;
                    isBuildMui = true;
                }
                boolean hasWXNature = false;
                boolean hasHMobileNature = false;
                if (this.getProject() != null) {
                    hasWXNature = this.getProject().hasNature("com.pandora.projects.ui.wxNature");
                    hasHMobileNature = this.getProject().hasNature("com.pandora.projects.ui.MKeyNature");
                }
                needShowWXSnippet = isBuildWX || hasWXNature;
                needShowMuiSnippet = isBuildMui || hasHMobileNature;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ArrayList<ICompletionProposal> results = new ArrayList<ICompletionProposal>();
            ICompletionProposal[] iCompletionProposalArray = snippets;
            int n = snippets.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal proposal = iCompletionProposalArray[n2];
                if (proposal instanceof SnippetTemplateProposal) {
                    String url;
                    SnippetTemplateProposal snippet = (SnippetTemplateProposal)proposal;
                    if (!(!needShowWXSnippet && StringUtil.isNotBlank((String)(url = snippet.getSnippetPath())) && url.contains("wx.ruble") && url.contains("com.pandora") || !needShowMuiSnippet && StringUtil.isNotBlank((String)(url = snippet.getSnippetPath())) && url.contains("mui.ruble") && url.contains("com.pandora") || !snippet.validateSnippetType(snippetType.getType()))) {
                        results.add(proposal);
                    }
                } else {
                    results.add(proposal);
                }
                ++n2;
            }
            return results;
        }
        return Collections.emptyList();
    }

    public String getSnippetContextTypeId() {
        return null;
    }

    public SnippetType getSnippetType() {
        return new SnippetType(SnippetType.Type.DEFAULT);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ArrayList<ICompletionProposal> completionProposals = new ArrayList<ICompletionProposal>();
        Index index = this.getIndex();
        if (index != null) {
            this.computeCompletionProposalsUsingIndex(viewer, offset, index, completionProposals);
        }
        return completionProposals.toArray(new ICompletionProposal[completionProposals.size()]);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        AssistHelper.checkState();
        PerformanceStats stats = null;
        try {
            ICompletionProposal[] others;
            if (PerformanceStats.isEnabled((String)PERFORMANCE_EVENT_PREFIX)) {
                stats = PerformanceStats.getStats((String)PERFORMANCE_EVENT_PREFIX, (Object)this);
                stats.startRun();
            }
            if ((others = this.doComputeCompletionProposals(viewer, offset, activationChar, autoActivated)) == null) {
                others = NO_PROPOSALS;
            }
            Collection<ICompletionProposal> snippetProposals = this.addSnippetProposals(viewer, offset, autoActivated);
            List<ICompletionProposal> rubleProposals = this.addRubleProposals(viewer, offset);
            AssistHelper.checkState();
            Collection proposals = CollectionsUtil.union(rubleProposals, snippetProposals);
            if (IdeLog.isTraceEnabled((Plugin)CommonEditorPlugin.getDefault(), (String)"com.aptana.editor.common/debug/content_assist")) {
                IdeLog.logTrace((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Generated {0} ruble proposals, {0} snippet proposals, and {0} language proposals", rubleProposals.size(), snippetProposals.size(), others.length), (String)"com.aptana.editor.common/debug/content_assist");
            }
            ICompletionProposal[] combined = new ICompletionProposal[others.length + proposals.size()];
            this.sortProposals(others);
            System.arraycopy(others, 0, combined, 0, others.length);
            ICompletionProposal[] proposalArrays = proposals.toArray(new ICompletionProposal[0]);
            this.sortProposals(proposalArrays);
            System.arraycopy(proposalArrays, 0, combined, others.length, proposalArrays.length);
            if (IdeLog.isTraceEnabled((Plugin)CommonEditorPlugin.getDefault(), (String)"com.aptana.editor.common/debug/content_assist")) {
                IdeLog.logTrace((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Combined {0} total proposals", combined.length), (String)"com.aptana.editor.common/debug/content_assist");
            }
            ICompletionProposal[] iCompletionProposalArray = combined;
            return iCompletionProposalArray;
        }
        finally {
            if (stats != null) {
                stats.endRun();
            }
        }
    }

    protected void computeCompletionProposalsUsingIndex(ITextViewer viewer, int offset, Index index, List<ICompletionProposal> completionProposals) {
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public void dispose() {
        IPreferenceStore commonPreferences;
        this.editor = null;
        this._completionProposalChars = null;
        this._contextInformationChars = null;
        this._proposalTriggerChars = null;
        this._project = null;
        if (this.getPreferenceNodeQualifier() != null) {
            EclipseUtil.instanceScope().getNode(this.getPreferenceNodeQualifier()).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        if ((commonPreferences = CommonEditorPlugin.getDefault().getPreferenceStore()) != null) {
            commonPreferences.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.isDisposed = true;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        return this.computeCompletionProposals(viewer, offset);
    }

    public int getUserAgentCount() {
        String[] ids = UserAgentManager.getInstance().getActiveUserAgentIDs(this.getProject());
        if (ids == null || ids.length == 0) {
            return 0;
        }
        int sdk = 0;
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (UserAgentManager.getInstance().isSDKAgents(id)) {
                ++sdk;
            }
            ++n2;
        }
        return ids.length - sdk > sdk ? ids.length - sdk : sdk;
    }

    protected IParseNode getAST() {
        return this.editor.getAST();
    }

    protected BundleManager getBundleManager() {
        return BundleManager.getInstance();
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this._completionProposalChars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this._contextInformationChars;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    protected IDocumentScopeManager getDocumentScopeManager() {
        return CommonEditorPlugin.getDefault().getDocumentScopeManager();
    }

    public String getErrorMessage() {
        return null;
    }

    protected String getFilename() {
        return this.editor.getEditorInput().getName();
    }

    protected Index getIndex() {
        return EditorUtil.getIndex(this.editor);
    }

    protected String getPreferenceNodeQualifier() {
        return null;
    }

    protected IProject getProject() {
        return this._project == null ? (this._project = EditorUtil.getProject(this.editor)) : this._project;
    }

    protected URI getProjectURI() {
        return this._projectURI == null ? (this._projectURI = EditorUtil.getProjectURI(this.editor)) : this._projectURI;
    }

    public char[] getProposalTriggerCharacters() {
        return this._proposalTriggerChars;
    }

    protected URI getURI() {
        return this._uri == null ? EditorUtil.getURI((IEditorPart)this.editor) : this._uri;
    }

    public boolean isActiveByUserAgent(String[] userAgents) {
        boolean result = false;
        if (userAgents == null || userAgents.length == 0) {
            result = true;
        } else {
            block0 : switch (this._filterType) {
                case NO_FILTER: {
                    result = true;
                    break;
                }
                case ONE_OR_MORE: {
                    String[] userAgentIds = UserAgentManager.getInstance().getActiveUserAgentIDs(this.getProject());
                    HashSet<String> activeNameSet = new HashSet<String>(Arrays.asList(userAgentIds));
                    String[] stringArray = userAgents;
                    int n = userAgents.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        if (activeNameSet.contains(id)) {
                            result = true;
                            break block0;
                        }
                        ++n2;
                    }
                    break;
                }
                case ALL: {
                    HashSet<String> nameSet = new HashSet<String>(Arrays.asList(userAgents));
                    String[] activeUserAgentIds = UserAgentManager.getInstance().getActiveUserAgentIDs(this.getProject());
                    result = nameSet.containsAll(Arrays.asList(activeUserAgentIds));
                    break;
                }
            }
        }
        return result;
    }

    public boolean isValidActivationCharacter(char c, int keyCode) {
        return false;
    }

    public boolean isValidAutoActivationLocation(char c, int keyCode, IDocument document, int offset) {
        return false;
    }

    public boolean isValidIdentifier(char c, int keyCode) {
        return false;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String key = event.getKey();
        if ("completionProposalActivationCharacters".equals(key)) {
            this._completionProposalChars = this.retrieveCAPreference("completionProposalActivationCharacters");
        } else if ("contextInformationActivationCharacters".equals(key)) {
            this._contextInformationChars = this.retrieveCAPreference("contextInformationActivationCharacters");
        } else if ("proposalTriggerCharacters".equals(key)) {
            this._proposalTriggerChars = this.retrieveCAPreference("proposalTriggerCharacters");
        }
    }

    private char[] retrieveCAPreference(String preferenceKey) {
        String chars = this.retrievePreference(preferenceKey);
        return chars != null ? chars.toCharArray() : null;
    }

    private String retrievePreference(String preferenceKey) {
        String qualifier = this.getPreferenceNodeQualifier();
        if (qualifier == null) {
            return null;
        }
        return Platform.getPreferencesService().getString(this.getPreferenceNodeQualifier(), preferenceKey, "", null);
    }

    protected void setSelectedProposal(String prefix, ICompletionProposal[] proposals) {
        AssistHelper.checkState();
        if (StringUtil.isEmpty((String)prefix) || proposals == null) {
            return;
        }
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            String displayString = proposal.getDisplayString();
            int comparison = displayString.compareToIgnoreCase(prefix);
            if (comparison >= 0 && displayString.toLowerCase().startsWith(prefix.toLowerCase())) {
                if (displayString.startsWith(prefix)) {
                    ((ICommonCompletionProposal)proposal).setRelevance(90);
                } else {
                    ((ICommonCompletionProposal)proposal).setRelevance(50);
                }
            }
            ++n2;
        }
    }

    public void setEditor(AbstractThemeableEditor editor) {
        this.editor = editor;
    }

    protected void sortProposals(ICompletionProposal[] proposals) {
        AssistHelper.checkState();
    }

    public boolean isEnableEmmet(IDocument document, int offset) {
        return true;
    }

    public static boolean checkTypesContainsNumber(List<String> types) {
        if (types == null || types.isEmpty()) {
            return false;
        }
        for (String type : types) {
            if (!StringUtil.isNotBlank((String)type) || !StringUtil.contains((String[])NUMBER_STRING, (String)type)) continue;
            return true;
        }
        return false;
    }

    public ICompletionProposal[] computeWordCompletionProposals(int offset, Image image, String[] containsChars) {
        return this.computeWordCompletionProposals(offset, image, containsChars, CompletionProposalType.CODEBLOCK);
    }

    public ICompletionProposal[] computeWordCompletionProposals(int offset, Image image, String[] containsChars, CompletionProposalType type) {
        IDocument document = this.editor.getDocument();
        HashSet<String> strings = new HashSet<String>();
        String prefixStr = this.getWordPrefix(offset, containsChars, document);
        int index = 0;
        StringBuilder sBuilder = new StringBuilder();
        do {
            char start;
            char c;
            try {
                c = document.getChar(index);
            }
            catch (BadLocationException badLocationException) {
                break;
            }
            if (this.isCharater(containsChars, c)) {
                sBuilder.append(c);
                continue;
            }
            String string = sBuilder.toString();
            if (StringUtil.isNotEmpty((String)string) && this.isStartCharater(containsChars, start = string.charAt(0)) && sBuilder.toString().startsWith(prefixStr) && !sBuilder.toString().equals(prefixStr)) {
                strings.add(sBuilder.toString());
            }
            sBuilder.delete(0, sBuilder.length());
        } while (++index < document.getLength());
        strings.addAll(this.computeSpecialWords());
        Range replaceRange = new Range(offset - prefixStr.length(), offset - 1);
        HashSet<StringValueCompletionProposal> results = new HashSet<StringValueCompletionProposal>();
        for (String str : strings) {
            StringValueCompletionProposal proposal = new StringValueCompletionProposal(str, (IRange)replaceRange, image, null);
            proposal.setIsItalics(true);
            proposal.setCompletionProposalType(type);
            results.add(proposal);
        }
        return results.toArray(new ICompletionProposal[results.size()]);
    }

    public String getWordPrefix(int offset, String[] containsChars, IDocument document) {
        StringBuilder prefix = new StringBuilder();
        int currentOffset = offset - 1;
        while (currentOffset >= 0) {
            try {
                char c = document.getChar(currentOffset);
                if (!this.isCharater(containsChars, c)) break;
                prefix.append(c);
            }
            catch (BadLocationException badLocationException) {
                break;
            }
            --currentOffset;
        }
        return prefix.reverse().toString();
    }

    protected Set<String> computeSpecialWords() {
        return Collections.emptySet();
    }

    public boolean isStartCharater(String[] containsChars, char start) {
        return Character.isJavaIdentifierStart(start) || StringUtil.contains((String[])containsChars, (String)String.valueOf(start));
    }

    public boolean isCharater(String[] containsChars, char c) {
        return Character.isJavaIdentifierPart(c) || StringUtil.contains((String[])containsChars, (String)String.valueOf(c));
    }
}

