/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.refactoring;

import com.aptana.parsing.lexer.IRange;
import com.pandora.refactor.core.RenameResourceInfo;
import com.pandora.refactor.core.refactoring.Messages;
import com.pandora.refactor.core.refactoring.RefactorContextInfo;
import com.pandora.refactor.core.refactoring.RefactorIRange;
import com.pandora.refactor.core.refactoring.TextFileContentChange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.IConditionChecker;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenameResourceDelegate {
    private final RenameResourceInfo info;
    private Map<IFile, List<RefactorIRange>> resourceFiles;
    private int prefix;

    public RenameResourceDelegate(RenameResourceInfo info) {
        this.info = info;
        this.resourceFiles = new HashMap<IFile, List<RefactorIRange>>();
    }

    public RefactoringStatus checkInitialConditions() {
        RefactoringStatus result = new RefactoringStatus();
        IFile sourceFile = this.info.getSourceFile();
        if (sourceFile == null || !sourceFile.exists()) {
            result.addFatalError("SourceFile is not exist");
        } else if (this.info.getSourceFile().isReadOnly()) {
            result.addFatalError("SourceFile is Readonly");
        } else if (this.isEmpty(this.info.getOldName())) {
            result.addFatalError("Key can not be null");
        }
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) {
        this.prefix = this.info.getNewName().length() - this.info.getOldName().length();
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask("checking", 100);
        RefactorContextInfo refactorContextInfo = this.info.getRefactorAction().doRefactor();
        this.resourceFiles = refactorContextInfo.getMapFromResult();
        pm.worked(50);
        if (context != null) {
            IFile[] files = new IFile[this.resourceFiles.size()];
            this.resourceFiles.keySet().toArray(files);
            IConditionChecker checker = context.getChecker(ValidateEditChecker.class);
            ValidateEditChecker editChecker = (ValidateEditChecker)checker;
            editChecker.addFiles(files);
        }
        pm.done();
        return result;
    }

    public void createChange(IProgressMonitor pm, CompositeChange rootChange) {
        try {
            pm.beginTask("connection changes", 100);
            if (this.info.isUpdateBundle()) {
                rootChange.addAll(this.createChangesForBundle());
            }
            pm.worked(100);
        }
        finally {
            pm.done();
        }
    }

    private Change[] createChangesForBundle() {
        ArrayList<CompositeChange> result = new ArrayList<CompositeChange>();
        Iterator<IFile> it = this.resourceFiles.keySet().iterator();
        CompositeChange indefineCompositeChange = new CompositeChange(Messages.RenameResourceDelegate_Rename_Indefine);
        CompositeChange undefineCompositeChange = new CompositeChange(Messages.RenameResourceDelegate_Rename_Undefine);
        CompositeChange indefineFileCompositeChange = null;
        CompositeChange undefineFIleCompositeChange = null;
        undefineCompositeChange.setEnabledShallow(false);
        boolean hasUndefine = false;
        boolean hasIndefine = false;
        while (it.hasNext()) {
            RefactorIRange iRange;
            IFile file = it.next();
            if (!file.exists()) continue;
            TextFileContentChange textFileChange = null;
            String name = String.valueOf(file.getName()) + " - " + file.getParent().getFullPath().makeRelative().toString();
            indefineFileCompositeChange = new CompositeChange(name);
            undefineFIleCompositeChange = new CompositeChange(name);
            List<RefactorIRange> list = this.resourceFiles.get(file);
            boolean hasFileIndefine = false;
            boolean hasFileUndefine = false;
            List<RefactorIRange> indefineList = this.getIndefineIRangeList(list);
            list.removeAll(indefineList);
            List<RefactorIRange> undefineList = list;
            int i = 0;
            while (i < indefineList.size()) {
                iRange = indefineList.get(i);
                if (iRange != null) {
                    textFileChange = this.getTextFileContentChange(iRange, i, file);
                    hasIndefine = true;
                    hasFileIndefine = true;
                    indefineFileCompositeChange.add((Change)textFileChange);
                }
                ++i;
            }
            i = 0;
            while (i < undefineList.size()) {
                iRange = undefineList.get(i);
                if (iRange != null) {
                    textFileChange = this.getTextFileContentChange(iRange, i, file);
                    hasUndefine = true;
                    hasFileUndefine = true;
                    textFileChange.setEnabledShallow(false);
                    undefineFIleCompositeChange.add((Change)textFileChange);
                }
                ++i;
            }
            if (hasFileIndefine) {
                indefineCompositeChange.add((Change)indefineFileCompositeChange);
            }
            if (!hasFileUndefine) continue;
            undefineCompositeChange.add((Change)undefineFIleCompositeChange);
        }
        if (hasIndefine) {
            result.add(indefineCompositeChange);
        }
        if (hasUndefine) {
            result.add(undefineCompositeChange);
        }
        return result.toArray(new Change[result.size()]);
    }

    private TextFileContentChange getTextFileContentChange(RefactorIRange iRange, int i, IFile file) {
        TextFileContentChange textFileChange = new TextFileContentChange(Messages.RenameResourceDelegate_Change_Name, file);
        ReplaceEdit edit = new ReplaceEdit(this.getKeyOffset((IRange)iRange, i), this.info.getOldName().length(), this.info.getNewName());
        ReplaceEdit previewEdit = new ReplaceEdit(this.getKeyOffset((IRange)iRange, 0), this.info.getOldName().length(), this.info.getNewName());
        textFileChange.setEdit((TextEdit)edit);
        textFileChange.setPreviewEdit((TextEdit)previewEdit);
        textFileChange.setKeepPreviewEdits(true);
        return textFileChange;
    }

    private List<RefactorIRange> getIndefineIRangeList(List<RefactorIRange> list) {
        ArrayList<RefactorIRange> indefineList = new ArrayList<RefactorIRange>();
        int i = 0;
        while (i < list.size()) {
            RefactorIRange iRange = list.get(i);
            if (iRange.isSure()) {
                indefineList.add(iRange);
            }
            ++i;
        }
        return indefineList;
    }

    private int getKeyOffset(IRange iRange, int i) {
        return Integer.valueOf(iRange.getStartingOffset()) + i * this.prefix;
    }

    private boolean isEmpty(String candidate) {
        return candidate == null || candidate.trim().length() == 0;
    }
}

