/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.refactoring;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.ExtendedFastPartitioner;
import com.aptana.editor.common.IExtendedPartitioner;
import com.aptana.editor.common.IPartitionerSwitchStrategy;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.NullPartitionerSwitchStrategy;
import com.aptana.editor.common.text.rules.CompositePartitionScanner;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.NullSubPartitionScanner;
import com.aptana.editor.css.CSSSourceConfiguration;
import com.aptana.editor.css.parsing.ast.CSSParseRootNode;
import com.aptana.editor.html.HTMLSourceConfiguration;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.js.JSSourceConfiguration;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.pandora.core.utils.RegularUtils;
import com.pandora.core.utils.URIUtils;
import com.pandora.refactor.core.refactoring.RefactorIRange;
import com.pandora.refactor.core.refactoring.RefactorUtils;
import com.pandora.refactor.core.refactoring.TextFileContentChange;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.TextSearchPage;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RefactorRenameFileParticipant
extends TextSearchPage {
    IProject _Project;
    String oldName;
    String newName;
    CompositeChange result;
    CompositeChange indentifineCompositeChange;
    CompositeChange undentifineCompositeChange;
    List<String> extendList;
    List<String> excludeFolderList;
    List<IFile> srcListFile = new ArrayList<IFile>();

    public RefactorRenameFileParticipant(CompositeChange compositeChange, IResource src, String oldName, String newName) {
        this._Project = src.getProject();
        this.oldName = oldName;
        this.newName = newName;
        this.result = compositeChange;
        this.undentifineCompositeChange = new CompositeChange("UnSelected renames");
        this.undentifineCompositeChange.setEnabledShallow(false);
        this.indentifineCompositeChange = new CompositeChange("Selected renames");
        this.extendList = Arrays.asList(RefactorUtils.EXTENDTIONS);
        this.excludeFolderList = Arrays.asList(RefactorUtils.EXCLUDEFOLDER);
        if (src instanceof IFile) {
            this.srcListFile.add((IFile)src);
        }
        if (src instanceof IFolder) {
            this.getFolderFile(src.getLocationURI());
        }
    }

    private void getFolderFile(URI uri) {
        try {
            IFileStore projectStore = EFS.getStore((URI)uri);
            this.refactorFolderFiles(projectStore);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void refactorFolderFiles(IFileStore projectStore) throws CoreException {
        IFileStore[] fileStores = projectStore.childStores(0, (IProgressMonitor)new NullProgressMonitor());
        if (fileStores == null || fileStores.length == 0) {
            return;
        }
        int i = 0;
        while (i < fileStores.length) {
            IFileStore fileStore = fileStores[i];
            if (fileStores != null && fileStores.length != 0) {
                File file = fileStore.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
                if (file.isFile()) {
                    String fname = file.getName();
                    if (StringUtil.isNotBlank((String)fname)) {
                        IPath ipath = RefactorRenameFileParticipant.getIPath(fileStore);
                        IFile ifile = RefactorRenameFileParticipant.getIFile(ipath);
                        this.srcListFile.add(ifile);
                    }
                } else {
                    this.refactorFolderFiles(fileStore);
                }
            }
            ++i;
        }
    }

    private static IFile getIFile(IPath ipath) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(ipath);
        return file;
    }

    private static IPath getIPath(IFileStore fileStore) {
        IPath path = Path.fromOSString((String)fileStore.toURI().getPath());
        return path;
    }

    public CompositeChange computeChange() {
        this.performAction();
        if (this.indentifineCompositeChange != null && this.indentifineCompositeChange.getChildren().length > 0) {
            this.result.add((Change)this.indentifineCompositeChange);
        }
        if (this.undentifineCompositeChange != null && this.undentifineCompositeChange.getChildren().length > 0) {
            this.result.add((Change)this.undentifineCompositeChange);
        }
        return this.result;
    }

    public boolean performAction() {
        IResource[] res = new IResource[]{this._Project};
        String[] extens = new String[]{"*.*"};
        FileTextSearchScope fts = FileTextSearchScope.newSearchScope((IResource[])res, (String[])extens, (boolean)false);
        FileSearchQuery isq = new FileSearchQuery(this.oldName, true, true, fts);
        isq.run((IProgressMonitor)new NullProgressMonitor());
        this.processResult(isq);
        return true;
    }

    private void processResult(FileSearchQuery isq) {
        ISearchResult isr = isq.getSearchResult();
        if (isr instanceof FileSearchResult) {
            Object[] os;
            FileSearchResult fsr = (FileSearchResult)isr;
            Object[] objectArray = os = fsr.getElements();
            int n = os.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                Object object = objectArray[n2];
                if (object instanceof IFile && this.checkFile(file = (IFile)object)) {
                    this.computeResult(fsr, object, file);
                }
                ++n2;
            }
        }
    }

    private void computeResult(FileSearchResult fileSearchResult, Object object, IFile ifile) {
        Match[] matchs = fileSearchResult.getMatches(object);
        try {
            IDocument document = this.getDocumentByIFile(ifile);
            boolean hasOnlyOne = false;
            if (matchs != null && matchs.length == 1) {
                hasOnlyOne = true;
            }
            if (this.isHTML(ifile)) {
                this.computeHTMLResult(ifile, matchs, document, hasOnlyOne);
            } else if (this.isJS(ifile)) {
                this.computeJSResult(ifile, matchs, document, hasOnlyOne);
            } else if (this.isCSS(ifile)) {
                this.computeCSSResult(ifile, matchs, document, hasOnlyOne);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void computeOtherResult(IFile ifile, Match[] matchs, IDocument document, boolean hasOnlyOne) {
        try {
            CompositeChange unchange = new CompositeChange(String.valueOf(ifile.getName()) + " - " + ifile.getParent().getFullPath().makeRelative().toString());
            unchange.setEnabledShallow(false);
            int prefixOffset = 0;
            TextFileContentChange textFileChange = null;
            boolean hasunChange = false;
            Match[] matchArray = matchs;
            int n = matchs.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                int startOffset = match.getOffset();
                int length = match.getLength();
                String replaceStr = document.get(startOffset, length);
                textFileChange = new TextFileContentChange(this.oldName, ifile);
                String replaceStr_new = this.newName;
                textFileChange.setEnabledShallow(false);
                ReplaceEdit edit = new ReplaceEdit(startOffset + prefixOffset, length, replaceStr_new);
                textFileChange.setEdit((TextEdit)edit);
                ReplaceEdit previewEdit = new ReplaceEdit(startOffset, length, replaceStr_new);
                textFileChange.setPreviewEdit((TextEdit)previewEdit);
                hasunChange = true;
                if (!hasOnlyOne) {
                    unchange.add((Change)textFileChange);
                }
                prefixOffset += replaceStr_new.length() - replaceStr.length();
                ++n2;
            }
            this.addUnOrIndentifineCompositeChange(hasOnlyOne, null, unchange, textFileChange, false, hasunChange);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void computeCSSResult(IFile ifile, Match[] matchs, IDocument document, boolean hasOnlyOne) {
        try {
            CompositeChange change = new CompositeChange(String.valueOf(ifile.getName()) + " - " + ifile.getParent().getFullPath().makeRelative().toString());
            CompositeChange unchange = new CompositeChange(String.valueOf(ifile.getName()) + " - " + ifile.getParent().getFullPath().makeRelative().toString());
            unchange.setEnabledShallow(false);
            int prefixOffset = 0;
            TextFileContentChange textFileChange = null;
            boolean hasChange = false;
            boolean hasunChange = false;
            CSSParseRootNode root = this.getCSSParseRoot(document);
            Match[] matchArray = matchs;
            int n = matchs.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                RefactorIRange range = this.getCSSIRange(ifile, document, match, root);
                if (range != null) {
                    String replaceStr = document.get(range.getStartingOffset(), range.getLength());
                    int startOffset = range.getStartingOffset();
                    textFileChange = new TextFileContentChange(this.oldName, ifile);
                    String replaceStr_new = "";
                    if (range.isSure()) {
                        hasChange = true;
                        replaceStr_new = this.getFolderRelativePath(replaceStr, ifile);
                        ReplaceEdit edit = new ReplaceEdit(startOffset + prefixOffset, range.getLength(), replaceStr_new);
                        textFileChange.setEdit((TextEdit)edit);
                        ReplaceEdit previewEdit = new ReplaceEdit(startOffset, range.getLength(), replaceStr_new);
                        textFileChange.setPreviewEdit((TextEdit)previewEdit);
                        if (!hasOnlyOne) {
                            if (range.isSure()) {
                                change.add((Change)textFileChange);
                            } else {
                                unchange.add((Change)textFileChange);
                            }
                        }
                        prefixOffset += replaceStr_new.length() - replaceStr.length();
                    }
                }
                ++n2;
            }
            this.addUnOrIndentifineCompositeChange(hasOnlyOne, change, unchange, textFileChange, hasChange, hasunChange);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addUnOrIndentifineCompositeChange(boolean hasOnlyOne, CompositeChange change, CompositeChange unchange, TextFileContentChange textFileChange, boolean hasChange, boolean hasunChange) {
        if (hasChange) {
            if (hasOnlyOne) {
                this.indentifineCompositeChange.add((Change)textFileChange);
            } else {
                this.indentifineCompositeChange.add((Change)change);
            }
        }
        if (hasunChange) {
            if (hasOnlyOne) {
                this.undentifineCompositeChange.add((Change)textFileChange);
            } else {
                this.undentifineCompositeChange.add((Change)unchange);
            }
        }
    }

    private CSSParseRootNode getCSSParseRoot(IDocument document) throws Exception {
        ParseState parseState = new ParseState(document.get());
        IParseRootNode ast = ParserPoolFactory.parse((String)"com.aptana.contenttype.css", (IParseState)parseState).getRootNode();
        CSSParseRootNode root = null;
        if (ast instanceof CSSParseRootNode) {
            root = (CSSParseRootNode)ast;
        }
        return root;
    }

    private Index getIndex(IProject project) {
        if (project == null) {
            return null;
        }
        IndexManager indexManager = IndexPlugin.getDefault().getIndexManager();
        return indexManager.getIndex(project.getLocationURI());
    }

    private void computeJSResult(IFile ifile, Match[] matchs, IDocument document, boolean hasOnlyOne) {
        try {
            CompositeChange change = new CompositeChange(String.valueOf(ifile.getName()) + " - " + ifile.getParent().getFullPath().makeRelative().toString());
            CompositeChange unchange = new CompositeChange(String.valueOf(ifile.getName()) + " - " + ifile.getParent().getFullPath().makeRelative().toString());
            unchange.setEnabledShallow(false);
            int prefixOffset = 0;
            TextFileContentChange textFileChange = null;
            boolean hasChange = false;
            boolean hasunChange = false;
            HTMLIndexQueryHelper queryHelper = new HTMLIndexQueryHelper();
            Map jsReferences = queryHelper.getJSReferences(this.getIndex(ifile.getProject()));
            if (CollectionsUtil.isEmpty((Map)jsReferences)) {
                return;
            }
            Set htmlSet = (Set)jsReferences.get(ifile.getProjectRelativePath().toString());
            Match[] matchArray = matchs;
            int n = matchs.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                RefactorIRange range = this.getJSIRange(ifile, document, match, htmlSet);
                if (range != null) {
                    String replaceStr = document.get(range.getStartingOffset(), range.getLength());
                    int startOffset = range.getStartingOffset();
                    textFileChange = new TextFileContentChange(this.oldName, ifile);
                    String replaceStr_new = "";
                    if (range.isSure()) {
                        hasChange = true;
                        replaceStr_new = this.getFolderRelativePath(replaceStr, ifile);
                        ReplaceEdit edit = new ReplaceEdit(startOffset + prefixOffset, range.getLength(), replaceStr_new);
                        textFileChange.setEdit((TextEdit)edit);
                        ReplaceEdit previewEdit = new ReplaceEdit(startOffset, range.getLength(), replaceStr_new);
                        textFileChange.setPreviewEdit((TextEdit)previewEdit);
                        if (!hasOnlyOne) {
                            if (range.isSure()) {
                                change.add((Change)textFileChange);
                            } else {
                                unchange.add((Change)textFileChange);
                            }
                        }
                        prefixOffset += replaceStr_new.length() - replaceStr.length();
                    }
                }
                ++n2;
            }
            this.addUnOrIndentifineCompositeChange(hasOnlyOne, change, unchange, textFileChange, hasChange, hasunChange);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void computeHTMLResult(IFile ifile, Match[] matchs, IDocument document, boolean hasOnlyOne) {
        try {
            CompositeChange change = new CompositeChange(String.valueOf(ifile.getName()) + " - " + ifile.getParent().getFullPath().makeRelative().toString());
            CompositeChange unchange = new CompositeChange(String.valueOf(ifile.getName()) + " - " + ifile.getParent().getFullPath().makeRelative().toString());
            unchange.setEnabledShallow(false);
            int prefixOffset = 0;
            TextFileContentChange textFileChange = null;
            boolean hasChange = false;
            boolean hasUnChange = false;
            Match[] matchArray = matchs;
            int n = matchs.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                RefactorIRange range = this.getHTMLIRange(ifile, document, match);
                if (range != null) {
                    String replaceStr = document.get(range.getStartingOffset(), range.getLength());
                    int startOffset = range.getStartingOffset();
                    textFileChange = new TextFileContentChange(this.oldName, ifile);
                    String replaceStr_new = "";
                    if (range.isSure()) {
                        hasChange = true;
                        replaceStr_new = this.getFolderRelativePath(replaceStr, ifile);
                        ReplaceEdit edit = new ReplaceEdit(startOffset + prefixOffset, range.getLength(), replaceStr_new);
                        textFileChange.setEdit((TextEdit)edit);
                        ReplaceEdit previewEdit = new ReplaceEdit(startOffset, range.getLength(), replaceStr_new);
                        textFileChange.setPreviewEdit((TextEdit)previewEdit);
                        if (!hasOnlyOne) {
                            if (range.isSure()) {
                                change.add((Change)textFileChange);
                            } else {
                                unchange.add((Change)textFileChange);
                            }
                        }
                        prefixOffset += replaceStr_new.length() - replaceStr.length();
                    }
                }
                ++n2;
            }
            this.addUnOrIndentifineCompositeChange(hasOnlyOne, change, unchange, textFileChange, hasChange, hasUnChange);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private boolean isCSS(IFile ifile) {
        return Arrays.asList(RefactorUtils.CSS_EXTENDTIONS).contains(ifile.getFileExtension());
    }

    private boolean isJS(IFile ifile) {
        return Arrays.asList(RefactorUtils.JS_EXTENDTIONS).contains(ifile.getFileExtension());
    }

    private boolean isHTML(IFile ifile) {
        return Arrays.asList(RefactorUtils.HTML_EXTENDTIONS).contains(ifile.getFileExtension());
    }

    private String getFolderRelativePath(String replaceStr, IFile iFile) {
        String resolvePath = "";
        if (iFile != null) {
            String srcFilePath = iFile.getProjectRelativePath().toString();
            resolvePath = replaceStr.startsWith("/") ? replaceStr : URIUtils.resolveURI((String)srcFilePath, (String)replaceStr);
            if (this.newName.equals("/")) {
                this.newName = "";
            }
            resolvePath = StringUtil.isBlank((String)this.oldName) ? String.valueOf(this.newName) + resolvePath : resolvePath.replace(this.oldName, this.newName);
            resolvePath = URIUtils.relativeURI((String)srcFilePath, (String)resolvePath);
        }
        return resolvePath;
    }

    private RefactorIRange getHTMLIRange(IFile ifile, IDocument document, Match match) throws BadLocationException {
        String resolvePath;
        boolean isExist;
        int srcIndex;
        ITypedRegion partition = document.getPartition(match.getOffset());
        String wholeTag = document.get(partition.getOffset(), partition.getLength());
        String tagvalue = "";
        String type = partition.getType();
        int startOffset = 0;
        int endOffset = 0;
        if (type.equals("__js_string_double") || type.equals("__js_string_single")) {
            tagvalue = this.getHTML_JSTagValue(wholeTag);
            if (StringUtil.isBlank((String)tagvalue)) {
                tagvalue = wholeTag;
            }
            if (tagvalue.startsWith("'") || tagvalue.startsWith("\"")) {
                tagvalue = tagvalue.substring(1, tagvalue.length() - 1);
            }
            if (StringUtil.isNotBlank((String)tagvalue) && (srcIndex = this.getSrcIndex(wholeTag, tagvalue)) > 0) {
                startOffset = partition.getOffset() + srcIndex;
                endOffset = startOffset + tagvalue.length() - 1;
            }
        } else if (type.equals("__css_string_double") || type.equals("__css_string_single")) {
            tagvalue = wholeTag.substring(1, wholeTag.length() - 1);
            srcIndex = this.getSrcIndex(wholeTag, tagvalue);
            if (srcIndex > 0) {
                startOffset = partition.getOffset() + srcIndex;
                endOffset = startOffset + tagvalue.length() - 1;
            }
        } else if (type.equals("__css___dftl_partition_content_type")) {
            int offset = match.getOffset() - partition.getOffset();
            ParseState parseState = new ParseState(wholeTag);
            try {
                int srcIndex2;
                IParseNode node;
                String nodeValue;
                IParseRootNode ast = ParserPoolFactory.parse((String)"com.aptana.contenttype.css", (IParseState)parseState).getRootNode();
                CSSParseRootNode root = null;
                if (ast instanceof CSSParseRootNode && StringUtil.isNotBlank((String)(tagvalue = this.getCSSTagValue(nodeValue = (node = (root = (CSSParseRootNode)ast).getNodeAtOffset(offset)).getText()))) && (srcIndex2 = this.getSrcIndex(wholeTag, tagvalue)) > 0) {
                    startOffset = partition.getOffset() + srcIndex2;
                    endOffset = startOffset + tagvalue.length() - 1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            tagvalue = this.getHTMLTagValue(wholeTag);
            if (StringUtil.isNotBlank((String)tagvalue) && (srcIndex = this.getSrcIndex(wholeTag, tagvalue)) > 0) {
                startOffset = partition.getOffset() + srcIndex;
                endOffset = startOffset + tagvalue.length() - 1;
            }
        }
        if (StringUtil.isNotBlank((String)tagvalue) && (isExist = this.checkResolvePathInSrcListFile(resolvePath = URIUtils.resolveURI((String)ifile.getProjectRelativePath().toString(), (String)tagvalue), this.srcListFile))) {
            return new RefactorIRange(startOffset, endOffset, ifile, true);
        }
        return new RefactorIRange(match.getOffset(), match.getOffset() + match.getLength() - 1, ifile, false);
    }

    private RefactorIRange getCSSIRange(IFile ifile, IDocument document, Match match, CSSParseRootNode root) {
        String value;
        RefactorIRange range = null;
        IParseNode node = root.getNodeAtOffset(match.getOffset());
        String tagValue = node.getText();
        int startOffset = node.getStartingOffset();
        if (StringUtil.isNotBlank((String)tagValue) && StringUtil.isNotBlank((String)(value = this.getCSSTagValue(tagValue)))) {
            startOffset += tagValue.indexOf(value);
            String resolvePath = URIUtils.resolveURI((String)ifile.getProjectRelativePath().toString(), (String)value);
            boolean isExist = this.checkResolvePathInSrcListFile(resolvePath, this.srcListFile);
            if (isExist) {
                int endOffset = startOffset + value.length() - 1;
                return new RefactorIRange(startOffset, endOffset, ifile, true);
            }
        }
        range = new RefactorIRange(match.getOffset(), match.getOffset() + match.getLength() - 1, ifile, false);
        return range;
    }

    private RefactorIRange getJSIRange(IFile ifile, IDocument document, Match match, Set<String> htmlSet) {
        RefactorIRange range = null;
        try {
            String wholeTag;
            ITypedRegion partition = document.getPartition(match.getOffset());
            if (("__js_string_single".equals(partition.getType()) || "__js_string_double".equals(partition.getType())) && StringUtil.isNotBlank((String)(wholeTag = document.get(partition.getOffset(), partition.getLength()))) && (wholeTag.startsWith("'") || wholeTag.startsWith("\""))) {
                String tagValue_ = wholeTag.substring(1, wholeTag.length() - 1);
                String value = this.getHTML_JSTagValue(tagValue_);
                if (StringUtil.isBlank((String)value)) {
                    value = tagValue_;
                }
                if (value.startsWith("'") || value.startsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                if (StringUtil.isNotBlank((String)value)) {
                    boolean isExist = false;
                    for (String htmlPath : htmlSet) {
                        String resolvePath = URIUtils.resolveURI((String)htmlPath, (String)value);
                        isExist = this.checkResolvePathInSrcListFile(resolvePath, this.srcListFile);
                        if (isExist) break;
                    }
                    if (isExist) {
                        int srcindex = this.getSrcIndex(wholeTag, value);
                        int startOffset = partition.getOffset() + srcindex;
                        int endOffset = startOffset + value.length() - 1;
                        return new RefactorIRange(startOffset, endOffset, ifile, true);
                    }
                }
            }
            range = new RefactorIRange(match.getOffset(), match.getOffset() + match.getLength() - 1, ifile, false);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return range;
    }

    private boolean checkResolvePathInSrcListFile(String resolvePath, List<IFile> srcListFile) {
        for (IFile iFile : srcListFile) {
            if (iFile == null || !iFile.getProjectRelativePath().toString().equals(resolvePath)) continue;
            return true;
        }
        return false;
    }

    private int getSrcIndex(String wholeTag, String srcName) {
        if (StringUtil.isBlank((String)srcName)) {
            return 0;
        }
        int srcIndex = wholeTag.indexOf(srcName);
        return srcIndex;
    }

    private String getHTMLTagValue(String wholeTag) {
        String regix = "";
        String srcvalue = "";
        String[] stringArray = RefactorUtils.HTML_SRC_ATTRIBUTE;
        int n = RefactorUtils.HTML_SRC_ATTRIBUTE.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            regix = String.valueOf(tag) + "[\\s]*=[\\s]*[\"']([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\"']";
            srcvalue = RegularUtils.match((String)regix, (String)wholeTag, (int)1);
            if (StringUtil.isNotBlank((String)srcvalue)) {
                return srcvalue;
            }
            regix = String.valueOf(tag) + "[\\s]*=[\\s]*([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\"']";
            srcvalue = RegularUtils.match((String)regix, (String)wholeTag, (int)1);
            if (StringUtil.isNotBlank((String)srcvalue)) {
                return srcvalue;
            }
            ++n2;
        }
        return "";
    }

    private String getHTML_JSTagValue(String wholeTag) {
        String regix = "";
        String srcvalue = "";
        String[] stringArray = RefactorUtils.JS_SRC_ATTRIBUTE;
        int n = RefactorUtils.JS_SRC_ATTRIBUTE.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            regix = String.valueOf(tag) + "[\\s]*=[\\s]*[\"']([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\"']";
            srcvalue = RegularUtils.match((String)regix, (String)wholeTag, (int)1);
            if (StringUtil.isNotBlank((String)srcvalue)) {
                return srcvalue;
            }
            ++n2;
        }
        return "";
    }

    private String getCSSTagValue(String tagValue) {
        String regix = "";
        String srcvalue = "";
        String[] stringArray = RefactorUtils.CSS_SRC_ATTRIBUTE;
        int n = RefactorUtils.CSS_SRC_ATTRIBUTE.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            regix = String.valueOf(tag) + "[\\s]*\\([\\s]*([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\\)]";
            srcvalue = RegularUtils.match((String)regix, (String)tagValue, (int)1);
            if (StringUtil.isNotBlank((String)srcvalue)) {
                return srcvalue;
            }
            ++n2;
        }
        return "";
    }

    private boolean checkFile(IFile file) {
        if (file == null || !file.exists()) {
            return false;
        }
        String ext = file.getFileExtension();
        if (!this.extendList.contains(ext)) {
            return false;
        }
        String filePath = file.getProjectRelativePath().toString();
        for (String excludeFolder : this.excludeFolderList) {
            if (!filePath.startsWith(excludeFolder)) continue;
            return false;
        }
        return true;
    }

    private IDocument getDocumentByIFile(IFile iFile) throws CoreException {
        InputStream inputStream = iFile.getContents();
        String content = IOUtil.read((InputStream)inputStream);
        Document document = new Document(content);
        if (this.isHTML(iFile)) {
            document = this.formatHTMLPartitioner((IDocument)document);
        } else if (this.isJS(iFile)) {
            document = this.formatJSPartitioner((IDocument)document);
        } else if (this.isCSS(iFile)) {
            document = this.formatCSSPartitioner((IDocument)document);
        }
        return document;
    }

    private IDocument formatCSSPartitioner(IDocument document) {
        CompositePartitionScanner partitionScanner = new CompositePartitionScanner(CSSSourceConfiguration.getDefault().createSubPartitionScanner(), (ISubPartitionScanner)new NullSubPartitionScanner(), (IPartitionerSwitchStrategy)new NullPartitionerSwitchStrategy());
        ExtendedFastPartitioner partitioner = new ExtendedFastPartitioner((IPartitionTokenScanner)partitionScanner, CSSSourceConfiguration.getDefault().getContentTypes());
        partitionScanner.setPartitioner((IExtendedPartitioner)partitioner);
        partitioner.connect(document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        CommonEditorPlugin.getDefault().getDocumentScopeManager().registerConfiguration(document, (IPartitioningConfiguration)CSSSourceConfiguration.getDefault());
        return document;
    }

    private IDocument formatJSPartitioner(IDocument document) {
        CompositePartitionScanner partitionScanner = new CompositePartitionScanner(JSSourceConfiguration.getDefault().createSubPartitionScanner(), (ISubPartitionScanner)new NullSubPartitionScanner(), (IPartitionerSwitchStrategy)new NullPartitionerSwitchStrategy());
        ExtendedFastPartitioner partitioner = new ExtendedFastPartitioner((IPartitionTokenScanner)partitionScanner, JSSourceConfiguration.getDefault().getContentTypes());
        partitionScanner.setPartitioner((IExtendedPartitioner)partitioner);
        partitioner.connect(document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        CommonEditorPlugin.getDefault().getDocumentScopeManager().registerConfiguration(document, (IPartitioningConfiguration)JSSourceConfiguration.getDefault());
        return document;
    }

    private IDocument formatHTMLPartitioner(IDocument document) {
        CompositePartitionScanner partitionScanner = new CompositePartitionScanner(HTMLSourceConfiguration.getDefault().createSubPartitionScanner(), (ISubPartitionScanner)new NullSubPartitionScanner(), (IPartitionerSwitchStrategy)new NullPartitionerSwitchStrategy());
        ExtendedFastPartitioner partitioner = new ExtendedFastPartitioner((IPartitionTokenScanner)partitionScanner, HTMLSourceConfiguration.getDefault().getContentTypes());
        partitionScanner.setPartitioner((IExtendedPartitioner)partitioner);
        partitioner.connect(document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        CommonEditorPlugin.getDefault().getDocumentScopeManager().registerConfiguration(document, (IPartitioningConfiguration)HTMLSourceConfiguration.getDefault());
        return document;
    }
}

