/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.refactoring;

import com.pandora.refactor.core.js.refactoring.JSRefactorRegion;
import com.pandora.refactor.core.refactoring.RefactorIRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class RefactorContextInfo {
    private int offset = 0;
    private String newName = null;
    private String oldName = null;
    private IFile sourceFile = null;
    private boolean refactorComments = false;
    private boolean refactorText = false;
    private boolean preview = false;
    private boolean isID = false;
    private IProject currentProject = null;
    private Set<JSRefactorRegion> result = new HashSet<JSRefactorRegion>();

    public boolean isID() {
        return this.isID;
    }

    public void setID(boolean isID) {
        this.isID = isID;
    }

    public Map<IFile, List<RefactorIRange>> getMapFromResult() {
        HashMap<IFile, List<RefactorIRange>> map = new HashMap<IFile, List<RefactorIRange>>();
        if (this.result == null) {
            return map;
        }
        RefactorIRange[] refactorIRanges = new RefactorIRange[this.result.size()];
        refactorIRanges = this.sortRefactorIRanges(refactorIRanges);
        this.getMapFromRefactorIRange(map, refactorIRanges);
        return map;
    }

    private void getMapFromRefactorIRange(Map<IFile, List<RefactorIRange>> map, RefactorIRange[] refactorIRanges) {
        List<Object> list = null;
        IFile iFile = null;
        RefactorIRange[] refactorIRangeArray = refactorIRanges;
        int n = refactorIRanges.length;
        int n2 = 0;
        while (n2 < n) {
            RefactorIRange refactorIRange = refactorIRangeArray[n2];
            if (refactorIRange != null) {
                iFile = refactorIRange.getiFile();
                list = map.containsKey(iFile) ? map.get(iFile) : new ArrayList();
                if (!list.contains((Object)refactorIRange)) {
                    list.add((Object)refactorIRange);
                }
                map.put(iFile, list);
            }
            ++n2;
        }
    }

    private RefactorIRange[] sortRefactorIRanges(RefactorIRange[] refactorIRanges) {
        IFile iFile = null;
        ArrayList<JSRefactorRegion> regions = new ArrayList<JSRefactorRegion>();
        regions.addAll(this.result);
        int i = 0;
        while (i < regions.size()) {
            JSRefactorRegion refactorRegion = (JSRefactorRegion)regions.get(i);
            if (refactorRegion != null) {
                RefactorIRange refactorIRange;
                iFile = refactorRegion.getTargetFile();
                refactorIRanges[i] = refactorIRange = new RefactorIRange(refactorRegion.getStartOffset(), refactorRegion.getEndOffset(), iFile, refactorRegion.isMakeSure());
            }
            ++i;
        }
        refactorIRanges = this.sortIRanges(refactorIRanges);
        return refactorIRanges;
    }

    private RefactorIRange[] sortIRanges(RefactorIRange[] iRanges) {
        Arrays.sort(iRanges, new IRangeComparator());
        return iRanges;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getOldName() {
        return this.oldName;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public IFile getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(IFile sourceFile) {
        this.sourceFile = sourceFile;
    }

    public boolean isRefactorComments() {
        return this.refactorComments;
    }

    public void setRefactorComments(boolean refactorComments) {
        this.refactorComments = refactorComments;
    }

    public boolean isRefactorText() {
        return this.refactorText;
    }

    public void setRefactorText(boolean refactorText) {
        this.refactorText = refactorText;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public void addResult(JSRefactorRegion refactorRegion) {
        this.result.add(refactorRegion);
    }

    public List<JSRefactorRegion> getResults() {
        ArrayList<JSRefactorRegion> regions = new ArrayList<JSRefactorRegion>();
        regions.addAll(this.result);
        return regions;
    }

    public void removeResult(JSRefactorRegion region) {
        if (this.result.contains(region)) {
            this.result.remove(region);
        }
    }

    public IProject getCurrentProject() {
        return this.currentProject;
    }

    public void setCurrentProject(IProject currentProject) {
        this.currentProject = currentProject;
    }

    class IRangeComparator
    implements Comparator<RefactorIRange> {
        IRangeComparator() {
        }

        @Override
        public int compare(RefactorIRange iRange1, RefactorIRange iRange2) {
            int secOffset;
            int firstOffset = iRange1.getStartingOffset();
            if (firstOffset > (secOffset = iRange2.getStartingOffset())) {
                return 1;
            }
            return -1;
        }
    }
}

