/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.refactoring;

import com.aptana.core.util.StringUtil;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import com.pandora.core.utils.RegularUtils;
import com.pandora.core.utils.URIUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;

public class RefactorActiveRange {
    private static String scriptStartTag = "<script";
    private static String scriptEndTag = "</script>";
    private static String scriptEndTag_ = "/>";
    private static String linkStartTag = "<link";
    private static String linkEndTag = "/>";
    private static final String PANDORA_REPLACE_STRING = "\u4e96";
    private static final char PANDORA_REPLACE_CHAR = '\u4e96';
    public static final String SCRIPT_TYPE = "_script";
    public static final String LINK_TYPE = "_css";
    public static final String HTML_TYPE = "_html";
    public static final String KEYWORD_TYPE = "_keyword";
    public static final String REG = "[\\s]*=[\\s]*[\"']([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\"']";

    public static List<IRange> computeRefactorRanges(IDocument doc, String type, String srcName, IFile iFile) {
        List<IRange> refactorRanges = new ArrayList<IRange>();
        refactorRanges = SCRIPT_TYPE.equals(type) ? RefactorActiveRange.computeRefactorRangesByTag(refactorRanges, doc, srcName, scriptStartTag, scriptEndTag, scriptEndTag_, type, iFile) : (LINK_TYPE.equals(type) ? RefactorActiveRange.computeRefactorRangesByTag(refactorRanges, doc, srcName, linkStartTag, linkEndTag, linkEndTag, type, iFile) : (HTML_TYPE.equals(type) ? RefactorActiveRange.computeRefactorRangesByTag(refactorRanges, doc, srcName, "", "", "", type, iFile) : RefactorActiveRange.computeRefactorRangesByTag(refactorRanges, doc, srcName, "", "", "", type, iFile)));
        return refactorRanges;
    }

    private static List<IRange> computeRefactorRangesByTag(List<IRange> refactorRanges, IDocument doc, String srcName, String startTag, String endTag, String endTag_, String type, IFile iFile) {
        return RefactorActiveRange.computeAllRefactorRanges(doc, srcName, iFile, refactorRanges, type, startTag, false);
    }

    private static List<IRange> computeRefactorRangesByType(List<IRange> refactorRanges, IDocument doc, String type, String startTag, String srcName, int i, boolean isMove, IFile iFile) throws BadLocationException {
        IRegion region = doc.getLineInformation(i);
        String lineStr = doc.get(region.getOffset(), region.getLength());
        boolean check = RefactorActiveRange.checkTagString(type, lineStr, startTag);
        if (!check) {
            return refactorRanges;
        }
        lineStr = lineStr.replace(scriptStartTag, PANDORA_REPLACE_STRING + scriptStartTag);
        lineStr = lineStr.replace(linkStartTag, PANDORA_REPLACE_STRING + linkStartTag);
        int startTagCount = StringUtil.characterInstanceCount((String)lineStr, (char)'\u4e96');
        int tagLength = 0;
        int tagOffset = 0;
        if (startTagCount > 0) {
            String[] lines = lineStr.split(PANDORA_REPLACE_STRING);
            String tagString = "";
            int j = 0;
            while (j < lines.length) {
                tagString = lines[j];
                check = RefactorActiveRange.checkTagString(type, tagString, startTag);
                if (check) {
                    tagOffset = RefactorActiveRange.getTagOffset(startTag, type, region, tagLength, tagString);
                    IRange range = null;
                    range = isMove ? RefactorActiveRange.computeHtmlRefactorRange(doc, tagOffset, srcName, iFile) : RefactorActiveRange.computeRange(doc, srcName, startTag, type, tagOffset, iFile);
                    if (range != null) {
                        refactorRanges.add(range);
                    }
                }
                tagLength += tagString.length();
                ++j;
            }
        }
        return refactorRanges;
    }

    private static boolean checkTagString(String type, String tagString, String startTag) {
        if (StringUtil.isBlank((String)tagString)) {
            return false;
        }
        boolean check = true;
        if (!type.equals(KEYWORD_TYPE) && !type.equals(HTML_TYPE) && tagString.indexOf(startTag) < 0) {
            check = false;
        } else if (tagString.indexOf(scriptStartTag) < 0 && tagString.indexOf(linkStartTag) < 0) {
            check = false;
        }
        return check;
    }

    private static int getTagOffset(String startTag, String type, IRegion region, int tagLength, String tagString) {
        int tagOffset = 0;
        int scriptStartTagIndex = tagString.indexOf(scriptStartTag);
        int linkStartTagIndex = tagString.indexOf(linkStartTag);
        int startTagIndex = tagString.indexOf(startTag);
        if (!type.equals(KEYWORD_TYPE) && !type.equals(HTML_TYPE) && startTagIndex >= 0) {
            tagOffset = region.getOffset() + tagLength + startTagIndex;
        } else if ((type.equals(KEYWORD_TYPE) || type.equals(HTML_TYPE)) && (scriptStartTagIndex >= 0 || linkStartTagIndex >= 0)) {
            if (scriptStartTagIndex >= 0) {
                tagOffset = region.getOffset() + tagLength + scriptStartTagIndex;
            } else if (linkStartTagIndex >= 0) {
                tagOffset = region.getOffset() + tagLength + linkStartTagIndex;
            }
        }
        return tagOffset;
    }

    private static IRange computeRange(IDocument doc, String srcName, String startTag, String type, int tagOffset, IFile iFile) throws BadLocationException {
        ITypedRegion partition = doc.getPartition(tagOffset);
        if ("__html_nest_tag".equals(partition.getType())) {
            return RefactorActiveRange.createRange(doc, srcName, type, iFile, partition);
        }
        return null;
    }

    private static IRange createRange(IDocument doc, String srcName, String type, IFile iFile, ITypedRegion partition) throws BadLocationException {
        String wholeTag = doc.get(partition.getOffset(), partition.getLength());
        String srcvalue = RefactorActiveRange.getSrcValue(wholeTag);
        if (StringUtil.isBlank((String)srcvalue)) {
            return null;
        }
        String resolvePath = URIUtils.resolveURI((String)iFile.getProjectRelativePath().toString(), (String)srcvalue);
        if (!type.equals(HTML_TYPE) && resolvePath.indexOf(srcName) < 0) {
            return null;
        }
        int srcIndex = RefactorActiveRange.getSrcIndex(wholeTag, srcvalue);
        if (srcIndex <= 0) {
            return null;
        }
        int startOffset = partition.getOffset() + srcIndex;
        int endOffset = startOffset + srcvalue.length() - 1;
        Range refactorRange = new Range(startOffset, endOffset);
        return refactorRange;
    }

    private static String getSrcValue(String wholeTag) {
        String regix = "";
        regix = wholeTag.startsWith(linkStartTag) ? "href" : "src";
        regix = String.valueOf(regix) + REG;
        String srcvalue = RegularUtils.match((String)regix, (String)wholeTag, (int)1);
        return srcvalue;
    }

    private static int getSrcIndex(String wholeTag, String srcName) {
        if (StringUtil.isBlank((String)srcName)) {
            return 0;
        }
        int srcIndex = wholeTag.indexOf(srcName);
        return srcIndex;
    }

    public static List<IRange> computeHtmlRefactorRanges(IDocument doc, String prefixName, IFile iFile) {
        ArrayList<IRange> refactorRanges = new ArrayList<IRange>();
        return RefactorActiveRange.computeAllRefactorRanges(doc, prefixName, iFile, refactorRanges, KEYWORD_TYPE, "", true);
    }

    private static List<IRange> computeAllRefactorRanges(IDocument doc, String prefixName, IFile iFile, List<IRange> refactorRanges, String type, String stargTag, boolean b) {
        int lineNum = doc.getNumberOfLines();
        try {
            int i = 0;
            while (i < lineNum) {
                refactorRanges = RefactorActiveRange.computeRefactorRangesByType(refactorRanges, doc, type, stargTag, prefixName, i, b, iFile);
                ++i;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return refactorRanges;
    }

    private static IRange computeHtmlRefactorRange(IDocument doc, int tagOffset, String prefixName, IFile iFile) throws BadLocationException {
        ITypedRegion partition = doc.getPartition(tagOffset);
        if ("__html_nest_tag".equals(partition.getType())) {
            return RefactorActiveRange.createRange(doc, prefixName, HTML_TYPE, iFile, partition);
        }
        return null;
    }

    public static List<IRange> computeFolderRanges(IDocument document, List<IFile> srcListFile, IFile iFile) {
        int lineNum = document.getNumberOfLines();
        ArrayList<IRange> refactorRanges = new ArrayList<IRange>();
        try {
            int i = 0;
            while (i < lineNum) {
                String type = KEYWORD_TYPE;
                IRegion region = document.getLineInformation(i);
                String lineStr = document.get(region.getOffset(), region.getLength());
                boolean check = RefactorActiveRange.checkTagString(type, lineStr, "");
                if (check) {
                    lineStr = lineStr.replace(scriptStartTag, PANDORA_REPLACE_STRING + scriptStartTag);
                    lineStr = lineStr.replace(linkStartTag, PANDORA_REPLACE_STRING + linkStartTag);
                    int startTagCount = StringUtil.characterInstanceCount((String)lineStr, (char)'\u4e96');
                    RefactorActiveRange.getLineRange(document, srcListFile, iFile, refactorRanges, region, lineStr, type, startTagCount);
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return refactorRanges;
    }

    private static int getLineRange(IDocument document, List<IFile> srcListFile, IFile iFile, List<IRange> refactorRanges, IRegion region, String lineStr, String type, int startTagCount) throws BadLocationException {
        int tagLength;
        block3: {
            tagLength = 0;
            int tagOffset = 0;
            if (startTagCount <= 0) break block3;
            String[] lines = lineStr.split(PANDORA_REPLACE_STRING);
            String tagString = "";
            int j = 0;
            while (j < lines.length) {
                block5: {
                    block4: {
                        int srcIndex;
                        String resolvePath;
                        boolean isExist;
                        tagString = lines[j];
                        boolean check = RefactorActiveRange.checkTagString(type, tagString, "");
                        if (!check) break block4;
                        tagOffset = RefactorActiveRange.getTagOffset("", type, region, tagLength, tagString);
                        Range range = null;
                        ITypedRegion partition = document.getPartition(tagOffset);
                        if (!"__html_nest_tag".equals(partition.getType())) break block4;
                        String wholeTag = document.get(partition.getOffset(), partition.getLength());
                        String srcvalue = RefactorActiveRange.getSrcValue(wholeTag);
                        if (StringUtil.isBlank((String)srcvalue) || !(isExist = RefactorActiveRange.checkResolvePathInSrcListFile(resolvePath = URIUtils.resolveURI((String)iFile.getProjectRelativePath().toString(), (String)srcvalue), srcListFile)) || (srcIndex = RefactorActiveRange.getSrcIndex(wholeTag, srcvalue)) <= 0) break block5;
                        int startOffset = partition.getOffset() + srcIndex;
                        int endOffset = startOffset + srcvalue.length() - 1;
                        range = new Range(startOffset, endOffset);
                        refactorRanges.add((IRange)range);
                    }
                    tagLength += tagString.length();
                }
                ++j;
            }
        }
        return tagLength;
    }

    private static boolean checkResolvePathInSrcListFile(String resolvePath, List<IFile> srcListFile) {
        for (IFile iFile : srcListFile) {
            if (iFile == null || !iFile.getProjectRelativePath().toString().equals(resolvePath)) continue;
            return true;
        }
        return false;
    }
}

