/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.refactoring;

import com.aptana.core.util.IOUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.ext.HTMLPartitionScanner;
import com.aptana.parsing.lexer.IRange;
import com.pandora.core.utils.URIUtils;
import com.pandora.refactor.core.refactoring.RefactorActiveRange;
import com.pandora.refactor.core.refactoring.TextFileContentChange;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class PandoraRefactorUtils {
    private static IProject _Project;
    public static final String _html_extention = ".html";
    public static final String _htm_extention = ".htm";
    public static final String _js_extention = ".js";
    public static final String _css_extention = ".css";
    public static final String _html_type = "_html_";
    public static final String _js_and_css_type = "_js_css_";

    public static List<IFile> refactorProjectResource(IFile srcFile, IFolder srcFolder, boolean isFile) {
        List<IFile> list = new ArrayList<IFile>();
        try {
            IFileStore projectStore = null;
            ArrayList<IFile> listFile = new ArrayList<IFile>();
            if (isFile) {
                _Project = srcFile.getProject();
                URI projectUri = _Project.getLocationURI();
                projectStore = EFS.getStore((URI)projectUri);
                String oldName = srcFile.getProjectRelativePath().toString();
                if (oldName.endsWith(_html_extention) || oldName.endsWith(_htm_extention)) {
                    list.add(srcFile);
                } else if (oldName.endsWith(_js_extention) || oldName.endsWith(_css_extention)) {
                    list = PandoraRefactorUtils.refactorProjectHtmlFiles(listFile, projectStore, isFile);
                }
            } else {
                projectStore = EFS.getStore((URI)srcFolder.getLocationURI());
                list = PandoraRefactorUtils.refactorProjectHtmlFiles(listFile, projectStore, isFile);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return list;
    }

    private static List<IFile> refactorProjectHtmlFiles(List<IFile> listFile, IFileStore projectStore, boolean isFile) throws CoreException {
        IFileStore[] fileStores = projectStore.childStores(0, (IProgressMonitor)new NullProgressMonitor());
        if (fileStores == null || fileStores.length == 0) {
            return listFile;
        }
        int i = 0;
        while (i < fileStores.length) {
            String name;
            IFileStore fileStore = fileStores[i];
            if (fileStores != null && fileStores.length != 0 && (name = fileStore.getName()).charAt(0) != '.') {
                File file = fileStore.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
                if (file.isFile()) {
                    IPath ipath = PandoraRefactorUtils.getIPath(fileStore);
                    IFile ifile = PandoraRefactorUtils.getIFile(ipath);
                    if (isFile && name.endsWith(_html_extention) || name.endsWith(_htm_extention)) {
                        listFile.add(ifile);
                    } else if (!isFile) {
                        listFile.add(ifile);
                    }
                } else {
                    PandoraRefactorUtils.refactorProjectHtmlFiles(listFile, fileStore, isFile);
                }
            }
            ++i;
        }
        return listFile;
    }

    private static IFile getIFile(IPath ipath) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(ipath);
        return file;
    }

    private static IPath getIPath(IFileStore fileStore) {
        IPath path = Path.fromOSString((String)fileStore.toURI().getPath());
        return path;
    }

    public static List<IRange> computeRefactorRanges(IDocument document, String oldName, IFile iFile) {
        List<IRange> list = null;
        list = oldName.endsWith(_js_extention) ? RefactorActiveRange.computeRefactorRanges(document, "_script", oldName, iFile) : (oldName.endsWith(_css_extention) ? RefactorActiveRange.computeRefactorRanges(document, "_css", oldName, iFile) : (oldName.endsWith(_htm_extention) || oldName.endsWith(_html_extention) ? RefactorActiveRange.computeRefactorRanges(document, "_html", oldName, iFile) : RefactorActiveRange.computeRefactorRanges(document, "_keyword", oldName, iFile)));
        return list;
    }

    public static CompositeChange computeRefactorChange(CompositeChange result, List<IFile> listFile, int prefix, String newName, String oldName, List<IFile> removeHtmlList, String newFileName, String oldFileName, IFile srcFile) throws CoreException {
        if (listFile == null || listFile.isEmpty()) {
            return result;
        }
        String oldFileName_ = srcFile.getProjectRelativePath().toString();
        for (IFile iFile : listFile) {
            IDocument document = PandoraRefactorUtils.getDocumentByIFile(iFile);
            List<IRange> list = PandoraRefactorUtils.computeRefactorRanges(document, oldFileName_, iFile);
            if (oldFileName_.endsWith(_html_extention) || oldFileName_.endsWith(_htm_extention)) {
                result = PandoraRefactorUtils.computeRefactorHtmlChange(document, result, list, iFile, prefix, newName);
                continue;
            }
            if (!oldFileName_.endsWith(_js_extention) && !oldFileName_.endsWith(_css_extention)) continue;
            result = PandoraRefactorUtils.computeRefactorChange(document, result, list, iFile, prefix, newName, oldName, srcFile);
        }
        return result;
    }

    private static CompositeChange computeRefactorHtmlChange(IDocument document, CompositeChange result, List<IRange> list, IFile iFile, int prefix, String newName) {
        try {
            if (list == null || list.isEmpty()) {
                return result;
            }
            String oldName = iFile.getProjectRelativePath().toString();
            IFile newiFile = PandoraRefactorUtils.getNewIFile(iFile, oldName, String.valueOf(newName) + iFile.getName());
            result = PandoraRefactorUtils.createTextFileChanges(document, result, list, iFile, newName, oldName, newiFile, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static IFile getNewIFile(IFile iFile, String oldName, String newName) {
        IPath iPath = PandoraRefactorUtils.getNewIPath(iFile, oldName, newName);
        IFile newIFile = PandoraRefactorUtils.getIFile(iPath);
        return newIFile;
    }

    private static IPath getNewIPath(IFile iFile, String oldName, String newName) {
        String localPath = iFile.getLocation().toString();
        localPath = localPath.replace(oldName, newName);
        IPath iPath = Path.fromOSString((String)localPath);
        return iPath;
    }

    private static CompositeChange computeRefactorChange(IDocument document, CompositeChange result, List<IRange> list, IFile iFile, int prefix, String newName, String oldName, IFile srcFile) {
        try {
            result = PandoraRefactorUtils.createTextFileChanges(document, result, list, iFile, newName, oldName, iFile, srcFile);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String getRelativePath(String replaceString, IFile iFile, String newName, String oldName, IRange iRange, IFile oldFile, IFile srcFile) throws BadLocationException {
        String srcFilePath;
        String resolvePath = "";
        resolvePath = srcFile != null ? ((srcFilePath = srcFile.getProjectRelativePath().toString()).endsWith(_css_extention) || srcFilePath.endsWith(_js_extention) ? srcFilePath : URIUtils.resolveURI((String)oldFile.getProjectRelativePath().toString(), (String)replaceString)) : URIUtils.resolveURI((String)oldFile.getProjectRelativePath().toString(), (String)replaceString);
        if (newName.equals("/")) {
            newName = "";
        }
        resolvePath = StringUtil.isBlank((String)oldName) ? String.valueOf(newName) + resolvePath : resolvePath.replace(oldName, newName);
        replaceString = URIUtils.relativeURI((String)iFile.getProjectRelativePath().toString(), (String)resolvePath);
        return replaceString;
    }

    public static CompositeChange computeFolderRefactorChange(CompositeChange result, List<IFile> listFile, int prefix, String newName, String oldName, IFolder srcFolder) throws CoreException {
        String fileExtention;
        if (listFile == null) {
            return result;
        }
        String oldFileName_ = String.valueOf(srcFolder.getProjectRelativePath().toString()) + "/";
        List<IFile> refactorHtmlList = PandoraRefactorUtils.getListByType(listFile, _html_type);
        listFile.removeAll(refactorHtmlList);
        List<IFile> list = null;
        List<IFile> projectHtmlList = PandoraRefactorUtils.getProjectHtmlFile(srcFolder.getProject());
        projectHtmlList.removeAll(refactorHtmlList);
        for (IFile iFile : projectHtmlList) {
            if (iFile == null) continue;
            fileExtention = iFile.getFileExtension();
            if (!(fileExtention = "." + fileExtention).equals(_htm_extention) && !fileExtention.equals(_html_extention)) continue;
            result = PandoraRefactorUtils.computeRefactorFolderChange(result, listFile, newName, oldName, iFile);
        }
        for (IFile iFile : refactorHtmlList) {
            fileExtention = iFile.getFileExtension();
            if (!(fileExtention = "." + fileExtention).equals(_htm_extention) && !fileExtention.equals(_html_extention)) continue;
            list = PandoraRefactorUtils.refactorProjectResource(iFile, null, true);
            result = PandoraRefactorUtils.computeHtmlOfRenameFolderChange(result, list, prefix, newName, oldFileName_, oldName);
        }
        return result;
    }

    private static CompositeChange computeRefactorFolderChange(CompositeChange result, List<IFile> srcListFile, String newName, String oldName, IFile iFile) {
        try {
            if (srcListFile == null || srcListFile.isEmpty()) {
                return result;
            }
            IDocument document = PandoraRefactorUtils.getDocumentByIFile(iFile);
            List<IRange> listRange = RefactorActiveRange.computeFolderRanges(document, srcListFile, iFile);
            CompositeChange compositeChange = new CompositeChange(String.valueOf(iFile.getName()) + " - " + iFile.getParent().getFullPath().makeRelative().toString());
            int prefixOffset = 0;
            boolean hasChange = false;
            for (IRange iRange : listRange) {
                if (iRange == null) continue;
                String replaceStr = document.get(iRange.getStartingOffset(), iRange.getLength());
                int startOffset = iRange.getStartingOffset();
                String replaceStr_new = PandoraRefactorUtils.getFolderRelativePath(replaceStr, iFile, newName, oldName);
                TextFileContentChange textFileChange = new TextFileContentChange("xxx.js", iFile);
                ReplaceEdit edit = new ReplaceEdit(startOffset + prefixOffset, iRange.getLength(), replaceStr_new);
                textFileChange.setEdit((TextEdit)edit);
                ReplaceEdit previewEdit = new ReplaceEdit(startOffset, iRange.getLength(), replaceStr_new);
                textFileChange.setPreviewEdit((TextEdit)previewEdit);
                compositeChange.add((Change)textFileChange);
                hasChange = true;
                prefixOffset += replaceStr_new.length() - replaceStr.length();
            }
            if (hasChange) {
                result.add((Change)compositeChange);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String getFolderRelativePath(String replaceStr, IFile iFile, String newName, String oldName) {
        String resolvePath = "";
        if (iFile != null) {
            String srcFilePath = iFile.getProjectRelativePath().toString();
            resolvePath = URIUtils.resolveURI((String)srcFilePath, (String)replaceStr);
            if (newName.equals("/")) {
                newName = "";
            }
            resolvePath = StringUtil.isBlank((String)oldName) ? String.valueOf(newName) + resolvePath : resolvePath.replace(oldName, newName);
            resolvePath = URIUtils.relativeURI((String)srcFilePath, (String)resolvePath);
        }
        return resolvePath;
    }

    private static List<IFile> getProjectHtmlFile(IProject project) {
        URI projectUri = project.getLocationURI();
        ArrayList<IFile> listFile = new ArrayList<IFile>();
        try {
            IFileStore projectStore = EFS.getStore((URI)projectUri);
            PandoraRefactorUtils.refactorProjectHtmlFiles(listFile, projectStore, true);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return listFile;
    }

    private static CompositeChange computeHtmlOfRenameFolderChange(CompositeChange result, List<IFile> listFile, int prefix, String newName, String oldFileName, String oldName) throws CoreException {
        if (listFile == null || listFile.isEmpty()) {
            return result;
        }
        for (IFile iFile : listFile) {
            String fileName = iFile.getName();
            if (!fileName.endsWith(_html_extention) && !fileName.endsWith(_htm_extention)) continue;
            IDocument document = PandoraRefactorUtils.getDocumentByIFile(iFile);
            List<IRange> list = PandoraRefactorUtils.computeRefactorRanges(document, oldFileName, iFile);
            result = PandoraRefactorUtils.computeRenameHtmlChange(document, result, list, iFile, prefix, newName, oldName);
        }
        return result;
    }

    private static CompositeChange computeRenameHtmlChange(IDocument document, CompositeChange result, List<IRange> list, IFile iFile, int prefix, String newName, String oldName) {
        try {
            if (list == null || list.isEmpty()) {
                return result;
            }
            IFile newiFile = PandoraRefactorUtils.getNewIFile(iFile, oldName, newName);
            result = PandoraRefactorUtils.createTextFileChanges(document, result, list, iFile, newName, oldName, newiFile, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static IDocument formatPartitioner(IDocument document) {
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new HTMLPartitionScanner(), new String[]{"__html_comment", "__html_quote_tag", "__html_single_tag", "__html_nest_tag"});
        partitioner.connect(document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        return document;
    }

    private static List<IFile> getListByType(List<IFile> listFile, String type) {
        ArrayList<IFile> fileList = new ArrayList<IFile>();
        for (IFile iFile : listFile) {
            String fileName = iFile.getName();
            if (type.equals(_html_type) && (fileName.endsWith(_htm_extention) || fileName.endsWith(_html_extention))) {
                fileList.add(iFile);
                continue;
            }
            if (!type.equals(_js_and_css_type) || !fileName.endsWith(_js_extention) && !fileName.endsWith(_css_extention)) continue;
            fileList.add(iFile);
        }
        return fileList;
    }

    public static CompositeChange computeMoveFolderRefactorChange(CompositeChange result, List<IFile> listFile, int prefix, String newName, String oldName, IFolder srcFolder) throws CoreException {
        if (listFile == null) {
            return result;
        }
        oldName = String.valueOf(srcFolder.getProjectRelativePath().toString()) + "/";
        List<IFile> htmlList = PandoraRefactorUtils.getListByType(listFile, _html_type);
        List<IFile> list = null;
        for (IFile iFile : listFile) {
            if (iFile == null) continue;
            String fileExtention = iFile.getFileExtension();
            fileExtention = "." + fileExtention;
            list = PandoraRefactorUtils.refactorProjectResource(iFile, null, true);
            if (fileExtention.equals(_css_extention) || fileExtention.equals(_js_extention)) {
                list.removeAll(htmlList);
                result = PandoraRefactorUtils.computeRefactorChange(result, list, prefix, newName, oldName, htmlList, newName, oldName, iFile);
                continue;
            }
            if (!fileExtention.equals(_htm_extention) && !fileExtention.equals(_html_extention)) continue;
            result = PandoraRefactorUtils.computeFolderMoveRefactorChange(result, list, prefix, newName, oldName);
        }
        return result;
    }

    private static CompositeChange computeFolderMoveRefactorChange(CompositeChange result, List<IFile> listFile, int prefix, String newName, String oldName) throws CoreException {
        if (listFile == null || listFile.isEmpty()) {
            return result;
        }
        for (IFile iFile : listFile) {
            String fileName = iFile.getName();
            if (!fileName.endsWith(_html_extention) && !fileName.endsWith(_htm_extention)) continue;
            IDocument document = PandoraRefactorUtils.getDocumentByIFile(iFile);
            List<IRange> list = RefactorActiveRange.computeHtmlRefactorRanges(document, oldName, iFile);
            result = PandoraRefactorUtils.computeMoveHtmlChange(document, result, list, iFile, prefix, newName, oldName);
        }
        return result;
    }

    private static CompositeChange computeMoveHtmlChange(IDocument document, CompositeChange result, List<IRange> list, IFile iFile, int prefix, String newName, String oldName) {
        try {
            if (list == null || list.isEmpty()) {
                return result;
            }
            IFile newiFile = PandoraRefactorUtils.getNewIFile(iFile, oldName, newName);
            result = PandoraRefactorUtils.createTextFileChanges(document, result, list, iFile, newName, oldName, newiFile, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static CompositeChange createTextFileChanges(IDocument document, CompositeChange result, List<IRange> list, IFile iFile, String newName, String oldName, IFile newiFile, IFile srcFile) throws BadLocationException {
        if (list == null || list.isEmpty()) {
            return result;
        }
        int prefixOffset = 0;
        int i = 0;
        while (i < list.size()) {
            IRange iRange = list.get(i);
            if (iRange != null) {
                String replaceStr = document.get(iRange.getStartingOffset(), iRange.getLength());
                int startOffset = iRange.getStartingOffset();
                String replaceStr_new = PandoraRefactorUtils.getRelativePath(replaceStr, newiFile, newName, oldName, iRange, iFile, srcFile);
                TextFileChange textFileChange = new TextFileChange(newName, newiFile);
                ReplaceEdit edit = new ReplaceEdit(startOffset + prefixOffset, iRange.getLength(), replaceStr_new);
                textFileChange.setEdit((TextEdit)edit);
                result.add((Change)textFileChange);
                prefixOffset += replaceStr_new.length() - replaceStr.length();
            }
            ++i;
        }
        return result;
    }

    private static IDocument getDocumentByIFile(IFile iFile) throws CoreException {
        InputStream inputStream = iFile.getContents();
        String content = IOUtil.read((InputStream)inputStream);
        Document document = new Document(content);
        document = PandoraRefactorUtils.formatPartitioner((IDocument)document);
        return document;
    }
}

