/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.refactoring;

import com.pandora.refactor.core.refactoring.RefactorMoveFileParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ide.IDE;

public class PandoraMoveParticipant
extends MoveParticipant {
    private static IFile srcFile;
    private static IFolder srcFolder;
    private static boolean isFile;

    protected boolean initialize(Object element) {
        srcFile = null;
        srcFolder = null;
        if (element instanceof IFile) {
            srcFile = (IFile)element;
            isFile = true;
        }
        if (element instanceof IFolder) {
            srcFolder = (IFolder)element;
            isFile = false;
        }
        return true;
    }

    public String getName() {
        return "com.pandora.refactor";
    }

    private void saveAll() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IProject project = null;
                project = isFile ? srcFile.getProject() : srcFolder.getProject();
                IDE.saveAllEditors((IResource[])new IResource[]{project}, (boolean)true);
            }
        });
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        this.saveAll();
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        MoveArguments move = super.getArguments();
        if (move == null) {
            return null;
        }
        IResource destFolder = (IResource)move.getDestination();
        String oldName = "";
        if (isFile && srcFile != null) {
            oldName = srcFile.getParent().getProjectRelativePath().toString();
        } else if (!isFile && srcFolder != null) {
            oldName = srcFolder.getParent().getProjectRelativePath().toString();
        } else {
            return null;
        }
        String newName = String.valueOf(destFolder.getProjectRelativePath().toString()) + "/";
        CompositeChange result = new CompositeChange(this.getName());
        if (isFile) {
            if (!oldName.endsWith("/")) {
                oldName = String.valueOf(oldName) + "/";
            }
            RefactorMoveFileParticipant refactorMoveFileParticipant = new RefactorMoveFileParticipant(result, (IResource)srcFile, oldName, newName);
            refactorMoveFileParticipant.computeChange();
        } else {
            if (!oldName.endsWith("/")) {
                oldName = String.valueOf(oldName) + "/";
            }
            RefactorMoveFileParticipant refactorMoveFileParticipant = new RefactorMoveFileParticipant(result, (IResource)srcFolder, oldName, newName);
            refactorMoveFileParticipant.computeChange();
        }
        if (result.getChildren().length < 1) {
            return null;
        }
        return result;
    }
}

