/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.refactoring;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.css.CSSSourceEditor;
import com.aptana.editor.css.parsing.ast.CSSAttributeSelectorNode;
import com.aptana.editor.html.HTMLEditor;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.js.JSSourceEditor;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseNodeAttribute;
import com.aptana.parsing.lexer.IRange;
import com.pandora.core.utils.RegularUtils;
import com.pandora.refactor.core.IRefactorAction;
import com.pandora.refactor.core.IRefactorSearchContext;
import com.pandora.refactor.core.html.refactoring.HTMLRefactorSearchContext;
import com.pandora.refactor.core.js.refactoring.JSRefactorSearchContext;
import com.pandora.refactor.core.refactoring.CSSRefactorSearchContext;
import com.pandora.refactor.core.refactoring.RefactorContextInfo;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;

public class DefaultRefactorAction
implements IRefactorAction {
    private AbstractThemeableEditor editor = null;
    private ITextSelection selection = null;
    private IRefactorSearchContext context = null;
    private IParseNode selectNode = null;
    private static final String REGX = "[\"']([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\"']";
    private static String[] SRC = new String[]{"id", "class"};
    private RefactorContextInfo info;
    private static String[] JSASSIGNMENTNODESVALUES = new String[]{".className"};
    private static String[] JSINVOKENODESVALUES = new String[]{"document.getElementsByClassName", "document.getElementById", "classList.add", "classList.remove", "classList.item", "classList.contains", "classList.toggle"};
    private static String[] JSNODE_ID_VALUES = new String[]{"document.getElementById"};

    public DefaultRefactorAction(AbstractThemeableEditor editor, ITextSelection selection) {
        this.editor = editor;
        this.selection = selection;
        this.info = new RefactorContextInfo();
        this.initRefactorContext(editor, selection);
    }

    private void initRefactorContext(AbstractThemeableEditor targetEditor, ITextSelection textSelection) {
        if (targetEditor instanceof JSSourceEditor) {
            this.context = new JSRefactorSearchContext();
        } else if (targetEditor instanceof HTMLEditor) {
            this.context = new HTMLRefactorSearchContext();
        } else if (targetEditor instanceof CSSSourceEditor) {
            this.context = new CSSRefactorSearchContext();
        }
    }

    @Override
    public boolean canRefactor() {
        int offset;
        block9: {
            IParseNode ast;
            block8: {
                if (this.editor == null || this.selection == null || this.context == null) {
                    return false;
                }
                try {
                    offset = this.selection.getOffset();
                    ast = this.context.getAST(this.editor, offset);
                    if (ast != null) break block8;
                    return false;
                }
                catch (Exception exception) {}
            }
            this.selectNode = ast.getNodeAtOffset(this.context.getRealOffset(offset));
            if (!(this.selectNode instanceof JSIdentifierNode)) break block9;
            return true;
        }
        if (this.selectNode instanceof JSStringNode) {
            return this.checkCanRefactor();
        }
        if (this.selectNode instanceof HTMLElementNode) {
            return this.checkSelectIsIDOrCLASS(offset, this.selectNode);
        }
        if (this.selectNode instanceof CSSAttributeSelectorNode) {
            return true;
        }
        return false;
    }

    private boolean checkCanRefactor() {
        block5: {
            IParseNode node_2;
            IParseNode node_1;
            block4: {
                node_1 = this.selectNode.getParent();
                if (!(node_1 instanceof JSAssignmentNode)) break block4;
                JSAssignmentNode jsAssignmentNode = (JSAssignmentNode)node_1;
                String parseNodetext = jsAssignmentNode.getLeftHandSide().toString();
                String[] stringArray = JSASSIGNMENTNODESVALUES;
                int n = JSASSIGNMENTNODESVALUES.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    if (parseNodetext.endsWith(value)) {
                        return true;
                    }
                    ++n2;
                }
                break block5;
            }
            if (!(node_1 instanceof JSArgumentsNode) || !((node_2 = node_1.getParent()) instanceof JSInvokeNode)) break block5;
            JSInvokeNode jsInvokeNode = (JSInvokeNode)node_2;
            String parseNodetext = jsInvokeNode.getFirstChild().toString();
            String[] stringArray = JSINVOKENODESVALUES;
            int n = JSINVOKENODESVALUES.length;
            int n3 = 0;
            while (n3 < n) {
                String value = stringArray[n3];
                if (parseNodetext.endsWith(value)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    private boolean checkSelectIsIDOrCLASS(int offset, IParseNode selectNode2) throws BadLocationException {
        IParseNodeAttribute[] iParseNodes = this.selectNode.getAttributes();
        String attName = "";
        IParseNodeAttribute[] iParseNodeAttributeArray = iParseNodes;
        int n = iParseNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNodeAttribute iParseNodeAttribute = iParseNodeAttributeArray[n2];
            attName = iParseNodeAttribute.getName();
            if (StringUtil.contains((String[])SRC, (String)attName) && this.checkOffset(offset, iParseNodeAttribute)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean checkOffset(int offset, IParseNodeAttribute iParseNodeAttribute) {
        IRange range = iParseNodeAttribute.getValueRange();
        int startOffset = range.getStartingOffset();
        int endOffset = range.getEndingOffset();
        return offset >= startOffset && offset <= endOffset;
    }

    @Override
    public String getSelectNode() {
        if (this.editor == null || this.selection == null || this.context == null) {
            return null;
        }
        int offset = this.selection.getOffset();
        String srcvalue = "";
        try {
            if (this.selectNode == null) {
                IParseNode ast = this.context.getAST(this.editor, offset);
                this.selectNode = ast.getNodeAtOffset(this.context.getRealOffset(offset));
            }
            if (this.selectNode instanceof JSIdentifierNode) {
                srcvalue = this.selectNode.getText();
            }
            if (this.selectNode instanceof JSStringNode) {
                srcvalue = this.selectNode.getText();
                srcvalue = srcvalue.substring(1, srcvalue.length() - 1);
                this.checkIDOrClass();
            }
            if (this.selectNode instanceof HTMLElementNode && StringUtil.isBlank((String)(srcvalue = this.getSelectValue(offset, this.selectNode)))) {
                srcvalue = this.selection.getText();
            }
            if (this.selectNode instanceof CSSAttributeSelectorNode) {
                srcvalue = this.selectNode.getText();
                if (srcvalue.startsWith("#")) {
                    this.info.setID(true);
                }
                if (StringUtil.isNotBlank((String)srcvalue)) {
                    srcvalue = srcvalue.substring(1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.info.setOldName(srcvalue);
        return srcvalue;
    }

    private void checkIDOrClass() {
        block4: {
            IParseNode node_2;
            IParseNode node_1;
            block5: {
                node_1 = this.selectNode.getParent();
                if (!(node_1 instanceof JSAssignmentNode)) break block5;
                JSAssignmentNode jsAssignmentNode = (JSAssignmentNode)node_1;
                String parseNodetext = jsAssignmentNode.getLeftHandSide().toString();
                String[] stringArray = JSNODE_ID_VALUES;
                int n = JSNODE_ID_VALUES.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    if (parseNodetext.endsWith(value)) {
                        this.info.setID(true);
                        break block4;
                    }
                    ++n2;
                }
                break block4;
            }
            if (!(node_1 instanceof JSArgumentsNode) || !((node_2 = node_1.getParent()) instanceof JSInvokeNode)) break block4;
            JSInvokeNode jsInvokeNode = (JSInvokeNode)node_2;
            String parseNodetext = jsInvokeNode.getFirstChild().toString();
            String[] stringArray = JSNODE_ID_VALUES;
            int n = JSNODE_ID_VALUES.length;
            int n3 = 0;
            while (n3 < n) {
                String value = stringArray[n3];
                if (parseNodetext.endsWith(value)) {
                    this.info.setID(true);
                    break;
                }
                ++n3;
            }
        }
    }

    private String getSelectValue(int offset, IParseNode selectNode2) throws BadLocationException {
        String srcvalue = "";
        IParseNodeAttribute[] iParseNodes = this.selectNode.getAttributes();
        String attName = "";
        IParseNodeAttribute[] iParseNodeAttributeArray = iParseNodes;
        int n = iParseNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNodeAttribute iParseNodeAttribute = iParseNodeAttributeArray[n2];
            attName = iParseNodeAttribute.getName();
            if (StringUtil.contains((String[])SRC, (String)attName) && this.checkOffset(offset, iParseNodeAttribute)) {
                String svalue = iParseNodeAttribute.getValue();
                srcvalue = svalue.startsWith("\"") ? RegularUtils.match((String)REGX, (String)svalue, (int)1) : svalue;
                int index = svalue.indexOf(srcvalue);
                if (attName.equals("class") && srcvalue.indexOf(" ") > -1) {
                    String[] values = svalue.split(" ");
                    int prefix = 0;
                    String[] stringArray = values;
                    int n3 = values.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int preOffset;
                        boolean check;
                        String value = stringArray[n4];
                        if (StringUtil.isNotBlank((String)value) && (check = this.checkOffset(offset, iParseNodeAttribute, preOffset = index + prefix, value))) {
                            srcvalue = value;
                            break;
                        }
                        prefix += value.length() + 1;
                        ++n4;
                    }
                }
                if (attName.equals("id")) {
                    this.info.setID(true);
                }
            }
            ++n2;
        }
        return srcvalue;
    }

    private boolean checkOffset(int offset, IParseNodeAttribute iParseNodeAttribute, int preOffset, String value) {
        IRange range = iParseNodeAttribute.getValueRange();
        int startOffset = range.getStartingOffset() + preOffset;
        int endOffset = startOffset + value.length();
        return offset >= startOffset && offset <= endOffset;
    }

    @Override
    public RefactorContextInfo doRefactor() {
        if (this.editor == null || this.selection == null || this.context == null) {
            return null;
        }
        this.context.search(this.editor, this.info, this.selection.getOffset());
        return this.info;
    }

    @Override
    public boolean isMakeSure() {
        return this.context.isMakeSure(this.editor, this.selection.getOffset());
    }

    @Override
    public boolean canReference() {
        return false;
    }
}

