/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.refactoring;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.html.ext.HTMLScript;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSThisNode;
import com.aptana.parsing.ast.IParseNode;
import com.pandora.refactor.core.IRefactorSearchContext;
import com.pandora.refactor.core.IRefactorStrategyFactory;
import com.pandora.refactor.core.RefactorCoreActivator;
import com.pandora.refactor.core.html.refactoring.IHTMLScriptRefactorStrategy;
import com.pandora.refactor.core.js.inferrer.InferrerUtils;
import com.pandora.refactor.core.js.refactoring.JSRefactorRegion;
import com.pandora.refactor.core.refactoring.IRefactorStrategy;
import com.pandora.refactor.core.refactoring.RefactorContextInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IFileEditorInput;

public abstract class AbstractSearchContext
implements IRefactorSearchContext {
    protected HTMLScript htmlScript = null;
    protected IParseNode rootNode = null;

    @Override
    public int getRealOffset(int offset) {
        return offset;
    }

    @Override
    public void search(AbstractThemeableEditor targetEditor, RefactorContextInfo refactorInfo, int offset) {
        if (!this.checkEditor(targetEditor)) {
            return;
        }
        try {
            IFile currentFile = this.getCurrentFile(targetEditor);
            IParseNode ast = this.getCacheAST(targetEditor, offset);
            if (ast == null) {
                return;
            }
            refactorInfo.setCurrentProject(currentFile.getProject());
            IParseNode refactorNode = ast.getNodeAtOffset(this.getRealOffset(offset));
            String identification = null;
            if (refactorNode instanceof JSIdentifierNode) {
                JSIdentifierNode node = (JSIdentifierNode)refactorNode;
                identification = node.getText();
                refactorInfo.setOldName(identification);
            }
            if (StringUtil.isNotEmpty(identification) && ast instanceof JSParseRootNode) {
                if (!(refactorNode.getParent() instanceof JSNode)) {
                    return;
                }
                IdeLog.logInfo((Plugin)RefactorCoreActivator.getDefault(), (String)("RefactorNode:" + refactorNode.getParent().getClass().getName()));
                IRefactorStrategyFactory factory = this.getRefactorStrategyFactory();
                IRefactorStrategy refactorStrategy = null;
                JSNode parentNode = (JSNode)refactorNode.getParent();
                switch (parentNode.getNodeType()) {
                    case 69: {
                        refactorStrategy = factory.buildParamRefactorStrategy();
                        break;
                    }
                    case 70: {
                        refactorStrategy = factory.buildFunctionRefactorStrategy();
                        break;
                    }
                    case 63: {
                        if (parentNode.getChild(0) != refactorNode) break;
                        refactorStrategy = factory.buildDeclarationRefactorStrategy();
                        break;
                    }
                    case 62: 
                    case 75: {
                        refactorStrategy = factory.buildInvokeRefactorStrategy();
                        break;
                    }
                    case 48: {
                        JSGetPropertyNode pNode = (JSGetPropertyNode)parentNode;
                        if (pNode.getRightHandSide() == refactorNode) {
                            refactorStrategy = this.buildGetPropertyRefactorStrategy(refactorNode, factory);
                            break;
                        }
                        JSNode declarationNode = InferrerUtils.searchDeclarationNode((JSIdentifierNode)refactorNode);
                        if (declarationNode == null) {
                            refactorStrategy = factory.buildDefaultRefactorStrategy();
                            break;
                        }
                        if (declarationNode instanceof JSDeclarationNode) {
                            refactorNode = declarationNode.getFirstChild();
                            refactorStrategy = factory.buildDeclarationRefactorStrategy();
                            break;
                        }
                        if (declarationNode instanceof JSIdentifierNode) {
                            refactorNode = declarationNode;
                            refactorStrategy = factory.buildParamRefactorStrategy();
                            break;
                        }
                        if (!(declarationNode instanceof JSFunctionNode)) break;
                        refactorNode = ((JSFunctionNode)declarationNode).getName();
                        refactorStrategy = factory.buildFunctionRefactorStrategy();
                        break;
                    }
                    case 76: {
                        refactorStrategy = factory.buildNameValuePairRefactorStrategy();
                        break;
                    }
                    default: {
                        JSNode declarationNode = InferrerUtils.searchDeclarationNode((JSIdentifierNode)refactorNode);
                        if (declarationNode == null) {
                            refactorNode = ast;
                            refactorStrategy = factory.buildDefaultRefactorStrategy();
                            break;
                        }
                        if (declarationNode instanceof JSDeclarationNode) {
                            refactorNode = declarationNode.getFirstChild();
                            refactorStrategy = factory.buildDeclarationRefactorStrategy();
                            break;
                        }
                        if (declarationNode instanceof JSIdentifierNode) {
                            refactorNode = declarationNode;
                            refactorStrategy = factory.buildParamRefactorStrategy();
                            break;
                        }
                        if (!(declarationNode instanceof JSFunctionNode)) break;
                        refactorNode = ((JSFunctionNode)declarationNode).getName();
                        refactorStrategy = factory.buildFunctionRefactorStrategy();
                    }
                }
                if (refactorStrategy instanceof IHTMLScriptRefactorStrategy) {
                    IHTMLScriptRefactorStrategy htmlScriptRefactorStrategy = (IHTMLScriptRefactorStrategy)refactorStrategy;
                    htmlScriptRefactorStrategy.setHTMLScript(this.htmlScript);
                }
                refactorStrategy.searchLocalRefactorNode(refactorNode, identification, refactorInfo, currentFile);
                refactorStrategy.searchOutsideRefactorNode(currentFile, refactorNode, identification, refactorInfo);
                refactorStrategy.filterRefactorNode(refactorInfo);
                this.printRefactorInfo(refactorInfo);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)RefactorCoreActivator.getDefault(), (Throwable)e);
        }
    }

    @Override
    public boolean isMakeSure(AbstractThemeableEditor targetEditor, int offset) {
        IParseNode refactorNode;
        block14: {
            IParseNode ast;
            block13: {
                if (!this.checkEditor(targetEditor)) {
                    return false;
                }
                try {
                    ast = this.getCacheAST(targetEditor, offset);
                    if (ast != null) break block13;
                    return false;
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)RefactorCoreActivator.getDefault(), (Throwable)e);
                    return false;
                }
            }
            refactorNode = ast.getNodeAtOffset(this.getRealOffset(offset));
            if (refactorNode.getParent() instanceof JSNode) break block14;
            return false;
        }
        boolean result = false;
        JSNode parentNode = (JSNode)refactorNode.getParent();
        switch (parentNode.getNodeType()) {
            case 69: {
                result = true;
                break;
            }
            case 70: {
                result = false;
                break;
            }
            case 63: {
                if (parentNode.getChild(0) != refactorNode) break;
                result = false;
                break;
            }
            case 62: 
            case 75: {
                result = false;
                break;
            }
            case 48: {
                result = false;
                break;
            }
            case 76: {
                result = false;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    protected boolean checkEditor(AbstractThemeableEditor targetEditor) {
        return targetEditor != null;
    }

    protected IFile getCurrentFile(AbstractThemeableEditor targetEditor) {
        IFile currentFile = ((IFileEditorInput)targetEditor.getEditorInput()).getFile();
        return currentFile;
    }

    protected IParseNode getCacheAST(AbstractThemeableEditor targetEditor, int offset) throws Exception {
        if (this.rootNode != null) {
            return this.rootNode;
        }
        this.rootNode = this.getAST(targetEditor, offset);
        return this.rootNode;
    }

    private IRefactorStrategy buildGetPropertyRefactorStrategy(IParseNode refactorNode, IRefactorStrategyFactory factory) {
        JSGetPropertyNode getPropertyNode = (JSGetPropertyNode)refactorNode.getParent();
        if (getPropertyNode.getLeftHandSide() instanceof JSThisNode) {
            return factory.buildObjectRefactorStrategy();
        }
        if (getPropertyNode.getLeftHandSide() instanceof JSGetPropertyNode) {
            JSGetPropertyNode node = (JSGetPropertyNode)getPropertyNode.getLeftHandSide();
            if ("prototype".equals(node.getRightHandSide().getText())) {
                return factory.buildPrototypeRefactorStrategy();
            }
        } else if (getPropertyNode.getRightHandSide() == refactorNode) {
            return factory.buildGetPropertyRefactorStrategy();
        }
        return null;
    }

    public HTMLScript getHtmlScript() {
        return this.htmlScript;
    }

    private void printRefactorInfo(RefactorContextInfo refactorInfo) {
        IdeLog.logInfo((Plugin)RefactorCoreActivator.getDefault(), (String)"===========================Start===========================");
        for (JSRefactorRegion region : refactorInfo.getResults()) {
            IdeLog.logInfo((Plugin)RefactorCoreActivator.getDefault(), (String)String.valueOf(region.getRefactorNode().getParent()));
            IdeLog.logInfo((Plugin)RefactorCoreActivator.getDefault(), (String)String.valueOf(region));
        }
        IdeLog.logInfo((Plugin)RefactorCoreActivator.getDefault(), (String)"===========================End===========================");
    }
}

