/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.js.refactoring;

import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSParametersNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSStatementsNode;
import com.aptana.editor.js.parsing.ast.JSVarNode;
import com.aptana.parsing.ast.IParseNode;
import com.pandora.refactor.core.js.refactoring.JSDeclarationRefactorStrategy;
import com.pandora.refactor.core.js.refactoring.JSRefactorRegion;
import com.pandora.refactor.core.refactoring.IRefactorStrategy;
import com.pandora.refactor.core.refactoring.RefactorContextInfo;
import com.pandora.refactor.core.refactoring.ResultHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;

public class JSParamRefactorStrategy
extends JSDeclarationRefactorStrategy
implements IRefactorStrategy {
    @Override
    public void searchLocalRefactorNode(IParseNode node, String identification, RefactorContextInfo refactorInfo, IFile targetFile) {
        if (node instanceof JSIdentifierNode) {
            JSIdentifierNode identifierNode;
            this.targetNode = identifierNode = (JSIdentifierNode)node;
            IParseNode jsNode = identifierNode.getParent().getParent();
            if (jsNode instanceof JSFunctionNode) {
                this.addResult(refactorInfo, identifierNode, targetFile);
                JSFunctionNode functionNode = (JSFunctionNode)jsNode;
                JSParseRootNode rootNode = (JSParseRootNode)identifierNode.getRootNode();
                JSScope scope = ParseUtil.getScopeAtOffset((IParseNode)rootNode, (int)functionNode.getChild(functionNode.getChildCount() - 1).getStartingOffset());
                this.searchCurrentScope(identifierNode.getText(), scope, refactorInfo, targetFile);
            }
        }
    }

    @Override
    protected boolean isIncludeParams(String identifier, JSNode rangeNode) {
        JSFunctionNode funcNode;
        IParseNode paramsNode;
        JSStatementsNode statementNode;
        if (rangeNode != null && rangeNode instanceof JSStatementsNode && (statementNode = (JSStatementsNode)rangeNode).getParent() instanceof JSFunctionNode && (paramsNode = (funcNode = (JSFunctionNode)statementNode.getParent()).getParameters()) instanceof JSParametersNode) {
            JSParametersNode parametersNode = (JSParametersNode)paramsNode;
            IParseNode[] iParseNodeArray = parametersNode.getChildren();
            int n = iParseNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IParseNode subNode = iParseNodeArray[n2];
                if (identifier.equals(subNode.getText()) && subNode != this.targetNode) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public void filterRefactorNode(RefactorContextInfo refactorInfo) {
        List<JSRefactorRegion> regions = refactorInfo.getResults();
        JSRefactorRegion[] regionArr = regions.toArray(new JSRefactorRegion[regions.size()]);
        Arrays.sort(regionArr, new Comparator<JSRefactorRegion>(){

            @Override
            public int compare(JSRefactorRegion o1, JSRefactorRegion o2) {
                return o1.getStartOffset() - o2.getStartOffset();
            }
        });
        regions = Arrays.asList(regionArr);
        ArrayList<JSRefactorRegion> deleteRegions = new ArrayList<JSRefactorRegion>();
        for (JSRefactorRegion region : regions) {
            JSIdentifierNode node = region.getRefactorNode();
            if (node.getParent() instanceof JSGetPropertyNode) {
                JSGetPropertyNode getPropertyNode = (JSGetPropertyNode)node.getParent();
                if (getPropertyNode.getLeftHandSide() == node) continue;
                deleteRegions.add(region);
                continue;
            }
            if (node.getParent() instanceof JSDeclarationNode) {
                JSDeclarationNode declarationNode = (JSDeclarationNode)node.getParent();
                if (declarationNode.getChild(0) != node || !(declarationNode.getParent() instanceof JSVarNode)) continue;
                deleteRegions.add(region);
                continue;
            }
            if (!(node.getParent() instanceof JSFunctionNode)) continue;
            deleteRegions.add(region);
        }
        this.executeFilter(refactorInfo, deleteRegions);
        ResultHandler.handle(refactorInfo, new ResultHandler.Handler(){

            @Override
            public void handle(JSRefactorRegion refactorRegion) {
                refactorRegion.setMakeSure(true);
            }
        });
    }
}

