/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.js.refactoring;

import com.aptana.editor.js.hyperlink.JSIdentifierCollector;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSConstructNode;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSNameValuePairNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSThisNode;
import com.aptana.parsing.ast.IParseNode;
import com.pandora.refactor.core.js.inferrer.InferrerUtils;
import com.pandora.refactor.core.js.refactoring.JSObjectRefactorStrategy;
import com.pandora.refactor.core.js.refactoring.JSRefactorRegion;
import com.pandora.refactor.core.refactoring.IRefactorStrategy;
import com.pandora.refactor.core.refactoring.RefactorContextInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;

public class JSGetPropertyRefactorStrategy
extends JSObjectRefactorStrategy
implements IRefactorStrategy {
    protected Set<String> relatedType = new HashSet<String>();
    protected static final String UNKNOW = "-1";
    protected static final String JS_OBJECT_TYPE = "JSObjectNode";
    protected boolean isGlobalSearch = false;

    @Override
    public void searchLocalRefactorNode(IParseNode node, String identification, RefactorContextInfo refactorInfo, IFile targetFile) {
        if (node instanceof JSIdentifierNode) {
            JSIdentifierNode identifierNode = (JSIdentifierNode)node;
            JSGetPropertyNode getNode = (JSGetPropertyNode)identifierNode.getParent();
            JSIdentifierNode leftNode = (JSIdentifierNode)getNode.getLeftHandSide();
            List<JSNode> jsNodes = InferrerUtils.searchDeclarationNodes(leftNode);
            if (jsNodes.isEmpty()) {
                this.globalSearchRefactorNode(refactorInfo, identifierNode);
                this.isGlobalSearch = true;
            } else {
                this.inferrerRelatedType(jsNodes);
                JSIdentifierCollector idCollector = new JSIdentifierCollector(identifierNode.getText());
                idCollector.visit((JSParseRootNode)identifierNode.getRootNode());
                List idnodes = idCollector.getIdentifiers();
                this.addIdentificationNode(idnodes, refactorInfo, targetFile, false);
            }
        }
    }

    protected void inferrerRelatedType(List<JSNode> jsNodes) {
        for (JSNode node : jsNodes) {
            JSConstructNode constructNode;
            IParseNode parseNode;
            if (node instanceof JSDeclarationNode) {
                JSDeclarationNode declarationNode = (JSDeclarationNode)node;
                if (declarationNode.getChildCount() != 2) continue;
                parseNode = declarationNode.getChild(1);
                if (parseNode instanceof JSConstructNode) {
                    constructNode = (JSConstructNode)parseNode;
                    this.relatedType.add(constructNode.getExpression().getText());
                    continue;
                }
                if (!(parseNode instanceof JSObjectNode)) continue;
                this.relatedType.add(JS_OBJECT_TYPE);
                continue;
            }
            if (node instanceof JSAssignmentNode) {
                JSAssignmentNode assignNode = (JSAssignmentNode)node;
                parseNode = assignNode.getRightHandSide();
                if (parseNode instanceof JSConstructNode) {
                    constructNode = (JSConstructNode)parseNode;
                    this.relatedType.add(constructNode.getExpression().getText());
                    continue;
                }
                if (!(parseNode instanceof JSObjectNode)) continue;
                this.relatedType.add(JS_OBJECT_TYPE);
                continue;
            }
            this.relatedType.add(UNKNOW);
        }
    }

    @Override
    protected void addIdentificationNode(List<JSIdentifierNode> identifierNodes, RefactorContextInfo refactorInfo, IFile targetFile, boolean isHTML) {
        for (JSIdentifierNode idNode : identifierNodes) {
            if (idNode.getParent() instanceof JSGetPropertyNode) {
                JSGetPropertyNode getPropertyNode = (JSGetPropertyNode)idNode.getParent();
                if (getPropertyNode.getRightHandSide() != idNode) continue;
                if (isHTML) {
                    if (this.htmlScript == null) continue;
                    this.addResult(refactorInfo, idNode, targetFile, this.htmlScript);
                    continue;
                }
                this.addResult(refactorInfo, idNode, targetFile);
                continue;
            }
            if (!(idNode.getParent() instanceof JSNameValuePairNode) || !this.relatedType.contains(JS_OBJECT_TYPE)) continue;
            if (isHTML) {
                if (this.htmlScript == null) continue;
                this.addResult(refactorInfo, idNode, targetFile, this.htmlScript);
                continue;
            }
            this.addResult(refactorInfo, idNode, targetFile);
        }
    }

    @Override
    public void searchOutsideRefactorNode(IFile targetJSFile, IParseNode node, String identification, RefactorContextInfo refactorInfo) {
        if (this.isGlobalSearch) {
            return;
        }
        super.searchOutsideRefactorNode(targetJSFile, node, identification, refactorInfo);
    }

    @Override
    public void filterRefactorNode(RefactorContextInfo refactorInfo) {
        ArrayList<JSRefactorRegion> deleteRegions = new ArrayList<JSRefactorRegion>();
        List<JSRefactorRegion> results = refactorInfo.getResults();
        for (JSRefactorRegion refactorRegion : results) {
            JSFunctionNode funcNode;
            JSIdentifierNode identifierNode = refactorRegion.getRefactorNode();
            if (!(identifierNode.getParent() instanceof JSGetPropertyNode)) {
                if (identifierNode.getParent() instanceof JSNameValuePairNode && this.relatedType.contains(JS_OBJECT_TYPE)) continue;
                deleteRegions.add(refactorRegion);
                continue;
            }
            JSGetPropertyNode getNode = (JSGetPropertyNode)identifierNode.getParent();
            IParseNode parseNode = getNode.getLeftHandSide();
            if (!(parseNode instanceof JSThisNode) || this.relatedType.contains((funcNode = super.getObjectNode(identifierNode)).getText())) continue;
            deleteRegions.add(refactorRegion);
        }
        this.executeFilter(refactorInfo, deleteRegions);
    }
}

