/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.js.refactoring;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.ext.FileRange;
import com.aptana.editor.html.ext.HTMLScript;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.JSParseState;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.pandora.refactor.core.index.JSFileReferenceHelper;
import com.pandora.refactor.core.js.inferrer.JSLocalScopeInferrer;
import com.pandora.refactor.core.js.refactoring.AbstractJSRefactorStrategy;
import com.pandora.refactor.core.js.refactoring.JSRefactorRegion;
import com.pandora.refactor.core.refactoring.IRefactorStrategy;
import com.pandora.refactor.core.refactoring.RefactorContextInfo;
import com.pandora.refactor.core.refactoring.ResultHandler;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class JSFunctionRefactorStrategy
extends AbstractJSRefactorStrategy
implements IRefactorStrategy {
    private static final String JS_CONTENT_TYPE = "js";
    protected boolean isGlobal = false;
    protected JSIdentifierNode targetNode = null;
    protected HTMLScript htmlScript = null;
    private IFile targetFile = null;

    @Override
    public void searchLocalRefactorNode(IParseNode node, String identification, RefactorContextInfo refactorInfo, IFile targetFile) {
        JSIdentifierNode identifierNode;
        if (node instanceof JSIdentifierNode && (identifierNode = (JSIdentifierNode)node).getParent() instanceof JSFunctionNode) {
            this.targetNode = identifierNode;
            this.targetFile = targetFile;
            JSParseRootNode rootNode = (JSParseRootNode)identifierNode.getRootNode();
            JSScope scope = ParseUtil.getScopeAtOffset((IParseNode)rootNode, (int)identifierNode.getStartingOffset());
            this.isGlobal = scope.getParentScope() == null;
            this.searchCurrentScope(identifierNode.getText(), scope, refactorInfo, targetFile);
        }
    }

    @Override
    public void searchOutsideRefactorNode(IFile targetJSFile, IParseNode node, String identification, RefactorContextInfo refactorInfo) {
        if (this.isGlobal) {
            if (targetJSFile == null) {
                return;
            }
            IProject project = targetJSFile.getProject();
            String keyPath = targetJSFile.getLocation().toString().substring(project.getLocation().toString().length());
            if (keyPath.startsWith("/")) {
                keyPath = keyPath.substring(1);
            }
            Set<String> htmlFiles = JSFileReferenceHelper.getReference(project, keyPath);
            for (String htmlFile : htmlFiles) {
                IFile ihtmlFile = project.getFile(htmlFile);
                if (!ihtmlFile.exists()) continue;
                try {
                    this.htmlScript = this.getHTMLScript(ihtmlFile);
                    JSParseState parseState = new JSParseState(this.htmlScript.getSource(), 0, true, true);
                    IParseRootNode rootNode = ParserPoolFactory.parse((String)"com.aptana.contenttype.js", (IParseState)parseState).getRootNode();
                    if (rootNode instanceof JSParseRootNode) {
                        this.searchCurrentScope(identification, ((JSParseRootNode)rootNode).getGlobals(), refactorInfo, ihtmlFile);
                    }
                    this.searchEventReferenceFunction(ihtmlFile, identification, refactorInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void searchEventReferenceFunction(IFile ihtmlFile, String identification, RefactorContextInfo refactorInfo) {
    }

    @Override
    public void filterRefactorNode(RefactorContextInfo refactorInfo) {
        ResultHandler.handle(refactorInfo, new ResultHandler.Handler(){

            @Override
            public void handle(JSRefactorRegion refactorRegion) {
                JSIdentifierNode identifierNode = refactorRegion.getRefactorNode();
                if (identifierNode.getParent() instanceof JSInvokeNode) {
                    refactorRegion.setMakeSure(true);
                } else if (identifierNode == JSFunctionRefactorStrategy.this.targetNode) {
                    refactorRegion.setMakeSure(true);
                }
            }
        });
    }

    private void searchCurrentScope(String identifier, JSScope scope, RefactorContextInfo refactorInfo, IFile targetFile) {
        boolean isJSFile = JS_CONTENT_TYPE.equals(targetFile.getFileExtension());
        String id = identifier;
        JSNode rangeNode = null;
        if (scope.getRange() instanceof JSNode) {
            rangeNode = (JSNode)scope.getRange();
        }
        JSLocalScopeInferrer localScopeInferrer = new JSLocalScopeInferrer(rangeNode, id);
        if (rangeNode == null) {
            localScopeInferrer.visit((JSParseRootNode)scope.getRange());
        } else {
            localScopeInferrer.visit(rangeNode);
        }
        List<JSIdentifierNode> identifierNodes = localScopeInferrer.getIdentifierNodes();
        if (!this.containDuplicateNode(identifierNodes, isJSFile)) {
            for (JSIdentifierNode idNode : identifierNodes) {
                if (isJSFile) {
                    this.addResult(refactorInfo, idNode, targetFile);
                    continue;
                }
                if (this.htmlScript == null) continue;
                this.addResult(refactorInfo, idNode, targetFile, this.htmlScript);
            }
            List scopes = scope.getChildren();
            for (JSScope childScope : scopes) {
                this.searchCurrentScope(identifier, childScope, refactorInfo, targetFile);
            }
        }
    }

    protected boolean containDuplicateNode(List<JSIdentifierNode> identifierNodes, boolean isJSFile) {
        if (this.targetNode == null) {
            return false;
        }
        for (JSIdentifierNode node : identifierNodes) {
            FileRange fileRange;
            IParseNode parentNode = node.getParent();
            if (!(parentNode instanceof JSFunctionNode) || !(isJSFile ? parentNode != this.targetNode.getParent() : this.htmlScript != null && (!StringUtil.isNotEmpty((String)(fileRange = this.htmlScript.findActualFileRange(node.getStartingOffset())).getFileName()) || !fileRange.getFileName().endsWith(this.targetFile.getFullPath().toString())))) continue;
            return true;
        }
        return false;
    }
}

