/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.js.refactoring;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.ext.FileRange;
import com.aptana.editor.html.ext.HTMLScript;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.JSParseState;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSNameValuePairNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSParametersNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSStatementsNode;
import com.aptana.editor.js.parsing.ast.JSVarNode;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.pandora.refactor.core.index.JSFileReferenceHelper;
import com.pandora.refactor.core.js.inferrer.JSLocalScopeInferrer;
import com.pandora.refactor.core.js.refactoring.AbstractJSRefactorStrategy;
import com.pandora.refactor.core.js.refactoring.JSRefactorRegion;
import com.pandora.refactor.core.refactoring.IRefactorStrategy;
import com.pandora.refactor.core.refactoring.RefactorContextInfo;
import com.pandora.refactor.core.refactoring.ResultHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class JSDeclarationRefactorStrategy
extends AbstractJSRefactorStrategy
implements IRefactorStrategy {
    private boolean isGlobal = false;
    protected JSIdentifierNode targetNode = null;
    private IFile targetFile = null;
    protected HTMLScript htmlScript = null;

    @Override
    public void searchLocalRefactorNode(IParseNode node, String identification, RefactorContextInfo refactorInfo, IFile targetFile) {
        JSIdentifierNode identifierNode;
        if (node instanceof JSIdentifierNode && (identifierNode = (JSIdentifierNode)node).getParent() instanceof JSDeclarationNode) {
            this.targetNode = identifierNode;
            this.targetFile = targetFile;
            JSParseRootNode rootNode = (JSParseRootNode)identifierNode.getRootNode();
            JSScope scope = ParseUtil.getScopeAtOffset((IParseNode)rootNode, (int)identifierNode.getStartingOffset());
            this.isGlobal = scope.getParentScope() == null;
            this.searchCurrentScope(identifierNode.getText(), scope, refactorInfo, targetFile);
        }
    }

    protected void searchCurrentScope(String identifier, JSScope scope, RefactorContextInfo refactorInfo, IFile targetFile) {
        boolean isJS = "js".equals(targetFile.getFileExtension());
        String id = identifier;
        JSNode rangeNode = null;
        if (scope.getRange() instanceof JSNode) {
            rangeNode = (JSNode)scope.getRange();
        }
        if (this.isIncludeParams(identifier, rangeNode)) {
            return;
        }
        JSLocalScopeInferrer localScopeInferrer = new JSLocalScopeInferrer(rangeNode, id);
        if (rangeNode == null) {
            localScopeInferrer.visit((JSParseRootNode)scope.getRange());
        } else {
            localScopeInferrer.visit(rangeNode);
        }
        List<JSIdentifierNode> identifierNodes = localScopeInferrer.getIdentifierNodes();
        identifierNodes = this.sort(identifierNodes);
        List scopes = scope.getChildren();
        int duplicateNodeEndOffset = Integer.MAX_VALUE;
        for (JSIdentifierNode idNode : identifierNodes) {
            if (idNode.getParent() instanceof JSDeclarationNode) {
                JSDeclarationNode declarationNode = (JSDeclarationNode)idNode.getParent();
                if (declarationNode.getChild(0) == idNode && declarationNode.getParent() instanceof JSVarNode) {
                    if (isJS) {
                        if (declarationNode.getChild(0) != this.targetNode && declarationNode.getStartingOffset() > this.targetNode.getParent().getEndingOffset()) {
                            duplicateNodeEndOffset = declarationNode.getEndingOffset();
                            break;
                        }
                    } else if (this.htmlScript != null) {
                        FileRange fileRange = this.htmlScript.findActualFileRange(idNode.getStartingOffset());
                        if (!StringUtil.isNotEmpty((String)fileRange.getFileName()) || !fileRange.getFileName().endsWith(this.targetFile.getFullPath().toString())) {
                            if (declarationNode.getChild(0) != this.targetNode) {
                                duplicateNodeEndOffset = declarationNode.getEndingOffset();
                                break;
                            }
                        } else if (declarationNode.getChild(0) != this.targetNode) {
                            continue;
                        }
                    }
                }
            } else if (idNode.getParent() instanceof JSParametersNode) continue;
            this.addResultRefactorNode(refactorInfo, targetFile, isJS, idNode);
        }
        for (JSScope childScope : scopes) {
            if (isJS ? childScope.getRange().getStartingOffset() > duplicateNodeEndOffset || childScope.getRange().getEndingOffset() < this.targetNode.getParent().getStartingOffset() : childScope.getRange().getStartingOffset() > duplicateNodeEndOffset) continue;
            this.searchCurrentScope(identifier, childScope, refactorInfo, targetFile);
        }
    }

    protected void addResultRefactorNode(RefactorContextInfo refactorInfo, IFile targetFile, boolean isJS, JSIdentifierNode idNode) {
        if (!isJS && this.htmlScript != null) {
            this.addResult(refactorInfo, idNode, targetFile, this.htmlScript);
        } else if (idNode.getStartingOffset() > this.targetNode.getParent().getEndingOffset() || idNode == this.targetNode) {
            this.addResult(refactorInfo, idNode, targetFile);
        }
    }

    protected boolean isIncludeParams(String identifier, JSNode rangeNode) {
        JSFunctionNode funcNode;
        IParseNode paramsNode;
        JSStatementsNode statementNode;
        if (rangeNode != null && rangeNode instanceof JSStatementsNode && (statementNode = (JSStatementsNode)rangeNode).getParent() instanceof JSFunctionNode && (paramsNode = (funcNode = (JSFunctionNode)statementNode.getParent()).getParameters()) instanceof JSParametersNode) {
            JSParametersNode parametersNode = (JSParametersNode)paramsNode;
            IParseNode[] iParseNodeArray = parametersNode.getChildren();
            int n = iParseNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IParseNode subNode = iParseNodeArray[n2];
                if (identifier.equals(subNode.getText()) && subNode.getStartingOffset() > this.targetNode.getEndingOffset()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public void searchOutsideRefactorNode(IFile targetJSFile, IParseNode node, String identification, RefactorContextInfo refactorInfo) {
        if (this.isGlobal) {
            if (targetJSFile == null) {
                return;
            }
            IProject project = targetJSFile.getProject();
            String keyPath = targetJSFile.getLocation().toString().substring(project.getLocation().toString().length());
            if (keyPath.startsWith("/")) {
                keyPath = keyPath.substring(1);
            }
            Set<String> htmlFiles = JSFileReferenceHelper.getReference(project, keyPath);
            for (String htmlFile : htmlFiles) {
                IFile ihtmlFile = project.getFile(htmlFile);
                if (!ihtmlFile.exists()) continue;
                try {
                    this.htmlScript = this.getHTMLScript(ihtmlFile);
                    JSParseState parseState = new JSParseState(this.htmlScript.getSource(), 0, true, true);
                    IParseRootNode rootNode = ParserPoolFactory.parse((String)"com.aptana.contenttype.js", (IParseState)parseState).getRootNode();
                    if (!(rootNode instanceof JSParseRootNode)) continue;
                    this.searchCurrentScope(identification, ((JSParseRootNode)rootNode).getGlobals(), refactorInfo, ihtmlFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void filterRefactorNode(RefactorContextInfo refactorInfo) {
        List<JSRefactorRegion> regions = refactorInfo.getResults();
        JSRefactorRegion[] regionArr = regions.toArray(new JSRefactorRegion[regions.size()]);
        Arrays.sort(regionArr, new Comparator<JSRefactorRegion>(){

            @Override
            public int compare(JSRefactorRegion o1, JSRefactorRegion o2) {
                return o1.getStartOffset() - o2.getStartOffset();
            }
        });
        regions = Arrays.asList(regionArr);
        ArrayList<JSRefactorRegion> deleteRegions = new ArrayList<JSRefactorRegion>();
        for (JSRefactorRegion region : regions) {
            JSNameValuePairNode pairNode;
            JSGetPropertyNode getPropertyNode;
            JSIdentifierNode node = region.getRefactorNode();
            if (node.getParent() instanceof JSGetPropertyNode && (getPropertyNode = (JSGetPropertyNode)node.getParent()).getLeftHandSide() != node) {
                region.setMakeSure(false);
            }
            if (node.getParent() instanceof JSNameValuePairNode && (pairNode = (JSNameValuePairNode)node.getParent()).getFirstChild() == node) {
                deleteRegions.add(region);
            }
            if (!(node.getParent() instanceof JSFunctionNode)) continue;
            deleteRegions.add(region);
        }
        this.executeFilter(refactorInfo, deleteRegions);
        ResultHandler.handle(refactorInfo, new ResultHandler.Handler(){

            @Override
            public void handle(JSRefactorRegion refactorRegion) {
                refactorRegion.setMakeSure(true);
            }
        });
    }
}

