/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.js.inferrer;

import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSConstructNode;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.parsing.ast.IParseNode;
import java.util.HashSet;
import java.util.Set;

public class JSInstanceInferrer
extends JSTreeWalker {
    private Set<String> instanceSet = new HashSet<String>();
    private JSFunctionNode objNode = null;

    public JSInstanceInferrer(JSFunctionNode objNode) {
        this.objNode = objNode;
    }

    public void visit(JSConstructNode node) {
        IParseNode parseNode = node.getExpression();
        if (this.objNode != null && this.objNode.getText().equals(parseNode.getText())) {
            this.addInstanceVariable(node);
        }
    }

    private void addInstanceVariable(JSConstructNode node) {
        if (node.getParent() instanceof JSDeclarationNode) {
            JSDeclarationNode declarationNode = (JSDeclarationNode)node.getParent();
            IParseNode leftNode = declarationNode.getFirstChild();
            this.instanceSet.add(leftNode.getText());
        } else if (node.getParent() instanceof JSAssignmentNode) {
            JSAssignmentNode assignNode = (JSAssignmentNode)node.getParent();
            IParseNode leftNode = assignNode.getLeftHandSide();
            this.instanceSet.add(leftNode.getText());
        }
    }

    public Set<String> getInstanceSet() {
        return this.instanceSet;
    }
}

