/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.html.refactoring;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.ext.FileRange;
import com.aptana.editor.html.ext.HTMLScript;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.ast.JSConstructNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.parsing.ast.IParseNode;
import com.pandora.refactor.core.html.refactoring.IHTMLScriptRefactorStrategy;
import com.pandora.refactor.core.html.refactoring.SwitchRefactorSearchContext;
import com.pandora.refactor.core.js.refactoring.JSInvokeRefactorStrategy;
import com.pandora.refactor.core.refactoring.RefactorContextInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class HTMLScriptInvokeRefactorStrategy
extends JSInvokeRefactorStrategy
implements IHTMLScriptRefactorStrategy {
    private boolean isTargetFunctionInHTML = false;

    @Override
    public void searchLocalRefactorNode(IParseNode node, String identification, RefactorContextInfo refactorInfo, IFile targetFile) {
        JSIdentifierNode identifierNode;
        if (node instanceof JSIdentifierNode && ((identifierNode = (JSIdentifierNode)node).getParent() instanceof JSInvokeNode || identifierNode.getParent() instanceof JSConstructNode)) {
            JSParseRootNode rootNode = (JSParseRootNode)identifierNode.getRootNode();
            JSScope scope = ParseUtil.getScopeAtOffset((IParseNode)rootNode, (int)identifierNode.getStartingOffset());
            JSFunctionNode targetFunc = this.searchTargetFunctionNode(scope, identifierNode);
            if (targetFunc != null) {
                FileRange fileRange = this.htmlScript.findActualFileRange(targetFunc.getName().getStartingOffset() + 1);
                if (StringUtil.isEmpty((String)fileRange.getFileName())) {
                    this.isTargetFunctionInHTML = true;
                    SwitchRefactorSearchContext context = new SwitchRefactorSearchContext(false, targetFile);
                    context.search(null, refactorInfo, fileRange.getStartingOffset());
                } else {
                    this.isTargetFunctionInHTML = false;
                    String filePath = fileRange.getFileName();
                    IProject project = targetFile.getProject();
                    IFile ifile = this.getProjectRelativePath(filePath, project);
                    SwitchRefactorSearchContext context = new SwitchRefactorSearchContext(true, ifile);
                    context.search(null, refactorInfo, fileRange.getStartingOffset());
                }
                IParseNode parseNode = targetFunc.getName();
                this.hasFindTargetFunction = true;
                super.searchLocalRefactorNode(parseNode, identification, refactorInfo, targetFile);
            } else {
                this.addResult(refactorInfo, identifierNode, targetFile);
            }
        }
    }

    protected IFile getProjectRelativePath(String filePath, IProject project) {
        if (filePath.startsWith("file:/")) {
            filePath = filePath.replaceFirst("file:/", "");
        }
        try {
            filePath = URLDecoder.decode(filePath, Charset.defaultCharset().displayName());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String keyPath = filePath.substring(project.getLocation().toString().length());
        if (keyPath.startsWith("/")) {
            keyPath = keyPath.substring(1);
        }
        IFile ifile = project.getFile(keyPath);
        return ifile;
    }

    @Override
    public void searchOutsideRefactorNode(IFile jsFile, IParseNode node, String identification, RefactorContextInfo refactorInfo) {
        super.searchOutsideRefactorNode(jsFile, node, identification, refactorInfo);
    }

    @Override
    public void filterRefactorNode(RefactorContextInfo refactorInfo) {
        super.filterRefactorNode(refactorInfo);
    }

    @Override
    public HTMLScript getHTMLScript() {
        return this.htmlScript;
    }

    @Override
    public void setHTMLScript(HTMLScript htmlScript) {
        this.htmlScript = htmlScript;
    }
}

