/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.html.refactoring;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.html.ext.HTMLFullScript;
import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.editor.js.parsing.JSParseState;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.pandora.refactor.core.IRefactorSearchContext;
import com.pandora.refactor.core.IRefactorStrategyFactory;
import com.pandora.refactor.core.html.refactoring.HTMLIDOrCLASSRefactorSearch;
import com.pandora.refactor.core.html.refactoring.HTMLScriptRefactorStrategyFactory;
import com.pandora.refactor.core.refactoring.AbstractSearchContext;
import com.pandora.refactor.core.refactoring.RefactorContextInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class HTMLRefactorSearchContext
extends AbstractSearchContext
implements IRefactorSearchContext {
    @Override
    public void search(AbstractThemeableEditor targetEditor, RefactorContextInfo refactorInfo, int offset) {
        IDocument doc = targetEditor.getDocumentProvider().getDocument((Object)targetEditor.getEditorInput());
        try {
            ITypedRegion typedRegion = doc.getPartition(offset);
            IParseNode parseNode = this.getAST(targetEditor, offset);
            IParseNode selectNode = parseNode.getNodeAtOffset(this.getRealOffset(offset));
            if (typedRegion.getType().equals("__html_tag") || typedRegion.getType().equals("__css___dftl_partition_content_type") || selectNode instanceof JSStringNode) {
                HTMLIDOrCLASSRefactorSearch htmlIDOrCLASSRefactorSearch = new HTMLIDOrCLASSRefactorSearch(targetEditor, refactorInfo, offset);
                htmlIDOrCLASSRefactorSearch.searchResult();
            } else {
                super.search(targetEditor, refactorInfo, offset);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public IParseNode getAST(AbstractThemeableEditor targetEditor, int offset) throws Exception {
        if (targetEditor == null) {
            return null;
        }
        if (targetEditor.getDocumentProvider() == null) {
            return null;
        }
        IDocument doc = targetEditor.getDocumentProvider().getDocument((Object)targetEditor.getEditorInput());
        if (doc == null || offset < 0 || offset > doc.getLength()) {
            return null;
        }
        ITypedRegion typedRegion = doc.getPartition(offset);
        IParseRootNode ast = null;
        if (typedRegion.getType().equals("__html_tag")) {
            HTMLParseState parseState = new HTMLParseState(doc.get());
            ast = ParserPoolFactory.parse((String)"com.aptana.contenttype.html", (IParseState)parseState).getRootNode();
        } else if (typedRegion.getType().equals("__css___dftl_partition_content_type")) {
            ParseState parseState = new ParseState(doc.get());
            ast = ParserPoolFactory.parse((String)"com.aptana.contenttype.css", (IParseState)parseState).getRootNode();
        } else {
            IEditorInput editorInput = targetEditor.getEditorInput();
            IFile currentFile = null;
            if (editorInput instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
                currentFile = fileEditorInput.getFile();
            }
            if (currentFile != null) {
                this.htmlScript = new HTMLFullScript(doc, offset, currentFile, true);
                JSParseState parseState = new JSParseState(this.htmlScript.getSource(), 0, true, true);
                ast = ParserPoolFactory.parse((String)"com.aptana.contenttype.js", (IParseState)parseState).getRootNode();
            }
        }
        return ast;
    }

    @Override
    public IRefactorStrategyFactory getRefactorStrategyFactory() {
        return new HTMLScriptRefactorStrategyFactory();
    }

    @Override
    public int getRealOffset(int offset) {
        return this.htmlScript == null ? offset : this.htmlScript.getOffset();
    }
}

