/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core;

import com.pandora.refactor.core.IRefactorSearch;
import com.pandora.refactor.core.refactoring.RefactorContextInfo;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class RefactorResourceVisitor
implements IResourceVisitor {
    private static final String[] acceptFileExtensions = new String[]{"html", "htm", "xhtml", "js"};
    private IRefactorSearch refactorSearch = null;
    private RefactorContextInfo refactorContextInfo = null;

    public RefactorResourceVisitor(IRefactorSearch refactorSearch, RefactorContextInfo refactorInfo) {
        this.refactorSearch = refactorSearch;
        this.refactorContextInfo = refactorInfo;
    }

    public boolean visit(IResource resource) throws CoreException {
        block3: {
            block4: {
                block2: {
                    if (!(resource instanceof IFile)) break block2;
                    IFile file = (IFile)resource;
                    this.searchRefactorNode(file);
                    break block3;
                }
                if (!(resource instanceof IFolder)) break block4;
                IFolder folder = (IFolder)resource;
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource subFile = iResourceArray[n2];
                    subFile.accept((IResourceVisitor)this);
                    ++n2;
                }
                break block3;
            }
            if (!(resource instanceof IProject)) break block3;
            IProject project = (IProject)resource;
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n3 = 0;
            while (n3 < n) {
                IResource subFile = iResourceArray[n3];
                subFile.accept((IResourceVisitor)this);
                ++n3;
            }
        }
        return true;
    }

    private void searchRefactorNode(IFile file) {
        if (Arrays.asList(acceptFileExtensions).contains(file.getFileExtension().toLowerCase())) {
            this.refactorSearch.searchFile(file, this.refactorContextInfo);
        }
    }
}

