/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.model;

import com.aptana.core.resources.IUniformResource;
import com.aptana.core.resources.IUniformResourceMarker;
import com.aptana.js.debug.core.JSDebugPlugin;
import com.aptana.js.debug.core.internal.model.JSDebugExceptionBreakpoint;
import com.aptana.js.debug.core.internal.model.JSDebugLineBreakpoint;
import com.aptana.js.debug.core.internal.model.JSDebugSourceLink;
import com.aptana.js.debug.core.internal.model.JSDebugWatchpoint;
import com.aptana.js.debug.core.internal.model.JSInspectExpression;
import com.aptana.js.debug.core.model.IJSExceptionBreakpoint;
import com.aptana.js.debug.core.model.IJSInspectExpression;
import com.aptana.js.debug.core.model.IJSVariable;
import com.aptana.js.debug.core.model.ISourceLink;
import com.aptana.js.debug.core.model.provisional.IJSWatchpoint;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpressionResult;

public final class JSDebugModel {
    private JSDebugModel() {
    }

    public static String getModelIdentifier() {
        return "com.aptana.js.debug.core";
    }

    public static ILineBreakpoint createLineBreakpoint(IResource resource, int line) throws CoreException {
        return new JSDebugLineBreakpoint(resource, line);
    }

    public static ILineBreakpoint createLineBreakpoint(IResource resource, int line, Map<String, Object> attributes, boolean register) throws CoreException {
        return new JSDebugLineBreakpoint(resource, line, attributes, register);
    }

    public static ILineBreakpoint createLineBreakpoint(IUniformResource resource, int line) throws CoreException {
        return new JSDebugLineBreakpoint(resource, line);
    }

    public static ILineBreakpoint createLineBreakpoint(IUniformResource resource, int line, Map<String, Object> attributes, boolean register) throws CoreException {
        return new JSDebugLineBreakpoint(resource, line, attributes, register);
    }

    public static ILineBreakpoint createLineBreakpointForResource(Object resource, int line, Map<String, Object> attributes, boolean register) throws CoreException {
        if (resource instanceof IResource) {
            return JSDebugModel.createLineBreakpoint((IResource)resource, line, attributes, register);
        }
        if (resource instanceof IUniformResource) {
            return JSDebugModel.createLineBreakpoint((IUniformResource)resource, line, attributes, register);
        }
        if (resource instanceof String) {
            attributes.put("com.aptana.js.debug.core.breakpointLocation", (String)resource);
            return new JSDebugLineBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), line, attributes, register);
        }
        return null;
    }

    public static ILineBreakpoint lineBreakpointExists(IResource resource, int lineNumber) {
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JSDebugModel.getModelIdentifier());
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            try {
                if (breakpoint instanceof ILineBreakpoint && resource.equals((Object)breakpoint.getMarker().getResource()) && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber) {
                    return (ILineBreakpoint)breakpoint;
                }
            }
            catch (CoreException e) {
                JSDebugPlugin.log(e);
            }
            ++n2;
        }
        return null;
    }

    public static ILineBreakpoint lineBreakpointExists(IUniformResource resource, int lineNumber) {
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JSDebugModel.getModelIdentifier());
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            try {
                IMarker marker = breakpoint.getMarker();
                if (breakpoint instanceof ILineBreakpoint && marker instanceof IUniformResourceMarker && resource.equals(((IUniformResourceMarker)marker).getUniformResource()) && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber) {
                    return (ILineBreakpoint)breakpoint;
                }
            }
            catch (CoreException e) {
                JSDebugPlugin.log(e);
            }
            ++n2;
        }
        return null;
    }

    public static IJSExceptionBreakpoint createExceptionBreakpoint(IResource resource, String exceptionTypeName) throws CoreException {
        return new JSDebugExceptionBreakpoint(resource, exceptionTypeName);
    }

    public static IJSExceptionBreakpoint createExceptionBreakpoint(IUniformResource resource, String exceptionTypeName) throws CoreException {
        return new JSDebugExceptionBreakpoint(resource, exceptionTypeName);
    }

    public static IJSExceptionBreakpoint exceptionBreakpointExists(String exceptionTypeName) {
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JSDebugModel.getModelIdentifier());
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            try {
                if (breakpoint instanceof IJSExceptionBreakpoint && exceptionTypeName.equals(((IJSExceptionBreakpoint)breakpoint).getExceptionTypeName())) {
                    return (IJSExceptionBreakpoint)breakpoint;
                }
            }
            catch (CoreException e) {
                JSDebugPlugin.log(e);
            }
            ++n2;
        }
        return null;
    }

    public static IJSInspectExpression createInspectExpression(IWatchExpressionResult expressionResult) {
        return new JSInspectExpression(expressionResult);
    }

    public static IJSWatchpoint createWatchpoint(IJSVariable variable) throws CoreException {
        return new JSDebugWatchpoint(variable);
    }

    public static boolean watchpointExists(IVariable variable) {
        return false;
    }

    public static ISourceLink createSourceLink(URI location) {
        return new JSDebugSourceLink(location);
    }
}

