/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.model.xhr;

import com.aptana.js.debug.core.internal.model.xhr.XHRTransfer;
import com.aptana.js.debug.core.model.xhr.IXHRService;
import com.aptana.js.debug.core.model.xhr.IXHRTransfer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;

public class XHRService
implements IXHRService {
    private Map<String, IXHRTransfer> transfers = new LinkedHashMap<String, IXHRTransfer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openRequest(String rid, String method, String url, boolean auth) {
        XHRTransfer xhr = new XHRTransfer(method, url, auth);
        Map<String, IXHRTransfer> map = this.transfers;
        synchronized (map) {
            this.transfers.put(rid, xhr);
        }
        this.fireChangeEvent(null);
    }

    public void setRequestHeaders(String rid, String[][] headers) {
        XHRTransfer xhr = (XHRTransfer)this.transfers.get(rid);
        if (xhr != null) {
            String[][] stringArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                String[] header = stringArray[n2];
                xhr.addRequestHeader(header[0], header[1]);
                ++n2;
            }
            this.fireChangeEvent(xhr);
        }
    }

    public void setRequestBody(String rid, String body) {
        XHRTransfer xhr = (XHRTransfer)this.transfers.get(rid);
        if (xhr != null) {
            xhr.setRequestBody(body);
            this.fireChangeEvent(xhr);
        }
    }

    public void setResponseHeaders(String rid, String[][] headers) {
        XHRTransfer xhr = (XHRTransfer)this.transfers.get(rid);
        if (xhr != null) {
            String[][] stringArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                String[] header = stringArray[n2];
                xhr.addResponseHeader(header[0], header[1]);
                ++n2;
            }
            this.fireChangeEvent(xhr);
        }
    }

    public void setResponseBody(String rid, String body) {
        XHRTransfer xhr = (XHRTransfer)this.transfers.get(rid);
        if (xhr != null) {
            xhr.setResponseBody(body);
            this.fireChangeEvent(xhr);
        }
    }

    public void setResponseStatus(String rid, int code, String text) {
        XHRTransfer xhr = (XHRTransfer)this.transfers.get(rid);
        if (xhr != null) {
            xhr.setResponseStatus(code, text);
            this.fireChangeEvent(xhr);
        }
    }

    public void setError(String rid) {
        XHRTransfer xhr = (XHRTransfer)this.transfers.get(rid);
        if (xhr != null) {
            xhr.setError(true);
            this.fireChangeEvent(xhr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IXHRTransfer[] getTransfers() {
        Map<String, IXHRTransfer> map = this.transfers;
        synchronized (map) {
            return this.transfers.values().toArray(new IXHRTransfer[this.transfers.size()]);
        }
    }

    @Override
    public int getTransfersCount() {
        return this.transfers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IXHRTransfer xhr) {
        Map<String, IXHRTransfer> map = this.transfers;
        synchronized (map) {
            for (Map.Entry<String, IXHRTransfer> entry : this.transfers.entrySet()) {
                if (entry.getValue() != xhr) continue;
                this.transfers.remove(entry.getKey());
                break;
            }
        }
        this.fireChangeEvent(null);
    }

    private void fireChangeEvent(Object data) {
        DebugEvent event = new DebugEvent((Object)this, 16, 512);
        event.setData(data);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }
}

