/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.model;

import com.aptana.js.debug.core.JSDebugPlugin;
import com.aptana.js.debug.core.internal.Util;
import com.aptana.js.debug.core.internal.model.JSDebugElement;
import com.aptana.js.debug.core.internal.model.JSDebugImplicitBreakpoint;
import com.aptana.js.debug.core.internal.model.JSDebugStackFrame;
import com.aptana.js.debug.core.internal.model.JSDebugTarget;
import com.aptana.js.debug.core.internal.model.Messages;
import com.aptana.js.debug.core.model.IJSLineBreakpoint;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public class JSDebugThread
extends JSDebugElement
implements IThread {
    protected static final String SUSPENDED = "suspended";
    private static final String SUSPEND = "suspend";
    private static final String SUSPEND_V2 = "suspend*{0}";
    private static final String BREAKPOINT = "breakpoint";
    private static final String KEYWORD = "keyword";
    private static final String FIRST_LINE = "firstLine";
    private static final String EXCEPTION = "exception";
    private static final String WATCHPOINT = "watchpoint";
    protected static final String RESUMED = "resumed";
    private static final String STEP_INTO = "stepInto";
    private static final String STEP_INTO_V2 = "stepInto*{0}";
    private static final String STEP_OVER = "stepOver";
    private static final String STEP_OVER_V2 = "stepOver*{0}";
    private static final String RESUME = "resume";
    private static final String RESUME_V2 = "resume*{0}";
    private static final String ABORT = "abort";
    private static final String START = "start";
    private static final String STEP_RETURN = "stepReturn";
    private static final String STEP_RETURN_V2 = "stepReturn*{0}";
    private static final String STEP_TO_FRAME = "stepToFrame";
    private static final String STEP = "step";
    private static final String FRAMES = "frames";
    private static final String FRAMES_V2 = "frames*{0}";
    private static final String SUBARGS_SPLIT = "\\|";
    private static final String STEP_TO_FRAME_0 = "stepToFrame*{1,number,integer}";
    private static final String STEP_TO_FRAME_0_V2 = "stepToFrame*{0}*{1,number,integer}";
    private static final IStackFrame[] emptyStack = new IStackFrame[0];
    private static final IBreakpoint[] emptyBreakpoints = new IBreakpoint[0];
    private final String threadId;
    private final String label;
    private IStackFrame[] stackFrames = emptyStack;
    private IBreakpoint[] breakpoints = emptyBreakpoints;
    private State runningState = State.STARTING;
    private boolean validateFrames = false;

    public JSDebugThread(IDebugTarget target, String threadId, String label) {
        super(target);
        this.threadId = threadId;
        this.label = label;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (!this.isSuspended()) {
            return emptyStack;
        }
        this.getStackFrames0();
        return this.isSuspended() && this.stackFrames != null ? this.stackFrames : emptyStack;
    }

    public boolean hasStackFrames() throws DebugException {
        if (!this.isSuspended()) {
            return false;
        }
        this.getStackFrames0();
        return this.stackFrames != null && this.stackFrames.length > 0;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        if (!this.isSuspended()) {
            return null;
        }
        this.getStackFrames0();
        return this.stackFrames != null && this.stackFrames.length > 0 ? this.stackFrames[0] : null;
    }

    public String getName() throws DebugException {
        String name = this.label != null ? this.label : (this.threadId == "0" ? Messages.JSDebugThread_main_label : this.threadId);
        return MessageFormat.format(Messages.JSDebugThread_Thread_Label, name, this.runningState == State.SUSPENDING ? MessageFormat.format(" ({0})", Messages.JSDebugThread_Suspending) : "");
    }

    public IBreakpoint[] getBreakpoints() {
        return this.isSuspended() && this.breakpoints != null ? this.breakpoints : emptyBreakpoints;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended() && this.runningState != State.STARTING;
    }

    public boolean isSuspended() {
        return this.runningState == State.SUSPENDED;
    }

    public void resume() throws DebugException {
        if (this.runningState != State.SUSPENDED) {
            return;
        }
        this.runningState = State.STEPPPING;
        this.fireChangeEvent(256);
        JSDebugTarget target = this.getJSDebugTarget();
        String command = MessageFormat.format(target.getProtocolVersion() >= 2 ? RESUME_V2 : RESUME, this.threadId);
        target.getConnection().sendCommand(command);
    }

    public void suspend() throws DebugException {
        if (this.runningState != State.RUNNING) {
            return;
        }
        this.runningState = State.SUSPENDING;
        this.fireChangeEvent(256);
        JSDebugTarget target = this.getJSDebugTarget();
        String command = MessageFormat.format(target.getProtocolVersion() >= 2 ? SUSPEND_V2 : SUSPEND, this.threadId);
        target.getConnection().sendCommand(command);
    }

    public boolean canStepInto() {
        return this.isSuspended() && !this.isStepping();
    }

    public boolean canStepOver() {
        return this.isSuspended() && !this.isStepping();
    }

    public boolean canStepReturn() {
        return this.isSuspended() && !this.isStepping();
    }

    public boolean isStepping() {
        return this.runningState == State.STEPPPING;
    }

    public void stepInto() throws DebugException {
        if (this.runningState != State.SUSPENDED) {
            return;
        }
        this.runningState = State.STEPPPING;
        this.fireChangeEvent(256);
        JSDebugTarget target = this.getJSDebugTarget();
        String command = MessageFormat.format(target.getProtocolVersion() >= 2 ? STEP_INTO_V2 : STEP_INTO, this.threadId);
        target.getConnection().sendCommand(command);
    }

    public void stepOver() throws DebugException {
        if (this.runningState != State.SUSPENDED) {
            return;
        }
        this.runningState = State.STEPPPING;
        this.fireChangeEvent(256);
        JSDebugTarget target = this.getJSDebugTarget();
        String command = MessageFormat.format(target.getProtocolVersion() >= 2 ? STEP_OVER_V2 : STEP_OVER, this.threadId);
        target.getConnection().sendCommand(command);
    }

    public void stepReturn() throws DebugException {
        if (this.runningState != State.SUSPENDED) {
            return;
        }
        this.runningState = State.STEPPPING;
        this.fireChangeEvent(256);
        JSDebugTarget target = this.getJSDebugTarget();
        String command = MessageFormat.format(target.getProtocolVersion() >= 2 ? STEP_RETURN_V2 : STEP_RETURN, this.threadId);
        target.getConnection().sendCommand(command);
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    void handleMessage(String[] args) {
        String action = args[0];
        int details = 0;
        if (SUSPENDED.equals(action)) {
            block28: {
                this.invalidateStackFrames();
                this.runningState = State.SUSPENDED;
                this.breakpoints = null;
                String reason = args[1];
                if (BREAKPOINT.equals(reason) || KEYWORD.equals(reason) || FIRST_LINE.equals(reason) || EXCEPTION.equals(reason) || WATCHPOINT.equals(reason)) {
                    details = 16;
                    this.stackFrames = null;
                    URI sourceFile = this.getJSDebugTarget().resolveSourceFile(Util.decodeData(args[2]));
                    try {
                        if (BREAKPOINT.equals(reason)) {
                            this.breakpointHit(sourceFile, Integer.parseInt(args[3]));
                            break block28;
                        }
                        JSDebugImplicitBreakpoint.Type type = null;
                        if (KEYWORD.equals(reason)) {
                            type = JSDebugImplicitBreakpoint.Type.DEBUGGER_KEYWORD;
                        } else if (FIRST_LINE.equals(reason)) {
                            type = JSDebugImplicitBreakpoint.Type.FIRST_LINE;
                        } else if (EXCEPTION.equals(reason)) {
                            type = JSDebugImplicitBreakpoint.Type.EXCEPTION;
                        } else if (WATCHPOINT.equals(reason)) {
                            type = JSDebugImplicitBreakpoint.Type.WATCHPOINT;
                        }
                        this.implicitBreakpointHit(sourceFile, Integer.parseInt(args[3]), type);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (reason.startsWith(STEP)) {
                    details = 8;
                } else {
                    details = 32;
                    this.stackFrames = null;
                }
            }
            this.fireSuspendEvent(details);
            this.fireChangeEvent(256);
        } else if (RESUMED.equals(action)) {
            String reason = args[1];
            if (STEP_INTO.equals(reason)) {
                details = 1;
            } else if (STEP_OVER.equals(reason)) {
                details = 2;
            } else if (STEP_RETURN.equals(reason) || STEP_TO_FRAME.equals(reason)) {
                details = 4;
            } else if (RESUME.equals(reason)) {
                details = 32;
                this.runningState = State.RUNNING;
            } else if (ABORT.equals(reason) || START.equals(reason)) {
                details = 0;
                this.runningState = State.RUNNING;
            } else {
                this.runningState = State.RUNNING;
            }
            if (reason.startsWith(STEP) && this.stackFrames != null && this.stackFrames.length == 1) {
                details = 32;
            }
            this.fireChangeEvent(256);
            this.fireResumeEvent(details);
        }
    }

    void stepToFrame(IStackFrame frame) throws DebugException {
        if (this.runningState != State.SUSPENDED) {
            return;
        }
        int targetFrameId = ((JSDebugStackFrame)frame).getFrameId();
        this.runningState = State.STEPPPING;
        this.fireChangeEvent(256);
        JSDebugTarget target = this.getJSDebugTarget();
        String command = MessageFormat.format(target.getProtocolVersion() >= 2 ? STEP_TO_FRAME_0_V2 : STEP_TO_FRAME_0, this.threadId, targetFrameId);
        target.getConnection().sendCommand(command);
    }

    boolean isInSuspendState() {
        return this.runningState == State.SUSPENDED || this.runningState == State.SUSPENDING;
    }

    String getThreadId() {
        return this.threadId;
    }

    private JSDebugTarget getJSDebugTarget() {
        return (JSDebugTarget)this.getDebugTarget();
    }

    private void breakpointHit(URI filename, int lineNumber) {
        IBreakpoint[] iBreakpointArray;
        IBreakpoint breakpoint = this.getJSDebugTarget().findBreakpointAt(filename, lineNumber);
        if (breakpoint != null && breakpoint instanceof IJSLineBreakpoint) {
            try {
                if (((IJSLineBreakpoint)breakpoint).getHitCount() > 0) {
                    breakpoint.setEnabled(false);
                }
            }
            catch (CoreException e) {
                JSDebugPlugin.log(e);
            }
        }
        if (breakpoint != null) {
            IBreakpoint[] iBreakpointArray2 = new IBreakpoint[1];
            iBreakpointArray = iBreakpointArray2;
            iBreakpointArray2[0] = breakpoint;
        } else {
            iBreakpointArray = null;
        }
        this.breakpoints = iBreakpointArray;
    }

    private void implicitBreakpointHit(URI filename, int line, JSDebugImplicitBreakpoint.Type type) {
        this.breakpoints = new IBreakpoint[]{new JSDebugImplicitBreakpoint(filename, line, type)};
    }

    private synchronized void getStackFrames0() throws DebugException {
        if (!this.validateFrames && this.stackFrames != null) {
            return;
        }
        JSDebugTarget target = this.getJSDebugTarget();
        String command = MessageFormat.format(target.getProtocolVersion() >= 2 ? FRAMES_V2 : FRAMES, this.threadId);
        String[] args = target.getConnection().sendCommandAndWait(command);
        if (args != null) {
            Vector<JSDebugStackFrame> frames = new Vector<JSDebugStackFrame>();
            int frameIndex = this.stackFrames != null ? this.stackFrames.length - 1 : -1;
            int i = args.length - 1;
            while (i >= 1) {
                int j = 0;
                String[] subargs = args[i].split(SUBARGS_SPLIT);
                int depth = Integer.parseInt(subargs[j++]);
                String function = Util.decodeData(subargs[j++]);
                String arguments = Util.decodeData(subargs[j++]);
                function = function.length() == 0 ? MessageFormat.format("[{0}]", i == args.length - 1 ? Messages.JSDebugTarget_TopLevelScript : Messages.JSDebugTarget_EvalScript) : String.valueOf(function) + MessageFormat.format("({0})", arguments);
                URI sourceFile = target.resolveSourceFile(Util.decodeData(subargs[j++]));
                int sourceLine = Integer.parseInt(subargs[j++]);
                int n = ++j;
                long pc = Long.parseLong(subargs[n]);
                int n2 = ++j;
                ++j;
                int scriptTag = Integer.parseInt(subargs[n2]);
                JSDebugStackFrame frame = null;
                if (frameIndex >= 0) {
                    JSDebugStackFrame oldFrame = (JSDebugStackFrame)this.stackFrames[frameIndex];
                    if (oldFrame.scriptTag == scriptTag && oldFrame.pc == pc) {
                        oldFrame.invalidate(depth, sourceLine, pc);
                        frame = oldFrame;
                        --frameIndex;
                    } else if (oldFrame.scriptTag == scriptTag) {
                        oldFrame.invalidate(depth, sourceLine, pc);
                        frameIndex = -1;
                    } else {
                        frameIndex = -1;
                    }
                }
                if (frame == null) {
                    frame = new JSDebugStackFrame(target, this, depth, function, sourceFile, sourceLine, pc, scriptTag);
                }
                frames.add(0, frame);
                --i;
            }
            this.stackFrames = frames.toArray(new IStackFrame[frames.size()]);
            this.validateFrames = false;
        }
    }

    private synchronized void invalidateStackFrames() {
        if (this.stackFrames != null) {
            IStackFrame[] iStackFrameArray = this.stackFrames;
            int n = this.stackFrames.length;
            int n2 = 0;
            while (n2 < n) {
                IStackFrame stackFrame = iStackFrameArray[n2];
                ((JSDebugStackFrame)stackFrame).invalidate();
                ++n2;
            }
        }
        this.validateFrames = true;
    }

    private static enum State {
        STARTING,
        RUNNING,
        SUSPENDED,
        SUSPENDING,
        STEPPPING;

    }
}

