/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.model;

import com.aptana.core.IURIMapper;
import com.aptana.core.io.efs.EFSUtils;
import com.aptana.core.resources.IUniformResource;
import com.aptana.core.resources.IUniformResourceMarker;
import com.aptana.core.util.EclipseUtil;
import com.aptana.debug.core.DebugCorePlugin;
import com.aptana.debug.core.DetailFormatter;
import com.aptana.debug.core.IDetailFormattersChangeListener;
import com.aptana.debug.core.sourcelookup.IFileContentRetriever;
import com.aptana.js.debug.core.JSDebugPlugin;
import com.aptana.js.debug.core.internal.Util;
import com.aptana.js.debug.core.internal.model.DebugConnection;
import com.aptana.js.debug.core.internal.model.JSDebugElement;
import com.aptana.js.debug.core.internal.model.JSDebugProcess;
import com.aptana.js.debug.core.internal.model.JSDebugScriptElement;
import com.aptana.js.debug.core.internal.model.JSDebugStackFrame;
import com.aptana.js.debug.core.internal.model.JSDebugThread;
import com.aptana.js.debug.core.internal.model.JSDebugTopScriptElement;
import com.aptana.js.debug.core.internal.model.JSDebugValue;
import com.aptana.js.debug.core.internal.model.JSDebugVariable;
import com.aptana.js.debug.core.internal.model.Messages;
import com.aptana.js.debug.core.internal.model.xhr.XHRService;
import com.aptana.js.debug.core.model.IJSDebugTarget;
import com.aptana.js.debug.core.model.IJSExceptionBreakpoint;
import com.aptana.js.debug.core.model.IJSLineBreakpoint;
import com.aptana.js.debug.core.model.IJSScriptElement;
import com.aptana.js.debug.core.model.JSDebugModel;
import com.aptana.js.debug.core.model.provisional.IJSWatchpoint;
import com.aptana.js.debug.core.model.xhr.IXHRService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;

public class JSDebugTarget
extends JSDebugElement
implements IJSDebugTarget,
IBreakpointManagerListener,
IDetailFormattersChangeListener {
    private static final String UPDATE = "update";
    private static final String VERSION = "version";
    private static final String JAVASCRIPT = "javascript";
    private static final String APP = "app";
    private static final String JAVASCRIPT_SCHEME = "javascript:";
    private static final String OPENED = "opened";
    private static final String HTTP = "http";
    private static final String FILE = "file";
    private static final String EXCEPTION_0_1 = "exception*{0}*{1}";
    private static final String BREAKPOINT_0_1_2_3 = "breakpoint*{0}*{1}*{2}{3}";
    private static final String WATCHPOINT_0_1_2 = "watchpoint*{0}*{1}*{2}";
    private static final String DETAILS_0 = "details*{1}";
    private static final String DETAILS_0_V2 = "details*{0}*{1}";
    private static final String SET_VALUE_0_1 = "setValue*{1}*{2}";
    private static final String SET_VALUE_0_1_V2 = "setValue*{0}*{1}*{2}";
    private static final String EVAL_0 = "eval[{0}]";
    private static final String EVAL_0_1 = "eval*{1}*{2}";
    private static final String EVAL_0_1_V2 = "eval*{0}*{1}*{2}";
    private static final String RESULT = "result";
    private static final String FRAME_0 = "frame[{0,number,integer}]";
    private static final String VARIABLES_0 = "variables*{1}";
    private static final String VARIABLES_0_V2 = "variables*{0}*{1}";
    private static final String OPEN_URL_0 = "openUrl*{0}";
    private static final String OPTION_0_1 = "option*{0}*{1}";
    private static final String ENABLE = "enable";
    private static final String STEP_FILTERS = "stepFilters";
    private static final String MONITOR_XHR = "monitorXHR";
    private static final String DETAIL_FORMATTERS = "detailFormatters";
    private static final String DISABLE = "disable";
    private static final String CHANGE = "change";
    private static final String REMOVE = "remove";
    private static final String CREATE = "create";
    private static final String RESOLVED = "resolved";
    private static final String DESTROYED = "destroyed";
    private static final String ARGS_SPLIT = "\\*";
    private static final String SUBARGS_SPLIT = "\\|";
    private static final String CREATED = "created";
    private static final String TERMINATE = "terminate";
    private static final String SUSPEND = "suspend";
    private static final String ERROR = "error";
    private static final String COMPLETED = "completed";
    private static final String LOADED = "loaded";
    private static final String SEND = "send";
    private static final String HEADERS = "headers";
    private static final String AUTH = "auth";
    private static final String OPEN = "open";
    private static final String START = "start";
    private static final String LOAD = "load";
    private static final String EXCEPTION = "exception";
    private static final String ERR = "err";
    private static final String WARN = "warn";
    private static final String TRACE = "trace";
    private static final String SRC = "src";
    private static final String BREAKPOINT = "breakpoint";
    private static final String SCRIPTS = "scripts";
    private static final String THREADS = "threads";
    private static final String CLIENT = "client";
    private static final String XHR = "xhr";
    private static final String LOG = "log";
    private static final String SUCCESS = "success";
    private static final String GET_SOURCE_0 = "getSource*{0}";
    private static final String STEP_FILTERS_ENABLED2 = "stepFiltersEnabled";
    private static final String BYPASS_CONSTRUCTORS = "bypassConstructors";
    private static final String SUSPEND_ON_KEYWORDS = "suspendOnKeywords";
    private static final String SUSPEND_ON_ERRORS = "suspendOnErrors";
    private static final String SUSPEND_ON_EXCEPTIONS = "suspendOnExceptions";
    private static final String SUSPEND_ON_FIRST_LINE = "suspendOnFirstLine";
    private static final char VARIABLE_FLAG_WRITABLE = 'w';
    private static final char VARIABLE_FLAG_CONST = 'c';
    private static final char VARIABLE_FLAG_LOCAL = 'l';
    private static final char VARIABLE_FLAG_ARG = 'a';
    private static final char VARIABLE_FLAG_EXCEPTION = 'e';
    private static final char WATCHPOINT_FLAG_READ = 'r';
    private static final char WATCHPOINT_FLAG_WRITE = 'w';
    private static final int PROTOCOL_VERSION_MIN = 0;
    private static final int PROTOCOL_VERSION_MAX = 2;
    protected static final String DEFAULT_THREAD_ID = "0";
    private static final int FLAG_STEP_FILTERS_ENABLED = 1;
    private static final int FLAG_FILTER_CONSTRUCTORS = 2;
    private static final int XOR_MASK = 4095;
    private static boolean checkUpdate = true;
    private DebugConnection connection;
    private int stepFilterMask = 0;
    private String[] stepFilters = null;
    private ILaunch launch;
    private String label;
    private IProcess process;
    private IURIMapper uriMapper;
    private Map<String, JSDebugThread> threads = new HashMap<String, JSDebugThread>();
    private IFileContentRetriever fileContentRetriever;
    private XHRService xhrService;
    private Map<URI, IJSScriptElement> topScriptElements = new HashMap<URI, IJSScriptElement>();
    private Map<Integer, IJSScriptElement> scripts = new HashMap<Integer, IJSScriptElement>();
    private List<IBreakpoint> runToLineBreakpoints = new ArrayList<IBreakpoint>();
    private Map<String, URI> sourceResolveCache = new HashMap<String, URI>(64);
    private URI mainFile = null;
    private IBreakpoint skipOperationOnBreakpoint = null;
    private boolean ignoreBreakpointCreation = false;
    private boolean contentChanged = false;
    private int protocolVersion;
    private Job updateContentJob = new Job("Debugger Content Update"){
        {
            this.setPriority(10);
            EclipseUtil.setSystemForJob((Job)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (JSDebugTarget.this.connection == null || !JSDebugTarget.this.connection.isConnected()) {
                return Status.OK_STATUS;
            }
            try {
                boolean changed = false;
                1 var3_3 = this;
                synchronized (var3_3) {
                    if (JSDebugTarget.this.contentChanged) {
                        changed = true;
                        JSDebugTarget.this.contentChanged = false;
                    }
                }
                if (changed) {
                    JSDebugTarget.this.fireChangeEvent(512);
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                this.schedule(1000L);
            }
        }
    };

    public JSDebugTarget(ILaunch launch, IProcess process, IURIMapper uriMapper, DebugConnection connection, boolean debugMode) throws CoreException {
        this(launch, null, process, uriMapper, connection, debugMode);
    }

    public JSDebugTarget(ILaunch launch, String label, IProcess process, IURIMapper uriMapper, DebugConnection connection, boolean debugMode) throws CoreException {
        super(null);
        this.launch = launch;
        this.label = label;
        this.process = process;
        this.connection = connection;
        this.uriMapper = uriMapper;
        try {
            if (debugMode) {
                launch.addDebugTarget((IDebugTarget)this);
            } else if (process instanceof JSDebugProcess) {
                ((JSDebugProcess)process).setDebugTarget(this);
            }
            this.init(debugMode);
        }
        catch (CoreException e) {
            this.shutdown();
            throw e;
        }
        catch (Exception e) {
            this.shutdown();
            this.throwDebugException(e);
        }
    }

    DebugConnection getConnection() {
        return this.connection;
    }

    int getProtocolVersion() {
        return this.protocolVersion;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IFileContentRetriever.class) {
            return this.getFileContentRetriever();
        }
        if (adapter == IXHRService.class) {
            return this.xhrService;
        }
        return super.getAdapter(adapter);
    }

    private IFileContentRetriever getFileContentRetriever() {
        if (this.fileContentRetriever == null) {
            this.fileContentRetriever = new IFileContentRetriever(){

                public InputStream getContents(URI uri) throws CoreException {
                    String[] args = JSDebugTarget.this.connection.sendCommandAndWait(MessageFormat.format(JSDebugTarget.GET_SOURCE_0, Util.encodeData(uri.toString())));
                    if (args != null && JSDebugTarget.SUCCESS.equals(args[1])) {
                        return new ByteArrayInputStream(Util.decodeData(args[2]).getBytes());
                    }
                    return null;
                }
            };
        }
        return this.fileContentRetriever;
    }

    private void handleLog(String[] args) {
        String log = args[1];
        String text = Util.decodeData(args[2]);
        if (args.length >= 4) {
            StringBuffer sb = new StringBuffer(text);
            String type = args[3];
            if (SRC.equals(type) && args.length >= 6) {
                URI fileName = this.resolveSourceFile(Util.decodeData(args[4]));
                sb.append(MessageFormat.format(" ({0}:{1})", fileName.getPath(), args[5]));
            } else if (TRACE.equals(type)) {
                sb.append('\n');
                int i = 4;
                while (i < args.length) {
                    String[] subargs = args[i].split(SUBARGS_SPLIT);
                    if (subargs[0].length() == 0) {
                        subargs[0] = MessageFormat.format("[{0}]", i == args.length - 1 ? Messages.JSDebugTarget_TopLevelScript : Messages.JSDebugTarget_EvalScript);
                    }
                    URI fileName = this.resolveSourceFile(Util.decodeData(subargs[2]));
                    sb.append(MessageFormat.format("\tat {0}({1}) ({2}:{3})\n", Util.decodeData(subargs[0]), Util.decodeData(subargs[1]), fileName.getPath(), subargs[3]));
                    ++i;
                }
            }
            text = sb.toString();
        }
        if (!text.endsWith("\n")) {
            text = String.valueOf(text) + "\n";
        }
        try {
            if (ERR.equals(log) || EXCEPTION.equals(log)) {
                OutputStream err = ((JSDebugProcess)this.process).getStream("ID_STANDARD_ERROR_STREAM");
                if (err != null) {
                    err.write(text.getBytes());
                }
            } else {
                OutputStream out;
                if (WARN.equals(log)) {
                    log = "ID_WARNING_STREAM";
                }
                if ((out = ((JSDebugProcess)this.process).getStream(log)) == null) {
                    out = ((JSDebugProcess)this.process).getStream("ID_STANDARD_OUTPUT_STREAM");
                }
                if (out != null) {
                    out.write(text.getBytes());
                }
            }
        }
        catch (IOException e) {
            JSDebugPlugin.log(e);
        }
    }

    private void handleXHR(String[] args) {
        String cmd;
        int j = 1;
        String rid = args[j++];
        if (START.equals(cmd = args[j++])) {
            String method = args[j++];
            String url = Util.decodeData(args[j++]);
            String[][] headers = JSDebugTarget.getXHRHeaders(Util.decodeData(args[j++]));
            String body = Util.decodeData(args[j++]);
            this.xhrService.openRequest(rid, method, url, false);
            this.xhrService.setRequestHeaders(rid, headers);
            this.xhrService.setRequestBody(rid, body);
        } else if (LOAD.equals(cmd)) {
            int statusCode = -1;
            try {
                statusCode = Integer.parseInt(args[j++]);
            }
            catch (NumberFormatException numberFormatException) {}
            String statusText = Util.decodeData(args[j++]);
            String[][] headers = JSDebugTarget.getXHRHeaders(Util.decodeData(args[j++]));
            String response = Util.decodeData(args[j++]);
            this.xhrService.setResponseStatus(rid, statusCode, statusText);
            this.xhrService.setResponseHeaders(rid, headers);
            this.xhrService.setResponseBody(rid, response);
        } else if (OPEN.equals(cmd)) {
            String method = args[j++];
            String url = Util.decodeData(args[j++]);
            String auth = args[j++];
            this.xhrService.openRequest(rid, method, url, AUTH.equals(auth));
        } else if (HEADERS.equals(cmd)) {
            String[][] headers = JSDebugTarget.getXHRHeaders(Util.decodeData(args[j++]));
            this.xhrService.setRequestHeaders(rid, headers);
        } else if (SEND.equals(cmd)) {
            String body = Util.decodeData(args[j++]);
            this.xhrService.setRequestBody(rid, body);
        } else if (LOADED.equals(cmd)) {
            int statusCode = -1;
            try {
                statusCode = Integer.parseInt(args[j++]);
            }
            catch (NumberFormatException numberFormatException) {}
            String statusText = Util.decodeData(args[j++]);
            String[][] headers = JSDebugTarget.getXHRHeaders(Util.decodeData(args[j++]));
            this.xhrService.setResponseHeaders(rid, headers);
            this.xhrService.setResponseStatus(rid, statusCode, statusText);
        } else if (COMPLETED.equals(cmd)) {
            String response = Util.decodeData(args[j++]);
            this.xhrService.setResponseBody(rid, response);
        } else if (ERROR.equals(cmd)) {
            this.xhrService.setError(rid);
        }
    }

    private static String[][] getXHRHeaders(String string) {
        String[] headers = string.split("\\n");
        ArrayList<String[]> list = new ArrayList<String[]>(headers.length);
        String[] stringArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            String header = stringArray[n2];
            String value = "";
            int pos = header.indexOf(": ");
            if (pos != -1) {
                value = header.substring(pos + 2);
                header = header.substring(0, pos);
            }
            list.add(new String[]{header, value});
            ++n2;
        }
        return (String[][])list.toArray((T[])new String[list.size()][]);
    }

    private void handleClientAction(String[] args) {
        URI fileName;
        String action;
        int j = 1;
        if (SUSPEND.equals(action = args[j++])) {
            try {
                if (this.canSuspend()) {
                    this.suspend();
                }
            }
            catch (DebugException debugException) {}
        } else if (TERMINATE.equals(action)) {
            try {
                if (this.canTerminate()) {
                    this.terminate();
                }
            }
            catch (DebugException debugException) {}
        } else if (OPEN.equals(action) && (fileName = this.resolveSourceFile(Util.decodeData(args[j++]))) != null) {
            Object sourceElement = null;
            ISourceLocator locator = this.launch.getSourceLocator();
            if (locator instanceof ISourceLookupDirector) {
                sourceElement = ((ISourceLookupDirector)locator).getSourceElement((Object)fileName);
            }
            if (sourceElement != null) {
                DebugCorePlugin.openInEditor(sourceElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleScripts(String[] args) {
        block23: {
            String action;
            block22: {
                action = args[1];
                if (CREATED.equals(action)) {
                    int i22 = 2;
                    while (i22 < args.length) {
                        int j = 0;
                        String[] subargs = args[i22].split(SUBARGS_SPLIT);
                        if (subargs.length < 5) {
                            JSDebugPlugin.log(MessageFormat.format("Missing fields in response: <{0}>", args[i22]));
                        } else {
                            int scriptTag = -1;
                            try {
                                scriptTag = Integer.parseInt(subargs[j++]);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            String source = Util.decodeData(subargs[j++]);
                            if (source.length() != 0 && !"[Eval-script]".equals(source) && !source.startsWith(JAVASCRIPT_SCHEME)) {
                                URI fileName = this.resolveSourceFile(source);
                                String scriptName = Util.decodeData(subargs[j++]);
                                int baseLine = -1;
                                int lineExtent = -1;
                                try {
                                    baseLine = Integer.parseInt(subargs[j++]);
                                    lineExtent = Integer.parseInt(subargs[j++]);
                                }
                                catch (NumberFormatException numberFormatException) {}
                                if (scriptName.length() != 0) {
                                    JSDebugScriptElement topScriptElement = (JSDebugScriptElement)this.topScriptElements.get(fileName);
                                    if (topScriptElement == null) {
                                        topScriptElement = new JSDebugTopScriptElement(this, fileName.getPath(), fileName);
                                        this.topScriptElements.put(fileName, topScriptElement);
                                    }
                                    JSDebugScriptElement scriptElement = new JSDebugScriptElement(this, scriptName, baseLine, lineExtent);
                                    topScriptElement.insertElement(scriptElement);
                                    if (scriptTag > 0) {
                                        this.scripts.put(scriptTag, scriptElement);
                                    }
                                }
                            }
                        }
                        ++i22;
                    }
                    Job i22 = this.updateContentJob;
                    synchronized (i22) {
                        this.contentChanged = true;
                    }
                }
                if (!DESTROYED.equals(action)) break block22;
                int j = 0;
                String[] subargs = args[2].split(SUBARGS_SPLIT);
                int scriptTag = -1;
                try {
                    scriptTag = Integer.parseInt(subargs[j++]);
                }
                catch (NumberFormatException numberFormatException) {}
                URI fileName = this.resolveSourceFile(Util.decodeData(subargs[j++]));
                JSDebugScriptElement topScriptElement = (JSDebugScriptElement)this.topScriptElements.get(fileName);
                if (scriptTag <= 0) break block23;
                JSDebugScriptElement scriptElement = (JSDebugScriptElement)this.scripts.remove(scriptTag);
                if (topScriptElement == null || scriptElement == null) break block23;
                topScriptElement.removeElement(scriptElement);
                break block23;
            }
            if (RESOLVED.equals(action)) {
                int i = 2;
                while (i < args.length) {
                    JSDebugScriptElement scriptElement;
                    int j = 0;
                    String[] subargs = args[i].split(SUBARGS_SPLIT);
                    int scriptTag = -1;
                    try {
                        scriptTag = Integer.parseInt(subargs[j++]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    String scriptName = Util.decodeData(subargs[j++]);
                    if (scriptTag >= 0 && scriptName.length() != 0 && (scriptElement = (JSDebugScriptElement)this.scripts.get(scriptTag)) != null) {
                        scriptElement.setName(scriptName);
                        scriptElement.fireChangeEvent(256);
                    }
                    ++i;
                }
            }
        }
    }

    private void handleThreads(String[] args) {
        JSDebugThread thread;
        String action = args[1];
        String threadId = args[2];
        if (CREATED.equals(action)) {
            if (threadId.length() > 0 && !this.threads.containsKey(threadId)) {
                String label = args[3];
                JSDebugThread thread2 = new JSDebugThread(this, threadId, label.length() > 0 ? label : null);
                this.threads.put(threadId, thread2);
                thread2.fireCreationEvent();
                this.fireChangeEvent(512);
            }
        } else if (DESTROYED.equals(action) && (thread = this.threads.get(threadId)) != null) {
            this.threads.remove(threadId);
            thread.fireTerminateEvent();
            this.fireChangeEvent(512);
        }
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public IThread[] getThreads() throws DebugException {
        return this.threads.values().toArray(new IThread[this.threads.size()]);
    }

    public boolean hasThreads() throws DebugException {
        return !this.threads.isEmpty();
    }

    public String getName() throws DebugException {
        return this.label != null ? this.label : Messages.JSDebugTarget_JSDebugger;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint.getModelIdentifier().equals(this.getModelIdentifier());
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.connection.isTerminated();
    }

    public void terminate() throws DebugException {
        if (this.isTerminated()) {
            return;
        }
        this.connection.sendCommand(TERMINATE);
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        for (JSDebugThread thread : this.threads.values()) {
            if (thread.isInSuspendState()) continue;
            return false;
        }
        return !this.threads.isEmpty();
    }

    public void resume() throws DebugException {
        for (IThread iThread : this.threads.values()) {
            iThread.resume();
        }
        this.fireResumeEvent(32);
    }

    public void suspend() throws DebugException {
        if (this.isDisconnected()) {
            return;
        }
        for (IThread iThread : this.threads.values()) {
            iThread.suspend();
        }
        this.fireSuspendEvent(32);
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (this.supportsBreakpoint(breakpoint) && breakpoint instanceof IJSLineBreakpoint) {
            try {
                if (((IJSLineBreakpoint)breakpoint).isRunToLine()) {
                    this.runToLineBreakpoints.add(breakpoint);
                }
            }
            catch (CoreException coreException) {}
        }
        this.handleBreakpoint(breakpoint, CREATE);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint) && breakpoint instanceof IJSLineBreakpoint) {
            try {
                if (((IJSLineBreakpoint)breakpoint).isRunToLine()) {
                    this.runToLineBreakpoints.remove(breakpoint);
                }
            }
            catch (CoreException coreException) {}
        }
        this.handleBreakpoint(breakpoint, REMOVE);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.handleBreakpoint(breakpoint, CHANGE);
    }

    public boolean canDisconnect() {
        return !this.isDisconnected();
    }

    public void disconnect() throws DebugException {
        this.connection.sendCommandAndWait(DISABLE);
        this.stopDebug();
    }

    public boolean isDisconnected() {
        return !this.connection.isConnected();
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public boolean isFilterConstructors() {
        return (this.stepFilterMask & 2) > 0;
    }

    @Override
    public void setFilterConstructors(boolean filter) {
        this.stepFilterMask = filter ? (this.stepFilterMask |= 2) : (this.stepFilterMask &= 0xFFD);
    }

    public boolean isStepFiltersEnabled() {
        return (this.stepFilterMask & 1) > 0;
    }

    public void setStepFiltersEnabled(boolean enabled) {
        this.stepFilterMask = enabled ? (this.stepFilterMask |= 1) : (this.stepFilterMask &= 0xFFE);
        try {
            this.setOption(STEP_FILTERS_ENABLED2, Boolean.toString(this.isStepFiltersEnabled()));
        }
        catch (DebugException e) {
            JSDebugPlugin.log(e);
        }
    }

    public boolean supportsStepFilters() {
        return !this.isTerminated() && !this.isDisconnected();
    }

    @Override
    public String[] getStepFilters() {
        return this.stepFilters;
    }

    @Override
    public void setStepFilters(String[] list) {
        this.stepFilters = list;
    }

    @Override
    public String getAttribute(String key) {
        return this.getLaunch().getAttribute(key);
    }

    @Override
    public void setAttribute(String key, String value) {
        this.getLaunch().setAttribute(key, value);
        try {
            this.handleAttribute(key);
        }
        catch (DebugException e) {
            JSDebugPlugin.log(e);
        }
    }

    private void handleAttribute(String key) throws DebugException {
        String value = this.getAttribute(key);
        boolean boolValue = Boolean.valueOf(value);
        if (SUSPEND_ON_FIRST_LINE.equals(key)) {
            this.setOption(SUSPEND_ON_FIRST_LINE, Boolean.toString(boolValue));
        } else if (SUSPEND_ON_EXCEPTIONS.equals(key)) {
            this.setOption(SUSPEND_ON_EXCEPTIONS, Boolean.toString(boolValue));
        } else if (SUSPEND_ON_ERRORS.equals(key)) {
            this.setOption(SUSPEND_ON_ERRORS, Boolean.toString(boolValue));
        } else if ("suspendOnDebuggerKeywords".equals(key)) {
            this.setOption(SUSPEND_ON_KEYWORDS, Boolean.toString(boolValue));
        }
    }

    public void detailFormattersChanged() {
        try {
            this.handleDetailFormattersChange();
        }
        catch (DebugException e) {
            JSDebugPlugin.log(e);
        }
    }

    private void handleDetailFormattersChange() throws DebugException {
        StringBuffer sb = new StringBuffer(DETAIL_FORMATTERS);
        for (DetailFormatter detailFormatter : JSDebugPlugin.getDefault().getDebugOptionsManager().getDetailFormatters()) {
            if (!detailFormatter.isEnabled()) continue;
            sb.append(MessageFormat.format("*{0}|{1}", detailFormatter.getTypeName(), Util.encodeData(detailFormatter.getSnippet())));
        }
        this.connection.sendCommandAndWait(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(boolean debugMode) throws CoreException {
        JSDebugTarget jSDebugTarget = this;
        synchronized (jSDebugTarget) {
            this.connection.start(new DebugConnectionHandler());
            this.updateContentJob.schedule();
            this.checkVersion();
        }
        this.xhrService = new XHRService();
        this.setOption(MONITOR_XHR, Boolean.toString(true));
        if (this.process instanceof JSDebugProcess) {
            ((JSDebugProcess)this.process).setXHRService(this.xhrService);
        }
        if (debugMode) {
            this.fireCreationEvent();
            if (this.protocolVersion < 2) {
                JSDebugThread thread = new JSDebugThread(this, DEFAULT_THREAD_ID, null);
                this.threads.put(DEFAULT_THREAD_ID, thread);
                thread.fireCreationEvent();
                this.fireChangeEvent(512);
            }
            this.handleAttribute(SUSPEND_ON_FIRST_LINE);
            this.handleAttribute(SUSPEND_ON_EXCEPTIONS);
            this.handleAttribute(SUSPEND_ON_ERRORS);
            this.handleAttribute("suspendOnDebuggerKeywords");
            this.setOption(BYPASS_CONSTRUCTORS, Boolean.toString(this.isFilterConstructors()));
            this.setOption(STEP_FILTERS_ENABLED2, Boolean.toString(this.isStepFiltersEnabled()));
            if (this.stepFilters != null && this.stepFilters.length > 0) {
                StringBuffer sb = new StringBuffer(STEP_FILTERS);
                int i = 0;
                while (i < this.stepFilters.length) {
                    sb.append(i != 0 ? (char)'|' : '*').append(Util.encodeData(this.stepFilters[i]));
                    ++i;
                }
                this.connection.sendCommandAndWait(sb.toString());
            }
            this.handleDetailFormattersChange();
            JSDebugPlugin.getDefault().getDebugOptionsManager().addChangeListener((IDetailFormattersChangeListener)this);
            IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelIdentifier());
            int n = iBreakpointArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                this.breakpointAdded(breakpoint);
                ++n2;
            }
            DebugPlugin.getDefault().getBreakpointManager().addBreakpointManagerListener((IBreakpointManagerListener)this);
            DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
            this.connection.sendCommandAndWait(ENABLE);
        }
    }

    private void checkVersion() throws DebugException {
        int protoVersion = 0;
        String version = null;
        String[] args = this.connection.sendCommandAndWait(VERSION);
        if (args != null && args.length >= 3 && args[1].charAt(0) != '!') {
            JSDebugPlugin.log(MessageFormat.format("Extension version: {0}; protocol v{1}", args[2], args[1]));
            try {
                protoVersion = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException numberFormatException) {}
            version = args[2];
        }
        if (protoVersion < 0 || protoVersion > 2) {
            this.throwDebugException(MessageFormat.format("Incompatible debugger extension protocol version {0} for [{1},{2}]", Integer.toString(protoVersion), Integer.toString(0), Integer.toString(2)));
        }
        this.protocolVersion = protoVersion;
        if (checkUpdate) {
            boolean update = false;
            if (version != null) {
                String pluginVersion = (String)Platform.getBundle((String)"com.aptana.js.debug.core").getHeaders().get("Bundle-Version");
                int index = pluginVersion.lastIndexOf(46);
                if (index != -1) {
                    if (index >= version.length() || !pluginVersion.substring(0, index).equals(version.substring(0, index))) {
                        update = true;
                    } else if (!pluginVersion.substring(index + 1).equals(version.substring(index + 1))) {
                        try {
                            if (Integer.parseInt(pluginVersion.substring(index + 1)) > Integer.parseInt(version.substring(index + 1))) {
                                update = true;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                if (update && (args = this.connection.sendCommandAndWait(UPDATE)) != null && args.length >= 2) {
                    JSDebugPlugin.log(MessageFormat.format("Extension update available: {0}", args[1]));
                }
            }
            checkUpdate = false;
        }
    }

    private synchronized void setOption(String option, String value) throws DebugException {
        if (this.connection.isConnected()) {
            this.connection.sendCommandAndWait(MessageFormat.format(OPTION_0_1, option, value));
        }
    }

    public void openURL(URL url) throws DebugException {
        if (this.connection.isConnected()) {
            try {
                DebugEvent event = new DebugEvent((Object)this, 32, 1);
                URL fileUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath());
                event.setData((Object)this.resolveSourceFile(fileUrl.toExternalForm()));
                this.fireEvent(event);
            }
            catch (MalformedURLException e) {
                JSDebugPlugin.log(e);
            }
            this.mainFile = null;
            this.connection.sendCommandAndWait(MessageFormat.format(OPEN_URL_0, Util.encodeData(url.toString())));
        }
    }

    private void stopDebug() throws DebugException {
        if (this.connection == null || !this.connection.isConnected()) {
            return;
        }
        this.connection.stop();
        this.updateContentJob.cancel();
        if (!this.threads.isEmpty()) {
            try {
                for (JSDebugThread thread : this.threads.values()) {
                    thread.fireTerminateEvent();
                }
                this.threads.clear();
                this.topScriptElements.clear();
                this.scripts.clear();
                this.fireChangeEvent(512);
            }
            finally {
                if (JSDebugPlugin.getDefault() != null) {
                    JSDebugPlugin.getDefault().getDebugOptionsManager().removeChangeListener((IDetailFormattersChangeListener)this);
                }
                if (DebugPlugin.getDefault() != null) {
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
                }
            }
        }
    }

    private void shutdown() throws DebugException {
        try {
            try {
                this.stopDebug();
                if (this.connection != null) {
                    this.connection.dispose();
                }
            }
            catch (IOException e) {
                this.throwDebugException(e);
                if (DebugPlugin.getDefault() != null) {
                    this.fireTerminateEvent();
                }
            }
        }
        finally {
            if (DebugPlugin.getDefault() != null) {
                this.fireTerminateEvent();
            }
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelIdentifier());
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (enabled) {
                this.breakpointAdded(breakpoint);
            } else {
                this.breakpointRemoved(breakpoint, null);
            }
            ++n2;
        }
    }

    protected IVariable[] loadVariables(String threadId, String qualifier) throws DebugException {
        if (!this.isThreadSuspended(threadId)) {
            return new IVariable[0];
        }
        ArrayList<JSDebugVariable> list = new ArrayList<JSDebugVariable>();
        String[] args = this.connection.sendCommandAndWait(MessageFormat.format(this.protocolVersion >= 2 ? VARIABLES_0_V2 : VARIABLES_0, threadId, Util.encodeData(qualifier)));
        if (args != null) {
            int i = 1;
            while (i < args.length) {
                String varData = args[i];
                int j = 0;
                if (varData.length() == 0) break;
                if (varData.endsWith("|")) {
                    varData = String.valueOf(varData) + "| ";
                }
                String[] subargs = varData.split(SUBARGS_SPLIT);
                String name = Util.decodeData(subargs[j++]);
                String type = Util.decodeData(subargs[j++]);
                String flags = subargs[j++];
                String stringValue = Util.decodeData(subargs[j++]);
                boolean complex = flags.indexOf(111) != -1;
                String q = MessageFormat.format("{0}.{1}", qualifier, name);
                JSDebugValue ivalue = new JSDebugValue(this, threadId, q, type, complex, stringValue);
                list.add(new JSDebugVariable(this, threadId, q, name, ivalue, JSDebugTarget.convertVariableFlags(flags)));
                ++i;
            }
        }
        return list.toArray(new IVariable[list.size()]);
    }

    protected Object evaluateExpression(String expression, IDebugElement context) throws DebugException {
        String status;
        String threadId;
        String qualifier;
        Object result = null;
        if (context instanceof JSDebugStackFrame) {
            qualifier = MessageFormat.format(FRAME_0, ((JSDebugStackFrame)context).getFrameId());
            threadId = ((JSDebugStackFrame)context).getThreadId();
        } else if (context instanceof JSDebugVariable) {
            qualifier = ((JSDebugVariable)context).getQualifier();
            threadId = ((JSDebugVariable)context).getThreadId();
        } else {
            return result;
        }
        if (!this.isThreadSuspended(threadId)) {
            return null;
        }
        String command = MessageFormat.format(this.protocolVersion >= 2 ? EVAL_0_1_V2 : EVAL_0_1, threadId, Util.encodeData(qualifier), Util.encodeData(expression));
        String[] args = this.connection.sendCommandAndWait(command);
        String string = status = args != null && args.length > 1 ? args[1] : null;
        if (RESULT.equals(status)) {
            String evalId = args[2];
            String varData = args[3];
            if (varData.endsWith("|")) {
                varData = String.valueOf(varData) + "| ";
            }
            String[] subargs = varData.split(SUBARGS_SPLIT);
            int j = 0;
            String type = subargs[j++];
            String flags = subargs[j++];
            String stringValue = Util.decodeData(subargs[j++]);
            boolean complex = flags.indexOf(111) != -1;
            result = new JSDebugValue(this, threadId, MessageFormat.format(EVAL_0, evalId), type, complex, stringValue);
        } else if (EXCEPTION.equals(status)) {
            result = new String[]{args[2]};
        }
        return result;
    }

    protected Object setValue(IVariable variable, IValue newValue) throws DebugException {
        Object result = null;
        if (!(variable instanceof JSDebugVariable)) {
            return result;
        }
        String qualifier = ((JSDebugVariable)variable).getQualifier();
        String threadId = ((JSDebugVariable)variable).getThreadId();
        if (!(newValue instanceof JSDebugValue)) {
            return result;
        }
        String vqualifier = ((JSDebugValue)newValue).getQualifier();
        if (!this.isThreadSuspended(threadId)) {
            return null;
        }
        String command = MessageFormat.format(this.protocolVersion >= 2 ? SET_VALUE_0_1_V2 : SET_VALUE_0_1, threadId, Util.encodeData(qualifier), vqualifier);
        String[] args = this.connection.sendCommandAndWait(command);
        if (args != null && args.length >= 3) {
            String status = args[1];
            if (RESULT.equals(status)) {
                String[] subargs = args[2].split(SUBARGS_SPLIT);
                int j = 0;
                String type = subargs[j++];
                String flags = subargs[j++];
                String stringValue = Util.decodeData(subargs[j++]);
                boolean complex = flags.indexOf(111) != -1;
                result = new JSDebugValue(this, threadId, qualifier, type, complex, stringValue);
            } else if (EXCEPTION.equals(status)) {
                result = new String[]{args[2]};
            }
        }
        return result;
    }

    @Override
    public String computeValueDetails(IValue value) throws DebugException {
        String status;
        String result = null;
        if (!(value instanceof JSDebugValue)) {
            return value.getValueString();
        }
        String qualifier = ((JSDebugValue)value).getQualifier();
        String threadId = ((JSDebugValue)value).getThreadId();
        if (!this.isThreadSuspended(threadId)) {
            return "";
        }
        String command = MessageFormat.format(this.protocolVersion >= 2 ? DETAILS_0_V2 : DETAILS_0, threadId, Util.encodeData(qualifier));
        String[] args = this.connection.sendCommandAndWait(command);
        if (args != null && args.length >= 3 && RESULT.equals(status = args[1])) {
            result = Util.decodeData(args[2]);
        }
        if (result == null) {
            result = value.getValueString();
        }
        if (result == null) {
            return "";
        }
        return result;
    }

    protected IVariable findVariable(String variableName, IDebugElement context) throws DebugException {
        Object result;
        if (Util.checkVariable(variableName) && (result = this.evaluateExpression(variableName, context)) instanceof JSDebugValue) {
            return new JSDebugVariable((IDebugTarget)this, ((JSDebugValue)((Object)result)).getThreadId(), null, variableName, (IValue)result);
        }
        return null;
    }

    private void handleBreakpoint(IBreakpoint breakpoint, String operation) {
        if (this.isDisconnected()) {
            return;
        }
        if (breakpoint.equals(this.skipOperationOnBreakpoint)) {
            this.skipOperationOnBreakpoint = null;
            return;
        }
        if (CREATE.equals(operation) && this.ignoreBreakpointCreation) {
            return;
        }
        if (this.supportsBreakpoint(breakpoint)) {
            if (breakpoint instanceof IJSLineBreakpoint) {
                this.handleLineBreakpoint((IJSLineBreakpoint)breakpoint, operation);
            } else if (breakpoint instanceof IJSExceptionBreakpoint) {
                this.handleExceptionBreakpoint((IJSExceptionBreakpoint)breakpoint, operation);
            } else if (breakpoint instanceof IJSWatchpoint) {
                this.handleWatchpoint((IJSWatchpoint)breakpoint, operation);
            }
        }
    }

    private void handleLineBreakpoint(IJSLineBreakpoint breakpoint, String operation) {
        int lineNumber;
        String properties;
        URI uri;
        IMarker marker;
        block14: {
            marker = breakpoint.getMarker();
            uri = null;
            properties = "";
            try {
                IResource resource;
                URI fileName = null;
                fileName = marker instanceof IUniformResourceMarker ? ((IUniformResourceMarker)marker).getUniformResource().getURI() : ((resource = marker.getResource()) instanceof IWorkspaceRoot ? URI.create((String)marker.getAttribute("com.aptana.js.debug.core.breakpointLocation")) : EFSUtils.getFileStore((IResource)resource).toURI());
                if (fileName != null && this.uriMapper != null) {
                    uri = this.uriMapper.resolve(EFS.getStore((URI)fileName));
                }
                if (uri != null || fileName == null) break block14;
                try {
                    if ("dbgsource".equals(fileName.getScheme())) {
                        uri = fileName;
                        break block14;
                    }
                    uri = fileName.toURL().toURI();
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            catch (CoreException e) {
                JSDebugPlugin.log(e);
            }
        }
        if ((lineNumber = marker.getAttribute("lineNumber", -1)) == -1 || uri == null) {
            return;
        }
        boolean remove = REMOVE.equals(operation);
        if (!remove) {
            boolean enabled = false;
            try {
                enabled = breakpoint.isEnabled();
            }
            catch (CoreException coreException) {}
            int hitCount = marker.getAttribute("com.aptana.js.debug.core.breakpointHitCount", 0);
            boolean conditionEnabled = marker.getAttribute("com.aptana.js.debug.core.breakpointConditionEnabled", false);
            String condition = conditionEnabled ? marker.getAttribute("com.aptana.js.debug.core.breakpointCondition", "") : "";
            String suspendOnTrue = marker.getAttribute("com.aptana.js.debug.core.breakpointConditionSuspendOnTrue", true) ? "1" : DEFAULT_THREAD_ID;
            properties = MessageFormat.format("*{0}*{1}*{2}*{3}", enabled ? "1" : DEFAULT_THREAD_ID, Integer.toString(hitCount), Util.encodeData(condition), suspendOnTrue);
        }
        try {
            String[] args = this.connection.sendCommandAndWait(MessageFormat.format(BREAKPOINT_0_1_2_3, operation, Util.encodeData(uri.toString()), Integer.toString(lineNumber), properties));
            if (!(remove || args != null && args.length >= 2 && (String.valueOf(operation) + 'd').equals(args[1]))) {
                breakpoint.setEnabled(false);
            }
        }
        catch (CoreException e) {
            JSDebugPlugin.log(e);
        }
    }

    private void handleExceptionBreakpoint(IJSExceptionBreakpoint breakpoint, String operation) {
        IMarker marker = breakpoint.getMarker();
        String exceptionTypeName = marker.getAttribute("com.aptana.js.debug.core.exceptionTypeName", "");
        if (exceptionTypeName == null || exceptionTypeName.length() == 0) {
            return;
        }
        boolean enabled = false;
        try {
            enabled = breakpoint.isEnabled();
        }
        catch (CoreException coreException) {}
        if (!enabled) {
            operation = REMOVE;
        }
        enabled = !REMOVE.equals(operation);
        try {
            String[] args = this.connection.sendCommandAndWait(MessageFormat.format(EXCEPTION_0_1, operation, exceptionTypeName));
            if (enabled && (args == null || !(String.valueOf(operation) + 'd').equals(args[1]))) {
                breakpoint.setEnabled(false);
            }
        }
        catch (CoreException e) {
            JSDebugPlugin.log(e);
        }
    }

    private void handleWatchpoint(IJSWatchpoint watchpoint, String operation) {
        IMarker marker = watchpoint.getMarker();
        String variableName = marker.getAttribute("com.aptana.js.debug.core.watchpointVariableAccessor", "");
        boolean enabled = false;
        try {
            enabled = watchpoint.isEnabled();
        }
        catch (CoreException coreException) {}
        if (!enabled) {
            if (CREATE.equals(operation)) {
                return;
            }
            operation = REMOVE;
        }
        enabled = !REMOVE.equals(operation);
        String kind = "";
        if (enabled) {
            try {
                if (watchpoint.isAccess()) {
                    kind = String.valueOf(kind) + 'r';
                }
                if (watchpoint.isModification()) {
                    kind = String.valueOf(kind) + 'w';
                }
            }
            catch (CoreException coreException) {}
        }
        try {
            String[] args = this.connection.sendCommandAndWait(MessageFormat.format(WATCHPOINT_0_1_2, operation, Util.encodeData(variableName), kind));
            if (enabled && (args == null || args.length < 2 || !(String.valueOf(operation) + 'd').equals(args[1]))) {
                watchpoint.setEnabled(false);
            }
        }
        catch (CoreException e) {
            JSDebugPlugin.log(e);
        }
    }

    protected IBreakpoint findBreakpointAt(URI fileName, int lineNumber) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelIdentifier());
        IBreakpoint breakpoint = this.findBreakpointIn(fileName, lineNumber, breakpoints);
        if (breakpoint != null) {
            return breakpoint;
        }
        if (!this.runToLineBreakpoints.isEmpty()) {
            return this.findBreakpointIn(fileName, lineNumber, this.runToLineBreakpoints.toArray(new IBreakpoint[this.runToLineBreakpoints.size()]));
        }
        return null;
    }

    protected IBreakpoint findBreakpointIn(URI fileName, int lineNumber, IBreakpoint[] breakpoints) {
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (this.getDebugTarget().supportsBreakpoint(breakpoint) && breakpoint instanceof ILineBreakpoint) {
                try {
                    URI breakpointURI;
                    IMarker marker = breakpoint.getMarker();
                    boolean fileMatched = false;
                    if (marker instanceof IUniformResourceMarker) {
                        breakpointURI = ((IUniformResourceMarker)marker).getUniformResource().getURI();
                        fileMatched = fileName.equals(breakpointURI);
                    } else if (marker.getResource() instanceof IWorkspaceRoot) {
                        breakpointURI = URI.create((String)marker.getAttribute("com.aptana.js.debug.core.breakpointLocation"));
                        fileMatched = fileName.equals(breakpointURI);
                    } else {
                        IFileStore fileStore = EFS.getStore((URI)fileName);
                        IResource resource = (IResource)fileStore.getAdapter(IResource.class);
                        if (resource != null) {
                            fileMatched = resource.equals((Object)marker.getResource());
                        } else {
                            File breakpointFile = marker.getResource().getLocation().toFile();
                            fileMatched = breakpointFile.equals(fileStore.getAdapter(File.class));
                        }
                    }
                    if (fileMatched && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber) {
                        return breakpoint;
                    }
                }
                catch (CoreException e) {
                    JSDebugPlugin.log(e);
                }
            }
            ++n2;
        }
        return null;
    }

    protected URI resolveSourceFile(String sourceFile) {
        URI resolved = this.sourceResolveCache.get(sourceFile);
        if (resolved != null) {
            return resolved;
        }
        try {
            URI uri = new URI(sourceFile);
            String scheme = uri.getScheme();
            if (FILE.equals(scheme)) {
                File osFile = new File(uri.getSchemeSpecificPart());
                resolved = EFSUtils.getLocalFileStore((File)osFile).toURI();
            } else if (HTTP.equals(scheme) && this.uriMapper != null) {
                IFileStore fileStore = this.uriMapper.resolve(uri);
                if (fileStore != null) {
                    resolved = fileStore.toURI();
                }
            } else if (APP.equals(scheme) && this.uriMapper != null) {
                IFileStore fileStore = this.uriMapper.resolve(uri);
                if (fileStore != null) {
                    resolved = fileStore.toURI();
                }
            } else if (JAVASCRIPT.equals(scheme) && this.mainFile != null) {
                return this.mainFile;
            }
            if (resolved != null) {
                this.sourceResolveCache.put(sourceFile, resolved);
                return resolved;
            }
        }
        catch (URISyntaxException e) {
            if (sourceFile.startsWith(JAVASCRIPT_SCHEME) && this.mainFile != null) {
                return this.mainFile;
            }
            JSDebugPlugin.log(e);
        }
        try {
            return new URI(sourceFile);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private Object findSourceResource(URI fileName) throws CoreException {
        ISourceLookupDirector lookupDirector;
        Object[] result;
        ISourceLocator locator = this.launch.getSourceLocator();
        if (locator instanceof ISourceLookupDirector && (result = (lookupDirector = (ISourceLookupDirector)locator).findSourceElements((Object)fileName)) != null && result.length > 0) {
            Object adopted;
            Object resource = result[0];
            if (resource instanceof IResource) {
                return resource;
            }
            if (!(resource instanceof IUniformResource) && resource instanceof IAdaptable && (adopted = ((IAdaptable)resource).getAdapter(IUniformResource.class)) != null) {
                resource = adopted;
            }
            return resource;
        }
        return null;
    }

    private static int convertVariableFlags(String string) {
        int flags = 0;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case 'w': {
                    flags |= 1;
                    break;
                }
                case 'c': {
                    flags |= 0x10;
                    break;
                }
                case 'l': {
                    flags |= 2;
                    break;
                }
                case 'a': {
                    flags |= 4;
                    break;
                }
                case 'e': {
                    flags |= 8;
                    break;
                }
            }
            ++n2;
        }
        return flags;
    }

    private boolean isThreadSuspended(String threadId) {
        JSDebugThread thread = this.threads.get(threadId);
        if (thread != null) {
            return thread.isSuspended();
        }
        return false;
    }

    @Override
    public IJSScriptElement[] getTopScriptElements() {
        return this.topScriptElements.values().toArray(new IJSScriptElement[this.topScriptElements.size()]);
    }

    private class DebugConnectionHandler
    implements DebugConnection.IHandler {
        private DebugConnectionHandler() {
        }

        @Override
        public void handleMessage(String message) {
            String action;
            String[] args = message.split(JSDebugTarget.ARGS_SPLIT);
            int j = 0;
            if (JSDebugTarget.LOG.equals(action = args[j++])) {
                JSDebugTarget.this.handleLog(args);
                return;
            }
            if (JSDebugTarget.XHR.equals(action)) {
                JSDebugTarget.this.handleXHR(args);
                return;
            }
            if (JSDebugTarget.CLIENT.equals(action)) {
                JSDebugTarget.this.handleClientAction(args);
                return;
            }
            if (JSDebugTarget.SCRIPTS.equals(action)) {
                JSDebugTarget.this.handleScripts(args);
                return;
            }
            if (JSDebugTarget.THREADS.equals(action)) {
                JSDebugTarget.this.handleThreads(args);
                return;
            }
            if (JSDebugTarget.BREAKPOINT.equals(action)) {
                block34: {
                    action = args[j++];
                    URI sourceFile = JSDebugTarget.this.resolveSourceFile(Util.decodeData(args[j++]));
                    int lineNumber = -1;
                    try {
                        lineNumber = Integer.parseInt(args[j++]);
                    }
                    catch (NumberFormatException e) {
                        JSDebugPlugin.log(e);
                    }
                    try {
                        IBreakpoint breakpoint = JSDebugTarget.this.findBreakpointAt(sourceFile, lineNumber);
                        if (JSDebugTarget.CREATE.equals(action) || JSDebugTarget.CHANGE.equals(action)) {
                            boolean enabled = "1".equals(args[j++]);
                            int hitCount = -1;
                            try {
                                hitCount = Integer.parseInt(args[j++]);
                            }
                            catch (NumberFormatException e) {
                                JSDebugPlugin.log(e);
                            }
                            String condition = Util.decodeData(args[j++]);
                            boolean conditionOnTrue = "1".equals(args[j++]);
                            if (breakpoint == null) {
                                Object resource;
                                HashMap<String, Object> attributes = new HashMap<String, Object>();
                                attributes.put("org.eclipse.debug.core.enabled", enabled);
                                if (hitCount != -1) {
                                    attributes.put("com.aptana.js.debug.core.breakpointHitCount", hitCount);
                                }
                                if (condition.length() != 0) {
                                    attributes.put("com.aptana.js.debug.core.breakpointCondition", condition);
                                    attributes.put("com.aptana.js.debug.core.breakpointConditionEnabled", Boolean.TRUE);
                                    attributes.put("com.aptana.js.debug.core.breakpointConditionSuspendOnTrue", conditionOnTrue);
                                }
                                if ((resource = JSDebugTarget.this.findSourceResource(sourceFile)) instanceof IResource) {
                                    try {
                                        JSDebugTarget.this.ignoreBreakpointCreation = true;
                                        JSDebugModel.createLineBreakpoint((IResource)resource, lineNumber, attributes, true);
                                        break block34;
                                    }
                                    finally {
                                        JSDebugTarget.this.ignoreBreakpointCreation = false;
                                    }
                                }
                                if (!(resource instanceof IUniformResource)) break block34;
                                try {
                                    JSDebugTarget.this.ignoreBreakpointCreation = true;
                                    JSDebugModel.createLineBreakpoint((IUniformResource)resource, lineNumber, attributes, true);
                                    break block34;
                                }
                                finally {
                                    JSDebugTarget.this.ignoreBreakpointCreation = false;
                                }
                            }
                            if (JSDebugTarget.CHANGE.equals(action)) {
                                if (breakpoint.isEnabled() != enabled) {
                                    JSDebugTarget.this.skipOperationOnBreakpoint = breakpoint;
                                    breakpoint.setEnabled(enabled);
                                }
                                if (breakpoint instanceof IJSLineBreakpoint) {
                                    IJSLineBreakpoint lineBreakpoint = (IJSLineBreakpoint)breakpoint;
                                    if (lineBreakpoint.getHitCount() != hitCount) {
                                        JSDebugTarget.this.skipOperationOnBreakpoint = breakpoint;
                                        lineBreakpoint.setHitCount(hitCount);
                                    }
                                    if (!condition.equals(lineBreakpoint.getCondition())) {
                                        JSDebugTarget.this.skipOperationOnBreakpoint = breakpoint;
                                        lineBreakpoint.setCondition(condition);
                                        lineBreakpoint.setConditionEnabled(condition.length() != 0);
                                    }
                                    if (lineBreakpoint.isConditionSuspendOnTrue() != conditionOnTrue) {
                                        JSDebugTarget.this.skipOperationOnBreakpoint = breakpoint;
                                        lineBreakpoint.setConditionSuspendOnTrue(conditionOnTrue);
                                    }
                                }
                            }
                            break block34;
                        }
                        if (JSDebugTarget.REMOVE.equals(action) && breakpoint != null) {
                            JSDebugTarget.this.skipOperationOnBreakpoint = breakpoint;
                            breakpoint.delete();
                        }
                    }
                    catch (CoreException e) {
                        JSDebugPlugin.log(e);
                    }
                }
                return;
            }
            if (JSDebugTarget.OPENED.equals(action)) {
                JSDebugTarget.this.mainFile = JSDebugTarget.this.resolveSourceFile(Util.decodeData(args[1]));
                DebugEvent event = new DebugEvent((Object)this, 32, 2);
                event.setData((Object)JSDebugTarget.this.mainFile);
                JSDebugTarget.this.fireEvent(event);
                return;
            }
            if ("suspended".equals(action) || "resumed".equals(action)) {
                JSDebugThread thread;
                String threadId = JSDebugTarget.DEFAULT_THREAD_ID;
                if (JSDebugTarget.this.protocolVersion >= 2) {
                    threadId = args[1];
                    args = Util.removeArrayElement(args, 1);
                }
                if ((thread = (JSDebugThread)((Object)JSDebugTarget.this.threads.get(threadId))) != null) {
                    thread.handleMessage(args);
                }
            }
        }

        @Override
        public void handleShutdown() {
            try {
                JSDebugTarget.this.shutdown();
            }
            catch (DebugException e) {
                JSDebugPlugin.log(e);
            }
        }
    }
}

