/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.model;

import com.aptana.core.resources.IUniformResource;
import com.aptana.core.resources.MarkerUtils;
import com.aptana.debug.core.util.DebugUtil;
import com.aptana.js.debug.core.JSDebugPlugin;
import com.aptana.js.debug.core.internal.model.Messages;
import com.aptana.js.debug.core.model.IJSLineBreakpoint;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;

public class JSDebugLineBreakpoint
extends LineBreakpoint
implements IJSLineBreakpoint {
    public JSDebugLineBreakpoint() {
    }

    public JSDebugLineBreakpoint(IResource resource, int lineNumber) throws CoreException {
        this(resource, lineNumber, new HashMap<String, Object>(), true);
    }

    public JSDebugLineBreakpoint(IUniformResource resource, int lineNumber) throws CoreException {
        this(resource, lineNumber, new HashMap<String, Object>(), true);
    }

    public JSDebugLineBreakpoint(final IResource resource, final int lineNumber, final Map<String, Object> attributes, final boolean register) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker("com.aptana.debug.core.lineBreakpointMarker");
                JSDebugLineBreakpoint.this.setMarker(marker);
                attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
                attributes.put("lineNumber", lineNumber);
                attributes.put("org.eclipse.debug.core.id", JSDebugLineBreakpoint.this.getModelIdentifier());
                attributes.put("message", MessageFormat.format(Messages.JSDebugLineBreakpoint_JSBreakpoint_0_1, resource.getFullPath().toString(), Integer.toString(lineNumber)));
                JSDebugLineBreakpoint.this.ensureMarker().setAttributes(attributes);
                JSDebugLineBreakpoint.this.register(register);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    public JSDebugLineBreakpoint(final IUniformResource resource, final int lineNumber, final Map<String, Object> attributes, final boolean register) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = MarkerUtils.createMarker((IUniformResource)resource, (Map)attributes, (String)"com.aptana.debug.core.lineBreakpointMarker");
                JSDebugLineBreakpoint.this.setMarker(marker);
                attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
                attributes.put("lineNumber", lineNumber);
                attributes.put("org.eclipse.debug.core.id", JSDebugLineBreakpoint.this.getModelIdentifier());
                attributes.put("message", MessageFormat.format(Messages.JSDebugLineBreakpoint_JSBreakpoint_0_1, DebugUtil.getPath((Object)resource), Integer.toString(lineNumber)));
                JSDebugLineBreakpoint.this.ensureMarker().setAttributes(attributes);
                JSDebugLineBreakpoint.this.register(register);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            JSDebugPlugin.log(Messages.JSDebugLineBreakpoint_BreakpointMarkerCreationFailed, e);
        }
    }

    public String getModelIdentifier() {
        return "com.aptana.js.debug.core";
    }

    @Override
    public boolean isRunToLine() throws CoreException {
        return this.ensureMarker().getAttribute("com.aptana.js.debug.core.runToLineBreakpoint", false);
    }

    private void register(boolean register) throws CoreException {
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    @Override
    public int getHitCount() throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("com.aptana.js.debug.core.breakpointHitCount", -1);
        }
        return -1;
    }

    @Override
    public void setHitCount(int count) throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            m.setAttribute("com.aptana.js.debug.core.breakpointHitCount", count);
        }
    }

    @Override
    public String getCondition() throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("com.aptana.js.debug.core.breakpointCondition", "");
        }
        return "";
    }

    @Override
    public void setCondition(String condition) throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            m.setAttribute("com.aptana.js.debug.core.breakpointCondition", (Object)condition);
        }
    }

    @Override
    public boolean isConditionEnabled() throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("com.aptana.js.debug.core.breakpointConditionEnabled", false);
        }
        return false;
    }

    @Override
    public void setConditionEnabled(boolean enabled) throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            m.setAttribute("com.aptana.js.debug.core.breakpointConditionEnabled", enabled);
        }
    }

    @Override
    public boolean isConditionSuspendOnTrue() throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("com.aptana.js.debug.core.breakpointConditionSuspendOnTrue", true);
        }
        return true;
    }

    @Override
    public void setConditionSuspendOnTrue(boolean suspendOnTrue) throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            m.setAttribute("com.aptana.js.debug.core.breakpointConditionSuspendOnTrue", suspendOnTrue);
        }
    }
}

