/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.browsers;

import com.aptana.core.util.FirefoxUtil;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.VersionUtil;
import com.aptana.js.debug.core.JSDebugPlugin;
import com.aptana.js.debug.core.internal.browsers.Firefox;
import com.aptana.js.debug.core.internal.browsers.InternetExplorer;
import com.aptana.js.debug.core.internal.browsers.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IStatusHandler;
import org.osgi.framework.Bundle;

public final class BrowserUtil {
    public static final String DEBUGGER_LAUNCH_URL = "http://www.aptana.com/?debugger=true&port=";
    private static final String[] EXTENSION_ID = new String[]{"debugger@aptana.com", "firebug@software.joehewitt.com"};
    private static final String[] EXTENSION_LOCAL_PATH = new String[]{"/res/firefox/aptanadebugger.xpi", "/res/firefox/firebug.xpi", "/res/ie/AptanaDebugger.dll"};
    private static final String FIREBUG_MIN_VERSION = "1.2.0";
    private static final String IE_PLUGIN_ID = "com.aptana.js.debug.core.ie";
    private static final String EXTENSIONS = "extensions/";
    private static final long INSTALL_TIMEOUT = 5000L;
    private static final Map<String, Boolean> browserCache = new HashMap<String, Boolean>(4);
    private static final IStatus installDebuggerPromptStatus = new Status(1, "com.aptana.js.debug.core", 301, "", null);

    private BrowserUtil() {
    }

    public static String getMacOSXApplicationIdentifier(String application) {
        return PlatformUtil.getApplicationInfo((String)application, (String)"CFBundleIdentifier");
    }

    public static boolean isBrowserRunning(String browserExecutable) {
        PlatformUtil.ProcessItem[] processes;
        if ("macosx".equals(Platform.getOS())) {
            browserExecutable = PlatformUtil.getApplicationExecutable((String)browserExecutable).getAbsolutePath();
        }
        if ((processes = PlatformUtil.getRunningProcesses()) != null) {
            String browserExecutable2 = browserExecutable;
            if ("linux".equals(Platform.getOS())) {
                browserExecutable2 = String.valueOf(browserExecutable2) + "-bin";
            }
            PlatformUtil.ProcessItem[] processItemArray = processes;
            int n = processes.length;
            int n2 = 0;
            while (n2 < n) {
                PlatformUtil.ProcessItem process = processItemArray[n2];
                if (browserExecutable.equals(process.getExecutableName()) || browserExecutable2.equals(process.getExecutableName())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isBrowserDebugCompatible(String browserExecutable) {
        return Firefox.isBrowserExecutable(browserExecutable) || InternetExplorer.isBrowserExecutable(browserExecutable) && BrowserUtil.isIEDebuggerAvailable();
    }

    private static boolean isIEDebuggerAvailable() {
        Bundle bundle = Platform.getBundle((String)IE_PLUGIN_ID);
        if (bundle != null) {
            return bundle.getEntry(EXTENSION_LOCAL_PATH[2]) != null;
        }
        return false;
    }

    public static void resetBrowserCache(String browserExecutable) {
        IPath dllPath;
        browserCache.remove(browserExecutable);
        if (InternetExplorer.isBrowserExecutable(browserExecutable) && (dllPath = JSDebugPlugin.getDefault().getStateLocation().append(".dll").addTrailingSeparator().append("AptanaDebugger.dll")).toFile().exists()) {
            dllPath.addFileExtension("registered").toFile().delete();
        }
    }

    public static boolean isBrowserDebugAvailable(String browserExecutable) {
        Boolean value = browserCache.get(browserExecutable);
        if (value != null) {
            return value;
        }
        if ("true".equals(Platform.getDebugOption((String)"com.aptana.debug.core/skip_debugger_install"))) {
            return true;
        }
        if (Firefox.isBrowserExecutable(browserExecutable)) {
            IPath profile = FirefoxUtil.findDefaultProfileLocation();
            if (profile != null) {
                boolean available = false;
                if (FirefoxUtil.getExtensionVersion((String)EXTENSION_ID[0], (IPath)profile) != null) {
                    String version = FirefoxUtil.getExtensionVersion((String)EXTENSION_ID[1], (IPath)profile);
                    available = version != null && VersionUtil.compareVersions((String)version, (String)FIREBUG_MIN_VERSION) >= 0;
                }
                browserCache.put(browserExecutable, available);
                return available;
            }
        } else if (InternetExplorer.isBrowserExecutable(browserExecutable) && BrowserUtil.isIEDebuggerAvailable()) {
            boolean available;
            block19: {
                IPath dllPath = JSDebugPlugin.getDefault().getStateLocation().append(".dll").addTrailingSeparator().append("AptanaDebugger.dll");
                IPath registeredPath = dllPath.addFileExtension("registered");
                boolean bl = available = dllPath.toFile().exists() && registeredPath.toFile().exists();
                if (available) {
                    String currentDllPath;
                    File file;
                    block20: {
                        boolean pathMatch;
                        block18: {
                            file = dllPath.toFile();
                            currentDllPath = PlatformUtil.queryRegestryStringValue((String)"HKCR\\CLSID\\{B8ADD4EA-ADE3-4DEB-A957-9BBD17D6D0C8}\\InprocServer32", null);
                            boolean bl2 = pathMatch = currentDllPath != null && file.getAbsolutePath().compareTo(new File(currentDllPath).getAbsolutePath()) == 0;
                            if (pathMatch && file.lastModified() == registeredPath.toFile().lastModified()) break block18;
                            if (!dllPath.addFileExtension("noupdate").toFile().exists() && file.delete()) {
                                BrowserUtil.extractFile(IE_PLUGIN_ID, EXTENSION_LOCAL_PATH[2], file);
                                pathMatch = false;
                                break block18;
                            }
                            if (pathMatch) break block18;
                            BrowserUtil.resetBrowserCache(browserExecutable);
                            return false;
                        }
                        if (pathMatch) break block19;
                        if (!BrowserUtil.isBrowserRunning(browserExecutable)) break block20;
                        return false;
                    }
                    try {
                        if (System.getProperty("os.version").charAt(0) >= '6' && !PlatformUtil.isUserAdmin()) {
                            PlatformUtil.runAsAdmin((String)"regsvr32.exe", (String[])new String[]{"/s", dllPath.toOSString()});
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            BrowserUtil.execProcess(new String[]{"regsvr32.exe", "/s", dllPath.toOSString()}, -1L);
                        }
                        currentDllPath = PlatformUtil.queryRegestryStringValue((String)"HKCR\\CLSID\\{B8ADD4EA-ADE3-4DEB-A957-9BBD17D6D0C8}\\InprocServer32", null);
                        if (currentDllPath == null || file.getAbsolutePath().compareTo(new File(currentDllPath).getAbsolutePath()) != 0) {
                            available = false;
                            registeredPath.toFile().setLastModified(file.lastModified());
                        }
                    }
                    catch (IOException e) {
                        JSDebugPlugin.log((IStatus)new Status(4, "com.aptana.js.debug.core", 0, e.getMessage(), (Throwable)e));
                    }
                }
            }
            browserCache.put(browserExecutable, available);
            return available;
        }
        return false;
    }

    private static int execProcess(String[] cmdline, final long timeout) throws IOException {
        Process process = Runtime.getRuntime().exec(cmdline);
        final Thread thread = Thread.currentThread();
        Thread waitTimeout = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(timeout);
                    thread.interrupt();
                }
                catch (InterruptedException interruptedException) {}
            }
        };
        int exitcode = 0;
        if (timeout != -1L) {
            try {
                waitTimeout.start();
                exitcode = process.waitFor();
                waitTimeout.interrupt();
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
            }
            process.destroy();
        }
        try {
            exitcode = process.waitFor();
        }
        catch (InterruptedException interruptedException) {}
        return exitcode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean installDebugExtension(String browserExecutable, IStatusHandler prompter, IProgressMonitor monitor) throws CoreException {
        boolean installDebugger = false;
        String browserName = "";
        if (Firefox.isBrowserExecutable(browserExecutable)) {
            browserName = "Firefox";
        } else if (InternetExplorer.isBrowserExecutable(browserExecutable)) {
            browserName = "Microsoft(R) Internet Explorer";
        }
        Object result = prompter.handleStatus(installDebuggerPromptStatus, (Object)browserName);
        if (result instanceof Boolean) {
            installDebugger = (Boolean)result;
        }
        if (!installDebugger) return false;
        monitor.subTask(Messages.BrowserUtil_InstallingDebugExtension);
        BrowserUtil.resetBrowserCache(browserExecutable);
        boolean installed = false;
        if (Firefox.isBrowserExecutable(browserExecutable)) {
            IPath profile = FirefoxUtil.findDefaultProfileLocation();
            if (profile != null) {
                try {
                    String version = FirefoxUtil.getExtensionVersion((String)EXTENSION_ID[1], (IPath)profile);
                    if (version != null && VersionUtil.compareVersions((String)version, (String)FIREBUG_MIN_VERSION) < 0) {
                        prompter.handleStatus(installDebuggerPromptStatus, (Object)("warning_" + Messages.BrowserUtil_PreviousVersionFound_Message));
                        return false;
                    }
                    if (FirefoxUtil.getExtensionVersion((String)EXTENSION_ID[0], (IPath)profile) == null) {
                        installed = FirefoxUtil.installExtension((URL)Platform.getBundle((String)"com.aptana.js.debug.core").getEntry(EXTENSION_LOCAL_PATH[0]), (String)EXTENSION_ID[0], (File)profile.append(EXTENSIONS).toFile());
                    }
                    if (FirefoxUtil.getExtensionVersion((String)EXTENSION_ID[1], (IPath)profile) == null) {
                        installed = FirefoxUtil.installExtension((URL)Platform.getBundle((String)"com.aptana.js.debug.core").getEntry(EXTENSION_LOCAL_PATH[1]), (String)EXTENSION_ID[1], (File)profile.append(EXTENSIONS).toFile());
                    }
                    if (installed) {
                        int max_retry = 3;
                        while (BrowserUtil.isBrowserRunning(browserExecutable) && max_retry-- > 0) {
                            prompter.handleStatus(installDebuggerPromptStatus, (Object)("quit_" + browserName));
                        }
                    }
                }
                catch (Exception e) {
                    JSDebugPlugin.log(e);
                }
            } else {
                JSDebugPlugin.log(Messages.BrowserUtil_FirefoxProfileNotFound);
            }
            if (installed && "macosx".equals(Platform.getOS())) {
                try {
                    BrowserUtil.execProcess(new String[]{"/usr/bin/open", "-b", BrowserUtil.getMacOSXApplicationIdentifier(browserExecutable)}, -1L);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.interrupted();
                    }
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.js.debug.core", 0, Messages.BrowserUtil_InstallError, (Throwable)e));
                }
            }
        } else if (InternetExplorer.isBrowserExecutable(browserExecutable)) {
            while (PlatformUtil.queryRegestryStringValue((String)"HKCR\\CLSID\\{04CCE2FF-A7D3-11D0-B436-00A0244A1DD2}\\InprocServer32", null) == null) {
                Boolean retry = (Boolean)prompter.handleStatus(installDebuggerPromptStatus, (Object)"nopdm");
                if (retry == null) return false;
                if (retry == false) return false;
            }
            int max_retry = 3;
            while (BrowserUtil.isBrowserRunning(browserExecutable) && max_retry-- > 0) {
                prompter.handleStatus(installDebuggerPromptStatus, (Object)("quit_" + browserName));
            }
            IPath dllPath = JSDebugPlugin.getDefault().getStateLocation().append(".dll").addTrailingSeparator().append("AptanaDebugger.dll");
            try {
                File file = dllPath.toFile();
                if (file.exists()) {
                    file.delete();
                } else {
                    dllPath.removeLastSegments(1).toFile().mkdirs();
                }
                BrowserUtil.extractFile(IE_PLUGIN_ID, EXTENSION_LOCAL_PATH[2], file);
                if (System.getProperty("os.version").charAt(0) >= '6' && !PlatformUtil.isUserAdmin()) {
                    PlatformUtil.runAsAdmin((String)"regsvr32.exe", (String[])new String[]{"/s", dllPath.toOSString()});
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    BrowserUtil.execProcess(new String[]{"regsvr32.exe", "/s", dllPath.toOSString()}, -1L);
                }
                dllPath.addFileExtension("registered").toFile().createNewFile();
                dllPath.addFileExtension("registered").toFile().setLastModified(file.lastModified());
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.js.debug.core", 0, Messages.BrowserUtil_InstallError, (Throwable)e));
            }
        }
        if (installed = BrowserUtil.isBrowserDebugAvailable(browserExecutable)) {
            prompter.handleStatus(installDebuggerPromptStatus, (Object)("installed_" + browserName));
            return installed;
        }
        BrowserUtil.resetBrowserCache(browserExecutable);
        prompter.handleStatus(installDebuggerPromptStatus, (Object)("failed_" + browserName));
        return installed;
    }

    private static void extractFile(String bundleId, String path, File file) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            int n;
            in = Platform.getBundle((String)bundleId).getEntry(path).openStream();
            out = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((n = in.read(buffer)) > 0) {
                out.write(buffer, 0, n);
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }
}

