/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

public final class Util {
    private static final Pattern CHECK_VARIABLE = Pattern.compile("\\A\\w+(?:\\.\\w+)*\\z");

    private Util() {
    }

    public static String fixupURI(String string) {
        URI uri = null;
        try {
            uri = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {}
        if (uri == null || uri.getScheme() == null) {
            return new File(string).toURI().toString();
        }
        return string;
    }

    public static String encodeData(String data) {
        return data.replaceAll("#", "#0").replaceAll("\\|", "#1").replaceAll("\\*", "#2");
    }

    public static String decodeData(String data) {
        return data.replaceAll("#2", "*").replaceAll("#1", "|").replaceAll("#0", "#");
    }

    public static boolean checkVariable(String variableName) {
        return CHECK_VARIABLE.matcher(variableName).matches();
    }

    public static String[] removeArrayElement(String[] array, int index) {
        if (array.length == 0 || index >= array.length) {
            return array;
        }
        String[] result = new String[array.length - 1];
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + 1, result, index, array.length - index - 1);
        return result;
    }
}

