/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal;

import com.aptana.debug.core.IExtendedStreamsProxy;
import com.aptana.js.debug.core.internal.OutputStreamMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.model.IStreamMonitor;

public class StreamsProxy
implements IExtendedStreamsProxy {
    private final Map<String, OutputStreamMonitor> monitorMap = new HashMap<String, OutputStreamMonitor>();

    public StreamsProxy(InputStream outIn, InputStream errIn) {
        this.monitorMap.put("ID_STANDARD_OUTPUT_STREAM", new OutputStreamMonitor(outIn, null));
        this.monitorMap.put("ID_STANDARD_ERROR_STREAM", new OutputStreamMonitor(errIn, null));
        for (OutputStreamMonitor monitor : this.monitorMap.values()) {
            monitor.startMonitoring();
        }
    }

    public StreamsProxy(Map<String, InputStream> streams) {
        for (Map.Entry<String, InputStream> entry : streams.entrySet()) {
            this.monitorMap.put(entry.getKey(), new OutputStreamMonitor(entry.getValue(), null));
        }
        for (OutputStreamMonitor monitor : this.monitorMap.values()) {
            monitor.startMonitoring();
        }
    }

    public IStreamMonitor getStreamMonitor(String streamIdentifier) {
        return (IStreamMonitor)this.monitorMap.get(streamIdentifier);
    }

    public String[] getStreamIdentifers() {
        return this.monitorMap.keySet().toArray(new String[this.monitorMap.size()]);
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return this.getStreamMonitor("ID_STANDARD_ERROR_STREAM");
    }

    public IStreamMonitor getOutputStreamMonitor() {
        return this.getStreamMonitor("ID_STANDARD_OUTPUT_STREAM");
    }

    public void write(String input) throws IOException {
        throw new IOException("not supported");
    }
}

