/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.ui.preferences;

import com.aptana.core.util.EclipseUtil;
import com.aptana.theme.ColorManager;
import com.aptana.theme.IThemeManager;
import com.aptana.theme.ThemePlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class ScriptSourcePreviewerUpdater {
    public ScriptSourcePreviewerUpdater(final SourceViewer viewer, SourceViewerConfiguration configuration, final IPreferenceStore preferenceStore) {
        Assert.isNotNull((Object)viewer);
        Assert.isNotNull((Object)configuration);
        Assert.isNotNull((Object)preferenceStore);
        final IPropertyChangeListener fontChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.textfont".equals(event.getProperty())) {
                    Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
                    viewer.getTextWidget().setFont(font);
                }
            }
        };
        final IEclipsePreferences.IPreferenceChangeListener themeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getKey().equals("THEME_CHANGED")) {
                    ColorManager colorManager = ThemePlugin.getDefault().getColorManager();
                    IThemeManager themeManager = ThemePlugin.getDefault().getThemeManager();
                    Color color = colorManager.getColor(themeManager.getCurrentTheme().getBackground());
                    StyledText styledText = viewer.getTextWidget();
                    styledText.setBackground(color);
                }
            }
        };
        final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                viewer.invalidateTextPresentation();
            }
        };
        viewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                preferenceStore.removePropertyChangeListener(propertyChangeListener);
                JFaceResources.getFontRegistry().removeListener(fontChangeListener);
                if (themeListener != null) {
                    EclipseUtil.instanceScope().getNode("com.aptana.theme").removePreferenceChangeListener(themeListener);
                }
            }
        });
        JFaceResources.getFontRegistry().addListener(fontChangeListener);
        preferenceStore.addPropertyChangeListener(propertyChangeListener);
        EclipseUtil.instanceScope().getNode("com.aptana.theme").addPreferenceChangeListener(themeListener);
    }
}

