/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.ui.preferences;

import com.aptana.formatter.preferences.IFieldValidator;
import com.aptana.formatter.preferences.IPreferenceDelegate;
import com.aptana.formatter.ui.IFormatterControlManager;
import com.aptana.formatter.ui.preferences.AddRemoveList;
import com.aptana.formatter.ui.preferences.ControlBindingManager;
import com.aptana.formatter.ui.preferences.FieldValidators;
import com.aptana.formatter.ui.util.IStatusChangeListener;
import com.aptana.formatter.ui.util.SWTFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class FormatterControlManager
implements IFormatterControlManager,
IStatusChangeListener {
    private final IPreferenceDelegate delegate;
    private final ControlBindingManager bindingManager;
    private final IStatusChangeListener listener;
    private final Map<Control, Label> labelAssociations = new HashMap<Control, Label>();
    private final ListenerList initListeners = new ListenerList();
    private boolean initialization;

    public FormatterControlManager(IPreferenceDelegate delegate, IStatusChangeListener listener) {
        this.delegate = delegate;
        this.bindingManager = new ControlBindingManager(delegate, this);
        this.listener = listener;
    }

    public Button createCheckbox(Composite parent, Object key, String text) {
        return this.createCheckbox(parent, key, text, 1);
    }

    public Button createCheckbox(Composite parent, Object key, String text, int hspan) {
        Button button = SWTFactory.createCheckButton(parent, text, null, false, hspan);
        this.bindingManager.bindControl(button, key, null);
        return button;
    }

    public Combo createCombo(Composite parent, Object key, String label, String[] items) {
        Label labelControl = SWTFactory.createLabel(parent, label);
        Combo combo = SWTFactory.createCombo(parent, 2056, 1, items);
        this.bindingManager.bindControl(combo, key);
        this.registerAssociatedLabel((Control)combo, labelControl);
        return combo;
    }

    public Combo createCombo(Composite parent, Object key, String label, String[] itemValues, String[] itemLabels) {
        Label labelControl = SWTFactory.createLabel(parent, label);
        Combo combo = SWTFactory.createCombo(parent, 2056, 1, itemLabels);
        this.bindingManager.bindControl(combo, key, itemValues);
        this.registerAssociatedLabel((Control)combo, labelControl);
        return combo;
    }

    public Text createNumber(Composite parent, Object key, String label) {
        Label labelControl = SWTFactory.createLabel(parent, label);
        Text text = SWTFactory.createText(parent, 2048, 1, "");
        this.bindingManager.bindControl(text, key, FieldValidators.POSITIVE_NUMBER_VALIDATOR);
        this.registerAssociatedLabel((Control)text, labelControl);
        return text;
    }

    public Text createNumber(Composite parent, String key, String label, int minValue) {
        Label labelControl = SWTFactory.createLabel(parent, label);
        Text text = SWTFactory.createText(parent, 2048, 1, "");
        this.bindingManager.bindControl(text, (Object)key, new FieldValidators.MinimumNumberValidator(minValue));
        this.registerAssociatedLabel((Control)text, labelControl);
        return text;
    }

    public Spinner createSpinner(Composite parent, Object key, int min, int max, int style) {
        Spinner spinner = SWTFactory.createSpinner(parent, min, max, 1, style);
        this.bindingManager.bindControl(spinner, key);
        return spinner;
    }

    public Spinner createSpinner(Composite parent, Object key, int style) {
        return this.createSpinner(parent, key, 0, 5, style);
    }

    public Spinner createSpinner(Composite parent, Object key) {
        return this.createSpinner(parent, key, 0, 5, 0);
    }

    public Text createText(Composite parent, Object key, String label) {
        Label labelControl = SWTFactory.createLabel(parent, label);
        Text text = SWTFactory.createText(parent, 2048, 1, "");
        this.bindingManager.bindControl(text, key, FieldValidators.EMPTY_TEXT_VALIDATOR);
        this.registerAssociatedLabel((Control)text, labelControl);
        return text;
    }

    public Text createText(Composite parent, Object key, String label, IFieldValidator validator) {
        Label labelControl = SWTFactory.createLabel(parent, label);
        Text text = SWTFactory.createText(parent, 2048, 1, "");
        this.bindingManager.bindControl(text, key, validator);
        this.registerAssociatedLabel((Control)text, labelControl);
        return text;
    }

    public Control createManagedList(Group group, Object key) {
        AddRemoveList list = new AddRemoveList((Composite)group);
        this.bindingManager.bindControl(list.getList(), key);
        return list.getControl();
    }

    public Control createManagedList(Group group, Object key, Collection<Short> validChars) {
        AddRemoveList list = new AddRemoveList((Composite)group, validChars);
        this.bindingManager.bindControl(list.getList(), key);
        return list.getControl();
    }

    public Label createLabel(Composite parent, String text, int hspan, int style) {
        Label label = new Label(parent, style);
        label.setText(text);
        GridData gridData = new GridData();
        gridData.horizontalSpan = hspan;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public Label createLabel(Composite parent, String text) {
        return this.createLabel(parent, text, 1, 0);
    }

    private void registerAssociatedLabel(Control control, Label label) {
        this.labelAssociations.put(control, label);
    }

    public void enableControl(Control control, boolean enabled) {
        control.setEnabled(enabled);
        Label label = this.labelAssociations.get(control);
        if (label != null) {
            label.setEnabled(enabled);
        }
        if (control instanceof Text) {
            IStatus status = this.bindingManager.validateText((Text)control);
            this.bindingManager.updateStatus(status);
        }
    }

    public void addInitializeListener(IFormatterControlManager.IInitializeListener listener) {
        this.initListeners.add((Object)listener);
    }

    public void removeInitializeListener(IFormatterControlManager.IInitializeListener listener) {
        this.initListeners.remove((Object)listener);
    }

    public void initialize() {
        this.initialization = true;
        try {
            this.bindingManager.initialize();
            Object[] listeners = this.initListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IFormatterControlManager.IInitializeListener)listeners[i]).initialize();
                ++i;
            }
        }
        finally {
            this.initialization = false;
        }
        this.listener.statusChanged(this.bindingManager.getStatus());
    }

    @Override
    public void statusChanged(IStatus status) {
        if (!this.initialization) {
            this.listener.statusChanged(status);
        }
    }

    public boolean getBoolean(Object key) {
        return this.delegate.getBoolean(key);
    }

    public String getString(Object key) {
        return this.delegate.getString(key);
    }

    public void setBoolean(Object key, boolean value) {
        this.delegate.setBoolean(key, value);
    }

    public void setString(Object key, String value) {
        this.delegate.setString(key, value);
    }
}

