/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.ui.preferences;

import com.aptana.formatter.preferences.IFieldValidator;
import com.aptana.formatter.ui.preferences.Messages;
import com.aptana.formatter.ui.util.StatusInfo;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;

public final class FieldValidators {
    public static final IFieldValidator POSITIVE_NUMBER_VALIDATOR = new PositiveNumberValidator();
    public static final IFieldValidator PORT_VALIDATOR = new PortValidator();
    public static final IFieldValidator EMPTY_TEXT_VALIDATOR = new EmptyTextValidator();

    public static class EmptyTextValidator
    implements IFieldValidator {
        public IStatus validate(String text) {
            StatusInfo status = new StatusInfo();
            if (text.trim().length() == 0) {
                status.setError(Messages.FieldIsEmpty);
            }
            return status;
        }
    }

    public static class MinimumNumberValidator
    extends PositiveNumberValidator {
        private int minValue;

        public MinimumNumberValidator(int minValue) {
            this.minValue = minValue;
        }

        @Override
        public IStatus validate(String text) {
            StatusInfo status = (StatusInfo)super.validate(text);
            if (!status.isOK()) {
                return status;
            }
            int value = Integer.parseInt(text);
            if (value < this.minValue) {
                status.setError(MessageFormat.format(Messages.MinValueInvalid, String.valueOf(this.minValue)));
            }
            return status;
        }
    }

    public static class PortValidator
    implements IFieldValidator {
        public IStatus validate(String text) {
            StatusInfo status = new StatusInfo();
            if (text.trim().length() == 0) {
                status.setError(Messages.PortIsEmpty);
            } else {
                try {
                    int value = Integer.parseInt(text);
                    if (value < 1000 || value > 65535) {
                        status.setError(MessageFormat.format(Messages.PortShouldBeInRange, text));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    status.setError(MessageFormat.format(Messages.PortShouldBeInRange, text));
                }
            }
            return status;
        }
    }

    public static class PositiveNumberValidator
    implements IFieldValidator {
        public IStatus validate(String text) {
            StatusInfo status = new StatusInfo();
            if (text.trim().length() == 0) {
                status.setError(Messages.PositiveNumberIsEmpty);
            } else {
                try {
                    int value = Integer.parseInt(text);
                    if (value < 0) {
                        status.setError(MessageFormat.format(Messages.PositiveNumberIsInvalid, text));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    status.setError(MessageFormat.format(Messages.PositiveNumberIsInvalid, text));
                }
            }
            return status;
        }
    }
}

