/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.ui.preferences;

import com.aptana.formatter.preferences.profile.IProfile;
import com.aptana.formatter.preferences.profile.IProfileManager;
import com.aptana.formatter.preferences.profile.IProfileVersioner;
import com.aptana.formatter.preferences.profile.ProfileKind;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.formatter.ui.util.StatusInfo;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateProfileDialog
extends StatusDialog {
    private Text fNameText;
    private Combo fProfileCombo;
    private static final StatusInfo fOk = new StatusInfo();
    private static final StatusInfo fEmpty = new StatusInfo(4, FormatterMessages.CreateProfileDialog_nameEmpty);
    private static final StatusInfo fDuplicate = new StatusInfo(4, FormatterMessages.CreateProfileDialog_nameExists);
    private final IProfileManager fProfileManager;
    private final List<IProfile> fSortedProfiles;
    private final String[] fSortedNames;
    private IProfile fCreatedProfile;
    private IProfileVersioner versioner;
    private IProject fProject;

    public CreateProfileDialog(Shell parentShell, IProfileManager profileManager, IProfileVersioner versioner, IProject fProject) {
        super(parentShell);
        this.fProfileManager = profileManager;
        this.fProject = fProject;
        this.fSortedProfiles = this.fProfileManager.getSortedProfiles();
        this.fSortedNames = this.fProfileManager.getSortedDisplayNames();
        this.versioner = versioner;
    }

    public void create() {
        super.create();
        this.setTitle(FormatterMessages.CreateProfileDialog_newProfile);
    }

    public Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        Label nameLabel = new Label(composite, 64);
        nameLabel.setText(FormatterMessages.CreateProfileDialog_profileName);
        nameLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fNameText = new Text(composite, 2052);
        this.fNameText.setLayoutData((Object)gd);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateProfileDialog.this.doValidation();
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        Label profileLabel = new Label(composite, 64);
        profileLabel.setText(FormatterMessages.CreateProfileDialog_initSettings);
        profileLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fProfileCombo = new Combo(composite, 12);
        this.fProfileCombo.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProfileCombo.setItems(this.fSortedNames);
        String selectedProfile = this.fProfileManager.getSelected(this.fProject).getName();
        if (this.fProfileCombo.indexOf(selectedProfile) > -1) {
            this.fProfileCombo.setText(selectedProfile);
        } else {
            this.fProfileCombo.select(0);
        }
        this.updateStatus(fEmpty);
        CreateProfileDialog.applyDialogFont((Control)composite);
        this.fNameText.setFocus();
        return composite;
    }

    protected void doValidation() {
        String name = this.fNameText.getText().trim();
        if (this.fProfileManager.containsName(name)) {
            this.updateStatus(fDuplicate);
            return;
        }
        if (name.length() == 0) {
            this.updateStatus(fEmpty);
            return;
        }
        this.updateStatus(fOk);
    }

    protected void okPressed() {
        if (!this.getStatus().isOK()) {
            return;
        }
        HashMap baseSettings = new HashMap(this.fSortedProfiles.get(this.fProfileCombo.getSelectionIndex()).getSettings());
        String profileName = this.fNameText.getText();
        this.fCreatedProfile = this.fProfileManager.create(this.fProject, ProfileKind.CUSTOM, profileName, baseSettings, this.versioner.getCurrentVersion());
        super.okPressed();
    }

    public final IProfile getCreatedProfile() {
        return this.fCreatedProfile;
    }
}

