/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.ui.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.formatter.ContributionExtensionManager;
import com.aptana.formatter.IScriptFormatterFactory;
import com.aptana.formatter.preferences.IPreferencesSaveDelegate;
import com.aptana.formatter.preferences.PreferenceKey;
import com.aptana.formatter.preferences.profile.IProfile;
import com.aptana.formatter.preferences.profile.IProfileManager;
import com.aptana.formatter.preferences.profile.IProfileStore;
import com.aptana.formatter.preferences.profile.IProfileVersioner;
import com.aptana.formatter.preferences.profile.ProfileKind;
import com.aptana.formatter.preferences.profile.ProfileManager;
import com.aptana.formatter.preferences.profile.ProfileStore;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.formatter.ui.IFormatterModifyDialog;
import com.aptana.formatter.ui.IFormatterModifyDialogOwner;
import com.aptana.formatter.ui.epl.FormatterUIEplPlugin;
import com.aptana.formatter.ui.preferences.AbstractOptionsBlock;
import com.aptana.formatter.ui.preferences.AlreadyExistsDialog;
import com.aptana.formatter.ui.preferences.CreateProfileDialog;
import com.aptana.formatter.ui.util.ExceptionHandler;
import com.aptana.formatter.ui.util.IStatusChangeListener;
import com.aptana.ui.UIPlugin;
import com.aptana.ui.util.SWTUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public abstract class AbstractFormatterSelectionBlock
extends AbstractOptionsBlock {
    private Composite fComposite;
    private Combo fProfileCombo;
    private Button fDeleteButton;
    private Button fNewButton;
    private Button fLoadButton;
    private Button fSaveButton;
    private Button fEditButton;
    private Button fDefaultButton;
    private static int selectedFormatter;
    private IScriptFormatterFactory[] factories;
    protected SourceViewer fSelectedPreviewViewer;
    private ArrayList<SourceViewer> sourcePreviewViewers;
    private StackLayout previewStackLayout;
    private IProfileManager profileManager;
    private IPropertyChangeListener profileChangeListener;
    private boolean useProjectSpecific;
    private static List<IScriptFormatterFactory> TEMP_LIST;

    static {
        TEMP_LIST = new ArrayList<IScriptFormatterFactory>();
    }

    protected abstract IFormatterModifyDialogOwner createDialogOwner(IScriptFormatterFactory var1);

    protected abstract ContributionExtensionManager getExtensionManager();

    protected abstract String getPreferenceLinkMessage();

    protected abstract void updatePreview();

    protected abstract SourceViewer createSourcePreview(Composite var1, IScriptFormatterFactory var2);

    public AbstractFormatterSelectionBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, ProfileManager.collectPreferenceKeys(TEMP_LIST, (boolean)true), container);
        Collections.sort(TEMP_LIST, new Comparator<IScriptFormatterFactory>(){

            @Override
            public int compare(IScriptFormatterFactory s1, IScriptFormatterFactory s2) {
                return s1.getName().compareToIgnoreCase(s2.getName());
            }
        });
        this.factories = TEMP_LIST.toArray(new IScriptFormatterFactory[TEMP_LIST.size()]);
        TEMP_LIST = new ArrayList<IScriptFormatterFactory>();
        this.sourcePreviewViewers = new ArrayList();
        this.fLookupOrder = new IScopeContext[]{EclipseUtil.instanceScope(), EclipseUtil.defaultScope()};
    }

    protected IProfileManager getProfileManager() {
        if (this.profileManager == null) {
            this.profileManager = ProfileManager.getInstance();
        }
        return this.profileManager;
    }

    @Override
    public boolean hasProjectSpecificOptions(IProject project) {
        if (project != null) {
            ProjectScope projectScope = new ProjectScope(project);
            return this.getProfileManager().getActiveProfileKey().getStoredValue((IScopeContext)projectScope) != null;
        }
        return false;
    }

    @Override
    public void useProjectSpecificSettings(boolean enable) {
        this.useProjectSpecific = enable;
        super.useProjectSpecificSettings(enable);
    }

    @Override
    protected boolean saveValues() {
        IProfileManager manager = this.getProfileManager();
        PreferenceKey profilesKey = manager.getProfilesKey();
        if (manager.isDirty()) {
            IProfileStore store = manager.getProfileStore();
            try {
                String value = ((ProfileStore)store).writeProfiles((Collection)manager.getSortedProfiles());
                profilesKey.setStoredValue((IScopeContext)EclipseUtil.instanceScope(), value);
                manager.clearDirty();
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)FormatterUIEplPlugin.getDefault(), (Throwable)e, (String)"com.aptana.formatter.epl/debug");
            }
        }
        IProfile selected = manager.getSelected(this.fProject);
        InstanceScope scope = null;
        PreferenceKey activeProfileKey = manager.getActiveProfileKey();
        if (this.fProject != null) {
            scope = new ProjectScope(this.fProject);
            if (!this.useProjectSpecific) {
                selected = null;
            }
        } else {
            scope = EclipseUtil.instanceScope();
        }
        activeProfileKey.setStoredValue((IScopeContext)scope, selected != null ? selected.getID() : null);
        activeProfileKey.flush((IScopeContext)scope);
        return super.saveValues();
    }

    protected void applyPreferences() {
        this.applyPreferences(false);
    }

    protected void applyPreferences(boolean isInitializing) {
        PreferenceKey activeProfileKey;
        IProfileManager manager = this.getProfileManager();
        IProfile profile = manager.getSelected(this.fProject);
        HashMap<String, String> settings = new HashMap<String, String>();
        if (profile != null) {
            settings.putAll(profile.getSettings());
        }
        if ((activeProfileKey = this.profileManager.getActiveProfileKey()) != null) {
            if (profile != null) {
                settings.put(activeProfileKey.getName(), profile.getID());
            } else {
                settings.remove(activeProfileKey.getName());
            }
        }
        SaveDelegate delegate = new SaveDelegate();
        IScriptFormatterFactory[] iScriptFormatterFactoryArray = this.factories;
        int n = this.factories.length;
        int n2 = 0;
        while (n2 < n) {
            IScriptFormatterFactory factory = iScriptFormatterFactoryArray[n2];
            factory.savePreferences(settings, (IPreferencesSaveDelegate)delegate, isInitializing);
            if (profile != null) {
                profile.setSettings(settings);
            }
            ++n2;
        }
        if (selectedFormatter < 0) {
            selectedFormatter = 0;
        }
        this.fSelectedPreviewViewer = this.sourcePreviewViewers.get(selectedFormatter);
        this.previewStackLayout.topControl = this.fSelectedPreviewViewer.getControl();
        this.updatePreview();
    }

    @Override
    public final Control createOptionsBlock(Composite parent) {
        return this.createSelectorBlock(parent);
    }

    protected Composite createSelectorBlock(Composite parent) {
        PixelConverter fPixConv = new PixelConverter((Control)parent);
        this.fComposite = this.createComposite(parent, 5);
        Label profileLabel = new Label(this.fComposite, 0);
        profileLabel.setText(FormatterMessages.AbstractFormatterSelectionBlock_activeProfile);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 5;
        profileLabel.setLayoutData((Object)data);
        this.fProfileCombo = AbstractFormatterSelectionBlock.createProfileCombo(this.fComposite, 1, fPixConv.convertWidthInCharsToPixels(20));
        this.updateComboFromProfiles();
        this.fProfileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractFormatterSelectionBlock.this.updateSelection();
            }
        });
        this.fNewButton = AbstractFormatterSelectionBlock.createButton(this.fComposite, 32);
        this.fNewButton.setImage(SWTUtils.getImage((AbstractUIPlugin)UIPlugin.getDefault(), (String)"/icons/add.gif"));
        this.fNewButton.setToolTipText(FormatterMessages.AbstractFormatterSelectionBlock_newProfile);
        this.fNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractFormatterSelectionBlock.this.createNewProfile(AbstractFormatterSelectionBlock.this.fComposite.getShell());
            }
        });
        this.fDeleteButton = AbstractFormatterSelectionBlock.createButton(this.fComposite, 32);
        this.fDeleteButton.setImage(SWTUtils.getImage((AbstractUIPlugin)UIPlugin.getDefault(), (String)"/icons/delete.gif"));
        this.fDeleteButton.setToolTipText(FormatterMessages.AbstractFormatterSelectionBlock_removeProfile);
        this.fDeleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.doDelete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.doDelete();
            }

            protected void doDelete() {
                IProfileManager profileManager = AbstractFormatterSelectionBlock.this.getProfileManager();
                IProfile selected = profileManager.getSelected(AbstractFormatterSelectionBlock.this.fProject);
                if (MessageDialog.openQuestion((Shell)AbstractFormatterSelectionBlock.this.fComposite.getShell(), (String)FormatterMessages.AbstractFormatterSelectionBlock_confirmRemoveLabel, (String)NLS.bind((String)FormatterMessages.AbstractFormatterSelectionBlock_confirmRemoveMessage, (Object)selected.getName()))) {
                    profileManager.deleteProfile(selected);
                    AbstractFormatterSelectionBlock.this.updateComboFromProfiles();
                    AbstractFormatterSelectionBlock.this.updateSelection();
                }
            }
        });
        this.fLoadButton = AbstractFormatterSelectionBlock.createButton(this.fComposite, 32);
        this.fLoadButton.setImage(SWTUtils.getImage((AbstractUIPlugin)UIPlugin.getDefault(), (String)"/icons/import.gif"));
        this.fLoadButton.setToolTipText(FormatterMessages.AbstractFormatterSelectionBlock_importProfile);
        this.fLoadButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractFormatterSelectionBlock.this.doImport(AbstractFormatterSelectionBlock.this.fComposite);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractFormatterSelectionBlock.this.doImport(AbstractFormatterSelectionBlock.this.fComposite);
            }
        });
        this.fSaveButton = AbstractFormatterSelectionBlock.createButton(this.fComposite, 32);
        this.fSaveButton.setImage(SWTUtils.getImage((AbstractUIPlugin)UIPlugin.getDefault(), (String)"/icons/export.gif"));
        this.fSaveButton.setToolTipText(FormatterMessages.FormatterModifyDialog_export);
        this.fSaveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractFormatterSelectionBlock.this.doExport();
            }
        });
        AbstractFormatterSelectionBlock.createLabel(this.fComposite, "", 3);
        this.fEditButton = AbstractFormatterSelectionBlock.createButton(this.fComposite, 32);
        this.fEditButton.setImage(SWTUtils.getImage((AbstractUIPlugin)UIPlugin.getDefault(), (String)"/icons/pencil.gif"));
        this.fEditButton.setToolTipText(FormatterMessages.AbstractFormatterSelectionBlock_edit);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractFormatterSelectionBlock.this.editButtonPressed();
            }
        });
        this.fDefaultButton = AbstractFormatterSelectionBlock.createButton(this.fComposite, 32);
        this.fDefaultButton.setImage(SWTUtils.getImage((AbstractUIPlugin)UIPlugin.getDefault(), (String)"/icons/arrow_undo.png"));
        this.fDefaultButton.setToolTipText(FormatterMessages.AbstractFormatterSelectionBlock_defaults);
        this.fDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IScriptFormatterFactory formatter = AbstractFormatterSelectionBlock.this.getSelectedFormatter();
                if (formatter == null) {
                    return;
                }
                PreferenceKey[] preferenceKeys = formatter.getPreferenceKeys();
                IProfileManager manager = AbstractFormatterSelectionBlock.this.getProfileManager();
                if (!MessageDialog.openQuestion((Shell)AbstractFormatterSelectionBlock.this.fDefaultButton.getShell(), (String)FormatterMessages.AbstractFormatterSelectionBlock_confirmDefaultsTitle, (String)NLS.bind((String)FormatterMessages.AbstractFormatterSelectionBlock_confirmDefaultsMessage, (Object)formatter.getName()))) {
                    return;
                }
                List builtInProfiles = manager.getBuiltInProfiles();
                String defaultProfileId = manager.getDefaultProfileID();
                IProfile defaultProfile = null;
                for (IProfile profile : builtInProfiles) {
                    if (!profile.getID().equals(defaultProfileId)) continue;
                    defaultProfile = profile;
                    break;
                }
                if (defaultProfile != null) {
                    Map defaultSettings = defaultProfile.getSettings();
                    Map activeSettings = manager.getSelected(AbstractFormatterSelectionBlock.this.fProject).getSettings();
                    InstanceScope context = EclipseUtil.instanceScope();
                    PreferenceKey[] preferenceKeyArray = preferenceKeys;
                    int n = preferenceKeys.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PreferenceKey key = preferenceKeyArray[n2];
                        String name = key.getName();
                        if (defaultSettings.containsKey(name)) {
                            String value = (String)defaultSettings.get(name);
                            activeSettings.put(name, value);
                            key.setStoredValue((IScopeContext)context, value);
                        } else {
                            activeSettings.remove(name);
                        }
                        ++n2;
                    }
                    manager.getSelected(AbstractFormatterSelectionBlock.this.fProject).setSettings(activeSettings);
                    manager.markDirty();
                    AbstractFormatterSelectionBlock.this.applyPreferences();
                }
            }
        });
        IProfileManager profileManager = this.getProfileManager();
        this.fDefaultButton.setEnabled(!profileManager.getSelected(this.fProject).isBuiltInProfile());
        this.configurePreview(this.fComposite, 5);
        this.updateButtons();
        this.applyPreferences(true);
        return this.fComposite;
    }

    protected void createNewProfile(Shell shell) {
        CreateProfileDialog p = new CreateProfileDialog(shell, this.getProfileManager(), this.profileManager.getProfileVersioner(), this.fProject);
        if (p.open() != 0) {
            return;
        }
        this.applyPreferences();
        this.updateComboFromProfiles();
    }

    protected void doImport(Composite group) {
        AlreadyExistsDialog aeDialog;
        IProfileManager profileManager;
        FileDialog dialog = new FileDialog(group.getShell(), 4096);
        dialog.setText(FormatterMessages.AbstractFormatterSelectionBlock_importProfileLabel);
        dialog.setFilterExtensions(new String[]{"*.xml"});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        Collection profiles = null;
        IProfileStore store = this.profileManager.getProfileStore();
        try {
            profiles = store.readProfilesFromFile(file);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)FormatterUIEplPlugin.getDefault(), (String)FormatterMessages.AbstractFormatterSelectionBlock_notValidProfile, (Throwable)e, (String)"com.aptana.formatter.epl/debug");
        }
        if (profiles == null || profiles.isEmpty()) {
            return;
        }
        IProfile profile = (IProfile)profiles.iterator().next();
        IProfileVersioner versioner = this.profileManager.getProfileVersioner();
        if (profile.getVersion() > versioner.getCurrentVersion()) {
            String title = FormatterMessages.AbstractFormatterSelectionBlock_importingProfile;
            String message = FormatterMessages.AbstractFormatterSelectionBlock_moreRecentVersion;
            MessageDialog.openWarning((Shell)group.getShell(), (String)title, (String)message);
        }
        if ((profileManager = this.getProfileManager()).containsName(profile.getName()) && (aeDialog = new AlreadyExistsDialog(group.getShell(), profile, profileManager, this.fProject)).open() != 0) {
            return;
        }
        ((IProfile.ICustomProfile)profile).setVersion(versioner.getCurrentVersion());
        profileManager.addProfile(this.fProject, profile);
        this.updateComboFromProfiles();
        this.applyPreferences();
    }

    private void doExport() {
        IProfileManager manager = this.getProfileManager();
        IProfileStore store = manager.getProfileStore();
        IProfile activeProfile = manager.getSelected(this.fProject);
        IProfile selected = manager.create(this.fProject, ProfileKind.TEMPORARY, activeProfile.getName(), activeProfile.getSettings(), activeProfile.getVersion());
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(FormatterMessages.FormatterModifyDialog_exportProfile);
        dialog.setFilterExtensions(new String[]{"*.xml"});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        String message = NLS.bind((String)FormatterMessages.FormatterModifyDialog_replaceFileQuestion, (Object)file.getAbsolutePath());
        if (file.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)FormatterMessages.FormatterModifyDialog_exportProfile, (String)message)) {
            return;
        }
        ArrayList<IProfile> profiles = new ArrayList<IProfile>();
        profiles.add(selected);
        try {
            store.writeProfilesToFile(profiles, file);
        }
        catch (CoreException e) {
            String title = FormatterMessages.FormatterModifyDialog_exportProfile;
            message = FormatterMessages.FormatterModifyDialog_exportProblem;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
    }

    protected void configurePreview(Composite composite, int numColumns) {
        AbstractFormatterSelectionBlock.createLabel(composite, FormatterMessages.AbstractFormatterSelectionBlock_preview, numColumns);
        Composite previewGroup = new Composite(composite, 0);
        previewGroup.setLayout((Layout)new GridLayout(1, true));
        GridData gd = new GridData(1296);
        gd.horizontalSpan = numColumns;
        previewGroup.setLayoutData((Object)gd);
        SashForm sashForm = new SashForm(previewGroup, 256);
        sashForm.setLayoutData((Object)new GridData(1808));
        final ListViewer listViewer = new ListViewer((Composite)sashForm, 2052);
        listViewer.getControl().setLayoutData((Object)new GridData(1808));
        Composite rightPanel = new Composite((Composite)sashForm, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        rightPanel.setLayout((Layout)layout);
        rightPanel.setLayoutData((Object)new GridData(1808));
        final Composite previewPane = new Composite(rightPanel, 2048);
        GridData previewGridData = new GridData(1808);
        previewGridData.heightHint = 300;
        previewGridData.widthHint = 450;
        previewPane.setLayoutData((Object)previewGridData);
        this.previewStackLayout = new StackLayout();
        previewPane.setLayout((Layout)this.previewStackLayout);
        listViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IScriptFormatterFactory factory = (IScriptFormatterFactory)element;
                return factory.getName();
            }
        });
        listViewer.setInput((Object)this.factories);
        if (selectedFormatter < 0) {
            selectedFormatter = 0;
        }
        listViewer.setSelection((ISelection)new StructuredSelection((Object)this.factories[selectedFormatter]));
        listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                selectedFormatter = listViewer.getList().getSelectionIndex();
                if (selectedFormatter > -1 && selectedFormatter < AbstractFormatterSelectionBlock.this.sourcePreviewViewers.size()) {
                    AbstractFormatterSelectionBlock.this.fSelectedPreviewViewer = (SourceViewer)AbstractFormatterSelectionBlock.this.sourcePreviewViewers.get(selectedFormatter);
                    ((AbstractFormatterSelectionBlock)AbstractFormatterSelectionBlock.this).previewStackLayout.topControl = AbstractFormatterSelectionBlock.this.fSelectedPreviewViewer.getControl();
                    previewPane.layout();
                    AbstractFormatterSelectionBlock.this.updatePreview();
                }
            }
        });
        listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (listViewer.getList().getSelectionIndex() > -1) {
                    AbstractFormatterSelectionBlock.this.editButtonPressed();
                }
            }
        });
        IScriptFormatterFactory[] iScriptFormatterFactoryArray = this.factories;
        int n = this.factories.length;
        int n2 = 0;
        while (n2 < n) {
            IScriptFormatterFactory factory = iScriptFormatterFactoryArray[n2];
            SourceViewer sourcePreview = this.createSourcePreview(previewPane, factory);
            this.sourcePreviewViewers.add(sourcePreview);
            ++n2;
        }
        if (selectedFormatter > -1 && this.sourcePreviewViewers.size() > selectedFormatter) {
            this.fSelectedPreviewViewer = this.sourcePreviewViewers.get(selectedFormatter);
            this.previewStackLayout.topControl = this.fSelectedPreviewViewer.getControl();
            previewPane.layout();
        }
        sashForm.setWeights(new int[]{1, 3});
        this.profileChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("profile.selected".equals(event.getProperty())) {
                    IProfile profile = (IProfile)event.getNewValue();
                    AbstractFormatterSelectionBlock.this.fSelectedPreviewViewer = (SourceViewer)AbstractFormatterSelectionBlock.this.sourcePreviewViewers.get(selectedFormatter);
                    ((AbstractFormatterSelectionBlock)AbstractFormatterSelectionBlock.this).previewStackLayout.topControl = AbstractFormatterSelectionBlock.this.fSelectedPreviewViewer.getControl();
                    previewPane.layout();
                    AbstractFormatterSelectionBlock.this.updatePreview();
                    AbstractFormatterSelectionBlock.this.fDefaultButton.setEnabled(!profile.isBuiltInProfile());
                }
            }
        };
        this.profileManager.addPropertyChangeListener(this.profileChangeListener);
    }

    @Override
    public void dispose() {
        if (this.profileChangeListener != null) {
            IProfileManager profileManager = this.getProfileManager();
            profileManager.removePropertyChangeListener(this.profileChangeListener);
        }
        super.dispose();
    }

    protected IScriptFormatterFactory getSelectedFormatter() {
        if (selectedFormatter < 0 || selectedFormatter >= this.factories.length) {
            return null;
        }
        return this.factories[selectedFormatter];
    }

    protected final void updateSelection() {
        IProfile selected = (IProfile)this.getProfileManager().getSortedProfiles().get(this.fProfileCombo.getSelectionIndex());
        this.getProfileManager().setSelected(this.fProject, selected);
        this.updateButtons();
        this.applyPreferences();
        this.updatePreview();
    }

    protected void editButtonPressed() {
        IScriptFormatterFactory factory = this.getSelectedFormatter();
        if (factory != null) {
            IProfileManager manager = this.getProfileManager();
            IFormatterModifyDialog dialog = factory.createDialog(this.createDialogOwner(factory));
            if (dialog != null) {
                IProfile profile = manager.getSelected(this.fProject);
                String title = NLS.bind((String)FormatterMessages.FormatterModifyDialog_dialogTitle, (Object)factory.getName(), (Object)profile.getName());
                dialog.setProfileManager(manager, title);
                dialog.setPreferences(profile.getSettings());
                if (dialog.open() == 0) {
                    profile = manager.getSelected(this.fProject);
                    this.updateComboFromProfiles();
                    Map newSettings = dialog.getPreferences();
                    if (!profile.getSettings().equals(newSettings)) {
                        profile.setSettings(newSettings);
                        manager.markDirty();
                        this.applyPreferences();
                    }
                }
            }
        }
    }

    protected void updateComboFromProfiles() {
        if (this.fProfileCombo != null && !this.fProfileCombo.isDisposed()) {
            this.fProfileCombo.removeAll();
            List profiles = this.getProfileManager().getSortedProfiles();
            IProfile selected = this.getProfileManager().getSelected(this.fProject);
            int selection = 0;
            int index = 0;
            for (IProfile profile : profiles) {
                this.fProfileCombo.add(profile.getName());
                if (profile.equals(selected)) {
                    selection = index;
                }
                ++index;
            }
            this.fProfileCombo.select(selection);
            this.updateButtons();
        }
    }

    protected void updateButtons() {
        if (this.fDeleteButton != null && !this.fDeleteButton.isDisposed()) {
            IProfile selected = this.getProfileManager().getSelected(this.fProject);
            this.fDeleteButton.setEnabled(selected != null && !selected.isBuiltInProfile());
        }
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private static Combo createProfileCombo(Composite composite, int span, int widthHint) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        gd.widthHint = widthHint;
        Combo combo = new Combo(composite, 12);
        combo.setFont(composite.getFont());
        combo.setLayoutData((Object)gd);
        return combo;
    }

    private static Button createButton(Composite composite, int style) {
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        GridData gd = new GridData(style);
        button.setLayoutData((Object)gd);
        return button;
    }

    protected static Label createLabel(Composite composite, String text, int numColumns) {
        return AbstractFormatterSelectionBlock.createLabel(composite, text, numColumns, false);
    }

    protected static Label createLabel(Composite composite, String text, int numColumns, boolean wrap) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        if (wrap) {
            gd.heightHint = new PixelConverter((Control)composite).convertHeightInCharsToPixels(2);
        }
        Label label = new Label(composite, wrap ? 64 : 0);
        label.setFont(composite.getFont());
        label.setText(text);
        label.setLayoutData((Object)gd);
        return label;
    }

    private class SaveDelegate
    implements IPreferencesSaveDelegate {
        private SaveDelegate() {
        }

        public void setBoolean(String qualifier, String key, boolean value) {
            AbstractFormatterSelectionBlock.this.setValue(new PreferenceKey(qualifier, key), value);
        }

        public void setInt(String qualifier, String key, int value) {
            AbstractFormatterSelectionBlock.this.setValue(new PreferenceKey(qualifier, key), String.valueOf(value));
        }

        public void setString(String qualifier, String key, String value) {
            AbstractFormatterSelectionBlock.this.setValue(new PreferenceKey(qualifier, key), value);
        }
    }
}

