/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.ui.preferences;

import com.aptana.editor.common.ExtendedFastPartitioner;
import com.aptana.editor.common.IExtendedPartitioner;
import com.aptana.editor.common.IPartitionerSwitchStrategy;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.NullPartitionerSwitchStrategy;
import com.aptana.editor.common.text.rules.CompositePartitionScanner;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.NullSubPartitionScanner;
import com.aptana.formatter.ContributionExtensionManager;
import com.aptana.formatter.IScriptFormatterFactory;
import com.aptana.formatter.ScriptFormatterManager;
import com.aptana.formatter.preferences.profile.IProfileManager;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.formatter.ui.IFormatterModifyDialogOwner;
import com.aptana.formatter.ui.preferences.AbstractConfigurationBlockPropertyAndPreferencePage;
import com.aptana.formatter.ui.preferences.AbstractFormatterSelectionBlock;
import com.aptana.formatter.ui.preferences.AbstractOptionsBlock;
import com.aptana.formatter.ui.preferences.FormatterPreviewUtils;
import com.aptana.formatter.ui.preferences.ScriptSourcePreviewerUpdater;
import com.aptana.formatter.ui.util.IStatusChangeListener;
import com.aptana.theme.ColorManager;
import com.aptana.theme.ThemePlugin;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public abstract class AbstractFormatterPreferencePage
extends AbstractConfigurationBlockPropertyAndPreferencePage {
    public static final String ID = "com.aptana.formatter.common";
    private static final Job[] NO_BUILD_JOBS = new Job[0];

    @Override
    protected AbstractOptionsBlock createOptionsBlock(IStatusChangeListener newStatusChangedListener, IProject project, IWorkbenchPreferenceContainer container) {
        return new FormatterSelectionBlock(newStatusChangedListener, project, container);
    }

    protected abstract IDialogSettings getDialogSettings();

    @Override
    protected String getHelpId() {
        return null;
    }

    @Override
    protected void setDescription() {
    }

    @Override
    protected String getPreferencePageId() {
        return ID;
    }

    @Override
    protected String getProjectHelpId() {
        return null;
    }

    @Override
    protected String getPropertyPageId() {
        return null;
    }

    protected class FormatterSelectionBlock
    extends AbstractFormatterSelectionBlock {
        private ISharedTextColors fColorManager;

        public FormatterSelectionBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
            super(context, project, container);
            this.fColorManager = new ColorManager();
        }

        @Override
        public void dispose() {
            this.fColorManager.dispose();
            super.dispose();
        }

        @Override
        protected ContributionExtensionManager getExtensionManager() {
            return ScriptFormatterManager.getInstance();
        }

        @Override
        protected IFormatterModifyDialogOwner createDialogOwner(IScriptFormatterFactory formatter) {
            return new FormatterModifyDialogOwner(formatter);
        }

        @Override
        public SourceViewer createSourcePreview(Composite composite, IScriptFormatterFactory factory) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{factory.getPreferenceStore(), generalTextStore});
            ProjectionViewer fPreviewViewer = this.createPreviewViewer(composite, null, null, false, 2816, (IPreferenceStore)store);
            if (fPreviewViewer == null) {
                return null;
            }
            SourceViewerConfiguration configuration = factory.createSimpleSourceViewerConfiguration(this.fColorManager, (IPreferenceStore)store, null, false);
            fPreviewViewer.configure(configuration);
            if (fPreviewViewer.getTextWidget().getTabs() == 0) {
                fPreviewViewer.getTextWidget().setTabs(4);
            }
            new ScriptSourcePreviewerUpdater((SourceViewer)fPreviewViewer, configuration, (IPreferenceStore)store);
            fPreviewViewer.setEditable(false);
            Document document = new Document();
            fPreviewViewer.setDocument((IDocument)document);
            IPartitioningConfiguration partitioningConfiguration = (IPartitioningConfiguration)factory.getPartitioningConfiguration();
            CompositePartitionScanner partitionScanner = new CompositePartitionScanner(partitioningConfiguration.createSubPartitionScanner(), (ISubPartitionScanner)new NullSubPartitionScanner(), (IPartitionerSwitchStrategy)new NullPartitionerSwitchStrategy());
            ExtendedFastPartitioner partitioner = new ExtendedFastPartitioner((IPartitionTokenScanner)partitionScanner, partitioningConfiguration.getContentTypes());
            partitionScanner.setPartitioner((IExtendedPartitioner)partitioner);
            partitioner.connect((IDocument)document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
            return fPreviewViewer;
        }

        private ProjectionViewer createPreviewViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, IPreferenceStore store) {
            ProjectionViewer viewer = new ProjectionViewer(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
            ThemePlugin.getDefault().getControlThemerFactory().apply((Viewer)viewer);
            return viewer;
        }

        @Override
        protected String getPreferenceLinkMessage() {
            return FormatterMessages.FormatterPreferencePage_settingsLink;
        }

        @Override
        protected void updatePreview() {
            if (this.fSelectedPreviewViewer != null) {
                IScriptFormatterFactory factory = this.getSelectedFormatter();
                IProfileManager manager = this.getProfileManager();
                FormatterPreviewUtils.updatePreview((ISourceViewer)this.fSelectedPreviewViewer, factory.getPreviewContent(), null, factory, (Map<String, String>)manager.getSelected(this.fProject).getSettings());
            }
        }

        @Override
        protected Job[] createBuildJobs(IProject project) {
            return NO_BUILD_JOBS;
        }

        private class FormatterModifyDialogOwner
        implements IFormatterModifyDialogOwner {
            private final IScriptFormatterFactory formatter;

            public FormatterModifyDialogOwner(IScriptFormatterFactory formatter) {
                this.formatter = formatter;
            }

            public ISourceViewer createPreview(Composite composite) {
                return FormatterSelectionBlock.this.createSourcePreview(composite, this.formatter);
            }

            public Shell getShell() {
                return AbstractFormatterPreferencePage.this.getShell();
            }

            public IDialogSettings getDialogSettings() {
                return AbstractFormatterPreferencePage.this.getDialogSettings();
            }

            public IProject getProject() {
                return FormatterSelectionBlock.this.fProject;
            }
        }
    }
}

