/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.view.browser.views;

import com.pandora.cef3.CEF3Browser;
import com.pandora.cef3.listener.ConsoleMessageEvent;
import com.pandora.cef3.listener.ConsoleMessageListener;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import com.pandora.core.utils.EclipseUtil;
import com.pandora.core.utils.ResourceUtil;
import com.pandora.view.browser.BrowserActivator;
import com.pandora.view.browser.console.WebConsole;
import com.pandora.view.browser.console.WebConsoleFactory;
import com.pandora.view.browser.preferences.BrowserScreenSize;
import com.pandora.view.browser.preferences.BrowserScreenSizeManager;
import com.pandora.view.browser.views.BrowserComposite;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.part.ViewPart;
import org.osgi.service.prefs.BackingStoreException;

public class WebBrowserView
extends ViewPart {
    public static final String VIEW_ID = "com.pandora.view.browser.view.WebBrowserView";
    public static final String PREFERENCE_BROWSER_SCREEN_SIZE = "BROWSER_SCREEN_SIZE";
    private BrowserComposite browserComposite;

    public void createPartControl(Composite parent) {
        this.browserComposite = new BrowserComposite(parent, 0, WebBrowserView.getBrowserScreenSizeConfig());
        Control browser = this.browserComposite.getBrowser();
        this.browserComposite.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                WebBrowserView.this.setTitleToolTip(event.title);
            }
        });
        this.browserComposite.setScreenSizeListener(new BrowserComposite.IScreenSizeListener(){

            @Override
            public void change(BrowserScreenSize browserScreenSize) {
                WebBrowserView.saveBrowserScreenSizeConfig(browserScreenSize);
            }
        });
        this.browserComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IPerspectiveDescriptor web;
                IPerspectiveDescriptor pd;
                IWorkbenchPage page;
                IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (win != null && (page = win.getActivePage()) != null && (pd = page.getPerspective()) != null && "com.aptana.ui.RealTimePerspective".equals(pd.getId()) && (web = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId("com.aptana.ui.WebPerspective")) != null) {
                    page.setPerspective(web);
                }
            }
        });
        if (browser instanceof CEF3Browser) {
            ((CEF3Browser)browser).addConsoleMessageListener(new ConsoleMessageListener(){

                public void onConsoleMessage(ConsoleMessageEvent event) {
                    try {
                        WebConsole messageConsole;
                        boolean isApplicationConsoleShow = false;
                        IConsole[] consles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
                        if (consles != null && consles.length > 0) {
                            IConsole[] iConsoleArray = consles;
                            int n = consles.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IConsole console = iConsoleArray[n2];
                                if (console.getName().contains("\u8fd0\u884c\u4e8e")) {
                                    isApplicationConsoleShow = true;
                                    break;
                                }
                                ++n2;
                            }
                        }
                        WebConsoleFactory webConsoleFactory = new WebConsoleFactory();
                        if (!isApplicationConsoleShow) {
                            webConsoleFactory.openConsole();
                        }
                        if ((messageConsole = webConsoleFactory.getConsole(true, !isApplicationConsoleShow)) != null && event.source != null) {
                            URI source = new URI(event.source);
                            IFile file = ResourceUtil.getIFileFromURL((URI)source);
                            String path = file != null && file.exists() ? source.getPath() : event.source;
                            String format = "[%s] \"%s\"\t%s (%d)";
                            String msg = String.format(format, WebBrowserView.this.getPartName(), event.message, path, event.line);
                            msg = msg.replace(": plus is not defined", ": plus is not defined (\u63d0\u793a: plus api\u53ea\u80fd\u5728\u624b\u673aapp\u91cc\u8fd0\u884c)");
                            if (event.message.startsWith("Uncaught ") && !messageConsole.getErrorConsoleStream().isClosed()) {
                                messageConsole.getErrorConsoleStream().println(msg);
                            } else if (!messageConsole.getOutputConsoleStream().isClosed()) {
                                messageConsole.getOutputConsoleStream().println(msg);
                            }
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {
                    }
                    catch (Throwable e) {
                        HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                    }
                }
            });
        }
    }

    public void setFocus() {
        this.browserComposite.setFocus();
    }

    private IProgressMonitor getProgressMonitor() {
        IStatusLineManager statusManager = this.getViewSite().getActionBars().getStatusLineManager();
        return statusManager.getProgressMonitor();
    }

    public BrowserComposite getWebBrowserViewer() {
        return this.browserComposite;
    }

    public void setURL(String url) {
        this.browserComposite.setURL(url);
    }

    public static void setBrowserScreenSizeConfig(String name) {
        final BrowserScreenSize browserScreenSize = BrowserScreenSizeManager.getInstance().getBrowserScreenSizeByName(name);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BrowserComposite browserComposite = BrowserActivator.getBrowserViewer();
                if (browserComposite != null) {
                    browserComposite.setBrowserScreen(browserScreenSize);
                } else {
                    WebBrowserView.saveBrowserScreenSizeConfig(browserScreenSize);
                }
            }
        });
    }

    private static BrowserScreenSize getBrowserScreenSizeConfig() {
        String name = EclipseUtil.instanceScope().getNode("com.pandora.view.browser").get(PREFERENCE_BROWSER_SCREEN_SIZE, null);
        if (name == null) {
            return null;
        }
        return BrowserScreenSizeManager.getInstance().getBrowserScreenSizeByName(name);
    }

    private static void saveBrowserScreenSizeConfig(BrowserScreenSize size) {
        IEclipsePreferences preferences = EclipseUtil.instanceScope().getNode("com.pandora.view.browser");
        if (size == null) {
            preferences.remove(PREFERENCE_BROWSER_SCREEN_SIZE);
        } else {
            preferences.put(PREFERENCE_BROWSER_SCREEN_SIZE, size.getName());
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    public void dispose() {
        this.getProgressMonitor().done();
        super.dispose();
    }
}

