/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.view.browser.views;

import com.pandora.cef3.BrowserFunctionCallback;
import com.pandora.cef3.CEF3Browser;
import com.pandora.cef3.OpenWindowEvent;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.view.browser.BrowserActivator;
import com.pandora.view.browser.ImageManager;
import com.pandora.view.browser.preferences.BrowserScreenSize;
import com.pandora.view.browser.preferences.BrowserScreenSizeDialog;
import com.pandora.view.browser.preferences.BrowserScreenSizeManager;
import com.pandora.view.browser.qr.QRShower;
import com.pandora.view.browser.views.Messages;
import java.net.URL;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.WorkbenchWindow;

public class BrowserComposite
extends Composite {
    private static final String RUNINBROWSER_PAGE_ID = "com.pandora.ui.preferences.webservers";
    private static final String SERVER_PAGE_ID = "com.pandora.webserver.preferences.servers";
    private static final String LOCAL_PAGE_ID = "com.pandora.webserver.preferences.servers.local";
    public static final int DISABLE_NAVTOOL_BAR = 2;
    public static final int DISABLE_DEVTOOL_BAR = 4;
    public static final int AUTO_OPEN_HIDDEN_DEVTOOL = 8;
    public static String BLANK_HTML_FILE = "";
    private boolean hasInitWithBlank;
    private ToolBarManager toolBarManager;
    private Combo urlCombo;
    private boolean loadInProgress = false;
    private boolean newWindow;
    private boolean locked;
    private boolean disableNavToolBAR = false;
    private boolean disableDevToolBAR = false;
    private Composite backgroundComposite;
    private Composite browserCompositeContainer;
    private BrowserScreenSize currentBrowserScreenSize;
    private int progressWorked;
    private CEF3Browser cefBrowser;
    private Browser browser;
    ToolBar toolbarBeforeURL;
    ToolBar toolbarAfterURL;
    private IAction consoleTool;
    private IAction goTool;
    private IAction forwardTool;
    private IAction stopTool;
    private IAction backTool;
    private IAction refreshTool;
    private IAction qrCodeTool;
    private IAction lockTool;
    private IScreenSizeListener screenSizeListener;

    public BrowserComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public BrowserComposite(Composite parent, int style, BrowserScreenSize browserScreenSize) {
        super(parent, 0);
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.currentBrowserScreenSize = browserScreenSize;
        this.disableNavToolBAR = (style & 2) != 0;
        this.disableDevToolBAR = (style & 4) != 0 || !this.supportCEF();
        this.backgroundComposite = new Composite((Composite)this, 0);
        this.backgroundComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.backgroundComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        if (!this.disableNavToolBAR) {
            Composite contain = new Composite(this.backgroundComposite, 0);
            contain.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
            contain.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).create());
            this.createActions();
            this.createNavBar(contain);
            this.createNavigationBar(contain);
        }
        ProgressListener progressListener = new ProgressListener(){

            public void changed(ProgressEvent event) {
                if (!BrowserComposite.this.loadInProgress && event.current < event.total) {
                    BrowserComposite.this.loadInProgress = true;
                    BrowserComposite.this.updateNavButtons();
                }
            }

            public void completed(ProgressEvent event) {
                BrowserComposite.this.loadInProgress = false;
                BrowserComposite.this.updateNavButtons();
            }
        };
        LocationAdapter locationAdapter = new LocationAdapter(){

            public void changed(LocationEvent event) {
                if (event.top) {
                    String url = event.location;
                    if (!(BrowserComposite.this.disableNavToolBAR || !StringUtil.isNotBlank((String)url) || "data:text/html,chromewebdata".equals(url) || BrowserComposite.this.isBlank(url) || url.equals(BrowserComposite.this.urlCombo.getText()))) {
                        BrowserComposite.this.urlCombo.setText(url);
                    }
                }
            }
        };
        OpenWindowListener openWindowListener = new OpenWindowListener(){

            public void open(WindowEvent event) {
                if (event instanceof OpenWindowEvent) {
                    Shell subShell = new Shell(BrowserComposite.this.getShell(), 1264);
                    subShell.setLayout((Layout)new FillLayout());
                    subShell.setText(Messages.BrowserComposite_Title);
                    subShell.setImage(BrowserComposite.this.getShell().getImage());
                    if (event.location != null) {
                        subShell.setLocation(event.location);
                    }
                    if (event.size != null) {
                        subShell.setSize(event.size);
                    }
                    subShell.setVisible(true);
                    BrowserComposite subBrowser = new BrowserComposite((Composite)subShell, 2);
                    subBrowser.setURL(((OpenWindowEvent)event).location);
                    subShell.layout();
                    subBrowser.newWindow = true;
                    if (event instanceof OpenWindowEvent) {
                        ((OpenWindowEvent)event).browser = subBrowser.cefBrowser;
                    } else {
                        event.browser = (Browser)subBrowser.getBrowser();
                    }
                }
            }
        };
        CloseWindowListener closeWindowListener = new CloseWindowListener(){

            public void close(WindowEvent event) {
                if (BrowserComposite.this.newWindow) {
                    BrowserComposite.this.getShell().dispose();
                }
            }
        };
        Composite container = new Composite(this.backgroundComposite, 0);
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        container.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.browserCompositeContainer = new Composite(container, 0);
        this.browserCompositeContainer.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.browserCompositeContainer.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        if (this.supportCEF()) {
            this.cefBrowser = new CEF3Browser(this.browserCompositeContainer, 0, this.currentBrowserScreenSize == null ? null : this.currentBrowserScreenSize.toDeviceScreen());
            this.cefBrowser.setEnableDevTools(!this.disableDevToolBAR);
            this.cefBrowser.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
            this.cefBrowser.addProgressListener(progressListener);
            this.cefBrowser.addLocationListener((LocationListener)locationAdapter);
            this.cefBrowser.addOpenWindowListener(openWindowListener);
            this.cefBrowser.addCloseWindowListener(closeWindowListener);
        } else {
            this.setBrowserCompositeSize(this.currentBrowserScreenSize, false);
            this.browser = new Browser(this.browserCompositeContainer, 0);
            this.browser.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
            this.browser.addProgressListener(progressListener);
            this.browser.addLocationListener((LocationListener)locationAdapter);
            this.browser.addOpenWindowListener(openWindowListener);
            this.browser.addCloseWindowListener(closeWindowListener);
        }
        this.updateNavButtons();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BrowserComposite.this.dispose();
            }
        });
        this.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
                if (event.total == 0 || BrowserComposite.this.urlCombo != null && StringUtil.isBlank((String)BrowserComposite.this.urlCombo.getText())) {
                    return;
                }
                IProgressMonitor progressMonitor = BrowserComposite.this.getProgressMonitor();
                if (event.current == 0) {
                    if (progressMonitor != null) {
                        progressMonitor.done();
                        progressMonitor.beginTask("\u6b63\u5728\u52a0\u8f7d:  " + BrowserComposite.this.getLoadingURL(), event.total);
                    }
                    BrowserComposite.this.progressWorked = 0;
                }
                if (BrowserComposite.this.progressWorked < event.current) {
                    if (progressMonitor != null) {
                        progressMonitor.worked(event.current - BrowserComposite.this.progressWorked);
                    }
                    BrowserComposite.this.progressWorked = event.current;
                }
            }

            public void completed(ProgressEvent event) {
                IProgressMonitor progressMonitor = BrowserComposite.this.getProgressMonitor();
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        IProgressMonitor progressMonitor = this.getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.done();
        }
        if (this.cefBrowser != null) {
            this.cefBrowser.dispose();
        } else {
            this.browser.dispose();
        }
    }

    private IProgressMonitor getProgressMonitor() {
        try {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (workbenchWindow != null) {
                IStatusLineManager statusManager = workbenchWindow.getActionBars().getStatusLineManager();
                return statusManager.getProgressMonitor();
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e);
        }
        return null;
    }

    public boolean execute(String script) {
        if (this.cefBrowser != null) {
            return this.cefBrowser.execute(script);
        }
        return this.browser.execute(script);
    }

    public void setBrowserScreen(BrowserScreenSize screenSize) {
        if (Objects.equals(this.currentBrowserScreenSize, screenSize)) {
            return;
        }
        if (this.supportCEF()) {
            this.cefBrowser.setDeviceScreen(screenSize == null ? null : screenSize.toDeviceScreen(), false);
        } else {
            this.setBrowserCompositeSize(screenSize, true);
        }
        this.currentBrowserScreenSize = screenSize;
        if (this.screenSizeListener != null) {
            this.screenSizeListener.change(screenSize);
        }
    }

    public BrowserScreenSize getBrowserScreen() {
        return this.currentBrowserScreenSize;
    }

    private void setBrowserCompositeSize(BrowserScreenSize screenSize, boolean layout) {
        if (screenSize == null) {
            this.browserCompositeContainer.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        } else {
            this.browserCompositeContainer.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).hint(screenSize.getWidth(), screenSize.getHeight()).create());
        }
        if (layout) {
            this.browserCompositeContainer.getParent().layout();
        }
    }

    private void addBrowserScrrenSize() {
        BrowserScreenSize result;
        BrowserScreenSizeDialog dialog = new BrowserScreenSizeDialog(this.getShell(), true);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null) {
            BrowserScreenSizeManager.getInstance().addBrowserScreenSize(result);
            this.setBrowserScreen(result);
        }
    }

    private void createNavBar(Composite parent) {
        final MenuManager menuManager = new MenuManager("BrowserNavBarMenu", "BrowserNavBarMenu");
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IPreferenceNode[] subs;
                manager.removeAll();
                menuManager.add((IAction)new Action(Messages.BrowserComposite_LBL_FullEditor, 2){

                    public void run() {
                        BrowserComposite.this.setBrowserScreen(null);
                    }

                    public boolean isChecked() {
                        return BrowserComposite.this.currentBrowserScreenSize == null;
                    }
                });
                Set<BrowserScreenSize> browserScreenSizes = BrowserScreenSizeManager.getInstance().getAllBrowserScreenSize();
                Iterator<BrowserScreenSize> iterator = browserScreenSizes.iterator();
                while (iterator.hasNext()) {
                    BrowserScreenSize screenSize;
                    final BrowserScreenSize screenSizef = screenSize = iterator.next();
                    menuManager.add((IAction)new Action(screenSizef.toString(), 2){

                        public void run() {
                            BrowserComposite.this.setBrowserScreen(screenSizef);
                        }

                        public boolean isChecked() {
                            return BrowserComposite.this.currentBrowserScreenSize != null && BrowserComposite.this.currentBrowserScreenSize.toString().equals(screenSizef.toString());
                        }
                    });
                }
                menuManager.add((IAction)new Action(Messages.BrowserComposite_LBL_SetSize){

                    public void run() {
                        BrowserComposite.this.addBrowserScrrenSize();
                    }
                });
                menuManager.add((IContributionItem)new Separator());
                IPreferenceNode[] iPreferenceNodeArray = subs = PlatformUI.getWorkbench().getPreferenceManager().getRootSubNodes();
                int n = subs.length;
                int n2 = 0;
                while (n2 < n) {
                    IPreferenceNode sub = iPreferenceNodeArray[n2];
                    if (sub.findSubNode(BrowserComposite.RUNINBROWSER_PAGE_ID) != null) {
                        menuManager.add((IAction)new Action("\u8bbe\u7f6eweb\u670d\u52a1\u5668..."){

                            public void run() {
                                PreferenceDialog p = PreferencesUtil.createPreferenceDialogOn((Shell)BrowserComposite.this.getShell(), (String)BrowserComposite.RUNINBROWSER_PAGE_ID, (String[])new String[]{BrowserComposite.RUNINBROWSER_PAGE_ID, BrowserComposite.SERVER_PAGE_ID, BrowserComposite.LOCAL_PAGE_ID}, null);
                                p.open();
                            }
                        });
                        break;
                    }
                    ++n2;
                }
            }
        });
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        Action action = new Action(Messages.BrowserComposite_LBL_Config, 4){

            public void run() {
            }
        };
        action.setImageDescriptor(ImageManager.getImageDescriptor("IMG_COMMAND"));
        action.setMenuCreator(new IMenuCreator(){

            public void dispose() {
            }

            public Menu getMenu(Control parent) {
                return menuManager.createContextMenu(parent);
            }

            public Menu getMenu(Menu parent) {
                return null;
            }
        });
        toolBarManager.add((IAction)action);
        ToolBar sizeToolBar = toolBarManager.createControl(parent);
        sizeToolBar.setLayoutData((Object)GridDataFactory.fillDefaults().create());
    }

    private void createNavigationBar(Composite parent) {
        this.toolBarManager = new ToolBarManager(0x800000);
        if (!this.disableDevToolBAR) {
            this.toolBarManager.add(this.consoleTool);
        }
        this.toolBarManager.add(this.backTool);
        this.toolBarManager.add(this.forwardTool);
        this.toolBarManager.add(this.stopTool);
        this.toolBarManager.add(this.refreshTool);
        this.toolbarBeforeURL = this.toolBarManager.createControl(parent);
        this.toolbarBeforeURL.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.urlCombo = new Combo(parent, 4);
        this.urlCombo.setLayoutData((Object)GridDataFactory.fillDefaults().minSize(50, -1).grab(true, false).create());
        this.urlCombo.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                BrowserComposite.this.setURL(BrowserComposite.this.urlCombo.getText());
            }
        });
        ToolBarManager toolBarManager2 = new ToolBarManager(0x800000);
        toolBarManager2.add(this.qrCodeTool);
        toolBarManager2.add(this.lockTool);
        toolBarManager2.add(this.goTool);
        this.toolbarAfterURL = toolBarManager2.createControl(parent);
        this.toolbarAfterURL.setLayoutData((Object)GridDataFactory.fillDefaults().create());
    }

    private void createActions() {
        if (!this.disableDevToolBAR) {
            this.consoleTool = new Action("\u6253\u5f00Chrome\u63a7\u5236\u53f0"){
                {
                    this.setToolTipText("\u6253\u5f00Chrome\u63a7\u5236\u53f0");
                    this.setImageDescriptor(ImageManager.getImageDescriptor("IMG_CONSOLE"));
                }

                public void run() {
                    BrowserComposite.this.openDevTools();
                }
            };
        }
        this.qrCodeTool = new Action("\u5f53\u524d\u7f51\u5740\u4e8c\u7ef4\u7801"){
            private QRShower qrCodeImage;
            {
                this.setToolTipText("\u663e\u793a\u5f53\u524d\u7f51\u5740\u4e8c\u7ef4\u7801");
                this.setImageDescriptor(ImageManager.getImageDescriptor("IMG_QR"));
                this.qrCodeImage = new QRShower(BrowserComposite.this.getShell());
            }

            public void run() {
                Rectangle rectangle = BrowserComposite.this.toolbarAfterURL.getItem(0).getBounds();
                Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height);
                point = BrowserComposite.this.toolbarAfterURL.toDisplay(point);
                this.qrCodeImage.run(BrowserComposite.this.getURL(), point);
            }
        };
        this.lockTool = new Action("\u9501\u5b9a\u5f53\u524d\u7f51\u5740", 2){
            {
                this.setToolTipText("\u9501\u5b9a\u5f53\u524d\u7f51\u5740, \u4e0d\u968f\u7f16\u8f91\u5668\u81ea\u52a8\u5207\u6362");
                this.setImageDescriptor(ImageManager.getImageDescriptor("IMG_UNLOCK"));
            }

            public void run() {
                BrowserComposite.this.locked = !BrowserComposite.this.locked;
                if (BrowserComposite.this.locked) {
                    this.setToolTipText("\u4e0d\u518d\u9501\u5b9a\u7f51\u5740, \u7f51\u5740\u968f\u7f16\u8f91\u5668\u81ea\u52a8\u5207\u6362");
                    BrowserComposite.this.lockTool.setImageDescriptor(ImageManager.getImageDescriptor("IMG_LOCK"));
                } else {
                    this.setToolTipText("\u9501\u5b9a\u5f53\u524d\u7f51\u5740, \u4e0d\u968f\u7f16\u8f91\u5668\u81ea\u52a8\u5207\u6362");
                    BrowserComposite.this.lockTool.setImageDescriptor(ImageManager.getImageDescriptor("IMG_UNLOCK"));
                }
            }
        };
        this.backTool = new Action(Messages.BrowserComposite_LBL_Back){
            {
                this.setToolTipText(Messages.BrowserComposite_TTP_Back);
                this.setImageDescriptor(ImageManager.getImageDescriptor("IMG_BACKWARD"));
            }

            public void run() {
                BrowserComposite.this.back();
            }
        };
        this.forwardTool = new Action(Messages.BrowserComposite_LBL_Forward){
            {
                this.setToolTipText(Messages.BrowserComposite_TTP_Forward);
                this.setImageDescriptor(ImageManager.getImageDescriptor("IMG_FORWARD"));
            }

            public void run() {
                BrowserComposite.this.forward();
            }
        };
        this.stopTool = new Action(Messages.BrowserComposite_LBL_Stop){
            {
                this.setToolTipText(Messages.BrowserComposite_TTP_Stop);
                this.setImageDescriptor(ImageManager.getImageDescriptor("IMG_STOP"));
            }

            public void run() {
                BrowserComposite.this.stop();
            }
        };
        this.refreshTool = new Action("\u5237\u65b0"){
            {
                this.setToolTipText(Messages.BrowserComposite_TTP_Refresh);
                this.setImageDescriptor(ImageManager.getImageDescriptor("IMG_REFRESH"));
            }

            public void run() {
                BrowserComposite.this.refresh();
            }
        };
        this.goTool = new Action(Messages.BrowserComposite_LBL_Go){
            {
                this.setToolTipText(Messages.BrowserComposite_TTP_Go);
                this.setImageDescriptor(ImageManager.getImageDescriptor("IMG_GO"));
            }

            public void run() {
                if (BrowserComposite.this.cefBrowser != null) {
                    BrowserComposite.this.cefBrowser.setUrl(BrowserComposite.this.urlCombo.getText());
                } else {
                    BrowserComposite.this.browser.setUrl(BrowserComposite.this.urlCombo.getText());
                }
            }
        };
    }

    private void updateNavButtons() {
        if (!this.disableNavToolBAR) {
            if (this.cefBrowser != null) {
                if (!this.isBlank(this.cefBrowser.getUrl())) {
                    this.backTool.setEnabled(!this.loadInProgress && this.cefBrowser.isBackEnabled());
                    this.forwardTool.setEnabled(!this.loadInProgress && this.cefBrowser.isForwardEnabled());
                    if (!this.disableDevToolBAR) {
                        this.consoleTool.setEnabled(this.cefBrowser.getCefBrowser() != null);
                    }
                    this.qrCodeTool.setEnabled(StringUtil.isNotBlank((String)this.cefBrowser.getUrl()));
                    this.lockTool.setEnabled(StringUtil.isNotBlank((String)this.cefBrowser.getUrl()));
                    this.refreshTool.setEnabled(StringUtil.isNotBlank((String)this.cefBrowser.getUrl()));
                    this.stopTool.setEnabled(this.loadInProgress);
                }
            } else {
                this.backTool.setEnabled(this.browser.isBackEnabled());
                this.forwardTool.setEnabled(this.browser.isForwardEnabled());
                this.qrCodeTool.setEnabled(StringUtil.isNotBlank((String)this.browser.getUrl()));
                this.lockTool.setEnabled(StringUtil.isNotBlank((String)this.browser.getUrl()));
                this.refreshTool.setEnabled(StringUtil.isNotBlank((String)this.browser.getUrl()));
                this.stopTool.setEnabled(this.loadInProgress);
            }
        }
    }

    public boolean setFocus() {
        if (this.cefBrowser != null) {
            return this.cefBrowser.setFocus();
        }
        return this.browser.setFocus();
    }

    public Control getBrowser() {
        if (this.cefBrowser != null) {
            return this.cefBrowser;
        }
        return this.browser;
    }

    public boolean setText(String html) {
        if (this.cefBrowser != null) {
            return this.cefBrowser.setText(html);
        }
        return this.browser.setText(html);
    }

    public boolean setURL(String url) {
        return this.setURL(url, false);
    }

    public void initWithBlank() {
        try {
            if (this.hasInitWithBlank) {
                return;
            }
            this.hasInitWithBlank = true;
            if (this.supportCEF() && StringUtil.isBlank((String)this.getURL())) {
                if (StringUtil.isEmpty((String)BLANK_HTML_FILE)) {
                    URL url = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("blank.html"));
                    BLANK_HTML_FILE = url.toString();
                }
                this.cefBrowser.setUrl(BLANK_HTML_FILE);
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    private boolean isBlank(String url) {
        return StringUtil.isNotBlank((String)BLANK_HTML_FILE) && url.replace("///", "/").endsWith(BLANK_HTML_FILE);
    }

    public boolean setURL(String url, boolean force) {
        if (url == null) {
            return false;
        }
        if (!force && this.isLocked() && StringUtil.isNotBlank((String)this.getURL())) {
            return false;
        }
        if (!this.disableNavToolBAR) {
            this.urlCombo.setText(url);
        }
        if (this.cefBrowser != null) {
            return this.cefBrowser.setUrl(url);
        }
        return this.browser.setUrl(url);
    }

    public String getURL() {
        if (!this.disableNavToolBAR) {
            return this.urlCombo.getText();
        }
        if (this.cefBrowser != null) {
            return this.cefBrowser.getUrl();
        }
        return this.browser.getUrl();
    }

    public String getRealURL() {
        if (this.cefBrowser != null) {
            if (this.cefBrowser.isloading() || this.disableNavToolBAR) {
                return this.cefBrowser.getUrl();
            }
        } else {
            return this.browser.getUrl();
        }
        return this.urlCombo.getText();
    }

    public String getLoadingURL() {
        if (this.cefBrowser != null) {
            if (this.cefBrowser.isloading() || this.disableNavToolBAR) {
                if (this.cefBrowser.getLoadingURL() != null) {
                    return this.cefBrowser.getLoadingURL();
                }
                return this.cefBrowser.getUrl();
            }
        } else {
            return this.browser.getUrl();
        }
        return this.urlCombo.getText();
    }

    public void refresh() {
        if (this.cefBrowser != null) {
            this.cefBrowser.refresh();
        } else {
            this.browser.refresh();
        }
    }

    public void addFocusListener(FocusListener listener) {
        super.addFocusListener(listener);
        if (this.cefBrowser != null) {
            this.cefBrowser.addFocusListener(listener);
        } else {
            this.browser.addFocusListener(listener);
        }
    }

    public void removeFocusListener(FocusListener listener) {
        super.removeFocusListener(listener);
        if (this.cefBrowser != null) {
            this.cefBrowser.removeFocusListener(listener);
        } else {
            this.browser.removeFocusListener(listener);
        }
    }

    public void addProgressListener(ProgressListener listener) {
        if (this.cefBrowser != null) {
            this.cefBrowser.addProgressListener(listener);
        } else {
            this.browser.addProgressListener(listener);
        }
    }

    public void setScreenSizeListener(IScreenSizeListener listener) {
        this.screenSizeListener = listener;
    }

    public void removeProgressListener(ProgressListener listener) {
        if (this.cefBrowser != null) {
            this.cefBrowser.removeProgressListener(listener);
        } else {
            this.browser.removeProgressListener(listener);
        }
    }

    public void addTitleListener(TitleListener listener) {
        if (this.cefBrowser != null) {
            this.cefBrowser.addTitleListener(listener);
        } else {
            this.browser.addTitleListener(listener);
        }
    }

    public void removeTitleListener(TitleListener listener) {
        if (this.cefBrowser != null) {
            this.cefBrowser.removeTitleListener(listener);
        } else {
            this.browser.removeTitleListener(listener);
        }
    }

    public boolean isDevToolsDialogOpened() {
        if (!this.isDisposed() && this.cefBrowser != null) {
            return this.cefBrowser != null && !this.cefBrowser.isDisposed() && this.cefBrowser.isDevToolsDialogOpened();
        }
        return false;
    }

    public void openDevTools() {
        if (this.cefBrowser != null && !this.disableDevToolBAR) {
            this.cefBrowser.openDevTools();
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void back() {
        if (this.cefBrowser != null) {
            this.cefBrowser.back();
        } else {
            this.browser.back();
        }
    }

    public void forward() {
        if (this.cefBrowser != null) {
            this.cefBrowser.forward();
        } else {
            this.browser.forward();
        }
    }

    public void stop() {
        if (this.cefBrowser != null) {
            this.cefBrowser.stop();
        } else {
            this.browser.stop();
        }
    }

    public void showQR() {
        if (this.qrCodeTool != null) {
            this.qrCodeTool.run();
        }
    }

    public void lockOrUnlockURL() {
        if (this.lockTool != null && this.toolbarAfterURL != null) {
            this.lockTool.run();
            this.toolbarAfterURL.getItem(1).setSelection(this.isLocked());
        } else {
            this.locked = !this.locked;
        }
    }

    public void registerFunction(String funcName, final IScriptHandler handler) {
        if (this.supportCEF()) {
            final CEF3Browser web = (CEF3Browser)this.getBrowser();
            new com.pandora.cef3.BrowserFunction(web, funcName){

                public void function(final Object[] arguments, final BrowserFunctionCallback callback) {
                    web.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            callback.success(handler.handle(arguments));
                        }
                    });
                }
            };
        } else {
            new BrowserFunction((Browser)this.getBrowser(), funcName){

                public Object function(Object[] arguments) {
                    return handler.handle(arguments);
                }
            };
        }
    }

    private boolean supportCEF() {
        return PlatformUtil.isWindows();
    }

    public void highlight(String selectorStr) {
        if (this.supportCEF() && this.cefBrowser.isDevToolsDialogOpened()) {
            this.cefBrowser.highlight(selectorStr);
        }
    }

    public static interface IScreenSizeListener {
        public void change(BrowserScreenSize var1);
    }

    public static interface IScriptHandler {
        public Object handle(Object[] var1);
    }
}

