/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.view.browser.qr;

import com.pandora.core.log.HBLog;
import com.pandora.core.ui.URL2QRCodeImage;
import com.pandora.core.utils.StringUtil;
import com.pandora.view.browser.BrowserActivator;
import java.net.URL;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class QRShower {
    private static final String RUNINBROWSER_PAGE_ID = "com.pandora.ui.preferences.webservers";
    private static final String SERVER_PAGE_ID = "com.pandora.webserver.preferences.servers";
    private static final String LOCAL_PAGE_ID = "com.pandora.webserver.preferences.servers.local";
    private Shell shell;
    private URL2QRCodeImage qrCodeImage;
    private SelectionAdapter qrCodeImageSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (QRShower.this.shell != null) {
                if (QRShower.this.qrCodeImage != null && QRShower.this.qrCodeImage.getShell() != null && !QRShower.this.qrCodeImage.getShell().isDisposed()) {
                    QRShower.this.qrCodeImage.close();
                }
                QRShower.this.setWebServer(QRShower.this.shell);
            }
        }
    };

    public QRShower(Shell shell) {
        this.shell = shell;
    }

    public void run(String urlStr, Point location) {
        block10: {
            try {
                if (!StringUtil.isNotBlank((String)urlStr)) break block10;
                if (location == null) {
                    location = this.shell.getDisplay().getCursorLocation();
                }
                location = new Point(location.x - 80, location.y + 5);
                Rectangle shellLocation = this.shell.getBounds();
                if (shellLocation.x + shellLocation.width < location.x + 160) {
                    location.x -= shellLocation.x + shellLocation.width - (location.x + 160) + 20;
                }
                this.qrCodeImage = new URL2QRCodeImage(this.shell, urlStr, (Plugin)BrowserActivator.getDefault(), location);
                try {
                    IPreferenceNode[] subs;
                    IPreferenceNode[] iPreferenceNodeArray = subs = PlatformUI.getWorkbench().getPreferenceManager().getRootSubNodes();
                    int n = subs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPreferenceNode sub = iPreferenceNodeArray[n2];
                        if (sub.findSubNode(RUNINBROWSER_PAGE_ID) != null) {
                            URL url = new URL(urlStr);
                            if ("127.0.0.1".equals(url.getHost()) || "localhost".equals(url.getHost())) {
                                this.qrCodeImage.setMessageAndListener("\u6ce8\u610f\uff1a127\u6bb5\u7684IP\u65e0\u6cd5\u88ab\u5176\u4ed6\u8bbe\u5907\u8bbf\u95ee\uff0c\u5982\u679c\u4f7f\u7528\u5176\u4ed6\u8bbe\u5907\u8bbf\u95ee\uff0c\u8bf7\u70b9<a>\u8fd9\u91cc</a>\u8bbe\u7f6eweb\u670d\u52a1\u5668IP\u6bb5", (SelectionListener)this.qrCodeImageSelectionAdapter);
                            } else {
                                this.qrCodeImage.setMessageAndListener(null, null);
                            }
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e);
                }
                this.qrCodeImage.open();
            }
            catch (Exception ex) {
                HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)ex);
            }
        }
    }

    private void setWebServer(Shell shell) {
        PreferenceDialog p = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)LOCAL_PAGE_ID, (String[])new String[]{RUNINBROWSER_PAGE_ID, SERVER_PAGE_ID, LOCAL_PAGE_ID}, null);
        p.open();
    }
}

