/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.view.browser.preferences;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.EclipseUtil;
import com.pandora.view.browser.BrowserActivator;
import com.pandora.view.browser.preferences.BrowserScreenSize;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class BrowserScreenSizeManager {
    public static final String STATE_FILENAME = "screensizes";
    public static final String DEFAULT_FILENAME = "config/default_screensizes.xml";
    private static final String ELEMENT_ROOT = "screensizes";
    private static final String ELEMENT_SIZE = "screensize";
    private static BrowserScreenSizeManager instance;
    private boolean hasLoaded;
    private File configFile;
    private Set<BrowserScreenSize> allScrrenSizeCommands = new TreeSet<BrowserScreenSize>();

    private BrowserScreenSizeManager() {
    }

    public static BrowserScreenSizeManager getInstance() {
        if (instance == null) {
            instance = new BrowserScreenSizeManager();
            instance.loadState();
        }
        return instance;
    }

    public Set<BrowserScreenSize> getAllBrowserScreenSize() {
        return this.allScrrenSizeCommands;
    }

    public BrowserScreenSize getBrowserScreenSizeByName(String name) {
        if (name == null) {
            return null;
        }
        for (BrowserScreenSize size : this.allScrrenSizeCommands) {
            if (!size.getName().equals(name)) continue;
            return size;
        }
        return null;
    }

    public void addBrowserScreenSize(BrowserScreenSize browserScreenSize) {
        if (!this.allScrrenSizeCommands.contains(browserScreenSize)) {
            this.allScrrenSizeCommands.remove(browserScreenSize);
        }
        this.allScrrenSizeCommands.add(browserScreenSize);
        this.saveState();
    }

    public void updateBrowserScreenSize(BrowserScreenSize browserScreenSize, BrowserScreenSize newBrowserScreenSize) {
        this.allScrrenSizeCommands.remove(browserScreenSize);
        this.allScrrenSizeCommands.add(newBrowserScreenSize);
        this.saveState();
    }

    public void removeBrowserScreenSize(BrowserScreenSize browserScreenSize) {
        this.allScrrenSizeCommands.remove(browserScreenSize);
        this.saveState();
    }

    private synchronized void loadState() {
        try {
            if (this.hasLoaded) {
                return;
            }
            this.hasLoaded = true;
            File xmlFile = this.getConfigFile();
            if (!xmlFile.exists()) {
                try {
                    File[] oldFiles = xmlFile.getParentFile().listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.startsWith("screensizes.");
                        }
                    });
                    if (oldFiles != null && oldFiles.length > 0) {
                        FileUtils.copyFile((File)oldFiles[0], (File)xmlFile);
                    }
                }
                catch (Exception e) {
                    HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e);
                }
            }
            this.loadState(xmlFile, false);
            BrowserScreenSizeManager.getInstance().loadDefaultState();
        }
        catch (Throwable e) {
            HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e);
        }
    }

    private void loadState(File file, boolean isDefault) {
        block16: {
            if (file.exists()) {
                FileReader reader = null;
                try {
                    reader = new FileReader(file);
                    XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                    boolean hasInited = true;
                    if (isDefault) {
                        IEclipsePreferences preferences = EclipseUtil.instanceScope().getNode("com.pandora.view.browser");
                        hasInited = preferences.getBoolean("changeDfault", false);
                        preferences.putBoolean("changeDfault", true);
                        try {
                            preferences.flush();
                        }
                        catch (BackingStoreException backingStoreException) {}
                    }
                    IMemento[] iMementoArray = memento.getChildren(ELEMENT_SIZE);
                    int n = iMementoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemento child = iMementoArray[n2];
                        BrowserScreenSize size = new BrowserScreenSize(child);
                        if (!size.isDefault() || !size.getName().equals("iPhone3") && !size.getName().equals("ldpi")) {
                            if (!this.allScrrenSizeCommands.add(size) && isDefault) {
                                BrowserScreenSize oldSize = this.getBrowserScreenSizeByName(size.getName());
                                if (oldSize != null && (!hasInited || oldSize.isImperfect())) {
                                    oldSize.setDpr(size.getDpr());
                                    oldSize.setMobile(size.isMobile());
                                    oldSize.setTouch(size.isTouch());
                                    oldSize.setImperfect(false);
                                    oldSize.setPriority(size.getPriority());
                                }
                            } else if (!isDefault && size.isImperfect() && size.isDefault()) {
                                size.setMobile(true);
                                size.setTouch(true);
                            }
                        }
                        ++n2;
                    }
                }
                catch (IOException e) {
                    HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e);
                    IOUtils.closeQuietly((Reader)reader);
                    break block16;
                }
                catch (CoreException e) {
                    try {
                        HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)reader);
                    break block16;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
        }
    }

    private void loadDefaultState() {
        try {
            URL url = FileLocator.find((Bundle)BrowserActivator.getDefault().getBundle(), (IPath)new Path(DEFAULT_FILENAME), null);
            this.loadState(new File(FileLocator.toFileURL((URL)url).getFile()), true);
        }
        catch (IOException e) {
            HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e);
        }
    }

    public void saveState() {
        block6: {
            File file = this.getConfigFile();
            XMLMemento memento = XMLMemento.createWriteRoot((String)"screensizes");
            for (BrowserScreenSize externalCommand : this.allScrrenSizeCommands) {
                IMemento child = memento.createChild(ELEMENT_SIZE);
                externalCommand.saveState(child);
            }
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(file);
                    memento.save((Writer)writer);
                }
                catch (IOException e) {
                    HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e);
                    IOUtils.closeQuietly((Writer)writer);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    private File getConfigFile() {
        if (this.configFile == null) {
            this.configFile = BrowserActivator.getDefault().getStateLocation().append("screensizes").addFileExtension("xml").makeAbsolute().toFile();
        }
        return this.configFile;
    }
}

