/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.view.browser.preferences;

import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.view.browser.preferences.BrowserScreenSize;
import com.pandora.view.browser.preferences.BrowserScreenSizeManager;
import java.util.Set;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class BrowserScreenSizeDialog
extends TitleAreaDialog {
    private Text scrrenNameText;
    private Text scrrenWidthText;
    private Text scrrenHeightText;
    private Text scrrenDprText;
    private Combo scrrenTypeCombo;
    private BrowserScreenSize size;
    private boolean showLink;

    public BrowserScreenSizeDialog(Shell parentShell, boolean showLink) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.showLink = showLink;
    }

    protected BrowserScreenSizeDialog(Shell parentShell, BrowserScreenSize size) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.size = size;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("\u81ea\u5b9a\u4e49\u5bbd\u9ad8");
        this.setMessage("\u8bbe\u7f6e\u8fb9\u6539\u8fb9\u770b\u6d4f\u89c8\u5668\u81ea\u5b9a\u4e49\u5bbd\u9ad8");
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(10, 10).spacing(5, 10).numColumns(4).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("\u540d\u79f0: ");
        this.scrrenNameText = new Text(composite, 2052);
        this.scrrenNameText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
        Label widthLabel = new Label(composite, 0);
        widthLabel.setText("\u5bbd\u5ea6: ");
        this.scrrenWidthText = new Text(composite, 2052);
        this.scrrenWidthText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
        Label heightLabel = new Label(composite, 0);
        heightLabel.setText("\u9ad8\u5ea6: ");
        this.scrrenHeightText = new Text(composite, 2052);
        this.scrrenHeightText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
        if (this.supportMobile()) {
            Label dprLabel = new Label(composite, 0);
            dprLabel.setText("DPR: ");
            this.scrrenDprText = new Text(composite, 2052);
            this.scrrenDprText.setMessage("Device pixel ratio, \u9ed8\u8ba4\u503c\u4e3a 1.0");
            this.scrrenDprText.setToolTipText(this.scrrenDprText.getMessage());
            dprLabel.setToolTipText(this.scrrenDprText.getMessage());
            this.scrrenDprText.setLayoutData((Object)GridDataFactory.swtDefaults().create());
            Label typeLabel = new Label(composite, 0);
            typeLabel.setText("\u5e73\u53f0: ");
            this.scrrenTypeCombo = new Combo(composite, 12);
            this.scrrenTypeCombo.setLayoutData((Object)GridDataFactory.swtDefaults().create());
            this.scrrenTypeCombo.add("\u79fb\u52a8");
            this.scrrenTypeCombo.add("\u79fb\u52a8 (\u975e\u89e6\u6478)");
            this.scrrenTypeCombo.add("\u684c\u9762");
            this.scrrenTypeCombo.add("\u684c\u9762 (\u89e6\u6478)");
            this.scrrenTypeCombo.select(0);
        }
        if (this.showLink) {
            new Label(composite, 0).setLayoutData((Object)GridDataFactory.fillDefaults().hint(-1, 0).span(2, 1).create());
            Link link = new Link(composite, 0);
            link.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).align(0x1000008, 0x1000000).grab(true, false).create());
            link.setText("<a>\u7ba1\u7406\u6d4f\u89c8\u5668\u5bbd\u9ad8\u8bbe\u7f6e</a>");
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BrowserScreenSizeDialog.this.close();
                    PreferenceDialog p = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"com.pandora.view.browser.preferences.BrowserSizePreferencePage", (String[])new String[]{"com.pandora.view.browser.preferences.BrowserSizePreferencePage"}, null);
                    p.open();
                }
            });
        }
        if (this.size != null) {
            this.init();
        }
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BrowserScreenSizeDialog.this.check();
            }
        };
        this.scrrenNameText.addModifyListener(modifyListener);
        this.scrrenWidthText.addModifyListener(modifyListener);
        this.scrrenHeightText.addModifyListener(modifyListener);
        if (this.supportMobile()) {
            this.scrrenDprText.addModifyListener(modifyListener);
        }
        return composite;
    }

    private void init() {
        this.scrrenNameText.setText(this.size.getName());
        this.scrrenNameText.setEnabled(!this.size.isDefault());
        this.scrrenWidthText.setText(String.valueOf(this.size.getWidth()));
        this.scrrenHeightText.setText(String.valueOf(this.size.getHeight()));
        if (this.supportMobile()) {
            this.scrrenDprText.setText(String.valueOf(this.size.getDpr()));
            if (this.size.isMobile() && this.size.isTouch()) {
                this.scrrenTypeCombo.select(0);
            } else if (this.size.isMobile()) {
                this.scrrenTypeCombo.select(1);
            } else if (this.size.isTouch()) {
                this.scrrenTypeCombo.select(3);
            } else {
                this.scrrenTypeCombo.select(2);
            }
            this.scrrenTypeCombo.setText(String.valueOf(this.size.getDpr()));
            this.scrrenTypeCombo.setEnabled(!this.size.isDefault());
        }
    }

    private void check() {
        String dprText;
        String message = null;
        String nameText = this.scrrenNameText.getText();
        String widthText = this.scrrenWidthText.getText();
        String heightText = this.scrrenHeightText.getText();
        String string = dprText = this.supportMobile() ? this.scrrenDprText.getText() : "1.0";
        if (StringUtil.isBlank((String)nameText)) {
            message = "\u8bf7\u586b\u5199\u540d\u79f0";
        }
        if (message == null) {
            if (widthText.trim().length() == 0) {
                message = "\u8bf7\u6307\u5b9a\u4e00\u4e2a\u6b63\u6574\u6570\u7684\u6d4f\u89c8\u5668\u7684\u5bbd\u5ea6";
            } else {
                try {
                    int width = Integer.parseInt(widthText);
                    if (width <= 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    message = "\u8bf7\u6307\u5b9a\u4e00\u4e2a\u6b63\u6574\u6570\u7684\u6d4f\u89c8\u5668\u7684\u5bbd\u5ea6";
                }
            }
        }
        if (message == null) {
            if (heightText.trim().length() == 0) {
                message = "\u8bf7\u6307\u5b9a\u4e00\u4e2a\u6b63\u6574\u6570\u7684\u9ad8\u5ea6";
            } else {
                try {
                    int height = Integer.parseInt(heightText);
                    if (height <= 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    message = "\u8bf7\u6307\u5b9a\u4e00\u4e2a\u6b63\u6574\u6570\u7684\u9ad8\u5ea6";
                }
            }
        }
        if (message == null && StringUtil.isNotBlank((String)dprText)) {
            try {
                float height = Float.parseFloat(dprText);
                if (height <= 0.0f) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                message = "\u8bf7\u6307\u5b9a\u4e00\u4e2a\u6b63\u6570\u7684DPR";
            }
        }
        if (message == null) {
            Set<BrowserScreenSize> all = BrowserScreenSizeManager.getInstance().getAllBrowserScreenSize();
            for (BrowserScreenSize browserScreenSize : all) {
                if (this.size == browserScreenSize || !browserScreenSize.getName().equals(nameText)) continue;
                message = "\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u81ea\u5b9a\u4e49\u5bbd\u9ad8\u914d\u7f6e\uff0c\u8bf7\u66f4\u6362\u540d\u79f0";
                break;
            }
        }
        this.setErrorMessage(message);
        this.getButton(0).setEnabled(message == null);
    }

    protected void okPressed() {
        String name = this.scrrenNameText.getText();
        int width = Integer.parseInt(this.scrrenWidthText.getText());
        int height = Integer.parseInt(this.scrrenHeightText.getText());
        String dprText = this.supportMobile() ? this.scrrenDprText.getText() : "1.0";
        float dpr = StringUtil.isBlank((String)dprText) ? 1.0f : Float.parseFloat(dprText);
        int index = this.supportMobile() ? this.scrrenTypeCombo.getSelectionIndex() : -1;
        boolean touch = index == 0 || index == 3;
        boolean mobile = index == 0 || index == 1;
        int priority = this.size == null ? 0 : this.size.getPriority();
        this.size = new BrowserScreenSize(name, width, height, dpr, touch, mobile);
        this.size.setPriority(priority);
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.check();
        return control;
    }

    public BrowserScreenSize getResult() {
        return this.size;
    }

    private boolean supportMobile() {
        return PlatformUtil.isWindows();
    }
}

