/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.view.browser.preferences;

import com.pandora.cef3.DeviceScreen;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.StringUtil;
import org.eclipse.ui.IMemento;

public class BrowserScreenSize
implements Comparable<BrowserScreenSize> {
    protected static final String ELEMENT_ID = "id";
    protected static final String ELEMENT_WIDTH = "width";
    protected static final String ELEMENT_HEIGHT = "height";
    protected static final String ELEMENT_DPR = "dpr";
    protected static final String ELEMENT_PRIORITY = "priority";
    protected static final String ELEMENT_MOBILE = "mobile";
    protected static final String ELEMENT_TOUCH = "touch";
    private String name;
    private int width;
    private int height;
    private int priority = 0;
    private float dpr = 1.0f;
    private boolean touch = true;
    private boolean mobile = true;
    private boolean imperfect = false;

    public BrowserScreenSize(String name, int width, int height, float dpr, boolean touch, boolean mobile) {
        this.name = name;
        this.width = width;
        this.height = height;
        this.dpr = dpr;
        this.touch = touch;
        this.mobile = mobile;
    }

    public BrowserScreenSize(IMemento child) {
        this.loadState(child);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public float getDpr() {
        return this.dpr;
    }

    public void setDpr(float dpr) {
        this.dpr = dpr;
    }

    public boolean isTouch() {
        return this.touch;
    }

    public void setTouch(boolean touch) {
        this.touch = touch;
    }

    public boolean isMobile() {
        return this.mobile;
    }

    public void setMobile(boolean mobile) {
        this.mobile = mobile;
    }

    public boolean isDefault() {
        return this.priority != 0;
    }

    public boolean isImperfect() {
        return this.imperfect;
    }

    public void setImperfect(boolean imperfect) {
        this.imperfect = imperfect;
    }

    public void loadState(IMemento memento) {
        if (memento != null) {
            this.name = this.getValue(memento, ELEMENT_ID);
            this.width = Integer.parseInt(this.getValue(memento, ELEMENT_WIDTH));
            this.height = Integer.parseInt(this.getValue(memento, ELEMENT_HEIGHT));
            this.priority = Integer.parseInt(this.getValue(memento, ELEMENT_PRIORITY));
            try {
                this.dpr = Float.parseFloat(this.getValue(memento, ELEMENT_DPR));
            }
            catch (Exception exception) {
                this.imperfect = true;
            }
            try {
                this.mobile = Boolean.parseBoolean(this.getValue(memento, ELEMENT_MOBILE));
            }
            catch (Exception exception) {
                this.imperfect = true;
            }
            try {
                this.touch = Boolean.parseBoolean(this.getValue(memento, ELEMENT_TOUCH));
            }
            catch (Exception exception) {
                this.imperfect = true;
            }
        }
    }

    protected String getValue(IMemento memento, String name) {
        return memento.getString(name);
    }

    public void saveState(IMemento memento) {
        if (memento != null) {
            memento.putString(ELEMENT_ID, this.name);
            memento.putInteger(ELEMENT_WIDTH, this.width);
            memento.putInteger(ELEMENT_HEIGHT, this.height);
            memento.putInteger(ELEMENT_PRIORITY, this.priority);
            memento.putFloat(ELEMENT_DPR, this.dpr);
            memento.putBoolean(ELEMENT_TOUCH, this.touch);
            memento.putBoolean(ELEMENT_MOBILE, this.mobile);
        }
    }

    public DeviceScreen toDeviceScreen() {
        return new DeviceScreen(this.width, this.height, (double)this.dpr, this.touch, this.mobile);
    }

    public String toString() {
        if (StringUtil.isBlank((String)this.name)) {
            return String.valueOf(this.width) + "x" + this.height + (PlatformUtil.isWindows() ? "x" + this.dpr : "");
        }
        return String.valueOf(this.name) + " (" + this.width + "x" + this.height + (PlatformUtil.isWindows() ? "x" + this.dpr : "") + ")";
    }

    @Override
    public int compareTo(BrowserScreenSize o) {
        if (o == null) {
            return -1;
        }
        boolean sameName = this.name.equals(o.name);
        if (sameName && this.priority > 0 && o.priority > 0) {
            return 0;
        }
        if (this.priority != o.priority && (this.priority > 0 || o.priority > 0)) {
            return o.priority - this.priority;
        }
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.dpr);
        result = 31 * result + this.height;
        result = 31 * result + (this.mobile ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.priority;
        result = 31 * result + (this.touch ? 1231 : 1237);
        result = 31 * result + this.width;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BrowserScreenSize other = (BrowserScreenSize)obj;
        if (Float.floatToIntBits(this.dpr) != Float.floatToIntBits(other.dpr)) {
            return false;
        }
        if (this.height != other.height) {
            return false;
        }
        if (this.mobile != other.mobile) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.touch != other.touch) {
            return false;
        }
        return this.width == other.width;
    }
}

