/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.coffee.parsing.lexer;

import beaver.Scanner;
import com.aptana.editor.coffee.parsing.Terminals;
import com.aptana.editor.coffee.parsing.ast.CoffeeCommentNode;
import com.aptana.editor.coffee.parsing.lexer.CoffeeRewriter;
import com.aptana.editor.coffee.parsing.lexer.CoffeeSymbol;
import com.aptana.editor.coffee.parsing.lexer.SyntaxError;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CoffeeScanner
extends Scanner {
    private static final short EMPTY = -1;
    private static final short TOKENS = -2;
    private static final short NEOSTRING = -3;
    private static final short UNKNOWN = -4;
    public static final Set<String> JS_KEYWORDS = new HashSet<String>();
    public static final Set<String> COFFEE_KEYWORDS;
    private static final Map<String, String> COFFEE_ALIAS_MAP;
    private static final Set<String> COFFEE_ALIASES;
    private static final Set<String> RESERVED;
    private static final Set<String> JS_FORBIDDEN;
    private static final Pattern IDENTIFIER;
    private static final Pattern NUMBER;
    private static final Pattern HEREDOC;
    private static final Pattern OPERATOR;
    private static final Pattern WHITESPACE;
    private static final Pattern COMMENT;
    private static final Pattern MULTI_DENT;
    private static final Pattern SIMPLESTR;
    private static final Pattern JSTOKEN;
    private static final String REGEX_PATTERN = "^ / (?! [\\s=] )[^ \\[ / \\n \\\\ ]*(?:  (?: \\\\[\\s\\S]    | \\[          [^ \\] \\n \\\\ ]*          (?: \\\\[\\s\\S] [^ \\] \\n \\\\ ]* )*        ]  ) [^ \\[ / \\n \\\\ ]*)*/ [imgy]{0,4} (?!\\w)";
    private static final Pattern REGEX;
    private static final Pattern HEREGEX;
    private static final Pattern HEREGEX_OMIT;
    private static final Pattern MULTILINER;
    private static final Pattern HEREDOC_INDENT;
    private static final Pattern HEREDOC_ILLEGAL;
    private static final Pattern LINE_CONTINUER;
    private static final Pattern TRAILING_SPACES;
    private static final Set<String> COMPOUND_ASSIGN;
    private static final Set<String> UNARY;
    private static final Set<String> LOGIC;
    private static final Set<String> SHIFT;
    private static final Set<String> COMPARE;
    private static final Set<String> MATH;
    private static final Set<String> RELATION;
    private static final Set<String> BOOL;
    private static final Set<Short> NOT_REGEX;
    private static final Set<Short> NOT_SPACED_REGEX;
    private static final Set<Short> CALLABLE;
    private static final Set<Short> INDEXABLE;
    private static final Set<Short> LINE_BREAK;
    private String fCode;
    private int fLine;
    private int fIndent;
    private int fIndebt;
    private int fOutdebt;
    private List<CoffeeSymbol> fTokens;
    private String fChunk;
    private boolean fSeenFor;
    private List<Integer> fIndents;
    private List<CoffeeCommentNode> fComments;
    private int fOffset;

    static {
        JS_KEYWORDS.add("true");
        JS_KEYWORDS.add("false");
        JS_KEYWORDS.add("null");
        JS_KEYWORDS.add("this");
        JS_KEYWORDS.add("new");
        JS_KEYWORDS.add("delete");
        JS_KEYWORDS.add("typeof");
        JS_KEYWORDS.add("in");
        JS_KEYWORDS.add("instanceof");
        JS_KEYWORDS.add("return");
        JS_KEYWORDS.add("throw");
        JS_KEYWORDS.add("break");
        JS_KEYWORDS.add("continue");
        JS_KEYWORDS.add("debugger");
        JS_KEYWORDS.add("if");
        JS_KEYWORDS.add("else");
        JS_KEYWORDS.add("switch");
        JS_KEYWORDS.add("for");
        JS_KEYWORDS.add("while");
        JS_KEYWORDS.add("do");
        JS_KEYWORDS.add("try");
        JS_KEYWORDS.add("catch");
        JS_KEYWORDS.add("finally");
        JS_KEYWORDS.add("class");
        JS_KEYWORDS.add("extends");
        JS_KEYWORDS.add("super");
        COFFEE_KEYWORDS = new HashSet<String>();
        COFFEE_KEYWORDS.add("undefined");
        COFFEE_KEYWORDS.add("then");
        COFFEE_KEYWORDS.add("unless");
        COFFEE_KEYWORDS.add("until");
        COFFEE_KEYWORDS.add("loop");
        COFFEE_KEYWORDS.add("of");
        COFFEE_KEYWORDS.add("by");
        COFFEE_KEYWORDS.add("when");
        COFFEE_ALIAS_MAP = new HashMap<String, String>();
        COFFEE_ALIAS_MAP.put("and", "&&");
        COFFEE_ALIAS_MAP.put("or", "||");
        COFFEE_ALIAS_MAP.put("is", "==");
        COFFEE_ALIAS_MAP.put("isnt", "!=");
        COFFEE_ALIAS_MAP.put("not", "!");
        COFFEE_ALIAS_MAP.put("yes", "true");
        COFFEE_ALIAS_MAP.put("no", "false");
        COFFEE_ALIAS_MAP.put("on", "true");
        COFFEE_ALIAS_MAP.put("off", "false");
        COFFEE_ALIASES = new HashSet<String>();
        for (String key : COFFEE_ALIAS_MAP.keySet()) {
            COFFEE_ALIASES.add(key);
        }
        COFFEE_KEYWORDS.addAll(COFFEE_ALIASES);
        RESERVED = new HashSet<String>();
        RESERVED.add("case");
        RESERVED.add("default");
        RESERVED.add("function");
        RESERVED.add("var");
        RESERVED.add("void");
        RESERVED.add("with");
        RESERVED.add("const");
        RESERVED.add("let");
        RESERVED.add("enum");
        RESERVED.add("export");
        RESERVED.add("import");
        RESERVED.add("native");
        RESERVED.add("__hasProp");
        RESERVED.add("__extends");
        RESERVED.add("__slice");
        RESERVED.add("__bind");
        RESERVED.add("__indexOf");
        JS_FORBIDDEN = new HashSet<String>();
        JS_FORBIDDEN.addAll(JS_KEYWORDS);
        JS_FORBIDDEN.addAll(RESERVED);
        IDENTIFIER = Pattern.compile("^([$A-Za-z_\\x7f-\\uffff][$\\w\\x7f-\\uffff]*)([^\\n\\S]*:(?!:))?");
        NUMBER = Pattern.compile("^0x[\\da-f]+|^\\d*\\.?\\d+(?:e[+-]?\\d+)?", 2);
        HEREDOC = Pattern.compile("^(\"\"\"|''')([\\s\\S]*?)(?:\\n[^\\n\\S]*)?\\1");
        OPERATOR = Pattern.compile("^(?:[-=]>|[-+*\\/%<>&|^!?=]=|>>>=?|([-+:])\\1|([&|<>])\\2=?|\\?\\.|\\.{2,3})");
        WHITESPACE = Pattern.compile("^[^\\n\\S]+");
        COMMENT = Pattern.compile("^###([^#][\\s\\S]*?)(?:###[^\\n\\S]*|(?:###)?$)|^(?:\\s*#(?!##[^#]).*)+");
        MULTI_DENT = Pattern.compile("^(?:\\n[^\\n\\S]*)+");
        SIMPLESTR = Pattern.compile("^'[^\\\\']*(?:\\\\.[^\\\\']*)*'");
        JSTOKEN = Pattern.compile("^`[^\\\\`]*(?:\\\\.[^\\\\`]*)*`");
        REGEX = Pattern.compile(REGEX_PATTERN, 4);
        HEREGEX = Pattern.compile("^\\/{3}([\\s\\S]+?)\\/{3}([imgy]{0,4})(?!\\w)");
        HEREGEX_OMIT = Pattern.compile("\\s+(?:#.*)?");
        MULTILINER = Pattern.compile("\\n");
        HEREDOC_INDENT = Pattern.compile("\\n+([^\\n\\S]*)");
        HEREDOC_ILLEGAL = Pattern.compile("\\*\\/");
        LINE_CONTINUER = Pattern.compile("^\\s*(?:,|\\??\\.(?![.\\d])|::)");
        TRAILING_SPACES = Pattern.compile("\\s+$");
        COMPOUND_ASSIGN = new HashSet<String>();
        COMPOUND_ASSIGN.add("-=");
        COMPOUND_ASSIGN.add("+=");
        COMPOUND_ASSIGN.add("/=");
        COMPOUND_ASSIGN.add("*=");
        COMPOUND_ASSIGN.add("%=");
        COMPOUND_ASSIGN.add("||=");
        COMPOUND_ASSIGN.add("&&=");
        COMPOUND_ASSIGN.add("?=");
        COMPOUND_ASSIGN.add("<<=");
        COMPOUND_ASSIGN.add(">>=");
        COMPOUND_ASSIGN.add(">>>=");
        COMPOUND_ASSIGN.add("&=");
        COMPOUND_ASSIGN.add("^=");
        COMPOUND_ASSIGN.add("|=");
        UNARY = new HashSet<String>();
        UNARY.add("!");
        UNARY.add("~");
        UNARY.add("NEW");
        UNARY.add("TYPEOF");
        UNARY.add("DELETE");
        UNARY.add("DO");
        LOGIC = new HashSet<String>();
        LOGIC.add("&&");
        LOGIC.add("||");
        LOGIC.add("&");
        LOGIC.add("|");
        LOGIC.add("^");
        SHIFT = new HashSet<String>();
        SHIFT.add("<<");
        SHIFT.add(">>");
        SHIFT.add(">>>");
        COMPARE = new HashSet<String>();
        COMPARE.add("==");
        COMPARE.add("!=");
        COMPARE.add("<");
        COMPARE.add(">");
        COMPARE.add("<=");
        COMPARE.add(">=");
        MATH = new HashSet<String>();
        MATH.add("*");
        MATH.add("/");
        MATH.add("%");
        RELATION = new HashSet<String>();
        RELATION.add("IN");
        RELATION.add("OF");
        RELATION.add("INSTANCEOF");
        BOOL = new HashSet<String>();
        BOOL.add("TRUE");
        BOOL.add("FALSE");
        BOOL.add("NULL");
        BOOL.add("UNDEFINED");
        NOT_REGEX = new HashSet<Short>();
        NOT_REGEX.add((short)10);
        NOT_REGEX.add((short)14);
        NOT_REGEX.add((short)15);
        NOT_REGEX.add((short)23);
        NOT_REGEX.add((short)22);
        NOT_REGEX.add((short)54);
        NOT_SPACED_REGEX = new HashSet<Short>();
        NOT_SPACED_REGEX.addAll(NOT_REGEX);
        NOT_SPACED_REGEX.add((short)60);
        NOT_SPACED_REGEX.add((short)69);
        NOT_SPACED_REGEX.add((short)17);
        NOT_SPACED_REGEX.add((short)6);
        NOT_SPACED_REGEX.add((short)11);
        CALLABLE = new HashSet<Short>();
        CALLABLE.add((short)6);
        CALLABLE.add((short)11);
        CALLABLE.add((short)14);
        CALLABLE.add((short)60);
        CALLABLE.add((short)54);
        CALLABLE.add((short)69);
        CALLABLE.add((short)33);
        CALLABLE.add((short)50);
        CALLABLE.add((short)7);
        CALLABLE.add((short)17);
        CALLABLE.add((short)16);
        INDEXABLE = new HashSet<Short>();
        INDEXABLE.addAll(CALLABLE);
        INDEXABLE.add((short)10);
        INDEXABLE.add((short)15);
        LINE_BREAK = new HashSet<Short>();
        LINE_BREAK.add((short)35);
        LINE_BREAK.add((short)41);
        LINE_BREAK.add((short)43);
    }

    public synchronized CoffeeSymbol nextToken() throws IOException, Scanner.Exception {
        if (this.fTokens == null) {
            this.tokenize(this.fCode, null);
        }
        if (this.fTokens.isEmpty()) {
            return new CoffeeSymbol(0, null);
        }
        return this.fTokens.remove(0);
    }

    private List<CoffeeSymbol> tokenize(String code, Map<String, Object> opts) throws SyntaxError {
        if (opts == null) {
            opts = new HashMap<String, Object>();
        }
        if (WHITESPACE.matcher(code).find()) {
            code = "\n" + code;
        }
        this.fCode = code = code.replaceAll("\r", "").replaceFirst(TRAILING_SPACES.pattern(), "");
        this.fLine = 0;
        if (opts.containsKey("fLine")) {
            Object value = opts.get("fLine");
            if (value instanceof Integer) {
                this.fLine = (Integer)value;
            } else if (value instanceof String) {
                try {
                    this.fLine = Integer.parseInt((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    this.fLine = 0;
                }
            }
        }
        this.fIndent = 0;
        this.fIndebt = 0;
        this.fOutdebt = 0;
        this.fIndents = new ArrayList<Integer>();
        this.fTokens = new ArrayList<CoffeeSymbol>();
        this.fComments = new ArrayList<CoffeeCommentNode>();
        this.fOffset = 0;
        while (this.fOffset < code.length() && (this.fChunk = code.substring(this.fOffset)).length() > 0) {
            int value = this.identifierToken();
            if (value > 0) {
                this.fOffset += value;
                continue;
            }
            value = this.commentToken();
            if (value > 0) {
                this.fOffset += value;
                continue;
            }
            value = this.whitespaceToken();
            if (value > 0) {
                this.fOffset += value;
                continue;
            }
            value = this.lineToken();
            if (value > 0) {
                this.fOffset += value;
                continue;
            }
            value = this.heredocToken();
            if (value > 0) {
                this.fOffset += value;
                continue;
            }
            value = this.stringToken();
            if (value > 0) {
                this.fOffset += value;
                continue;
            }
            value = this.numberToken();
            if (value > 0) {
                this.fOffset += value;
                continue;
            }
            value = this.regexToken();
            if (value > 0) {
                this.fOffset += value;
                continue;
            }
            value = this.jsToken();
            if (value > 0) {
                this.fOffset += value;
                continue;
            }
            value = this.literalToken();
            if (value <= 0) continue;
            this.fOffset += value;
        }
        this.closeIndentation();
        this.fTokens = new CoffeeRewriter().rewrite(this.fTokens);
        this.fChunk = null;
        this.fCode = null;
        this.fIndents = null;
        return this.fTokens;
    }

    private int identifierToken() throws SyntaxError {
        CoffeeSymbol prev;
        boolean forcedIdentifier;
        char c = this.fChunk.charAt(0);
        if (!(Character.isLetter(c) || c == '$' || c == '_' || c <= '\uffff' && c >= '\u007f')) {
            return 0;
        }
        Matcher m = IDENTIFIER.matcher(this.fChunk);
        if (!m.find()) {
            return 0;
        }
        String id = m.group(1);
        if ("own".equals(id) && 5 == this.tag()) {
            this.token((short)70, id, id.length());
            return id.length();
        }
        String colon = m.group(2);
        boolean bl = forcedIdentifier = colon != null;
        if (!forcedIdentifier && (prev = this.last(this.fTokens)) != null) {
            short ref2 = prev.getId();
            forcedIdentifier = ref2 == 48 || ref2 == 49 || ref2 == 50 || ref2 == 7 && !prev.spaced;
        }
        int tag = 6;
        if (JS_KEYWORDS.contains(id) || !forcedIdentifier && COFFEE_KEYWORDS.contains(id)) {
            String upper = id.toUpperCase();
            tag = this.terminal(upper);
            if ("WHEN".equals(upper) && LINE_BREAK.contains(this.tag())) {
                tag = 56;
            } else if ("FOR".equals(upper)) {
                tag = 5;
                this.fSeenFor = true;
            } else if ("UNLESS".equals(upper)) {
                tag = 19;
            } else if (UNARY.contains(upper)) {
                tag = 32;
            } else if (RELATION.contains(upper)) {
                if (!"INSTANCEOF".equals(upper) && this.fSeenFor) {
                    tag = this.terminal("FOR" + upper);
                    this.fSeenFor = false;
                } else {
                    tag = 37;
                    if ("!".equals(this.value())) {
                        this.fTokens.remove(this.fTokens.size() - 1);
                        id = String.valueOf('!') + id;
                    }
                }
            }
        }
        if (JS_FORBIDDEN.contains(id)) {
            if (forcedIdentifier) {
                tag = 6;
                id = new String(id);
            } else if (RESERVED.contains(id)) {
                this.identifierError(id);
            }
        }
        if (!forcedIdentifier) {
            if (COFFEE_ALIASES.contains(id)) {
                id = COFFEE_ALIAS_MAP.get(id);
            }
            if ("!".equals(id)) {
                tag = 32;
            } else if ("==".equals(id) || "!=".equals(id)) {
                tag = 38;
            } else if ("&&".equals(id) || "||".equals(id)) {
                tag = 39;
            } else if ("true".equals(id) || "false".equals(id) || "null".equals(id) || "undefined".equals(id)) {
                tag = 15;
            } else if ("break".equals(id) || "continue".equals(id) || "debugger".equals(id)) {
                tag = 28;
            }
        }
        String input = m.group(0);
        this.token((short)tag, id, colon == null ? input.length() : input.length() - 1);
        if (colon != null) {
            this.token((short)72, ":", this.fOffset + input.length() - 1, 1);
        }
        return input.length();
    }

    private short terminal(String terminalName) {
        Field f;
        block28: {
            if (")".equals(terminalName)) {
                return 60;
            }
            if ("(".equals(terminalName)) {
                return 12;
            }
            if ("++".equals(terminalName)) {
                return 23;
            }
            if ("--".equals(terminalName)) {
                return 22;
            }
            if ("+".equals(terminalName)) {
                return 2;
            }
            if ("-".equals(terminalName)) {
                return 1;
            }
            if ("{".equals(terminalName)) {
                return 8;
            }
            if ("}".equals(terminalName)) {
                return 69;
            }
            if ("[".equals(terminalName)) {
                return 9;
            }
            if ("]".equals(terminalName)) {
                return 54;
            }
            if ("...".equals(terminalName)) {
                return 55;
            }
            if ("..".equals(terminalName)) {
                return 59;
            }
            if (".".equals(terminalName)) {
                return 48;
            }
            if ("?.".equals(terminalName)) {
                return 49;
            }
            if ("?".equals(terminalName)) {
                return 33;
            }
            if (",".equals(terminalName)) {
                return 47;
            }
            if ("=".equals(terminalName)) {
                return 61;
            }
            if (":".equals(terminalName)) {
                return 72;
            }
            if ("::".equals(terminalName)) {
                return 50;
            }
            if (":\\".equals(terminalName)) {
                return 65;
            }
            if ("@".equals(terminalName)) {
                return 7;
            }
            if ("->".equals(terminalName)) {
                return 20;
            }
            if ("=>".equals(terminalName)) {
                return 21;
            }
            if (BOOL.contains(terminalName)) {
                return 15;
            }
            if (MATH.contains(terminalName)) {
                return 34;
            }
            try {
                f = Terminals.class.getField(terminalName);
                if (f != null) break block28;
                return -4;
            }
            catch (Throwable throwable) {
                return -4;
            }
        }
        return (Short)f.get(null);
    }

    private int numberToken() {
        char c = this.fChunk.charAt(0);
        if (!Character.isDigit(c)) {
            return 0;
        }
        Matcher m = NUMBER.matcher(this.fChunk);
        if (!m.find()) {
            return 0;
        }
        String number = m.group(0);
        this.token((short)10, number, number.length());
        return number.length();
    }

    private int stringToken() throws SyntaxError {
        String string;
        switch (this.fChunk.charAt(0)) {
            case '\'': {
                Matcher m = SIMPLESTR.matcher(this.fChunk);
                if (!m.find()) {
                    return 0;
                }
                string = m.group(0);
                this.token((short)11, string.replaceAll(MULTILINER.pattern(), "\\\n"), string.length());
                break;
            }
            case '\"': {
                string = this.balancedString(this.fChunk, '\"');
                if (string == null) {
                    return 0;
                }
                if (string.indexOf("#{", 1) > 0) {
                    this.interpolateString(string.substring(1, string.length() - 1), false, false);
                    break;
                }
                this.token((short)11, this.escapeLines(string), string.length());
                break;
            }
            default: {
                return 0;
            }
        }
        this.fLine += this.count(string, "\n");
        return string.length();
    }

    private int heredocToken() throws SyntaxError {
        char c = this.fChunk.charAt(0);
        if (c != '\"' && c != '\'') {
            return 0;
        }
        Matcher m = HEREDOC.matcher(this.fChunk);
        if (!m.find()) {
            return 0;
        }
        String heredoc = m.group(0);
        char quote = heredoc.charAt(0);
        String doc = this.sanitizeHeredoc(m.group(2), null, false);
        if (quote == '\"' && doc.indexOf("#{") >= 0) {
            this.interpolateString(doc, true, false);
        } else {
            this.token((short)11, this.makeString(doc, Character.toString(quote), true), heredoc.length());
        }
        this.fLine += this.count(heredoc, "\n");
        return heredoc.length();
    }

    private int commentToken() {
        char c = this.fChunk.charAt(0);
        if (!Character.isWhitespace(c) && c != '#') {
            return 0;
        }
        int index = this.fChunk.indexOf(35);
        if (index == -1) {
            return 0;
        }
        String leading = this.fChunk.substring(0, index);
        if (leading.trim().length() != 0) {
            return 0;
        }
        Matcher m = COMMENT.matcher(this.fChunk);
        if (!m.find()) {
            return 0;
        }
        String comment = m.group(0);
        String here = m.group(1);
        if (here != null) {
            this.token((short)18, this.sanitizeHeredoc(here, this.makeIndent(this.fIndent), false), comment.length() - 1);
            this.token((short)43, "\n", 1);
        }
        int addOffset = comment.indexOf(35);
        int startOffset = this.fOffset + addOffset;
        this.fComments.add(new CoffeeCommentNode(comment.substring(addOffset), startOffset, this.fOffset + comment.length()));
        this.fLine += this.count(comment, "\n");
        return comment.length();
    }

    private String makeIndent(int length) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < length) {
            builder.append(' ');
            ++i;
        }
        return builder.toString();
    }

    private int jsToken() {
        if (this.fChunk.charAt(0) != '`') {
            return 0;
        }
        Matcher match = JSTOKEN.matcher(this.fChunk);
        if (!match.find()) {
            return 0;
        }
        String script = match.group(0);
        this.token((short)13, script.substring(1, script.length() - 1), script.length());
        return script.length();
    }

    private int regexToken() throws SyntaxError {
        if (this.fChunk.charAt(0) != '/') {
            return 0;
        }
        Matcher m = HEREGEX.matcher(this.fChunk);
        if (m.find()) {
            int length = this.heregexToken(m);
            this.fLine += this.count(m.group(0), "\n");
            return length;
        }
        CoffeeSymbol prev = this.last(this.fTokens);
        if (prev != null && (prev.spaced ? NOT_REGEX : NOT_SPACED_REGEX).contains(prev.getId())) {
            return 0;
        }
        m = REGEX.matcher(this.fChunk);
        if (!m.find()) {
            return 0;
        }
        String regex = m.group(0);
        this.token((short)14, regex.equals("//") ? "/(?:)/" : regex, regex.length());
        return regex.length();
    }

    private int heregexToken(Matcher match) throws SyntaxError {
        String heregex = match.group(0);
        String body = match.group(1);
        String flags = match.group(2);
        if (body.indexOf("#{") < 0) {
            String re = body.replaceAll(HEREGEX_OMIT.pattern(), "").replaceAll("\\/", Matcher.quoteReplacement("\\/"));
            this.token((short)14, "/" + (re.length() == 0 ? "(?:)" : re) + "/" + flags, heregex.length());
            return heregex.length();
        }
        this.token((short)6, "RegExp");
        this.fTokens.add(new CoffeeSymbol(42, "("));
        Stack<CoffeeSymbol> tmpTokens = new Stack<CoffeeSymbol>();
        Stack<CoffeeSymbol> interpolatedNodes = this.interpolateString(body, false, true);
        int _len = interpolatedNodes.size();
        int i = 0;
        while (i < _len) {
            block9: {
                block8: {
                    Object value;
                    block7: {
                        CoffeeSymbol interpolatedNode = (CoffeeSymbol)((Object)interpolatedNodes.get(i));
                        short tag = interpolatedNode.getId();
                        value = interpolatedNode.getValue();
                        if (tag != -2) break block7;
                        tmpTokens.addAll((Stack)value);
                        break block8;
                    }
                    String strValue = (String)value;
                    if ((strValue = strValue.replaceAll(HEREGEX_OMIT.pattern(), "")).length() == 0) break block9;
                    strValue = strValue.replaceAll("\\", "\\\\");
                    tmpTokens.push(new CoffeeSymbol(11, this.makeString(strValue, "\"", true)));
                }
                tmpTokens.push(new CoffeeSymbol(2, "+"));
            }
            ++i;
        }
        tmpTokens.pop();
        if (!tmpTokens.isEmpty() && tmpTokens.get(0) != null && ((CoffeeSymbol)((Object)tmpTokens.get(0))).getId() != 11) {
            this.fTokens.add(new CoffeeSymbol(11, "\"\""));
            this.fTokens.add(new CoffeeSymbol(2, "+"));
        }
        this.fTokens.addAll(tmpTokens);
        if (flags != null && flags.length() > 0) {
            this.fTokens.add(new CoffeeSymbol(47, ","));
            this.fTokens.add(new CoffeeSymbol(11, "\"" + flags + "\""));
        }
        this.token((short)60, ")");
        return heregex.length();
    }

    private int lineToken() {
        if (this.fChunk.charAt(0) != '\n') {
            return 0;
        }
        Matcher m = MULTI_DENT.matcher(this.fChunk);
        if (!m.find()) {
            return 0;
        }
        String indent = m.group(0);
        this.fLine += this.count(indent, "\n");
        int size = indent.length() - 1 - indent.lastIndexOf("\n");
        boolean noNewlines = this.unfinished();
        if (size - this.fIndebt == this.fIndent) {
            if (noNewlines) {
                this.suppressNewlines();
            } else {
                this.newlineToken();
            }
            return indent.length();
        }
        if (size > this.fIndent) {
            if (noNewlines) {
                this.fIndebt = size - this.fIndent;
                this.suppressNewlines();
                return indent.length();
            }
            int diff = size - this.fIndent + this.fOutdebt;
            this.token((short)35, diff, 0);
            this.fIndents.add(diff);
            this.fIndebt = 0;
            this.fOutdebt = 0;
        } else {
            this.fIndebt = 0;
            this.outdentToken(this.fIndent - size, noNewlines);
        }
        this.fIndent = size;
        return indent.length();
    }

    private void outdentToken(int moveOut, boolean noNewlines) {
        Integer dent = null;
        while (moveOut > 0) {
            int len = this.fIndents.size() - 1;
            if (this.fIndents.get(len) == 0) {
                moveOut = 0;
                continue;
            }
            if (this.fIndents.get(len) == this.fOutdebt) {
                moveOut -= this.fOutdebt;
                this.fOutdebt = 0;
                continue;
            }
            if (this.fIndents.get(len) < this.fOutdebt) {
                this.fOutdebt -= this.fIndents.get(len).intValue();
                moveOut -= this.fIndents.get(len).intValue();
                continue;
            }
            dent = this.fIndents.remove(this.fIndents.size() - 1) - this.fOutdebt;
            moveOut -= dent.intValue();
            this.fOutdebt = 0;
            this.token((short)41, dent, 0);
        }
        if (dent != null) {
            this.fOutdebt -= moveOut;
        }
        if (this.tag() != 43 && !noNewlines) {
            this.token((short)43, "\n", 1);
        }
    }

    private int whitespaceToken() {
        char c = this.fChunk.charAt(0);
        if (!Character.isWhitespace(c) || c == '\n') {
            return 0;
        }
        Matcher match = WHITESPACE.matcher(this.fChunk);
        boolean nline = this.fChunk.length() > 0 && this.fChunk.charAt(0) == '\n';
        boolean matched = match.find();
        if (!matched && !nline) {
            return 0;
        }
        CoffeeSymbol prev = this.last(this.fTokens);
        if (prev != null) {
            if (matched) {
                prev.spaced = true;
            } else {
                prev.newLine = true;
            }
        }
        if (matched) {
            return match.group(0).length();
        }
        return 0;
    }

    private void newlineToken() {
        if (this.tag() != 43) {
            this.token((short)43, "\n", 1);
        }
    }

    private void suppressNewlines() {
        if ("\\".equals(this.value())) {
            this.fTokens.remove(this.fTokens.size() - 1);
        }
    }

    private int literalToken() throws SyntaxError {
        String value;
        Matcher match = OPERATOR.matcher(this.fChunk);
        if (match.find()) {
            value = match.group(0);
            if (value.length() == 2 && (value.charAt(0) == '-' || value.charAt(0) == '=') && value.charAt(1) == '>') {
                this.tagParameters();
            }
        } else {
            value = Character.toString(this.fChunk.charAt(0));
        }
        int tag = this.terminal(value);
        CoffeeSymbol prev = this.last(this.fTokens);
        if (value.equals("=") && prev != null) {
            if (!prev.reserved && JS_FORBIDDEN.contains(prev.getValue())) {
                this.assignmentError();
            }
            if (prev.getValue().equals("||") || prev.getValue().equals("&&")) {
                this.fTokens.remove(this.fTokens.size() - 1);
                prev = new CoffeeSymbol(67, "" + prev.getValue() + '=');
                this.fTokens.add(prev);
                return value.length();
            }
        }
        if (value.equals(";")) {
            tag = 43;
        } else if (MATH.contains(value)) {
            tag = 34;
        } else if (COMPARE.contains(value)) {
            tag = 38;
        } else if (COMPOUND_ASSIGN.contains(value)) {
            tag = 67;
        } else if (UNARY.contains(value)) {
            tag = 32;
        } else if (SHIFT.contains(value)) {
            tag = 36;
        } else if (LOGIC.contains(value) || value.equals("?") && prev != null && prev.spaced) {
            tag = 39;
        } else if (prev != null && !prev.spaced) {
            if (value.equals("(") && CALLABLE.contains(prev.getId())) {
                if (prev.getId() == 33) {
                    prev.setId((short)51);
                }
                tag = 42;
            } else if (value.equals("[") && INDEXABLE.contains(prev.getId())) {
                tag = 44;
                switch (prev.getId()) {
                    case 33: {
                        prev.setId((short)45);
                        break;
                    }
                    case 50: {
                        prev.setId((short)46);
                    }
                }
            }
        }
        this.token((short)tag, value, value.length());
        return value.length();
    }

    private String sanitizeHeredoc(String doc, String indent, boolean herecomment) {
        if (herecomment) {
            Matcher m = HEREDOC_ILLEGAL.matcher(doc);
            if (m.find()) {
                throw new Error("block comment cannot contain \"*/\", starting on fLine " + (this.fLine + 1));
            }
            if (doc.indexOf(10) <= 0) {
                return doc;
            }
        } else {
            Matcher match = HEREDOC_INDENT.matcher(doc);
            while (match.find()) {
                String attempt = match.group(1);
                int len = attempt.length();
                if (indent != null && (len <= 0 || len >= indent.length())) continue;
                indent = attempt;
            }
        }
        if (indent != null) {
            doc = doc.replaceAll("\\n" + indent, "\n");
        }
        if (!herecomment) {
            doc = doc.replaceFirst("^\n", "");
        }
        return doc;
    }

    private void tagParameters() {
        CoffeeSymbol tok;
        if (this.tag() != 60) {
            return;
        }
        Stack<CoffeeSymbol> stack = new Stack<CoffeeSymbol>();
        int i = this.fTokens.size();
        this.fTokens.get(--i).setId((short)68);
        while ((tok = this.fTokens.get(--i)) != null) {
            switch (tok.getId()) {
                case 60: {
                    stack.push(tok);
                    break;
                }
                case 12: 
                case 42: {
                    if (!stack.isEmpty()) {
                        stack.pop();
                        break;
                    }
                    if (tok.getId() == 12) {
                        tok.setId((short)25);
                        return;
                    }
                    return;
                }
            }
        }
    }

    private void closeIndentation() {
        this.outdentToken(this.fIndent, false);
    }

    private void identifierError(String word) throws SyntaxError {
        throw new SyntaxError("Reserved word \"" + word + "\" on fLine " + (this.fLine + 1));
    }

    private void assignmentError() throws SyntaxError {
        throw new SyntaxError("Reserved word \"" + this.value() + "\" on fLine " + (this.fLine + 1) + " can't be assigned");
    }

    private String balancedString(String str, char end) {
        Stack<Character> stack = new Stack<Character>();
        stack.push(Character.valueOf(end));
        int len = str.length();
        boolean small = 1 <= len;
        int prev = 32;
        int i = 1;
        while (!(small ? i >= len : i <= len)) {
            char letter = str.charAt(i);
            switch (letter) {
                case '\\': {
                    ++i;
                    break;
                }
                default: {
                    if (letter == end) {
                        stack.pop();
                        if (stack.isEmpty()) {
                            return str.substring(0, i + 1);
                        }
                        end = ((Character)stack.get(stack.size() - 1)).charValue();
                        break;
                    }
                    if (end == '}' && (letter == '\"' || letter == '\'')) {
                        end = letter;
                        stack.push(Character.valueOf(end));
                    } else if (end == '}' && letter == '{') {
                        end = '}';
                        stack.push(Character.valueOf('}'));
                    } else if (end == '\"' && prev == 35 && letter == '{') {
                        end = '}';
                        stack.push(Character.valueOf('}'));
                    }
                    prev = letter;
                }
            }
            i += small ? 1 : -1;
        }
        throw new Error("missing " + stack.pop() + ", starting on fLine " + (this.fLine + 1));
    }

    private Stack<CoffeeSymbol> interpolateString(String str, boolean heredoc, boolean regex) throws SyntaxError {
        int interpolated;
        Stack<CoffeeSymbol> tmpTokens = new Stack<CoffeeSymbol>();
        int pi = 0;
        int i = 0;
        while (i < str.length()) {
            String expr;
            char letter = str.charAt(i);
            if (letter == '\\') {
                ++i;
            } else if (letter == '#' && str.charAt(i + 1) == '{' && (expr = this.balancedString(str.substring(i + 1), '}')) != null) {
                String inner;
                if (pi < i) {
                    tmpTokens.push(new CoffeeSymbol(-3, str.substring(pi, i)));
                }
                if ((inner = expr.substring(1, expr.length() - 1)).length() > 0) {
                    HashMap<String, Object> newOptions = new HashMap<String, Object>();
                    newOptions.put("fLine", this.fLine);
                    newOptions.put("rewrite", false);
                    List<CoffeeSymbol> nested = new CoffeeScanner().tokenize(inner, newOptions);
                    nested.remove(nested.size() - 1);
                    if (nested.get(0) != null && nested.get(0).getId() == 43) {
                        nested.remove(0);
                    }
                    if (!nested.isEmpty()) {
                        if (nested.size() > 1) {
                            nested.add(0, new CoffeeSymbol(12, "("));
                            nested.add(new CoffeeSymbol(60, ")"));
                        }
                        tmpTokens.push(new CoffeeSymbol(-2, nested));
                    }
                }
                pi = (i += expr.length()) + 1;
            }
            ++i;
        }
        if (i > pi && pi < str.length()) {
            tmpTokens.push(new CoffeeSymbol(-3, str.substring(pi)));
        }
        if (regex) {
            return tmpTokens;
        }
        if (tmpTokens.isEmpty()) {
            tmpTokens.push(this.token((short)11, "\"\""));
            return tmpTokens;
        }
        if (((CoffeeSymbol)((Object)tmpTokens.get(0))).getId() != -3) {
            tmpTokens.add(0, new CoffeeSymbol(-1, ""));
        }
        if ((interpolated = tmpTokens.size()) > 1) {
            this.token((short)12, "(");
        }
        int x = 0;
        while (x < interpolated) {
            CoffeeSymbol token = (CoffeeSymbol)((Object)tmpTokens.get(x));
            short tag = token.getId();
            Object value = token.getValue();
            if (x != 0) {
                this.token((short)2, "+");
            }
            if (tag == -2) {
                this.fTokens.addAll((List)value);
            } else {
                this.token((short)11, this.makeString((String)value, "\"", heredoc));
            }
            ++x;
        }
        if (interpolated != 0) {
            this.token((short)60, ")");
        }
        return tmpTokens;
    }

    private CoffeeSymbol token(short tokenType, Object value) {
        CoffeeSymbol symbol = new CoffeeSymbol(tokenType, value);
        this.fTokens.add(symbol);
        return symbol;
    }

    private CoffeeSymbol token(short tokenType, Object value, int length) {
        return this.token(tokenType, value, this.fOffset, length);
    }

    private CoffeeSymbol token(short tokenType, Object value, int offset, int length) {
        CoffeeSymbol symbol = new CoffeeSymbol(tokenType, offset, offset + length, value);
        this.fTokens.add(symbol);
        return symbol;
    }

    private short tag() {
        CoffeeSymbol tok = this.last(this.fTokens);
        if (tok == null) {
            return -4;
        }
        return tok.getId();
    }

    private String value() {
        CoffeeSymbol tok = this.last(this.fTokens);
        if (tok == null) {
            return null;
        }
        return (String)tok.value;
    }

    private boolean unfinished() {
        if (LINE_CONTINUER.matcher(this.fChunk).find()) {
            return true;
        }
        CoffeeSymbol value = this.last(this.fTokens);
        if (value == null) {
            return false;
        }
        switch (value.getId()) {
            case 1: 
            case 2: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 48: 
            case 49: 
            case 58: 
            case 67: {
                return true;
            }
        }
        return "\\".equals(value.getValue());
    }

    private String escapeLines(String string) {
        return this.escapeLines(string, false);
    }

    private String escapeLines(String str, boolean heredoc) {
        return MULTILINER.matcher(str).replaceAll(heredoc ? "\\n" : "");
    }

    private String makeString(String body, String quote, boolean heredoc) {
        if (body == null) {
            return String.valueOf(quote) + quote;
        }
        Pattern p = Pattern.compile("\\\\([\\s\\S])");
        Matcher m = p.matcher(body);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String match = m.group(0);
            String contents = m.group(1);
            String replacement = match;
            if (contents.equals("\n") || contents.equals(quote)) {
                replacement = contents;
            }
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        body = sb.toString();
        body = body.replaceAll(quote, "\\$&");
        return String.valueOf(quote) + this.escapeLines(body, heredoc) + quote;
    }

    private CoffeeSymbol last(List<CoffeeSymbol> array) {
        return this.last(array, 0);
    }

    private CoffeeSymbol last(List<CoffeeSymbol> array, int back) {
        int index = array.size() - back - 1;
        if (index < 0 || index >= array.size()) {
            return null;
        }
        return array.get(index);
    }

    /*
     * Unable to fully structure code
     */
    private int count(String string, String substr) {
        num = 0;
        pos = 0;
        if (substr.length() != 0) ** GOTO lbl6
        return -1;
lbl-1000:
        // 1 sources

        {
            ++num;
lbl6:
            // 2 sources

            ** while ((pos = 1 + string.indexOf((String)substr, (int)pos)) != 0)
        }
lbl7:
        // 1 sources

        return num;
    }

    public void setSource(String source) {
        this.reset();
        this.fCode = source;
    }

    private void reset() {
        this.fTokens = null;
        this.fIndents = null;
        this.fCode = null;
    }

    public List<CoffeeCommentNode> getComments() {
        return Collections.unmodifiableList(this.fComments);
    }
}

