/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.coffee;

import com.aptana.editor.coffee.CoffeeCodeScanner;
import com.aptana.editor.coffee.contentassist.CoffeeContentassistProcessor;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.text.SingleTokenScanner;
import com.aptana.editor.common.text.rules.CommentScanner;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.SubPartitionScanner;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import com.aptana.editor.js.JSEscapeSequenceScanner;
import com.aptana.editor.js.text.rules.JSRegExpRule;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;

public class CoffeeSourceConfiguration
implements IPartitioningConfiguration,
ISourceViewerConfiguration {
    public static final String PREFIX = "__coffee_";
    public static final String DEFAULT = "__coffee__dftl_partition_content_type";
    public static final String SINGLELINE_COMMENT = "__coffee_singleline_comment";
    public static final String MULTILINE_COMMENT = "__coffee_block_comment";
    public static final String STRING_DOUBLE = "__coffee_string_double";
    public static final String STRING_SINGLE = "__coffee_string_single";
    public static final String REGEXP = "__coffee_regexp";
    public static final String HEREDOC = "__coffee_heredoc";
    public static final String DOUBLE_HEREDOC = "__coffee_heredoc_double";
    public static final String COMMAND = "__coffee_command";
    public static final String HEREGEX = "__coffee_heregex";
    public static final String[] CONTENT_TYPES = new String[]{"__coffee__dftl_partition_content_type", "__coffee_singleline_comment", "__coffee_block_comment", "__coffee_string_double", "__coffee_string_single", "__coffee_regexp", "__coffee_heredoc", "__coffee_heredoc_double", "__coffee_command", "__coffee_heregex"};
    private static final String[][] TOP_CONTENT_TYPES = new String[][]{{"com.aptana.contenttype.coffeescript"}};
    private IPredicateRule[] partitioningRules = new IPredicateRule[]{new EndOfLineRule("####", CoffeeSourceConfiguration.getToken("__coffee_singleline_comment")), new MultiLineRule("###", "###", CoffeeSourceConfiguration.getToken("__coffee_block_comment")), new EndOfLineRule("#", CoffeeSourceConfiguration.getToken("__coffee_singleline_comment")), new MultiLineRule("`", "`", CoffeeSourceConfiguration.getToken("__coffee_command"), '\\'), new MultiLineRule("'''", "'''", CoffeeSourceConfiguration.getToken("__coffee_heredoc")), new MultiLineRule("\"\"\"", "\"\"\"", CoffeeSourceConfiguration.getToken("__coffee_heredoc_double")), new SingleLineRule("\"", "\"", CoffeeSourceConfiguration.getToken("__coffee_string_double"), '\\'), new SingleLineRule("'", "'", CoffeeSourceConfiguration.getToken("__coffee_string_single"), '\\'), new MultiLineRule("///", "///", CoffeeSourceConfiguration.getToken("__coffee_heregex")), new JSRegExpRule((IToken)new Token((Object)"__coffee_regexp"))};
    private static CoffeeSourceConfiguration instance;

    static {
        IContentTypeTranslator c = CommonEditorPlugin.getDefault().getContentTypeTranslator();
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.coffeescript"}), new QualifiedContentType(new String[]{"source.coffee"}));
        c.addTranslation(new QualifiedContentType(new String[]{HEREDOC}), new QualifiedContentType(new String[]{"string.quoted.heredoc.coffee"}));
        c.addTranslation(new QualifiedContentType(new String[]{DOUBLE_HEREDOC}), new QualifiedContentType(new String[]{"string.quoted.double.heredoc.coffee"}));
        c.addTranslation(new QualifiedContentType(new String[]{STRING_SINGLE}), new QualifiedContentType(new String[]{"string.quoted.single.coffee"}));
        c.addTranslation(new QualifiedContentType(new String[]{STRING_DOUBLE}), new QualifiedContentType(new String[]{"string.quoted.double.coffee"}));
        c.addTranslation(new QualifiedContentType(new String[]{COMMAND}), new QualifiedContentType(new String[]{"string.quoted.script.coffee"}));
        c.addTranslation(new QualifiedContentType(new String[]{MULTILINE_COMMENT}), new QualifiedContentType(new String[]{"comment.block.coffee"}));
        c.addTranslation(new QualifiedContentType(new String[]{SINGLELINE_COMMENT}), new QualifiedContentType(new String[]{"comment.line.coffee"}));
        c.addTranslation(new QualifiedContentType(new String[]{HEREGEX}), new QualifiedContentType(new String[]{"string.regexp.coffee"}));
        c.addTranslation(new QualifiedContentType(new String[]{REGEXP}), new QualifiedContentType(new String[]{"string.regexp.coffee"}));
    }

    private CoffeeSourceConfiguration() {
    }

    public static CoffeeSourceConfiguration getDefault() {
        if (instance == null) {
            instance = new CoffeeSourceConfiguration();
        }
        return instance;
    }

    public String[] getContentTypes() {
        return CONTENT_TYPES;
    }

    public String[][] getTopContentTypes() {
        return TOP_CONTENT_TYPES;
    }

    public IPredicateRule[] getPartitioningRules() {
        return this.partitioningRules;
    }

    public ISubPartitionScanner createSubPartitionScanner() {
        return new SubPartitionScanner(this.getPartitioningRules(), CONTENT_TYPES, CoffeeSourceConfiguration.getToken(DEFAULT));
    }

    public String getDocumentContentType(String contentType) {
        if (contentType.startsWith(PREFIX)) {
            return "com.aptana.contenttype.coffeescript";
        }
        return null;
    }

    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        ThemeingDamagerRepairer dr = new ThemeingDamagerRepairer(this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, DEFAULT);
        reconciler.setRepairer((IPresentationRepairer)dr, DEFAULT);
        dr = new ThemeingDamagerRepairer(this.getBlockCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, MULTILINE_COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, MULTILINE_COMMENT);
        dr = new ThemeingDamagerRepairer(this.getSingleQuotedStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, STRING_SINGLE);
        reconciler.setRepairer((IPresentationRepairer)dr, STRING_SINGLE);
        dr = new ThemeingDamagerRepairer(this.getDoubleQuotedStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, STRING_DOUBLE);
        reconciler.setRepairer((IPresentationRepairer)dr, STRING_DOUBLE);
        dr = new ThemeingDamagerRepairer(this.getSingleLineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, SINGLELINE_COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, SINGLELINE_COMMENT);
        dr = new ThemeingDamagerRepairer(this.getRegexpScanner());
        reconciler.setDamager((IPresentationDamager)dr, REGEXP);
        reconciler.setRepairer((IPresentationRepairer)dr, REGEXP);
        dr = new ThemeingDamagerRepairer(this.getHeredocScanner());
        reconciler.setDamager((IPresentationDamager)dr, HEREDOC);
        reconciler.setRepairer((IPresentationRepairer)dr, HEREDOC);
        dr = new ThemeingDamagerRepairer(this.getDoubleHeredocScanner());
        reconciler.setDamager((IPresentationDamager)dr, DOUBLE_HEREDOC);
        reconciler.setRepairer((IPresentationRepairer)dr, DOUBLE_HEREDOC);
        dr = new ThemeingDamagerRepairer(this.getCommandScanner());
        reconciler.setDamager((IPresentationDamager)dr, COMMAND);
        reconciler.setRepairer((IPresentationRepairer)dr, COMMAND);
        dr = new ThemeingDamagerRepairer(this.getHeregexScanner());
        reconciler.setDamager((IPresentationDamager)dr, HEREGEX);
        reconciler.setRepairer((IPresentationRepairer)dr, HEREGEX);
    }

    private ITokenScanner getDoubleQuotedStringScanner() {
        return new JSEscapeSequenceScanner("string.quoted.double.coffee");
    }

    private ITokenScanner getDoubleHeredocScanner() {
        return new JSEscapeSequenceScanner("string.quoted.double.heredoc.coffee");
    }

    private ITokenScanner getRegexpScanner() {
        return new JSEscapeSequenceScanner("string.regexp.coffee");
    }

    private ITokenScanner getHeregexScanner() {
        return this.getRegexpScanner();
    }

    private ITokenScanner getCommandScanner() {
        return new SingleTokenScanner(CoffeeSourceConfiguration.getToken("string.quoted.script.coffee"));
    }

    private ITokenScanner getSingleQuotedStringScanner() {
        return new SingleTokenScanner(CoffeeSourceConfiguration.getToken("string.quoted.single.coffee"));
    }

    private ITokenScanner getHeredocScanner() {
        return new SingleTokenScanner(CoffeeSourceConfiguration.getToken("string.quoted.heredoc.coffee"));
    }

    private ITokenScanner getBlockCommentScanner() {
        return new CommentScanner(CoffeeSourceConfiguration.getToken("comment.block.coffee"));
    }

    private ITokenScanner getSingleLineCommentScanner() {
        return new CommentScanner(CoffeeSourceConfiguration.getToken("comment.line.coffee"));
    }

    private ITokenScanner getCodeScanner() {
        return new CoffeeCodeScanner();
    }

    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        return new CoffeeContentassistProcessor(editor);
    }

    private static IToken getToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }
}

