/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.internal.core.builtin;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.SocketUtil;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.SimpleWebServer;
import com.aptana.webserver.core.URLtoURIMapper;
import com.aptana.webserver.core.WebServerCorePlugin;
import com.aptana.webserver.internal.core.builtin.LocalWebServerHttpRequestHandler;
import com.aptana.webserver.internal.core.builtin.LocalWebServerLogger;
import com.aptana.webserver.internal.core.builtin.Messages;
import com.aptana.webserver.internal.core.preferences.WebServerPreferences;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.nio.DefaultServerIOEventDispatch;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.protocol.BufferingHttpServiceHandler;
import org.apache.http.nio.protocol.EventListener;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.nio.reactor.ListeningIOReactor;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;

public class LocalWebServer
extends SimpleWebServer {
    private static final String NAME = "HBuilder\u5185\u7f6eWeb\u670d\u52a1\u5668";
    private static final int SOCKET_TIMEOUT = 10000;
    private static final long STARTUP_TIMEOUT = 10000L;
    private static final long SHUTDOWN_TIMEOUT = 2000L;
    private static final int SOCKET_BUFFER_SIZE = 16384;
    private static final int WORKER_COUNT = 2;
    private Thread thread;
    private ListeningIOReactor reactor;
    protected int port;
    private String host;
    private int[] portRange;

    public LocalWebServer(URI documentRoot) {
        this(WebServerPreferences.getServerAddress(), WebServerPreferences.getPortRange(), documentRoot);
    }

    public LocalWebServer(String host, int[] portRange, URI documentRoot) {
        Assert.isLegal((documentRoot != null ? 1 : 0) != 0, (String)"DocumentRoot should be set");
        this.setDocumentRoot(documentRoot);
        this.setName(NAME);
        this.host = host;
        this.portRange = portRange;
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            this.port = SocketUtil.findFreePort((InetAddress)inetAddress, (int)portRange[0], (int)portRange[1]);
            if (this.port <= 0) {
                this.port = SocketUtil.findFreePort((InetAddress)inetAddress);
            }
            this.setBaseURL(new URL("http", host, this.port, "/"));
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
        }
    }

    private void testConnection(URL url) throws CoreException {
        CoreException exception = null;
        int trial = 0;
        while (trial < 3) {
            try {
                URLConnection connection = url.openConnection();
                connection.connect();
                connection.getContentType();
                return;
            }
            catch (IOException e) {
                exception = new CoreException((IStatus)new Status(4, "com.aptana.webserver.core", "Testing WebServer connection failed", (Throwable)e));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                ++trial;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void startServer(final int port) {
        this.updateState(IServer.State.STARTING);
        this.thread = new Thread(){

            @Override
            public void run() {
                LocalWebServer.this.runServer(new InetSocketAddress(port), new LocalWebServerHttpRequestHandler(LocalWebServer.this));
            }
        };
        this.thread.setDaemon(true);
        this.thread.start();
        Thread.yield();
        long startTime = System.currentTimeMillis();
        while (this.thread.isAlive() && System.currentTimeMillis() - startTime < 10000L) {
            if (this.reactor != null && this.reactor.getStatus() == IOReactorStatus.ACTIVE) {
                this.updateState(IServer.State.STARTED);
                break;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                this.updateState(IServer.State.UNKNOWN);
                break;
            }
        }
    }

    private void runServer(InetSocketAddress socketAddress, HttpRequestHandler httpRequestHandler) {
        BasicHttpParams params = new BasicHttpParams();
        params.setIntParameter("http.socket.timeout", 10000).setBooleanParameter("http.connection.stalecheck", false).setIntParameter("http.socket.buffer-size", 16384).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", (Object)("HttpComponents/" + EclipseUtil.getPluginVersion((String)"org.apache.httpcomponents.httpcore")));
        BasicHttpProcessor httpProcessor = new BasicHttpProcessor();
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        HttpRequestHandlerRegistry handlerRegistry = new HttpRequestHandlerRegistry();
        handlerRegistry.register("*", httpRequestHandler);
        BufferingHttpServiceHandler serviceHandler = new BufferingHttpServiceHandler((HttpProcessor)httpProcessor, (HttpResponseFactory)new DefaultHttpResponseFactory(), (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpParams)params);
        serviceHandler.setHandlerResolver((HttpRequestHandlerResolver)handlerRegistry);
        serviceHandler.setEventListener((EventListener)new LocalWebServerLogger());
        DefaultServerIOEventDispatch eventDispatch = new DefaultServerIOEventDispatch((NHttpServiceHandler)serviceHandler, (HttpParams)params);
        try {
            this.reactor = new DefaultListeningIOReactor(2, (HttpParams)params);
            this.reactor.listen((SocketAddress)socketAddress);
            this.reactor.execute((IOEventDispatch)eventDispatch);
        }
        catch (InterruptedIOException interruptedIOException) {
            return;
        }
        catch (IOReactorException e) {
            IdeLog.logWarning((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
        }
    }

    @Override
    public IStatus stop(boolean force, IProgressMonitor monitor) {
        if (this.thread != null && this.thread.isAlive()) {
            if (this.reactor != null) {
                try {
                    this.reactor.shutdown(2000L);
                }
                catch (IOException ignore) {
                    IdeLog.logWarning((Plugin)WebServerCorePlugin.getDefault(), (String)"An error occurred shutting down the built-in preview server", (Throwable)ignore);
                }
            }
            this.thread.interrupt();
            try {
                this.thread.join(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus start(String mode, IProgressMonitor monitor) {
        if (!"run".equals(mode)) {
            return new Status(4, "com.aptana.webserver.core", Messages.LocalWebServer_ServerModeError);
        }
        this.startServer(this.port);
        return Status.OK_STATUS;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public String getMode() {
        return "run";
    }

    @Override
    public IServer.State getState() {
        return this.fState;
    }

    @Override
    public ILaunch getLaunch() {
        return null;
    }

    @Override
    public IProcess[] getProcesses() {
        return new IProcess[0];
    }

    @Override
    public String getHostname() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public IFileStore resolve(URI uri) {
        return new URLtoURIMapper(this.getBaseURL(), this.getDocumentRoot()).resolve(uri, true);
    }

    public void resetHost(URI documentRoot) {
        try {
            boolean isHostChange;
            String newHost = WebServerPreferences.getServerAddress();
            boolean bl = isHostChange = !this.host.equals(newHost);
            if (!isHostChange) {
                return;
            }
            this.setDocumentRoot(documentRoot);
            this.host = newHost;
            this.setBaseURL(new URL("http", this.host, this.port, "/"));
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
        }
    }

    public void restart() {
        try {
            int[] newPortRange = WebServerPreferences.getPortRange();
            boolean isPortChange = !Arrays.equals(this.portRange, newPortRange);
            this.stop(true, (IProgressMonitor)new NullProgressMonitor());
            this.reactor = null;
            if (isPortChange) {
                this.portRange = newPortRange;
                InetAddress inetAddress = InetAddress.getByName(this.host);
                this.port = SocketUtil.findFreePort((InetAddress)inetAddress, (int)this.portRange[0], (int)this.portRange[1]);
                if (this.port <= 0) {
                    this.port = SocketUtil.findFreePort((InetAddress)inetAddress);
                }
                this.setBaseURL(new URL("http", this.host, this.port, "/"));
            }
            this.start("run", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
        }
    }
}

