/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.core;

import com.aptana.core.IURIMapper;
import com.aptana.core.io.efs.EFSUtils;
import com.aptana.core.logging.IdeLog;
import com.aptana.webserver.core.WebServerCorePlugin;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.URIUtil;

public class URLtoURIMapper
implements IURIMapper {
    private URL baseURL;
    private URI documentRoot;

    public URLtoURIMapper(URL baseURL, URI documentRoot) {
        this.baseURL = baseURL;
        this.documentRoot = documentRoot;
    }

    public URI resolve(IFileStore file) {
        if (!this.isValid()) {
            return null;
        }
        try {
            IPath relativePath = EFSUtils.getRelativePath((IFileStore)EFS.getStore((URI)this.documentRoot), (IFileStore)file);
            if (relativePath != null) {
                try {
                    URI url = URIUtil.append((URI)this.baseURL.toURI(), (String)relativePath.toPortableString());
                    String path = url.toString();
                    if (path != null && (path.contains("+") || path.contains("#") || path.contains("#") || path.contains("=") || path.contains(" "))) {
                        path = path.replace("+", "%2b").replace("#", "%23").replace("&", "%26").replace("=", "%3d").replace(" ", "%20");
                        url = new URI(path);
                    }
                    return url;
                }
                catch (URISyntaxException e) {
                    IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
                }
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    public IFileStore resolve(URI uri) {
        return this.resolve(uri, false);
    }

    public IFileStore resolve(URI uri, boolean decode) {
        if (!this.isValid()) {
            return null;
        }
        try {
            if (decode) {
                return this.resolve(Path.fromPortableString((String)URLDecoder.decode(this.baseURL.toURI().relativize(uri).getPath(), "UTF-8")));
            }
            return this.resolve(Path.fromPortableString((String)this.baseURL.toURI().relativize(uri).getPath()));
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    private IFileStore resolve(IPath path) {
        if (!this.isValid()) {
            return null;
        }
        try {
            return EFS.getStore((URI)this.documentRoot).getFileStore(path);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    private boolean isValid() {
        return this.baseURL != null && this.documentRoot != null;
    }
}

