/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.realtime.preview.listener;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import com.pandora.core.utils.EclipseUtil;
import com.pandora.core.utils.MarkdownUtils;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.realtime.preview.RealTimeActivator;
import com.pandora.realtime.preview.RealTimeHelper;
import com.pandora.view.browser.views.BrowserComposite;
import com.pandora.view.browser.views.WebBrowserView;
import java.io.File;
import java.net.URL;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.osgi.service.prefs.BackingStoreException;

public class EditorChangeListener
implements IPartListener2 {
    private static final String DIR_PREVIEW = "preview";
    private static final String PREFERENCE_INIT_2_MOBILE = "INIT_2_MOBILE";
    private static Object object = new Object();
    private static EditorChangeListener broswerListenner;
    private static boolean needInitWithBlank;
    private IElementStateListener editorFileSaveListener = new IElementStateListener(){

        public void elementMoved(Object originalElement, Object movedElement) {
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
            if (RealTimeHelper.getRealTimeInterface() == null) {
                return;
            }
            if (!isDirty && element instanceof IEditorInput) {
                final IEditorInput editorInput = (IEditorInput)element;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (RealTimeHelper.isWebViewShowed()) {
                                BrowserComposite viewer;
                                IFileEditorInput input;
                                String launchURL = null;
                                if (editorInput instanceof IFileEditorInput) {
                                    input = (IFileEditorInput)editorInput;
                                    IFileStore inputFile = RealTimeHelper.getRealTimeInterface().convertFile(input.getFile());
                                    if (RealTimeHelper.getEditorInputFile() != null && !RealTimeHelper.getEditorInputFile().equals(inputFile)) {
                                        return;
                                    }
                                    if (MarkdownUtils.isMarkDown((String)inputFile.getName())) {
                                        launchURL = EditorChangeListener.this.getMdrkDownPreViewURL(inputFile.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor()));
                                    } else {
                                        URL url = RealTimeHelper.getRealTimeInterface().convertURL(inputFile);
                                        if (url != null) {
                                            launchURL = url.toString();
                                        }
                                    }
                                    if (StringUtil.isNotBlank((String)launchURL)) {
                                        RealTimeHelper.getRealTimeInterface().startWebServer(inputFile.getName());
                                    }
                                } else if (editorInput instanceof FileStoreEditorInput) {
                                    input = (FileStoreEditorInput)editorInput;
                                    launchURL = MarkdownUtils.isMarkDown((String)input.getName()) ? EditorChangeListener.this.getMdrkDownPreViewURL(new File(input.getURI())) : input.getURI().toString();
                                }
                                if (StringUtil.isNotBlank(launchURL) && (viewer = RealTimeHelper.getBrowserViewer()) != null) {
                                    if (RealTimeHelper.iSameWithWebViewUri(launchURL, viewer.getRealURL())) {
                                        viewer.refresh();
                                    } else {
                                        viewer.setURL(launchURL);
                                    }
                                    if (viewer.getBrowser() instanceof Browser) {
                                        try {
                                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().setFocus();
                                        }
                                        catch (Throwable throwable) {}
                                    }
                                }
                            }
                        }
                        catch (Throwable e) {
                            HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
                        }
                    }
                });
            }
        }

        public void elementDeleted(Object element) {
        }

        public void elementContentReplaced(Object element) {
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }
    };

    static {
        needInitWithBlank = false;
    }

    private EditorChangeListener() {
    }

    public static EditorChangeListener getInstance() {
        if (broswerListenner == null) {
            broswerListenner = new EditorChangeListener();
        }
        return broswerListenner;
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        if (RealTimeHelper.getRealTimeInterface() == null) {
            return;
        }
        if (partRef.getId().equals("com.pandora.view.browser.view.WebBrowserView")) {
            if (StringUtil.isBlank((String)RealTimeHelper.getEditorInputUrl())) {
                EditorChangeListener.initWithBlank();
            } else {
                if (RealTimeHelper.getEditorInputFile() != null) {
                    RealTimeHelper.getRealTimeInterface().beforeRealTimeFileNameChange(RealTimeHelper.getEditorInputFile().getName());
                }
                RealTimeHelper.updateRealTimeBrowserURL(true);
            }
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        if (partRef instanceof IEditorReference) {
            IEditorPart editor = ((IEditorReference)partRef).getEditor(false);
            if (editor instanceof AbstractTextEditor) {
                ((AbstractTextEditor)editor).getDocumentProvider().removeElementStateListener(this.editorFileSaveListener);
                IEditorReference[] leaveEditors = partRef.getPage().getEditorReferences();
                int num = 0;
                if (leaveEditors.length > 0) {
                    IEditorReference[] iEditorReferenceArray = leaveEditors;
                    int n = leaveEditors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorReference editorReference = iEditorReferenceArray[n2];
                        if (editorReference.getEditor(false) instanceof AbstractTextEditor) {
                            ++num;
                        }
                        ++n2;
                    }
                }
                if (leaveEditors.length == 0 || num == 0) {
                    RealTimeHelper.setEditorInputFile(null);
                    RealTimeHelper.setEditorInputUrl(null);
                }
            }
        } else if ("com.pandora.view.browser.view.WebBrowserView".equals(partRef.getId())) {
            needInitWithBlank = false;
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        if (RealTimeHelper.getRealTimeInterface() == null) {
            return;
        }
        try {
            if (partRef instanceof IEditorReference) {
                if (((IEditorReference)partRef).getEditor(false) instanceof AbstractTextEditor) {
                    try {
                        IEditorInput input = ((IEditorReference)partRef).getEditorInput();
                        if (input != null && input.exists()) {
                            RealTimeHelper.getRealTimeInterface().beforeActiveEditor(input.getName());
                        }
                    }
                    catch (Throwable e) {
                        HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
                    }
                }
                if (this.needTabChangeJob((IEditorReference)partRef)) {
                    needInitWithBlank = true;
                    AbstractTextEditor editorPart = (AbstractTextEditor)((EditorReference)partRef).getEditor(false);
                    editorPart.getDocumentProvider().addElementStateListener(this.editorFileSaveListener);
                    IEditorInput iEditorInput = ((IEditorReference)partRef).getEditorInput();
                    boolean isMarkDown = MarkdownUtils.isMarkDown((String)iEditorInput.getName());
                    if (isMarkDown) {
                        IFileEditorInput input;
                        File mdFile = null;
                        if (iEditorInput instanceof IFileEditorInput) {
                            input = (IFileEditorInput)iEditorInput;
                            IFileStore fileStore = RealTimeHelper.getRealTimeInterface().convertFile(input.getFile());
                            mdFile = fileStore.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
                        } else if (iEditorInput instanceof FileStoreEditorInput) {
                            input = (FileStoreEditorInput)iEditorInput;
                            mdFile = new File(input.getURI());
                        }
                        File targetFolder = RealTimeActivator.getDefault().getBundle().getDataFile(DIR_PREVIEW);
                        boolean isValid = MarkdownUtils.isMarkDownHtmlValid(mdFile, (File)targetFolder);
                        this.setChangedEditorInput(editorPart, iEditorInput, !isValid);
                    } else {
                        this.setChangedEditorInput(editorPart, iEditorInput, false);
                    }
                }
            }
            if (!needInitWithBlank) {
                EditorChangeListener.initWithBlank();
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
        }
    }

    public static void initWithBlank() {
        if (needInitWithBlank) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    BrowserComposite viewer;
                    if (RealTimeHelper.isWebViewShowed() && (viewer = RealTimeHelper.getBrowserViewer()) != null) {
                        viewer.initWithBlank();
                        RealTimeHelper.getFocus2Editor();
                        needInitWithBlank = true;
                    }
                }
                catch (Exception e) {
                    HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
                }
            }
        });
    }

    private boolean needTabChangeJob(IEditorReference partRef) {
        if (partRef == null) {
            return false;
        }
        return this.needTabChangeJob(partRef.getEditor(false));
    }

    private boolean needTabChangeJob(IEditorPart editor) {
        block5: {
            if (RealTimeHelper.getRealTimeInterface() == null || editor == null) {
                return false;
            }
            if (editor instanceof AbstractTextEditor) {
                IEditorInput input;
                block6: {
                    input = editor.getEditorInput();
                    if (input == null) break block5;
                    if (!MarkdownUtils.isMarkDown((String)input.getName())) break block6;
                    return true;
                }
                try {
                    return RealTimeHelper.getRealTimeInterface().isRealTimeFileNameEnable(input.getName());
                }
                catch (Exception e) {
                    HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setChangedEditorInput(AbstractTextEditor editor, IEditorInput iEditorInput, boolean force) {
        if (RealTimeHelper.getRealTimeInterface() == null) {
            return;
        }
        Object object = EditorChangeListener.object;
        synchronized (object) {
            try {
                String launchURL = null;
                IFileStore inputFile = null;
                if (iEditorInput instanceof IFileEditorInput) {
                    IFileEditorInput input = (IFileEditorInput)iEditorInput;
                    inputFile = RealTimeHelper.getRealTimeInterface().convertFile(input.getFile());
                    if (MarkdownUtils.isMarkDown((String)iEditorInput.getName())) {
                        launchURL = this.getMdrkDownPreViewURL(inputFile.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor()));
                    } else {
                        URL url = RealTimeHelper.getRealTimeInterface().convertURL(inputFile);
                        launchURL = url.toString();
                    }
                    try {
                        if (input.getFile().getProject().hasNature("com.pandora.projects.ui.MKeyNature")) {
                            EditorChangeListener.initScreenSizeConfig2Mobile();
                        }
                    }
                    catch (Exception e) {
                        HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
                    }
                } else if (iEditorInput instanceof FileStoreEditorInput) {
                    inputFile = null;
                    FileStoreEditorInput input = (FileStoreEditorInput)iEditorInput;
                    launchURL = MarkdownUtils.isMarkDown((String)iEditorInput.getName()) ? this.getMdrkDownPreViewURL(new File(input.getURI())) : input.getURI().toString();
                }
                if (inputFile != null && (launchURL == null || !launchURL.equals(RealTimeHelper.getEditorInputUrl())) && RealTimeHelper.isWebViewShowed()) {
                    RealTimeHelper.getRealTimeInterface().beforeRealTimeFileNameChange(inputFile.getName());
                }
                RealTimeHelper.setEditorInputFile(inputFile);
                RealTimeHelper.setEditorInputUrl(launchURL);
            }
            catch (Exception e) {
                HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
            }
        }
        RealTimeHelper.updateRealTimeBrowserURL(force);
    }

    public static void initScreenSizeConfig2Mobile() {
        if (!PlatformUtil.isWindows()) {
            return;
        }
        IEclipsePreferences preferences = EclipseUtil.instanceScope().getNode("com.pandora.editor.realtime.preview");
        boolean hasInited = preferences.getBoolean(PREFERENCE_INIT_2_MOBILE, false);
        if (hasInited) {
            return;
        }
        WebBrowserView.setBrowserScreenSizeConfig((String)"iPhone6");
        preferences.putBoolean(PREFERENCE_INIT_2_MOBILE, true);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    private String getMdrkDownPreViewURL(File mdFile) {
        try {
            File targetFolder = RealTimeActivator.getDefault().getBundle().getDataFile(DIR_PREVIEW);
            File html = MarkdownUtils.markdownToHtmlFolder((File)mdFile, (File)targetFolder);
            if (html != null && html.exists()) {
                return html.toURI().toString();
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
        }
        return mdFile.toURI().toString();
    }
}

