/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.realtime.preview;

import com.pandora.cef3.CEF3Browser;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.StringUtil;
import com.pandora.realtime.preview.IRealTimeInterface;
import com.pandora.realtime.preview.RealTimeActivator;
import com.pandora.realtime.preview.listener.EditorChangeListener;
import com.pandora.view.browser.BrowserActivator;
import com.pandora.view.browser.views.BrowserComposite;
import com.pandora.view.browser.views.WebBrowserView;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RealTimeHelper {
    private static volatile String editorInputUrl;
    private static volatile IFileStore editorInputFile;
    private static IRealTimeInterface realTimeInterface;

    static {
        realTimeInterface = null;
    }

    public static String getEditorInputUrl() {
        return editorInputUrl;
    }

    public static void setEditorInputUrl(String editorInputUrl) {
        RealTimeHelper.editorInputUrl = editorInputUrl;
    }

    public static IFileStore getEditorInputFile() {
        return editorInputFile;
    }

    public static void setEditorInputFile(IFileStore editorInputFile) {
        RealTimeHelper.editorInputFile = editorInputFile;
    }

    public static IRealTimeInterface getRealTimeInterface() {
        return realTimeInterface;
    }

    public static void init(IRealTimeInterface realTimeInterface) {
        if (RealTimeHelper.realTimeInterface != null) {
            return;
        }
        RealTimeHelper.realTimeInterface = realTimeInterface;
        final IWorkbench workbench = PlatformUI.getWorkbench();
        final IWorkbenchWindow[] workbenchWindow = new IWorkbenchWindow[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                workbenchWindow[0] = workbench.getActiveWorkbenchWindow();
            }
        });
        if (workbenchWindow[0] != null) {
            try {
                IWorkbenchPage page = workbenchWindow[0].getActivePage();
                if (page != null) {
                    EditorChangeListener.getInstance().partActivated(page.getReference((IWorkbenchPart)page.getActiveEditor()));
                }
            }
            catch (Exception e) {
                HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
            }
            try {
                workbenchWindow[0].getPartService().addPartListener((IPartListener2)EditorChangeListener.getInstance());
            }
            catch (Exception e) {
                HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
            }
        }
        workbench.addWindowListener(new IWindowListener(){

            public void windowOpened(IWorkbenchWindow window) {
                try {
                    window.getPartService().addPartListener((IPartListener2)EditorChangeListener.getInstance());
                }
                catch (Throwable e) {
                    HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
                }
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
            }

            public void windowActivated(IWorkbenchWindow window) {
                try {
                    EditorChangeListener.getInstance().partActivated(window.getActivePage().getActivePartReference());
                }
                catch (Throwable e) {
                    HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
                }
            }
        });
    }

    public static BrowserComposite getBrowserViewer() {
        return BrowserActivator.getBrowserViewer();
    }

    public static WebBrowserView getWebBrowserView() {
        return BrowserActivator.getWebBrowserView();
    }

    public static boolean isWebViewShowed() {
        try {
            String viewId;
            IViewReference viewReference;
            IWorkbenchPage page;
            IWorkbenchWindow windows = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (windows != null && (page = windows.getActivePage()) != null && (viewReference = page.findViewReference(viewId = "com.pandora.view.browser.view.WebBrowserView")) != null && !viewReference.isFastView()) {
                return true;
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
        }
        return false;
    }

    public static boolean iSameWithWebViewUri(String newUri, BrowserComposite webView) {
        return RealTimeHelper.iSameWithWebViewUri(newUri, webView.getLoadingURL()) || RealTimeHelper.iSameWithWebViewUri(newUri, webView.getURL()) && RealTimeHelper.iSameWithWebViewUri(newUri, webView.getRealURL());
    }

    public static boolean iSameWithWebViewUriPath(String newUri, BrowserComposite webView) {
        return RealTimeHelper.iSameWithWebViewUriPath(newUri, webView.getLoadingURL()) || RealTimeHelper.iSameWithWebViewUriPath(newUri, webView.getURL()) && RealTimeHelper.iSameWithWebViewUriPath(newUri, webView.getRealURL());
    }

    public static boolean iSameWithWebViewUri(String newUri, String webViewUri) {
        block4: {
            try {
                if (!StringUtil.isBlank((String)webViewUri)) break block4;
                return false;
            }
            catch (URISyntaxException uRISyntaxException) {
                return false;
            }
        }
        if (newUri != null && webViewUri != null) {
            URI newURI = new URI(newUri);
            URI webViewURI = new URI(webViewUri);
            return StringUtil.areEqualIgnoreCase((String)newURI.getScheme(), (String)webViewURI.getScheme()) && StringUtil.areEqualIgnoreCase((String)newURI.getHost(), (String)webViewURI.getHost()) && (newURI.getPort() == webViewURI.getPort() || newURI.getPort() == 80 && webViewURI.getPort() == -1) && StringUtil.areEqualIgnoreCase((String)newURI.getPath(), (String)webViewURI.getPath());
        }
        return newUri == webViewUri;
    }

    public static boolean iSameWithWebViewUriPath(String newPath, String url) {
        block5: {
            try {
                if (!StringUtil.isBlank((String)url)) break block5;
                return false;
            }
            catch (URISyntaxException uRISyntaxException) {
                return false;
            }
        }
        if (newPath != null) {
            if (!newPath.startsWith("/")) {
                newPath = "/" + newPath;
            }
            newPath = newPath.replace("\\", "/").replace("//", "/");
            URI webViewURI = new URI(url);
            String path = webViewURI.getPath();
            return newPath.equalsIgnoreCase(path);
        }
        return newPath == url;
    }

    public static void updateRealTimeBrowserURL() {
        RealTimeHelper.updateRealTimeBrowserURL(false);
    }

    public static void updateRealTimeBrowserURL(final boolean force) {
        try {
            if (editorInputUrl == null) {
                return;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (RealTimeHelper.isWebViewShowed()) {
                        try {
                            BrowserComposite viewer = RealTimeHelper.getBrowserViewer();
                            if (viewer != null) {
                                if (force || !RealTimeHelper.iSameWithWebViewUri(editorInputUrl, viewer)) {
                                    if (editorInputFile != null) {
                                        RealTimeHelper.getRealTimeInterface().startWebServer(editorInputFile.getName());
                                    }
                                    viewer.setURL(editorInputUrl);
                                }
                                RealTimeHelper.getFocus2Editor();
                            }
                        }
                        catch (Exception e) {
                            HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
        }
    }

    public static void getFocus2Editor() {
        Display.getDefault().timerExec(300, new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().setFocus();
                }
                catch (Throwable throwable) {}
            }
        });
    }

    public static int getRealTimeBrowserRemoteDebugPort() {
        try {
            BrowserComposite browserViewer = RealTimeHelper.getBrowserViewer();
            if (browserViewer != null && browserViewer.getBrowser() instanceof CEF3Browser) {
                CEF3Browser browser = (CEF3Browser)browserViewer.getBrowser();
                return browser.getRemoteDebuggingPort();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return -1;
    }
}

